/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class TypeInPanel
extends JPanel {
    private JTextField field;
    private JComboBox choice;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    TypeInPanel(String string, final Question question, int n, String[] stringArray, JButton jButton, ActionListener actionListener) {
        Object object;
        this.setLayout(new GridBagLayout());
        this.setName(string);
        this.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (n <= 0) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
        }
        JLabel jLabel = new JLabel(i18n.getString(string + ".lbl"));
        jLabel.setName(string + ".lbl");
        jLabel.setDisplayedMnemonic(i18n.getString(string + ".mne").charAt(0));
        jLabel.setToolTipText(i18n.getString(string + ".tip"));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        if (stringArray == null) {
            this.field = new JTextField(question.getStringValue());
            this.field.setName(string + ".txt");
            this.field.addActionListener(actionListener);
            this.field.getDocument().addDocumentListener(new ActionDocListener(this.field, actionListener, "edited"));
            this.field.setToolTipText(jLabel.getToolTipText());
            jLabel.setLabelFor(this.field);
            if (n <= 0) {
                gridBagConstraints.fill = 2;
            } else {
                this.field.setColumns(n);
            }
            this.add((Component)this.field, gridBagConstraints);
        } else {
            this.choice = new JComboBox();
            this.choice.setName(string + ".chc");
            this.choice.setEditable(true);
            this.choice.setSelectedItem(question.getStringValue());
            jLabel.setLabelFor(this.choice);
            object = this.choice.getEditor().getEditorComponent();
            ((Component)object).setFont(((Component)object).getFont().deriveFont(0));
            if (object instanceof Accessible) {
                if (((Component)object).getName() == null) {
                    ((Component)object).setName(string + ".chc.ed");
                }
                AccessibleContext accessibleContext = ((Component)object).getAccessibleContext();
                accessibleContext.setAccessibleName(i18n.getString(string + ".chc.ed.name"));
                accessibleContext.setAccessibleDescription(i18n.getString(string + ".chc.ed.desc"));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.choice.addItem(stringArray[i]);
            }
            if (n <= 0) {
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
            } else {
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
            }
            this.add((Component)this.choice, gridBagConstraints);
        }
        if (jButton != null) {
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jButton, gridBagConstraints);
        }
        object = new Runnable(){

            public void run() {
                try {
                    question.setValue(TypeInPanel.this.getValue());
                }
                catch (Interview.Fault fault) {
                    throw new Error(fault);
                }
            }
        };
        this.putClientProperty("valueSaver", object);
    }

    String getValue() {
        if (this.field != null) {
            return this.field.getText();
        }
        return (String)this.choice.getSelectedItem();
    }

    void setValue(String string) {
        if (this.field != null) {
            this.field.setText(string);
        } else {
            this.choice.setSelectedItem(string);
        }
    }
}

