/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class EditJTI {
    private InterviewParameters interview;
    private boolean verbose;
    private PrintWriter out;
    private static int MAX_INDENT = Integer.getInteger("EditJTI.maxIndent", 32);
    private static int NUM_BACKUPS = Integer.getInteger("EditJTI.numBackups", 2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$EditJTI == null ? (class$com$sun$javatest$EditJTI = EditJTI.class$("com.sun.javatest.EditJTI")) : class$com$sun$javatest$EditJTI);
    static /* synthetic */ Class class$com$sun$javatest$EditJTI;

    public static void main(String[] stringArray) {
        try {
            EditJTI editJTI = new EditJTI();
            boolean bl = editJTI.run(stringArray);
            System.exit(bl ? 0 : 1);
        }
        catch (BadArgs badArgs) {
            System.err.println(badArgs.getMessage());
            EditJTI.usage(System.err);
            System.exit(2);
        }
        catch (Fault fault) {
            System.err.println(fault.getMessage());
            System.exit(3);
        }
    }

    public static void usage(PrintStream printStream) {
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$EditJTI == null ? (class$com$sun$javatest$EditJTI = EditJTI.class$("com.sun.javatest.EditJTI")) : class$com$sun$javatest$EditJTI).getName());
        printStream.println(i18n.getString("editJTI.usage.title"));
        printStream.print("  ");
        printStream.print(string);
        printStream.println(i18n.getString("editJTI.usage.summary"));
        printStream.println(i18n.getString("editJTI.usage.options"));
        printStream.println(i18n.getString("editJTI.usage.help1"));
        printStream.println(i18n.getString("editJTI.usage.help2"));
        printStream.println(i18n.getString("editJTI.usage.help3"));
        printStream.println(i18n.getString("editJTI.usage.classpath1"));
        printStream.println(i18n.getString("editJTI.usage.classpath2"));
        printStream.println(i18n.getString("editJTI.usage.log1"));
        printStream.println(i18n.getString("editJTI.usage.log2"));
        printStream.println(i18n.getString("editJTI.usage.outfile1"));
        printStream.println(i18n.getString("editJTI.usage.outfile2"));
        printStream.println(i18n.getString("editJTI.usage.path1"));
        printStream.println(i18n.getString("editJTI.usage.path2"));
        printStream.println(i18n.getString("editJTI.usage.preview1"));
        printStream.println(i18n.getString("editJTI.usage.preview2"));
        printStream.println(i18n.getString("editJTI.usage.ts1"));
        printStream.println(i18n.getString("editJTI.usage.ts2"));
        printStream.println(i18n.getString("editJTI.usage.verbose1"));
        printStream.println(i18n.getString("editJTI.usage.verbose2"));
        printStream.println("");
        printStream.println(i18n.getString("editJTI.usage.edit"));
        printStream.println(i18n.getString("editJTI.usage.set"));
        printStream.println(i18n.getString("editJTI.usage.search"));
        printStream.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] stringArray) throws BadArgs, Fault {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            boolean bl = this.run(stringArray, printWriter);
            return bl;
        }
        finally {
            printWriter.flush();
        }
    }

    public boolean run(String[] stringArray, PrintWriter printWriter) throws BadArgs, Fault {
        boolean bl;
        boolean bl2;
        String[] stringArray2;
        File file;
        File file2;
        File file3;
        block49: {
            file3 = null;
            file2 = null;
            file = null;
            File file4 = null;
            File file5 = null;
            File file6 = null;
            stringArray2 = null;
            boolean bl3 = false;
            bl2 = false;
            bl = false;
            boolean bl4 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if ((stringArray[i].equals("-o") || stringArray[i].equals("-out")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file2, stringArray[i]);
                    file2 = new File(stringArray[++i]);
                    continue;
                }
                if ((stringArray[i].equals("-i") || stringArray[i].equals("-in")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file3, stringArray[i]);
                    file3 = new File(stringArray[++i]);
                    continue;
                }
                if ((stringArray[i].equals("-l") || stringArray[i].equals("log")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file, stringArray[i]);
                    file = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-n") || stringArray[i].equals("-preview")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-p") || stringArray[i].equals("-path")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-v") || stringArray[i].equals("-verbose")) {
                    bl4 = true;
                    continue;
                }
                if ((stringArray[i].equals("-cp") || stringArray[i].equals("-classpath")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file4, stringArray[i]);
                    file4 = new File(stringArray[++i]);
                    continue;
                }
                if ((stringArray[i].equals("-ts") || stringArray[i].equals("-testsuite")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file5, stringArray[i]);
                    file5 = new File(stringArray[++i]);
                    continue;
                }
                if ((stringArray[i].equals("-wd") || stringArray[i].equals("-workdir")) && i + 1 < stringArray.length) {
                    EditJTI.checkUnset(file5, stringArray[i]);
                    file6 = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-help") || stringArray[i].equals("-usage") || stringArray[i].equals("/?")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].startsWith("-")) {
                    throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", stringArray[i]);
                }
                if (i <= stringArray.length - 1) {
                    if (file3 == null) {
                        stringArray2 = new String[stringArray.length - 1 - i];
                        System.arraycopy(stringArray, i, stringArray2, 0, stringArray2.length);
                        file3 = new File(stringArray[stringArray.length - 1]);
                    } else {
                        stringArray2 = new String[stringArray.length - i];
                        System.arraycopy(stringArray, i, stringArray2, 0, stringArray2.length);
                    }
                    i = stringArray.length - 1;
                    continue;
                }
                throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", stringArray[i]);
            }
            if (stringArray.length == 0 || bl3) {
                EditJTI.usage(System.out);
                if (file3 == null) {
                    return true;
                }
            }
            if (file4 != null && file5 != null) {
                throw new BadArgs(i18n, "editJTI.cantHaveClassPathAndTestSuite");
            }
            if (file3 == null) {
                throw new BadArgs(i18n, "editJTI.noInterview");
            }
            this.verbose = bl4;
            this.out = printWriter;
            try {
                if (file6 != null) {
                    this.interview = InterviewParameters.open(file5, file6, file3);
                    break block49;
                }
                if (file5 != null) {
                    TestSuite testSuite;
                    try {
                        testSuite = TestSuite.open(file5);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new Fault(i18n, "editJTI.cantFindTestSuite", file5);
                    }
                    catch (TestSuite.NotTestSuiteFault notTestSuiteFault) {
                        throw new Fault(i18n, "editJTI.notATestSuite", file5);
                    }
                    catch (TestSuite.Fault fault) {
                        throw new Fault(i18n, "editJTI.cantOpenTestSuite", new Object[]{file5, fault});
                    }
                    this.load(file3, testSuite);
                    break block49;
                }
                if (file4 != null) {
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file4.toURL()});
                    this.load(file3, uRLClassLoader);
                } else {
                    this.load(file3);
                }
            }
            catch (Interview.Fault fault) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file3.getPath(), fault.getMessage()});
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Fault(i18n, "editJTI.cantFindFile", file3.getPath());
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file3.getPath(), iOException});
            }
            catch (IllegalStateException illegalStateException) {
                if (this.verbose) {
                    illegalStateException.printStackTrace();
                }
                throw new Fault(i18n, "editJTI.badState", illegalStateException.getMessage());
            }
        }
        if (NUM_BACKUPS > 0) {
            this.interview.setBackupPolicy(BackupPolicy.simpleBackups(NUM_BACKUPS));
        }
        if (stringArray2 != null) {
            this.edit(stringArray2);
        }
        if (bl) {
            this.showPath();
        }
        try {
            if (file != null) {
                if (bl2) {
                    String string = i18n.getString("editJTI.wouldWriteLog", file);
                    printWriter.println(string);
                } else {
                    this.writeLog(file);
                }
            }
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "editJTI.cantWriteLog", new Object[]{file.getPath(), iOException});
        }
        try {
            if (bl2) {
                String string = this.interview.isEdited() ? i18n.getString("editJTI.wouldSaveEdited", file2 != null ? file2 : file3) : (file2 != null ? i18n.getString("editJTI.wouldSaveNotEdited", file2) : i18n.getString("editJTI.wouldNotSave"));
                printWriter.println(string);
            } else if (file2 != null) {
                this.save(file2);
            } else if (this.interview.isEdited()) {
                this.save(file3);
            }
        }
        catch (Interview.Fault fault) {
            throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{file2.getPath(), fault});
        }
        catch (IOException iOException) {
            File file7 = file2 == null ? this.interview.getFile() : file2;
            throw new Fault(i18n, "editJTI.cantSaveFile", new Object[]{file7.getPath(), iOException});
        }
        return this.interview.isFinishable();
    }

    public void load(File file) throws IOException, Interview.Fault {
        this.interview = InterviewParameters.open(file);
        this.interview.setEdited(false);
    }

    public void load(File file, TestSuite testSuite) throws IOException, Interview.Fault, Fault {
        try {
            this.interview = testSuite.createInterview();
        }
        catch (TestSuite.Fault fault) {
            throw new Fault(i18n, "editJTI.cantCreateInterviewForTestSuite", new Object[]{testSuite.getPath(), fault.getMessage()});
        }
        this.interview.load(file);
        this.interview.setEdited(false);
    }

    public void load(File file, URLClassLoader uRLClassLoader) throws IOException, Interview.Fault, Fault {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        String string = (String)properties.get("INTERVIEW");
        try {
            Class<?> clazz = uRLClassLoader.loadClass(string);
            this.interview = (InterviewParameters)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            throw new Fault(i18n, "editJTI.invalidInterview", file);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Fault(i18n, "editJTI.cantFindClass", new Object[]{string, file});
        }
        catch (InstantiationException instantiationException) {
            throw new Fault(i18n, "editJTI.cantInstantiateClass", new Object[]{string, file});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Fault(i18n, "editJTI.cantAccessClass", new Object[]{string, file});
        }
        this.interview.load(file);
        this.interview.setEdited(false);
    }

    public void save(File file) throws IOException, Interview.Fault {
        this.interview.save(file);
    }

    public void showPath() {
        int n;
        Question[] questionArray = this.interview.getPath();
        int n2 = 0;
        for (n = 0; n < questionArray.length; ++n) {
            n2 = Math.max(n2, questionArray[n].getTag().length());
        }
        n2 = Math.min(n2, MAX_INDENT);
        for (n = 0; n < questionArray.length; ++n) {
            Question question = questionArray[n];
            String string = question.getTag();
            String string2 = question.getStringValue();
            this.out.print(string);
            int n3 = string.length();
            if (n3 > MAX_INDENT && string2 != null && string2.length() > 0) {
                this.out.println();
                n3 = 0;
            }
            for (int i = n3; i < n2; ++i) {
                this.out.print(' ');
            }
            this.out.print(' ');
            this.out.println(string2 == null ? "" : string2);
        }
    }

    public void writeLog(File file) throws IOException {
        WizPrint wizPrint = new WizPrint(this.interview);
        wizPrint.setShowResponses(true);
        wizPrint.setShowResponseTypes(false);
        wizPrint.setShowTags(true);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        wizPrint.write(bufferedWriter);
    }

    public void edit(String[] stringArray) throws Fault {
        for (int i = 0; i < stringArray.length; ++i) {
            this.edit(stringArray[i]);
        }
    }

    public void edit(String string) throws Fault {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf(61);
        if (Character.isJavaIdentifierStart(string.charAt(0)) && n > 0) {
            this.setValue(string.substring(0, n), string.substring(n + 1));
        } else if (string.toLowerCase().startsWith("import:")) {
            this.importFile(new File(string.substring("import:".length())));
        } else {
            int n2 = 0;
            char c = string.charAt(n2);
            int n3 = string.indexOf(c, n2 + 1);
            if (n3 == -1) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            int n4 = string.length() - 1;
            if (string.charAt(n4) != c) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            String string2 = string.substring(n2 + 1, n3);
            String string3 = string.substring(n3 + 1, n4);
            if (string2.length() == 0) {
                throw new Fault(i18n, "editJTI.badCmd", string);
            }
            this.setMatchingValues(string2, string3);
        }
    }

    private void importFile(File file) throws Fault {
        Properties properties;
        BufferedInputStream bufferedInputStream;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "editJTI.cantFindImport", file);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "editJTI.cantOpenImport", new Object[]{file, iOException});
        }
        try {
            properties = new Properties();
            properties.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "editJTI.cantReadImport", new Object[]{file, iOException});
        }
        Question[] questionArray = this.interview.getPath();
        for (int i = 0; i < questionArray.length; ++i) {
            Question question = questionArray[i];
            String string = properties.getProperty(question.getTag());
            if (string == null) continue;
            this.setValue(question, string);
            questionArray = this.interview.getPath();
        }
    }

    private void setMatchingValues(String string, String string2) throws Fault {
        boolean bl = false;
        Question[] questionArray = this.interview.getPath();
        for (int i = 0; i < questionArray.length; ++i) {
            int n;
            Question question = questionArray[i];
            String string3 = question.getStringValue();
            if (string3 == null || (n = EditJTI.match(string, string3, false, false)) < 0) continue;
            String string4 = string3.substring(0, n) + string2 + string3.substring(n + string.length());
            this.setValue(question, string4);
            bl = true;
            questionArray = this.interview.getPath();
        }
        if (!bl) {
            throw new Fault(i18n, "editJTI.cantFindMatch", string);
        }
    }

    private void setValue(String string, String string2) throws Fault {
        Question[] questionArray = this.interview.getPath();
        for (int i = 0; i < questionArray.length; ++i) {
            Question question = questionArray[i];
            if (!question.getTag().equals(string)) continue;
            this.setValue(question, string2);
            return;
        }
        throw new Fault(i18n, "editJTI.cantFindQuestion", string);
    }

    private void setValue(Question question, String string) throws Fault {
        try {
            String string2 = question.getStringValue();
            question.setValue(string);
            if (this.verbose) {
                this.out.println(i18n.getString("editJTI.update", new Object[]{question.getTag(), string2, question.getStringValue()}));
            }
        }
        catch (Interview.Fault fault) {
            throw new Fault(i18n, "editJTI.cantSetValue", new Object[]{question.getTag(), fault.getMessage()});
        }
    }

    private static int match(String string, String string2, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i <= n2 - n; ++i) {
            if (!string.regionMatches(!bl, 0, string2, i, n) || bl2 && (!bl2 || i != 0 && !EditJTI.isBoundaryCh(string2.charAt(i - 1)) || i + n != string2.length() && !EditJTI.isBoundaryCh(string2.charAt(i + n)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    private static void checkUnset(Object object, String string) throws BadArgs {
        if (object != null) {
            throw new BadArgs((ResourceBundle)i18n, "editJTI.dupOption", string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        BadArgs(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

