/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.SortedProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class InterviewParameters
extends Interview
implements Parameters {
    private boolean inGetName;
    private ExcludeListFilter cachedExcludeListFilter;
    private KeywordsFilter cachedKeywordsFilter;
    private StatusFilter cachedStatusFilter;
    private TestFilter cachedRelevantTestFilter;
    private TestSuite cachedRelevantTestFilterTestSuite;
    private TestEnvironment cachedRelevantTestFilterEnv;
    private TestFilter[] cachedTestFilters;
    private WorkDirectory workDir;
    private BackupPolicy backupPolicy;
    private boolean markersEnabled;
    private boolean markersFilterEnabled;
    private File currFile;
    private long currFileLastModified;
    private boolean currFileLoaded;
    private static final String TESTSUITE = "TESTSUITE";
    private static final String WORKDIR = "WORKDIR";
    private static final String MARKERS_ENABLED = "MARKERS.enabled";
    private static final String MARKERS_FILTER = "MARKERS.filter";
    private static final String TRUE = "true";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$InterviewParameters == null ? (class$com$sun$javatest$InterviewParameters = InterviewParameters.class$("com.sun.javatest.InterviewParameters")) : class$com$sun$javatest$InterviewParameters);
    static /* synthetic */ Class class$com$sun$javatest$InterviewParameters;

    protected InterviewParameters(String string) {
        super(string);
    }

    public abstract void setWorkDirectory(WorkDirectory var1);

    public void init(String[] stringArray) throws Interview.Fault {
        if (stringArray != null && stringArray.length > 0) {
            throw new Interview.Fault(i18n, "ip.unknownArgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getName() {
        if (this.inGetName) {
            return null;
        }
        try {
            TestEnvironment testEnvironment;
            this.inGetName = true;
            Parameters.EnvParameters envParameters = this.getEnvParameters();
            if (envParameters != null && (testEnvironment = envParameters.getEnv()) != null) {
                String string = testEnvironment.getName();
                return string;
            }
            testEnvironment = null;
            return testEnvironment;
        }
        finally {
            this.inGetName = false;
        }
    }

    public String getDescription() {
        TestEnvironment testEnvironment;
        Parameters.EnvParameters envParameters = this.getEnvParameters();
        if (envParameters != null && (testEnvironment = envParameters.getEnv()) != null) {
            return testEnvironment.getDescription();
        }
        return null;
    }

    protected Question getPrologSuccessorQuestion() {
        return this.getEnvFirstQuestion();
    }

    public TestEnvironment getEnv() {
        Parameters.EnvParameters envParameters = this.getEnvParameters();
        if (envParameters == null) {
            throw new NullPointerException();
        }
        return envParameters.getEnv();
    }

    protected abstract Question getEnvFirstQuestion();

    protected Question getEnvSuccessorQuestion() {
        return this.getTestsFirstQuestion();
    }

    public String[] getTests() {
        Parameters.TestsParameters testsParameters = this.getTestsParameters();
        return testsParameters == null ? null : testsParameters.getTests();
    }

    protected abstract Question getTestsFirstQuestion();

    protected Question getTestsSuccessorQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    public ExcludeList getExcludeList() {
        Parameters.ExcludeListParameters excludeListParameters = this.getExcludeListParameters();
        return excludeListParameters == null ? new ExcludeList() : excludeListParameters.getExcludeList();
    }

    protected abstract Question getExcludeListFirstQuestion();

    protected Question getExcludeTableFirstQuestion() {
        return this.getExcludeListFirstQuestion();
    }

    protected Question getExcludeListSuccessorQuestion() {
        return this.getKeywordsFirstQuestion();
    }

    protected Question getExcludeTableSuccessorQuestion() {
        return this.getExcludeListSuccessorQuestion();
    }

    public Keywords getKeywords() {
        Parameters.KeywordsParameters keywordsParameters = this.getKeywordsParameters();
        return keywordsParameters == null ? null : keywordsParameters.getKeywords();
    }

    protected abstract Question getKeywordsFirstQuestion();

    protected Question getKeywordsSuccessorQuestion() {
        return this.getPriorStatusFirstQuestion();
    }

    public boolean[] getPriorStatusValues() {
        Parameters.PriorStatusParameters priorStatusParameters = this.getPriorStatusParameters();
        return priorStatusParameters == null ? null : priorStatusParameters.getPriorStatusValues();
    }

    protected abstract Question getPriorStatusFirstQuestion();

    protected Question getPriorStatusSuccessorQuestion() {
        return this.getConcurrencyFirstQuestion();
    }

    public int getConcurrency() {
        Parameters.ConcurrencyParameters concurrencyParameters = this.getConcurrencyParameters();
        return concurrencyParameters == null ? 1 : concurrencyParameters.getConcurrency();
    }

    protected abstract Question getConcurrencyFirstQuestion();

    protected Question getConcurrencySuccessorQuestion() {
        return this.getTimeoutFactorFirstQuestion();
    }

    public float getTimeoutFactor() {
        Parameters.TimeoutFactorParameters timeoutFactorParameters = this.getTimeoutFactorParameters();
        return timeoutFactorParameters == null ? 1.0f : timeoutFactorParameters.getTimeoutFactor();
    }

    protected abstract Question getTimeoutFactorFirstQuestion();

    protected Question getTimeoutFactorSuccessorQuestion() {
        return this.getEpilogFirstQuestion();
    }

    protected abstract Question getEpilogFirstQuestion();

    public boolean isValid() {
        return this.isFinishable();
    }

    public String getErrorMessage() {
        Question[] questionArray = this.getPath();
        Question question = questionArray[questionArray.length - 1];
        if (question instanceof FinalQuestion) {
            return null;
        }
        if (question instanceof ErrorQuestion) {
            return question.getText();
        }
        String string = question.getStringValue();
        return i18n.getString("ip.noAnswer", new Object[]{question.getSummary(), question.getText(), question.getTag(), new Integer(string == null ? 0 : 1), this.trim(string)});
    }

    private String trim(String string) {
        return string == null ? null : (string.length() < 40 ? string : string.substring(0, 37) + "...");
    }

    public TestFilter getExcludeTableFilter() {
        return this.getExcludeListFilter();
    }

    public TestFilter getExcludeListFilter() {
        ExcludeList excludeList = this.getExcludeList();
        if (excludeList == null) {
            this.cachedExcludeListFilter = null;
        } else if (this.cachedExcludeListFilter == null || this.cachedExcludeListFilter.getExcludeList() != excludeList) {
            this.cachedExcludeListFilter = new ExcludeListFilter(excludeList);
        }
        return this.cachedExcludeListFilter;
    }

    public TestFilter getKeywordsFilter() {
        Keywords keywords = this.getKeywords();
        if (keywords == null) {
            this.cachedKeywordsFilter = null;
        } else if (this.cachedKeywordsFilter == null || this.cachedKeywordsFilter.getKeywords() != keywords) {
            this.cachedKeywordsFilter = new KeywordsFilter(keywords);
        }
        return this.cachedKeywordsFilter;
    }

    public TestFilter getPriorStatusFilter() {
        WorkDirectory workDirectory = this.getWorkDirectory();
        TestResultTable testResultTable = workDirectory == null ? null : workDirectory.getTestResultTable();
        boolean[] blArray = this.getPriorStatusValues();
        if (testResultTable == null || blArray == null) {
            this.cachedStatusFilter = null;
        } else if (this.cachedStatusFilter == null || this.cachedStatusFilter.getTestResultTable() != testResultTable || !InterviewParameters.equal(this.cachedStatusFilter.getStatusValues(), blArray)) {
            this.cachedStatusFilter = new StatusFilter(blArray, testResultTable);
        }
        return this.cachedStatusFilter;
    }

    public TestFilter getRelevantTestFilter() {
        TestSuite testSuite = this.getTestSuite();
        TestEnvironment testEnvironment = this.getEnv();
        if (testSuite == null || testEnvironment == null) {
            this.cachedRelevantTestFilter = null;
        } else if (this.cachedRelevantTestFilter == null || testSuite != this.cachedRelevantTestFilterTestSuite || testEnvironment != this.cachedRelevantTestFilterEnv) {
            this.cachedRelevantTestFilter = testSuite.createTestFilter(testEnvironment);
        }
        return this.cachedRelevantTestFilter;
    }

    public synchronized TestFilter[] getFilters() {
        TestFilter testFilter;
        TestFilter testFilter2;
        TestFilter testFilter3;
        Vector<TestFilter> vector = new Vector<TestFilter>();
        TestFilter testFilter4 = this.getExcludeListFilter();
        if (testFilter4 != null) {
            vector.addElement(testFilter4);
        }
        if ((testFilter3 = this.getKeywordsFilter()) != null) {
            vector.addElement(testFilter3);
        }
        if ((testFilter2 = this.getPriorStatusFilter()) != null) {
            vector.addElement(testFilter2);
        }
        if ((testFilter = this.getRelevantTestFilter()) != null) {
            vector.addElement(testFilter);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (InterviewParameters.equal(vector, this.cachedTestFilters)) {
            return this.cachedTestFilters;
        }
        Object[] objectArray = new TestFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static boolean equal(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null) {
            return blArray == blArray2;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(Vector vector, TestFilter[] testFilterArray) {
        if (testFilterArray == null || vector.size() != testFilterArray.length) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(testFilterArray[i])) continue;
            return false;
        }
        return true;
    }

    public File getFile() {
        return this.currFile;
    }

    public void setFile(File file) {
        this.currFile = file;
        this.currFileLoaded = false;
        this.currFileLastModified = 0L;
    }

    public static boolean isInterviewFile(File file) {
        return file.getName().endsWith(".jti");
    }

    public static InterviewParameters open(File file) throws IOException, Interview.Fault {
        return InterviewParameters.open(file, (TestSuite)null, (WorkDirectory)null);
    }

    public static InterviewParameters open(File file, TestSuite testSuite) throws IOException, Interview.Fault {
        if (testSuite == null) {
            throw new NullPointerException();
        }
        return InterviewParameters.open(file, testSuite, null);
    }

    public static InterviewParameters open(File file, WorkDirectory workDirectory) throws IOException, Interview.Fault {
        if (workDirectory == null) {
            throw new NullPointerException();
        }
        return InterviewParameters.open(file, workDirectory.getTestSuite(), workDirectory);
    }

    private static InterviewParameters open(File file, TestSuite testSuite, WorkDirectory workDirectory) throws IOException, Interview.Fault {
        Object object;
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            properties.load(bufferedInputStream);
        }
        catch (RuntimeException runtimeException) {
            throw new JTIFault((ResourceBundle)i18n, "ip.errorReadingFile", new Object[]{file, runtimeException});
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        if (testSuite == null) {
            object = (String)properties.get(TESTSUITE);
            if (object == null) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.noTestSuiteInFile", file);
            }
            try {
                testSuite = TestSuite.open(new File((String)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TestSuiteFault((ResourceBundle)i18n, "ip.cantFindTestSuiteInFile", new Object[]{object, file});
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuiteInFile", new Object[]{object, file, fault.getMessage()});
            }
        }
        if (workDirectory == null && (object = (String)properties.get(WORKDIR)) != null) {
            try {
                workDirectory = WorkDirectory.open(new File((String)object), testSuite);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WorkDirFault((ResourceBundle)i18n, "ip.cantFindWorkDirInFile", new Object[]{object, file});
            }
            catch (WorkDirectory.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDirInFile", new Object[]{object, file, fault.getMessage()});
            }
        }
        try {
            object = testSuite.createInterview();
        }
        catch (TestSuite.Fault fault) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{testSuite.getPath(), fault.getMessage()});
        }
        if (workDirectory != null) {
            ((InterviewParameters)object).setWorkDirectory(workDirectory);
        }
        try {
            ((InterviewParameters)object).load((Map)properties, file);
        }
        catch (Interview.Fault fault) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantLoadInterview", new Object[]{file, fault.getMessage()});
        }
        return object;
    }

    public void clear() {
        super.clear();
        this.setEdited(false);
        this.currFile = null;
    }

    public static InterviewParameters open(String string, String string2, String string3) throws Interview.Fault {
        File file = string != null && string.length() > 0 ? new File(string) : null;
        File file2 = string2 != null && string2.length() > 0 ? new File(string2) : null;
        File file3 = string3 != null && string3.length() > 0 ? new File(string3) : null;
        return InterviewParameters.open(file, file2, file3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InterviewParameters open(File file, File file2, File file3) throws Interview.Fault {
        InterviewParameters interviewParameters;
        WorkDirectory workDirectory;
        TestSuite testSuite;
        if (file != null) {
            try {
                testSuite = TestSuite.open(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindTestSuite", file);
            }
            catch (IOException iOException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{file, iOException});
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenTestSuite", new Object[]{file, fault.getMessage()});
            }
        } else {
            testSuite = null;
        }
        if (file2 != null) {
            try {
                if (testSuite == null) {
                    workDirectory = WorkDirectory.open(file2);
                    testSuite = workDirectory.getTestSuite();
                }
                workDirectory = WorkDirectory.open(file2, testSuite);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindWorkDir", file2);
            }
            catch (IOException iOException) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{file2, iOException});
            }
            catch (WorkDirectory.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenWorkDir", new Object[]{file2, fault.getMessage()});
            }
        } else {
            workDirectory = null;
        }
        if (file3 == null) {
            if (testSuite == null) throw new Interview.Fault(i18n, "ip.noPaths");
            try {
                interviewParameters = testSuite.createInterview();
            }
            catch (TestSuite.Fault fault) {
                throw new Interview.Fault((ResourceBundle)i18n, "ip.cantCreateInterviewForTestSuite", new Object[]{file, fault});
            }
            if (workDirectory == null) return interviewParameters;
            interviewParameters.setWorkDirectory(workDirectory);
            return interviewParameters;
        }
        try {
            if (workDirectory != null) return InterviewParameters.open(file3, workDirectory);
            if (testSuite == null) {
                interviewParameters = InterviewParameters.open(file3);
                testSuite = interviewParameters.getTestSuite();
            } else {
                interviewParameters = InterviewParameters.open(file3, testSuite);
            }
            workDirectory = interviewParameters.getWorkDirectory();
            return interviewParameters;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantFindConfigFile", file3);
        }
        catch (IOException iOException) {
            throw new Interview.Fault((ResourceBundle)i18n, "ip.cantOpenConfigFile", new Object[]{file3, iOException});
        }
    }

    public void load() throws IOException, Interview.Fault {
        File file = this.getFile();
        if (file != null && file.exists()) {
            this.load(file);
        } else {
            this.clear();
            this.setEdited(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws FileNotFoundException, IOException, Interview.Fault {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            this.load((Map)properties, file);
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public void load(Map map, File file) throws Interview.Fault {
        this.load(map);
        this.setEdited(false);
        this.currFile = file;
        this.currFileLastModified = file.lastModified();
        this.currFileLoaded = true;
    }

    public void load(Map map, boolean bl) throws Interview.Fault {
        super.load(map, bl);
        String string = (String)map.get(MARKERS_ENABLED);
        this.setMarkersEnabled(string != null && string.equalsIgnoreCase(TRUE));
        String string2 = (String)map.get(MARKERS_FILTER);
        this.setMarkersFilterEnabled(string2 != null && string2.equalsIgnoreCase(TRUE));
    }

    public void load(Parameters parameters) {
        this.loadTestsParameters(parameters.getTestsParameters());
        this.loadExcludeListParameters(parameters.getExcludeListParameters());
        this.loadKeywordsParameters(parameters.getKeywordsParameters());
        this.loadPriorStatusParameters(parameters.getPriorStatusParameters());
        this.loadEnvParameters(parameters.getEnvParameters());
        this.loadConcurrencyParameters(parameters.getConcurrencyParameters());
        this.loadTimeoutFactorParameters(parameters.getTimeoutFactorParameters());
    }

    private void loadTestsParameters(Parameters.TestsParameters testsParameters) {
        Parameters.TestsParameters testsParameters2 = this.getTestsParameters();
        if (!(testsParameters2 instanceof Parameters.MutableTestsParameters)) {
            return;
        }
        Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)testsParameters2;
        if (testsParameters instanceof Parameters.MutableTestsParameters) {
            Parameters.MutableTestsParameters mutableTestsParameters2 = (Parameters.MutableTestsParameters)testsParameters;
            mutableTestsParameters.setTestsMode(mutableTestsParameters2.getTestsMode());
            mutableTestsParameters.setSpecifiedTests(mutableTestsParameters2.getSpecifiedTests());
        } else {
            String[] stringArray = testsParameters.getTests();
            if (stringArray == null) {
                mutableTestsParameters.setTestsMode(1);
                mutableTestsParameters.setSpecifiedTests(null);
            } else {
                mutableTestsParameters.setTestsMode(2);
                mutableTestsParameters.setSpecifiedTests(stringArray);
            }
        }
    }

    private void loadExcludeListParameters(Parameters.ExcludeListParameters excludeListParameters) {
        Parameters.ExcludeListParameters excludeListParameters2 = this.getExcludeListParameters();
        if (!(excludeListParameters2 instanceof Parameters.MutableExcludeListParameters)) {
            return;
        }
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters2;
        if (excludeListParameters instanceof Parameters.MutableExcludeListParameters) {
            Parameters.MutableExcludeListParameters mutableExcludeListParameters2 = (Parameters.MutableExcludeListParameters)excludeListParameters;
            mutableExcludeListParameters.setExcludeMode(mutableExcludeListParameters2.getExcludeMode());
            mutableExcludeListParameters.setCustomExcludeFiles(mutableExcludeListParameters2.getCustomExcludeFiles());
            mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(mutableExcludeListParameters2.isLatestExcludeAutoCheckEnabled());
            mutableExcludeListParameters.setLatestExcludeAutoCheckMode(mutableExcludeListParameters2.getLatestExcludeAutoCheckMode());
            mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(mutableExcludeListParameters2.getLatestExcludeAutoCheckInterval());
        } else {
            mutableExcludeListParameters.setExcludeMode(4);
            mutableExcludeListParameters.setCustomExcludeFiles(null);
            mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(false);
            mutableExcludeListParameters.setLatestExcludeAutoCheckMode(1);
            mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(0);
        }
    }

    private void loadKeywordsParameters(Parameters.KeywordsParameters keywordsParameters) {
        Parameters.KeywordsParameters keywordsParameters2 = this.getKeywordsParameters();
        if (!(keywordsParameters2 instanceof Parameters.MutableKeywordsParameters)) {
            return;
        }
        Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)keywordsParameters2;
        if (keywordsParameters instanceof Parameters.MutableKeywordsParameters) {
            Parameters.MutableKeywordsParameters mutableKeywordsParameters2 = (Parameters.MutableKeywordsParameters)keywordsParameters;
            mutableKeywordsParameters.setKeywordsMode(mutableKeywordsParameters2.getKeywordsMode());
            mutableKeywordsParameters.setMatchKeywords(mutableKeywordsParameters2.getMatchKeywordsMode(), mutableKeywordsParameters2.getMatchKeywordsValue());
        } else {
            Keywords keywords = keywordsParameters.getKeywords();
            if (keywords == null) {
                mutableKeywordsParameters.setKeywordsMode(1);
                mutableKeywordsParameters.setMatchKeywords(3, "");
            } else {
                mutableKeywordsParameters.setKeywordsMode(2);
                mutableKeywordsParameters.setMatchKeywords(3, keywords.toString());
            }
        }
    }

    private void loadPriorStatusParameters(Parameters.PriorStatusParameters priorStatusParameters) {
        Parameters.PriorStatusParameters priorStatusParameters2 = this.getPriorStatusParameters();
        if (!(priorStatusParameters2 instanceof Parameters.MutablePriorStatusParameters)) {
            return;
        }
        Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)priorStatusParameters2;
        if (priorStatusParameters instanceof Parameters.MutablePriorStatusParameters) {
            Parameters.MutablePriorStatusParameters mutablePriorStatusParameters2 = (Parameters.MutablePriorStatusParameters)priorStatusParameters;
            mutablePriorStatusParameters.setPriorStatusMode(mutablePriorStatusParameters2.getPriorStatusMode());
            mutablePriorStatusParameters.setMatchPriorStatusValues(mutablePriorStatusParameters2.getMatchPriorStatusValues());
        } else {
            boolean[] blArray = priorStatusParameters.getPriorStatusValues();
            if (blArray == null) {
                mutablePriorStatusParameters.setPriorStatusMode(1);
                mutablePriorStatusParameters.setMatchPriorStatusValues(new boolean[4]);
            } else {
                mutablePriorStatusParameters.setPriorStatusMode(2);
                mutablePriorStatusParameters.setMatchPriorStatusValues(blArray);
            }
        }
    }

    private void loadEnvParameters(Parameters.EnvParameters envParameters) {
        Parameters.EnvParameters envParameters2 = this.getEnvParameters();
        if (!(envParameters2 instanceof Parameters.LegacyEnvParameters)) {
            return;
        }
        Parameters.LegacyEnvParameters legacyEnvParameters = (Parameters.LegacyEnvParameters)envParameters2;
        if (envParameters instanceof Parameters.LegacyEnvParameters) {
            Parameters.LegacyEnvParameters legacyEnvParameters2 = (Parameters.LegacyEnvParameters)envParameters;
            legacyEnvParameters.setEnvFiles(legacyEnvParameters2.getEnvFiles());
            legacyEnvParameters.setEnvName(legacyEnvParameters2.getEnvName());
        }
    }

    private void loadConcurrencyParameters(Parameters.ConcurrencyParameters concurrencyParameters) {
        Parameters.ConcurrencyParameters concurrencyParameters2 = this.getConcurrencyParameters();
        if (!(concurrencyParameters2 instanceof Parameters.MutableConcurrencyParameters)) {
            return;
        }
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)concurrencyParameters2;
        mutableConcurrencyParameters.setConcurrency(concurrencyParameters.getConcurrency());
    }

    private void loadTimeoutFactorParameters(Parameters.TimeoutFactorParameters timeoutFactorParameters) {
        Parameters.TimeoutFactorParameters timeoutFactorParameters2 = this.getTimeoutFactorParameters();
        if (!(timeoutFactorParameters2 instanceof Parameters.MutableTimeoutFactorParameters)) {
            return;
        }
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)timeoutFactorParameters2;
        mutableTimeoutFactorParameters.setTimeoutFactor(timeoutFactorParameters.getTimeoutFactor());
    }

    public void save() throws IOException, Interview.Fault {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException();
        }
        this.save(file);
    }

    public void save(File file) throws IOException, Interview.Fault {
        this.saveAs(file);
        this.setEdited(false);
        this.currFile = file;
        this.currFileLastModified = file.lastModified();
        this.currFileLoaded = true;
    }

    public void saveAs(File file) throws IOException, Interview.Fault {
        this.saveAs(file, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(File file, boolean bl, boolean bl2) throws IOException, Interview.Fault {
        Object object;
        SortedProperties sortedProperties = new SortedProperties();
        if (bl && (object = this.getTestSuite()) != null) {
            sortedProperties.put(TESTSUITE, ((TestSuite)object).getPath());
        }
        if (bl2 && (object = this.getWorkDirectory()) != null) {
            sortedProperties.put(WORKDIR, ((WorkDirectory)object).getPath());
        }
        this.save(sortedProperties);
        object = this.backupPolicy == null ? new BufferedOutputStream(new FileOutputStream(file)) : this.backupPolicy.backupAndOpenStream(file);
        try {
            sortedProperties.store((OutputStream)object, "JavaTest Configuration Interview");
        }
        finally {
            ((OutputStream)object).close();
        }
    }

    public void save(Map map) {
        if (this.markersEnabled) {
            map.put(MARKERS_ENABLED, TRUE);
        }
        if (this.markersFilterEnabled) {
            map.put(MARKERS_FILTER, TRUE);
        }
        super.save(map);
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public boolean isFileLoaded() {
        return this.currFileLoaded;
    }

    public boolean isFileNewer() {
        File file = this.getFile();
        return file != null && file.exists() && (this.currFileLastModified == 0L || file.lastModified() > this.currFileLastModified);
    }

    public boolean getMarkersEnabled() {
        return this.markersEnabled;
    }

    public void setMarkersEnabled(boolean bl) {
        if (bl != this.markersEnabled) {
            this.markersEnabled = bl;
            this.setEdited(true);
        }
    }

    public boolean getMarkersFilterEnabled() {
        return this.markersFilterEnabled;
    }

    public void setMarkersFilterEnabled(boolean bl) {
        if (bl != this.markersFilterEnabled) {
            this.markersFilterEnabled = bl;
            this.setEdited(true);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class JTIFault
    extends Interview.Fault {
        public JTIFault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle, string);
        }

        public JTIFault(ResourceBundle resourceBundle, String string, Object object) {
            super(resourceBundle, string, object);
        }

        public JTIFault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(resourceBundle, string, objectArray);
        }
    }

    public static class TestSuiteFault
    extends Interview.Fault {
        public TestSuiteFault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle, string);
        }

        public TestSuiteFault(ResourceBundle resourceBundle, String string, Object object) {
            super(resourceBundle, string, object);
        }

        public TestSuiteFault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(resourceBundle, string, objectArray);
        }
    }

    public static class WorkDirFault
    extends Interview.Fault {
        public WorkDirFault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle, string);
        }

        public WorkDirFault(ResourceBundle resourceBundle, String string, Object object) {
            super(resourceBundle, string, object);
        }

        public WorkDirFault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(resourceBundle, string, objectArray);
        }
    }
}

