/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

class TRT_Iterator
implements TestResultTable.TreeIterator {
    private String[] initialTests;
    private Object outQueueLock = new Object();
    private LinkedList outQueue;
    private TestResultTable.TreeNode[] nodes;
    private int nodeIndex = -1;
    private TestFilter[] filters;
    private int[] resultStats;
    private int absoluteCount;
    private int rejectCount;
    private boolean recordRejects;
    private Hashtable filteredTRs;
    private TestResult currentResult;
    private Object rejLock;
    private FilterObserver fo;
    private Stack stack;
    private PseudoFrame currFrame = null;
    private boolean finished = false;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TRT_Iterator == null ? (class$com$sun$javatest$TRT_Iterator = TRT_Iterator.class$("com.sun.javatest.TRT_Iterator")) : class$com$sun$javatest$TRT_Iterator);
    protected boolean debug = Debug.getBoolean(class$com$sun$javatest$TRT_Iterator == null ? (class$com$sun$javatest$TRT_Iterator = TRT_Iterator.class$("com.sun.javatest.TRT_Iterator")) : class$com$sun$javatest$TRT_Iterator);
    static /* synthetic */ Class class$com$sun$javatest$TRT_Iterator;

    protected TRT_Iterator() {
        this.outQueue = new LinkedList();
        this.resultStats = new int[4];
    }

    TRT_Iterator(TestResultTable.TreeNode treeNode) {
        this();
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = treeNode;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator without filters, one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode treeNode, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        this.nodes = new TestResultTable.TreeNode[1];
        this.nodes[0] = treeNode;
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and one initial node.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] treeNodeArray, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        if (treeNodeArray != null) {
            this.nodes = new TestResultTable.TreeNode[treeNodeArray.length];
            System.arraycopy(treeNodeArray, 0, this.nodes, 0, treeNodeArray.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters and initial nodes.");
        }
    }

    TRT_Iterator(TestResultTable.TreeNode[] treeNodeArray, TestResult[] testResultArray, TestFilter[] testFilterArray) {
        this();
        this.filters = testFilterArray;
        if (testResultArray != null && testResultArray.length != 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < testResultArray.length; ++i) {
                try {
                    if (this.wouldAccept(testResultArray[i]) != -1) continue;
                    this.outQueue.addLast(testResultArray[i]);
                    vector.add(testResultArray[i].getDescription().getRootRelativeURL());
                    continue;
                }
                catch (TestResult.Fault fault) {
                    // empty catch block
                }
            }
            this.initialTests = new String[vector.size()];
            vector.copyInto(this.initialTests);
        }
        if (treeNodeArray != null) {
            this.nodes = new TestResultTable.TreeNode[treeNodeArray.length];
            System.arraycopy(treeNodeArray, 0, this.nodes, 0, treeNodeArray.length);
        }
        this.init(this.nodes);
        if (this.debug) {
            Debug.println("Created TreeIterator with filters, nodes and initial TR set.");
        }
    }

    public boolean hasMoreElements() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        TestResult testResult = null;
        if (this.hasMoreElements()) {
            Object object = this.outQueueLock;
            synchronized (object) {
                testResult = (TestResult)this.outQueue.removeFirst();
            }
            this.findNext();
            int n = testResult.getStatus().getType();
            this.resultStats[n] = this.resultStats[n] + 1;
            return testResult;
        }
        throw new NoSuchElementException(i18n.getString("trt.noElements"));
    }

    public boolean hasNext() {
        return this.hasMoreElements();
    }

    public Object next() {
        return this.nextElement();
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from TestResultTable thhrough interator.  Do not call this method.");
    }

    public int getProcessedCount() {
        return this.absoluteCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public void setRecordRejects(boolean bl) {
        this.recordRejects = bl;
        if (this.recordRejects) {
            if (this.filteredTRs == null) {
                this.filteredTRs = new Hashtable(10);
            }
            if (this.fo == null) {
                this.fo = new FilterObserver();
            }
        }
    }

    public int[] getResultStats() {
        int[] nArray = new int[this.resultStats.length];
        System.arraycopy(this.resultStats, 0, nArray, 0, this.resultStats.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getFilterStats() {
        if (this.filteredTRs == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        Object object = this.rejLock;
        synchronized (object) {
            Enumeration enumeration = this.filteredTRs.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Iterator iterator = ((Vector)this.filteredTRs.get(k)).iterator();
                while (iterator.hasNext()) {
                    hashtable.put(iterator.next(), k);
                }
            }
        }
        return hashtable;
    }

    public TestFilter[] getFilters() {
        if (this.filters == null || this.filters.length == 0) {
            return null;
        }
        TestFilter[] testFilterArray = new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, testFilterArray, 0, this.filters.length);
        return testFilterArray;
    }

    public String[] getInitialURLs() {
        int n;
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        if (this.nodes != null) {
            for (n = 0; n < this.nodes.length; ++n) {
                vector.addElement(TestResultTable.getRootRelativePath(this.nodes[n]));
            }
        }
        if (this.initialTests != null) {
            for (n = 0; n < this.initialTests.length; ++n) {
                vector.add(this.initialTests[n]);
            }
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        if (this.hasNext()) {
            Object object = this.outQueueLock;
            synchronized (object) {
                return this.outQueue.getFirst();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPending(TestResult testResult) {
        boolean bl;
        block31: {
            TRT_TreeNode tRT_TreeNode;
            int n;
            String string;
            String string2;
            String string3;
            block32: {
                int n2;
                if (!this.hasMoreElements()) {
                    return false;
                }
                string2 = string3 = testResult.getTestName();
                Object object = this.outQueueLock;
                synchronized (object) {
                    if (this.outQueue.size() > 0) {
                        for (n2 = 0; n2 < this.outQueue.size(); ++n2) {
                            TestResult testResult2 = (TestResult)this.outQueue.get(n2);
                            if (!testResult2.getTestName().equals(string3)) continue;
                            return true;
                        }
                    }
                }
                bl = false;
                n2 = 0;
                if (this.nodes == null) break block31;
                block12: for (int i = this.nodeIndex; i < this.nodes.length; ++i) {
                    string = TestResultTable.getRootRelativePath(this.nodes[i]);
                    if (!string3.startsWith(string)) continue;
                    if (i > this.nodeIndex) {
                        bl = true;
                        n2 = 1;
                        break;
                    }
                    if (i < this.nodeIndex) {
                        bl = false;
                        n2 = 1;
                        break;
                    }
                    if (string.length() != 0) {
                        string2 = string3.substring(string.length() + 1);
                    }
                    for (n = 0; n < this.stack.size(); ++n) {
                        String string4 = TestResultTable.getDirName(string2);
                        string2 = TestResultTable.behead(string2);
                        PseudoFrame pseudoFrame = (PseudoFrame)this.stack.elementAt(n);
                        TRT_TreeNode tRT_TreeNode2 = (TRT_TreeNode)pseudoFrame.getNode();
                        int n3 = tRT_TreeNode2.getNodeIndex(string4, false);
                        int n4 = pseudoFrame.getCurrentIndex();
                        if (string3.indexOf("/") == -1) {
                            n3 = n4;
                        }
                        if (n3 == -1 || n3 < n4) {
                            bl = false;
                            n2 = 1;
                            continue block12;
                        }
                        if (n3 == pseudoFrame.getCurrentIndex()) {
                            if (string2.indexOf(47) != -1) continue;
                            if (n + 1 == this.stack.size()) {
                                n2 = 0;
                                continue block12;
                            }
                            switch (TRT_Iterator.checkTestPosition(pseudoFrame, string3)) {
                                case -1: 
                                case 0: {
                                    bl = false;
                                    n2 = 1;
                                    continue block12;
                                }
                                case 2: {
                                    bl = true;
                                    n2 = 1;
                                    continue block12;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        bl = true;
                        n2 = 1;
                        continue block12;
                    }
                }
                if (n2 != 0) break block31;
                tRT_TreeNode = (TRT_TreeNode)this.currFrame.getNode();
                string = TestResultTable.getDirName(string2);
                if ((string2 = TestResultTable.behead(string2)).indexOf("/") != -1) break block32;
                switch (TRT_Iterator.checkTestPosition(this.currFrame, string3)) {
                    case -1: 
                    case 0: {
                        bl = false;
                        break block31;
                    }
                    case 2: {
                        bl = true;
                        break block31;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (!string.equals(this.currFrame.getNode().getName())) {
                bl = false;
                string = TestResultTable.getDirName(string2);
                tRT_TreeNode = (TRT_TreeNode)this.currFrame.getNode();
                n = tRT_TreeNode.getNodeIndex(string, false);
                int n5 = this.currFrame.getCurrentIndex();
                if (n == -1) {
                    bl = false;
                } else if (n < n5) {
                    bl = false;
                } else {
                    if (n == n5) {
                        throw new IllegalStateException("");
                    }
                    bl = true;
                }
            } else {
                n = tRT_TreeNode.getTestIndex(string3);
                if (n == -1) {
                    bl = false;
                }
                bl = n > this.currFrame.getCurrentIndex();
            }
        }
        return bl;
    }

    private void init(TestResultTable.TreeNode[] treeNodeArray) {
        this.nodes = treeNodeArray != null && treeNodeArray.length == 0 ? null : treeNodeArray;
        boolean bl = this.nextNode();
        if (bl) {
            this.findNext();
        } else if (this.outQueue.size() == 0) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void findNext() {
        boolean bl = false;
        if (this.finished) {
            return;
        }
        while (!bl) {
            Object object;
            block21: {
                if (this.currFrame == null) {
                    Object object2 = this.outQueueLock;
                    synchronized (object2) {
                        if (this.outQueue.size() == 0) {
                            this.finished = true;
                        }
                    }
                    return;
                }
                int n = this.currFrame.nextIndex();
                if (n == -1) {
                    this.nextFrame();
                    continue;
                }
                Object object3 = this.currFrame.getNode().getChild(n);
                if (object3 == null) {
                    this.nextFrame();
                    continue;
                }
                if (object3 instanceof TestResultTable.TreeNode) {
                    object = (TestResultTable.TreeNode)object3;
                    this.push(this.currFrame);
                    this.currFrame = new PseudoFrame((TestResultTable.TreeNode)object);
                    continue;
                }
                object = (TestResult)object3;
                try {
                    int n2 = this.wouldAccept((TestResult)object);
                    if (n2 >= 0) {
                    }
                    break block21;
                }
                catch (TestResult.Fault fault) {
                    TestResultTable testResultTable = null;
                    if (this.nodes != null && this.nodes[0] != null) {
                        testResultTable = this.nodes[0].getEnclosingTable();
                    } else {
                        if (((TestResult)object).getParent() == null) continue;
                        testResultTable = ((TestResult)object).getParent().getEnclosingTable();
                    }
                    if (testResultTable == null) continue;
                    object = testResultTable.resetTest((TestResult)object);
                    try {
                        if (this.wouldAccept((TestResult)object) >= 0) {
                            continue;
                        }
                        break block21;
                    }
                    catch (TestResult.Fault fault2) {
                        if (!this.debug) continue;
                        fault2.printStackTrace(Debug.getWriter());
                    }
                }
                continue;
            }
            Object object4 = this.outQueueLock;
            synchronized (object4) {
                this.outQueue.addLast(object);
            }
            bl = true;
        }
    }

    private boolean isTop(TestResultTable.TreeNode treeNode) {
        return treeNode.isRoot() || this.nodes[this.nodeIndex] == treeNode;
    }

    private boolean nextNode() {
        this.stack = new Stack();
        this.currFrame = null;
        if (this.nodes != null && ++this.nodeIndex < this.nodes.length) {
            TestResultTable.TreeNode treeNode = this.nodes[this.nodeIndex];
            this.currFrame = new PseudoFrame(treeNode);
            return true;
        }
        return false;
    }

    private void push(PseudoFrame pseudoFrame) {
        this.stack.push(pseudoFrame);
    }

    private PseudoFrame pop() {
        if (!this.stack.empty()) {
            return (PseudoFrame)this.stack.pop();
        }
        return null;
    }

    private void nextFrame() {
        this.currFrame = this.pop();
        if (this.currFrame == null) {
            this.nextNode();
        }
    }

    private int wouldAccept(TestResult testResult) throws TestResult.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return -1;
        }
        if (this.debug) {
            Debug.println("Iterator checking filter for: " + testResult.getWorkRelativePath());
        }
        ++this.absoluteCount;
        this.currentResult = testResult;
        for (int i = 0; i < this.filters.length; ++i) {
            boolean bl;
            block6: {
                bl = true;
                try {
                    bl = this.fo == null ? this.filters[i].accepts(testResult.getDescription()) : this.filters[i].accepts(testResult.getDescription(), this.fo);
                }
                catch (TestFilter.Fault fault) {
                    bl = true;
                    if (!this.debug) break block6;
                    Debug.println("   -> exception while checking filter: " + fault.getMessage());
                }
            }
            if (bl) continue;
            if (this.debug) {
                Debug.println("   -> Rejected by: " + this.filters[i]);
                Debug.println("   -> Test Status: " + testResult.getStatus().getType());
            }
            ++this.rejectCount;
            return i;
        }
        return -1;
    }

    private static int checkTestPosition(PseudoFrame pseudoFrame, String string) {
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)pseudoFrame.getNode();
        int n = tRT_TreeNode.getTestIndex(string);
        int n2 = pseudoFrame.getCurrentIndex();
        int n3 = 3;
        n3 = n == -1 ? -1 : (n < n2 ? 0 : (n == n2 ? 1 : (n > n2 ? 2 : 3)));
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class FilterObserver
    implements TestFilter.Observer {
        private FilterObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rejected(TestDescription testDescription, TestFilter testFilter) {
            Object object = TRT_Iterator.this.rejLock;
            synchronized (object) {
                Vector<TestResult> vector = (Vector<TestResult>)TRT_Iterator.this.filteredTRs.get(testFilter);
                if (vector == null) {
                    vector = new Vector<TestResult>();
                    TRT_Iterator.this.filteredTRs.put(testFilter, vector);
                }
                try {
                    if (TRT_Iterator.this.currentResult.getDescription() != testDescription) {
                        throw new JavaTestError("TRT_Iterator observered TR.TD does not match filtered one.");
                    }
                }
                catch (TestResult.Fault fault) {
                    throw new JavaTestError("TRT_Iterator cannot determine TR source info.", fault);
                }
                vector.add(TRT_Iterator.this.currentResult);
            }
        }
    }

    private static class PseudoFrame {
        private int currIndex;
        private TestResultTable.TreeNode node;

        PseudoFrame(TestResultTable.TreeNode treeNode) {
            this.node = treeNode;
            this.currIndex = -1;
        }

        int nextIndex() {
            if (++this.currIndex < this.node.getChildCount()) {
                return this.currIndex;
            }
            return -1;
        }

        TestResultTable.TreeNode getNode() {
            return this.node;
        }

        int getCurrentIndex() {
            return this.currIndex;
        }
    }
}

