/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.PropertyArray;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class TestDescription
implements Serializable {
    private String rootDir;
    private String rootRelativePath;
    private String[] fields;
    private static File cachedRoot;
    private static String cachedRootDir;

    public TestDescription(File file, File file2, Map map) throws IllegalArgumentException {
        String string;
        Object object;
        if (file.equals(cachedRoot)) {
            this.rootDir = cachedRootDir;
        } else {
            this.rootDir = (file.exists() ? file.isFile() : file.getName().endsWith(".html")) ? file.getParent() : file.getPath();
            cachedRoot = file;
            cachedRootDir = this.rootDir;
        }
        String string2 = file2.getPath();
        if (file2.isAbsolute()) {
            object = this.rootDir;
            if (!string2.startsWith((String)object) || string2.charAt(((String)object).length()) != File.separatorChar) {
                throw new IllegalArgumentException("file must be relative to root: " + file2);
            }
            string = string2.substring(((String)object).length() + 1);
        } else {
            string = string2;
        }
        this.rootRelativePath = string.replace(File.separatorChar, '/');
        object = new Vector(0, map.size() * 2);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)map.get(string3);
            TestDescription.insert((Vector)object, string3, string4);
        }
        this.fields = new String[((Vector)object).size()];
        ((Vector)object).copyInto(this.fields);
    }

    private TestDescription(String string, String string2, String[] stringArray) {
        this.rootDir = string;
        char c = string2.charAt(string.length());
        this.rootRelativePath = string2.substring(string.length() + 1).replace(c, '/');
        Vector vector = new Vector(0, stringArray.length);
        for (int i = 0; i < stringArray.length; i += 2) {
            String string3 = stringArray[i];
            if (string3.startsWith("$") || string3.equals("testsuite") || string3.equals("file")) continue;
            String string4 = stringArray[i + 1];
            TestDescription.insert(vector, string3, string4);
        }
        this.fields = new String[vector.size()];
        vector.copyInto(this.fields);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TestDescription)) {
            return false;
        }
        TestDescription testDescription = (TestDescription)object;
        if (testDescription.getParameterCount() != this.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < this.fields.length; i += 2) {
            String string = testDescription.getParameter(this.fields[i]);
            if (string != null && string.equals(this.fields[i + 1])) continue;
            return false;
        }
        return true;
    }

    public File getDir() {
        return new File(this.getFile().getParent());
    }

    public File getFile() {
        return new File(this.rootDir, this.rootRelativePath.replace('/', File.separatorChar));
    }

    public String getId() {
        return this.getParameter("id");
    }

    public String getTitle() {
        String string = this.getParameter("title");
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public String getName() {
        String string;
        int n = this.rootRelativePath.lastIndexOf(47);
        String string2 = n == -1 ? this.rootRelativePath : this.rootRelativePath.substring(n + 1);
        int n2 = string2.indexOf(46);
        if (n2 != -1) {
            string2 = string2.substring(0, n2);
        }
        if ((string = this.getParameter("id")) != null) {
            string2 = string2 + "_" + string;
        }
        return string2;
    }

    public String[] getKeywords() {
        return StringArray.split(this.getParameter("keywords"));
    }

    public Set getKeywordTable() {
        String[] stringArray = StringArray.split(this.getParameter("keywords"));
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toLowerCase();
            treeSet.add(string);
        }
        return treeSet;
    }

    public String[] getSources() {
        return StringArray.split(this.getParameter("source"));
    }

    public File[] getSourceFiles() {
        String string = this.getFile().getParent();
        String[] stringArray = this.getSources();
        File[] fileArray = new File[stringArray.length];
        String string2 = System.getProperty("user.dir") + File.separator;
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string, stringArray[i].replace('/', File.separatorChar));
            String string3 = file.getPath();
            if (string3.startsWith(string2)) {
                string3 = string3.substring(string2.length());
                fileArray[i] = new File(string3);
                continue;
            }
            fileArray[i] = file;
        }
        return fileArray;
    }

    public String getClassDir() {
        return this.getParameter("classDir");
    }

    public String getExecuteClass() {
        return this.getParameter("executeClass");
    }

    public String getExecuteArgs() {
        return this.getParameter("executeArgs");
    }

    public int getTimeout() {
        String string = this.getParameter("timeout");
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public File getRoot() {
        return new File(this.rootDir, "testsuite.html");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getRootRelativePath() {
        return this.rootRelativePath;
    }

    public File getRootRelativeFile() {
        return new File(this.rootRelativePath.replace('/', File.separatorChar));
    }

    public String getRootRelativeURL() {
        String string = this.getParameter("id");
        return string == null ? this.rootRelativePath : this.rootRelativePath + "#" + string;
    }

    public File getRootRelativeDir() {
        String string = this.getRootRelativeFile().getParent();
        return string == null ? new File(".") : new File(string);
    }

    public int getParameterCount() {
        return this.fields.length / 2;
    }

    public Iterator getParameterKeys() {
        return new Iterator(){
            int pos = 0;

            public boolean hasNext() {
                return TestDescription.this.fields != null && TestDescription.this.fields.length != 0 && this.pos < TestDescription.this.fields.length;
            }

            public Object next() {
                if (TestDescription.this.fields == null || TestDescription.this.fields.length == 0 || this.pos == TestDescription.this.fields.length) {
                    return null;
                }
                String string = TestDescription.this.fields[this.pos];
                this.pos += 2;
                return string;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getParameter(String string) {
        int n = 0;
        int n2 = this.fields.length - 2;
        if (n2 < 0) {
            return null;
        }
        String string2 = this.fields[n2];
        int n3 = string.compareTo(string2);
        if (n3 > 0) {
            return null;
        }
        while (n <= n2) {
            int n4 = n + (n2 - n) / 4 * 2;
            String string3 = this.fields[n4];
            n3 = string.compareTo(string3);
            if (n3 < 0) {
                n2 = n4 - 2;
                continue;
            }
            if (n3 > 0) {
                n = n4 + 2;
                continue;
            }
            return this.fields[n4 + 1];
        }
        return null;
    }

    public String toString() {
        return "TestDescription[" + this.getTitle() + "]";
    }

    void save(Map map) {
        this.saveField(map, "$root", this.rootDir);
        this.saveField(map, "$file", this.getFile().getPath());
        for (int i = 0; i < this.fields.length; i += 2) {
            this.saveField(map, this.fields[i], this.fields[i + 1]);
        }
    }

    private void saveField(Map map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    static TestDescription load(String[] stringArray) {
        String string;
        String string2 = PropertyArray.get(stringArray, "$root");
        if (string2 == null) {
            string2 = PropertyArray.get(stringArray, "testsuite");
        }
        if ((string = PropertyArray.get(stringArray, "$file")) == null) {
            string = PropertyArray.get(stringArray, "file");
        }
        return new TestDescription(string2, string, stringArray);
    }

    private static void insert(Vector vector, String string, String string2) {
        int n = 0;
        int n2 = vector.size() - 2;
        int n3 = 0;
        if (n2 < 0) {
            vector.addElement(string);
            vector.addElement(string2);
            return;
        }
        String string3 = (String)vector.elementAt(n2);
        int n4 = string.compareTo(string3);
        if (n4 > 0) {
            vector.addElement(string);
            vector.addElement(string2);
            return;
        }
        while (n <= n2) {
            n3 = n + (n2 - n) / 4 * 2;
            String string4 = (String)vector.elementAt(n3);
            n4 = string.compareTo(string4);
            if (n4 < 0) {
                n2 = n3 - 2;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 2;
                continue;
            }
            throw new Error("should not happen");
        }
        if (n4 > 0) {
            n3 += 2;
        }
        vector.insertElementAt(string, n3);
        vector.insertElementAt(string2, n3 + 1);
    }
}

