/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.Harness;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import java.util.Iterator;

public abstract class TestRunner {
    private WorkDirectory workDir;
    private BackupPolicy backupPolicy;
    private TestEnvironment env;
    private ExcludeList excludeList;
    private int concurrency;
    private Harness.Observer notifier;

    void setWorkDirectory(WorkDirectory workDirectory) {
        this.workDir = workDirectory;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public TestSuite getTestSuite() {
        return this.workDir.getTestSuite();
    }

    void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    void setEnvironment(TestEnvironment testEnvironment) {
        this.env = testEnvironment;
    }

    public TestEnvironment getEnvironment() {
        return this.env;
    }

    void setExcludeList(ExcludeList excludeList) {
        this.excludeList = excludeList;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    public String[] getExcludedTestCases(TestDescription testDescription) {
        return this.excludeList.getTestCases(testDescription);
    }

    void setConcurrency(int n) {
        this.concurrency = n;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    void setNotifier(Harness.Observer observer) {
        this.notifier = observer;
    }

    protected abstract boolean runTests(Iterator var1) throws InterruptedException;

    protected void notifyStartingTest(TestResult testResult) {
        this.notifier.startingTest(testResult);
    }

    protected void notifyFinishedTest(TestResult testResult) {
        this.notifier.finishedTest(testResult);
    }
}

