/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LogFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class WorkDirectory {
    private File root;
    private TestSuite testSuite;
    private String testSuiteID;
    private int testCount = -1;
    private TestResultTable testResultTable;
    private File jtData;
    private LogFile logFile;
    private static HashMap dirMap = new HashMap(2);
    private static final String JTDATA = "jtData";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTSUITE_ID = "id";
    private static final String TESTSUITE_NAME = "name";
    private static final String TESTSUITE_ROOT = "root";
    private static final String TESTSUITE_TESTCOUNT = "testCount";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$WorkDirectory == null ? (class$com$sun$javatest$WorkDirectory = WorkDirectory.class$("com.sun.javatest.WorkDirectory")) : class$com$sun$javatest$WorkDirectory);
    static /* synthetic */ Class class$com$sun$javatest$WorkDirectory;

    public static boolean isWorkDirectory(File file) {
        File file2 = new File(file, JTDATA);
        return file2.exists() && file2.isDirectory();
    }

    public static boolean isEmptyDirectory(File file) {
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            return stringArray == null || stringArray.length == 0;
        }
        return false;
    }

    public static WorkDirectory create(File file, TestSuite testSuite) throws BadDirectoryFault, WorkDirectoryExistsFault, InitializationFault {
        return WorkDirectory.createOrConvert(file, testSuite, true);
    }

    public static WorkDirectory convert(File file, TestSuite testSuite) throws BadDirectoryFault, WorkDirectoryExistsFault, FileNotFoundException, InitializationFault {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        return WorkDirectory.createOrConvert(file, testSuite, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkDirectory createOrConvert(File file, TestSuite testSuite, boolean bl) throws BadDirectoryFault, WorkDirectoryExistsFault, InitializationFault {
        ArrayList arrayList = new ArrayList();
        try {
            Object object;
            File file2;
            File file3;
            if (file.exists()) {
                file3 = WorkDirectory.canonicalize(file);
                file2 = new File(file3, JTDATA);
                if (!file3.isDirectory()) {
                    throw new BadDirectoryFault(i18n, "wd.notDirectory", file3);
                }
                if (!file3.canRead()) {
                    throw new BadDirectoryFault(i18n, "wd.notReadable", file3);
                }
                if (file2.exists() && file2.isDirectory()) {
                    throw new WorkDirectoryExistsFault(i18n, "wd.alreadyExists", file3);
                }
                if (bl && (object = file3.list()) != null && ((String[])object).length > 0) {
                    throw new BadDirectoryFault(i18n, "wd.notEmpty", file3);
                }
            } else {
                if (!WorkDirectory.mkdirs(file, arrayList)) {
                    throw new BadDirectoryFault(i18n, "wd.cantCreate", file);
                }
                file3 = WorkDirectory.canonicalize(file);
                file2 = new File(file3, JTDATA);
            }
            if (!WorkDirectory.mkdirs(file2, arrayList)) {
                throw new BadDirectoryFault(i18n, "wd.cantCreate", file3);
            }
            try {
                Object object2 = dirMap;
                synchronized (object2) {
                    object = new WorkDirectory(file3, testSuite, null);
                    dirMap.put(file3, new WeakReference<String[]>((String[])object));
                }
                super.saveTestSuiteInfo();
                arrayList = null;
                object2 = object;
                return object2;
            }
            catch (IOException iOException) {
                throw new BadDirectoryFault(i18n, "wd.cantWriteTestSuiteInfo", file3, iOException);
            }
        }
        finally {
            if (arrayList != null) {
                WorkDirectory.undo(arrayList);
            }
        }
    }

    private static boolean mkdirs(File file, ArrayList arrayList) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !WorkDirectory.mkdirs(file2, arrayList)) {
            return false;
        }
        if (file.mkdir()) {
            arrayList.add(file);
            return true;
        }
        return false;
    }

    private static void undo(ArrayList arrayList) {
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file = (File)arrayList.get(i);
            WorkDirectory.delete(file);
        }
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() && !fileArray[i].isFile()) continue;
                WorkDirectory.delete(fileArray[i]);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkDirectory open(File file) throws FileNotFoundException, BadDirectoryFault, NotWorkDirectoryFault, MismatchFault, TestSuiteFault, InitializationFault {
        WorkDirectory workDirectory;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File file2 = WorkDirectory.canonicalize(file);
        if (!file2.isDirectory()) {
            throw new BadDirectoryFault(i18n, "wd.notDirectory", file2);
        }
        if (!file2.canRead()) {
            throw new BadDirectoryFault(i18n, "wd.notReadable", file2);
        }
        File file3 = new File(file2, JTDATA);
        if (!file3.exists()) {
            throw new NotWorkDirectoryFault(i18n, "wd.notWorkDir", file2);
        }
        HashMap hashMap = dirMap;
        synchronized (hashMap) {
            TestSuite testSuite;
            Properties properties;
            WeakReference weakReference = (WeakReference)dirMap.get(file2);
            WorkDirectory workDirectory2 = workDirectory = weakReference == null ? null : (WorkDirectory)weakReference.get();
            if (workDirectory != null) {
                return workDirectory;
            }
            try {
                String string;
                properties = WorkDirectory.loadTestSuiteInfo(file3);
                String string2 = properties.getProperty(TESTSUITE_ROOT);
                if (string2 == null) {
                    throw new BadDirectoryFault(i18n, "wd.noTestSuiteRoot", file2);
                }
                File file4 = new File(string2);
                if (!file4.exists()) {
                    throw new TestSuiteFault(i18n, "wd.cantFindTestSuite", file2, file4.getPath());
                }
                String string3 = properties == null ? null : (String)properties.get(TESTSUITE_ID);
                if (!(string3 == null ? "" : string3).equals((string = (testSuite = TestSuite.open(file4)).getID()) == null ? "" : string)) {
                    throw new MismatchFault(i18n, "wd.mismatchID", file2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BadDirectoryFault(i18n, "wd.noTestSuiteFile", file2);
            }
            catch (IOException iOException) {
                throw new BadDirectoryFault(i18n, "wd.badTestSuiteFile", file2, iOException);
            }
            catch (TestSuite.Fault fault) {
                throw new TestSuiteFault(i18n, "wd.cantOpenTestSuite", file2, fault.toString());
            }
            workDirectory = new WorkDirectory(file2, testSuite, properties);
            dirMap.put(file2, new WeakReference<WorkDirectory>(workDirectory));
        }
        return workDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkDirectory open(File file, TestSuite testSuite) throws FileNotFoundException, BadDirectoryFault, NotWorkDirectoryFault, MismatchFault, InitializationFault {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        File file2 = WorkDirectory.canonicalize(file);
        if (!file2.isDirectory()) {
            throw new BadDirectoryFault(i18n, "wd.notDirectory", file2);
        }
        if (!file2.canRead()) {
            throw new BadDirectoryFault(i18n, "wd.notReadable", file2);
        }
        File file3 = new File(file2, JTDATA);
        if (!file3.exists()) {
            throw new NotWorkDirectoryFault(i18n, "wd.notWorkDir", file2);
        }
        WorkDirectory workDirectory = null;
        HashMap hashMap = dirMap;
        synchronized (hashMap) {
            WeakReference weakReference = (WeakReference)dirMap.get(file2);
            if (weakReference != null) {
                workDirectory = (WorkDirectory)weakReference.get();
            }
            if (workDirectory == null) {
                Properties properties;
                try {
                    properties = WorkDirectory.loadTestSuiteInfo(file3);
                }
                catch (IOException iOException) {
                    properties = null;
                }
                String string = properties == null ? null : (String)properties.get(TESTSUITE_ID);
                String string2 = testSuite.getID();
                if (!(string == null ? "" : string).equals(string2 == null ? "" : string2)) {
                    throw new MismatchFault(i18n, "wd.mismatchID", file2);
                }
                try {
                    workDirectory = new WorkDirectory(file2, testSuite, properties);
                    workDirectory.saveTestSuiteInfo();
                    dirMap.put(file2, new WeakReference<WorkDirectory>(workDirectory));
                }
                catch (IOException iOException) {
                    throw new BadDirectoryFault(i18n, "wd.cantWriteTestSuiteInfo", file2, iOException);
                }
            }
        }
        return workDirectory;
    }

    private WorkDirectory(File file, TestSuite testSuite, Map map) {
        if (file == null || testSuite == null) {
            throw new NullPointerException();
        }
        this.root = file;
        this.testSuite = testSuite;
        this.jtData = new File(file, JTDATA);
        if (map != null) {
            int n;
            String string = (String)map.get(TESTSUITE_TESTCOUNT);
            if (string == null) {
                n = -1;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
            }
            this.testCount = n;
        } else {
            this.testCount = testSuite.getEstimatedTestCount();
        }
        this.testSuiteID = testSuite.getID();
        if (this.testSuiteID == null) {
            this.testSuiteID = "";
        }
    }

    public File getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.root.getPath();
    }

    public File getJTData() {
        return this.jtData;
    }

    public File getFile(String string) {
        return new File(this.root, string);
    }

    public File getSystemFile(String string) {
        return new File(this.jtData, string);
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public int getTestSuiteTestCount() {
        return this.testCount;
    }

    public void setTestSuiteTestCount(int n) {
        if (n != this.testCount) {
            this.testCount = n;
            try {
                this.saveTestSuiteInfo();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public TestResultTable getTestResultTable() {
        if (this.testResultTable == null) {
            this.testResultTable = new TestResultTable(this);
        }
        return this.testResultTable;
    }

    public void setTestResultTable(TestResultTable testResultTable) {
        if (testResultTable == null) {
            throw new NullPointerException();
        }
        if (testResultTable == this.testResultTable) {
            return;
        }
        if (this.testResultTable != null && this.testResultTable != testResultTable) {
            throw new IllegalStateException();
        }
        WorkDirectory workDirectory = testResultTable.getWorkDirectory();
        if (workDirectory != null && workDirectory != this) {
            throw new IllegalArgumentException();
        }
        if (workDirectory == null) {
            testResultTable.setWorkDirectory(this);
        }
        this.testResultTable = testResultTable;
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string);
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string, object);
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string, objectArray);
    }

    private void ensureLogFileInitialized() {
        if (this.logFile == null) {
            this.logFile = new LogFile(this.getSystemFile("log.txt"));
        }
    }

    public boolean purge(String string) throws PurgeFault {
        File file;
        if (string == null) {
            return false;
        }
        boolean bl = true;
        File file2 = file = string.length() == 0 ? this.root : this.getFile(string);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            bl = this.recursivePurge(file, string);
        } else {
            bl = file.delete();
            this.testResultTable.resetTest(string);
        }
        return bl;
    }

    private boolean recursivePurge(File file, String string) throws PurgeFault {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string2 = string.length() == 0 ? file2.getName() : string + "/" + file2.getName();
            if (file2.isFile()) {
                bl &= file2.delete();
                if (!file2.getName().endsWith(".jtr")) continue;
                this.testResultTable.resetTest(string2);
                continue;
            }
            if (string2.equals(JTDATA)) continue;
            bl &= this.recursivePurge(file2, string2);
            bl &= file2.delete();
        }
        return bl;
    }

    private static Properties loadTestSuiteInfo(File file) throws FileNotFoundException, IOException {
        File file2 = new File(file, TESTSUITE);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return properties;
    }

    private synchronized void saveTestSuiteInfo() throws IOException {
        File file = File.createTempFile(TESTSUITE, ".new", this.jtData);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Properties properties = new Properties();
        properties.put(TESTSUITE_ROOT, this.testSuite.getPath());
        String string = this.testSuite.getName();
        if (string != null) {
            properties.put(TESTSUITE_NAME, string);
        }
        if (this.testCount > 0) {
            properties.put(TESTSUITE_TESTCOUNT, Integer.toString(this.testCount));
        }
        if (this.testSuiteID != null && this.testSuiteID.length() > 0) {
            properties.put(TESTSUITE_ID, this.testSuiteID);
        }
        properties.save(bufferedOutputStream, "JavaTest Work Directory: Test Suite Info");
        ((OutputStream)bufferedOutputStream).close();
        file.renameTo(new File(this.jtData, TESTSUITE));
    }

    private static File canonicalize(File file) throws BadDirectoryFault {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new BadDirectoryFault(i18n, "wd.cantCanonicalize", file, iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PurgeFault
    extends Fault {
        PurgeFault(I18NResourceBundle i18NResourceBundle, String string, File file, Object object) {
            super(i18NResourceBundle, string, new Object[]{file.getPath(), object});
        }
    }

    public static class InitializationFault
    extends Fault {
        InitializationFault(I18NResourceBundle i18NResourceBundle, String string, File file, Object object) {
            super(i18NResourceBundle, string, new Object[]{file.getPath(), object});
        }
    }

    public static class TestSuiteFault
    extends Fault {
        TestSuiteFault(I18NResourceBundle i18NResourceBundle, String string, File file, Object object) {
            super(i18NResourceBundle, string, new Object[]{file.getPath(), object});
        }
    }

    public static class MismatchFault
    extends Fault {
        MismatchFault(I18NResourceBundle i18NResourceBundle, String string, File file) {
            super(i18NResourceBundle, string, file.getPath());
        }
    }

    public static class WorkDirectoryExistsFault
    extends Fault {
        WorkDirectoryExistsFault(I18NResourceBundle i18NResourceBundle, String string, File file) {
            super(i18NResourceBundle, string, file.getPath());
        }
    }

    public static class NotWorkDirectoryFault
    extends Fault {
        NotWorkDirectoryFault(I18NResourceBundle i18NResourceBundle, String string, File file) {
            super(i18NResourceBundle, string, file.getPath());
        }
    }

    public static class BadDirectoryFault
    extends Fault {
        BadDirectoryFault(I18NResourceBundle i18NResourceBundle, String string, File file) {
            super(i18NResourceBundle, string, file.getPath());
        }

        BadDirectoryFault(I18NResourceBundle i18NResourceBundle, String string, File file, Throwable throwable) {
            super(i18NResourceBundle, string, new Object[]{file.getPath(), throwable.toString()});
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

