/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.agent.AgentWriter;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.Deprecated;
import com.sun.javatest.agent.Map;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.Timer;
import com.sun.javatest.util.WriterStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Vector;

public class Agent
implements Runnable {
    private boolean closing;
    private Thread mainThread;
    private int maxThreads;
    private Vector threads = new Vector();
    private Vector tasks = new Vector();
    private Notifier notifier = new Notifier();
    private Object currSystemStreamOwner = null;
    private PrintStream saveOut;
    private PrintStream saveErr;
    public static boolean tracing = false;
    static PrintStream traceOut = System.out;
    public static final int DEFAULT_RETRY_DELAY = 5;
    private int retryDelay = 5;
    private ConnectionFactory connectionFactory;
    private Map map;
    private Timer timer;
    private static int threadInitNumber;
    static final short protocolVersion = 103;
    public static final int defaultActivePort = 1907;
    public static final int defaultPassivePort = 1908;
    static final byte CLASS = 67;
    static final byte DATA = 68;
    static final byte LOG = 76;
    static final byte LOG_FLUSH = 108;
    static final byte REF = 82;
    static final byte REF_FLUSH = 114;
    static final byte STATUS = 83;
    static final String productName = "JavaTest Agent";
    static final String productVersion = "JTA_3.1.4";
    static final String productCopyright = "Copyright \ufffd 1996-2006 Sun Microsystems, Inc";
    private static Constructor classLoaderConstructor;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$com$sun$javatest$agent$AgentClassLoader;
    static /* synthetic */ Class class$com$sun$javatest$agent$Agent$Task;

    public Agent(ConnectionFactory connectionFactory, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("bad concurrency: " + n);
        }
        this.connectionFactory = connectionFactory;
        this.maxThreads = n;
    }

    public void setRetryDelay(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid delay");
        }
        this.retryDelay = n;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public synchronized void setMap(Map map) {
        this.map = map;
        if (tracing) {
            if (map == null) {
                traceOut.println("set map null");
            } else {
                traceOut.println("set map:");
                Enumeration enumeration = map.enumerate();
                while (enumeration.hasMoreElements()) {
                    String[] stringArray = (String[])enumeration.nextElement();
                    traceOut.println("map-from: " + stringArray[0]);
                    traceOut.println("map-to:   " + stringArray[1]);
                }
                traceOut.println("end of map");
            }
        }
    }

    public void addObserver(Observer observer) {
        this.notifier.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.notifier.removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        if (this.mainThread != null) {
            throw new IllegalStateException("Agent already running");
        }
        this.mainThread = Thread.currentThread();
        this.timer = new Timer();
        this.closing = false;
        try {
            try {
                if (tracing) {
                    traceOut.println("AGENT STARTED, maxThreads=" + this.maxThreads);
                }
                this.notifier.started();
                if (this.maxThreads <= 0) {
                    Object var5_1 = null;
                    this.timer.finished();
                    this.notifier.finished();
                    if (tracing) {
                        traceOut.println("AGENT EXITING");
                    }
                    this.mainThread = null;
                    return;
                }
                while (!this.closing) {
                    while (this.threads.size() < this.maxThreads && !this.closing) {
                        Thread thread = new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run() {
                                Agent agent;
                                Thread thread = Thread.currentThread();
                                if (tracing) {
                                    traceOut.println("THREAD " + thread.getName() + " STARTED " + this.getClass().getName());
                                }
                                try {
                                    try {
                                        Agent.this.handleRequestsUntilClosed();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Object var4_3 = null;
                                        Agent agent3 = Agent.this;
                                        synchronized (agent3) {
                                            Agent.this.threads.removeElement(thread);
                                            Agent.this.notifyAll();
                                        }
                                        if (!tracing) return;
                                        traceOut.println("THREAD " + thread.getName() + " EXITING");
                                        return;
                                    }
                                    Object var4_2 = null;
                                    agent = Agent.this;
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    Agent agent2 = Agent.this;
                                    synchronized (agent2) {
                                        Agent.this.threads.removeElement(thread);
                                        Agent.this.notifyAll();
                                    }
                                    if (!tracing) throw throwable;
                                    traceOut.println("THREAD " + thread.getName() + " EXITING");
                                    throw throwable;
                                }
                                synchronized (agent) {
                                    Agent.this.threads.removeElement(thread);
                                    Agent.this.notifyAll();
                                }
                                if (!tracing) return;
                                traceOut.println("THREAD " + thread.getName() + " EXITING");
                            }
                        });
                        thread.setName("Agent" + Agent.nextThreadNum());
                        int n = Thread.currentThread().getPriority();
                        int n2 = (n + 1) / 2;
                        thread.setPriority(n2);
                        thread.start();
                        this.threads.addElement(thread);
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    this.close();
                }
                catch (InterruptedException interruptedException2) {
                }
                Object var5_3 = null;
                this.timer.finished();
                this.notifier.finished();
                if (tracing) {
                    traceOut.println("AGENT EXITING");
                }
                this.mainThread = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.timer.finished();
            this.notifier.finished();
            if (tracing) {
                traceOut.println("AGENT EXITING");
            }
            this.mainThread = null;
            throw throwable;
        }
        Object var5_2 = null;
        this.timer.finished();
        this.notifier.finished();
        if (tracing) {
            traceOut.println("AGENT EXITING");
        }
        this.mainThread = null;
    }

    public synchronized void interrupt() {
        if (this.mainThread != null) {
            this.mainThread.interrupt();
        }
    }

    public synchronized void close() throws InterruptedException {
        Object object;
        int n;
        this.closing = true;
        for (n = 0; n < this.threads.size(); ++n) {
            object = (Thread)this.threads.elementAt(n);
            if (tracing) {
                traceOut.println("INTERRUPTING THREAD " + ((Thread)object).getName());
            }
            ((Thread)object).interrupt();
        }
        traceOut.println("WAITING 3s FOR THREADS TO CLEANUP");
        Thread.currentThread();
        Thread.sleep(3000L);
        for (n = 0; n < this.tasks.size(); ++n) {
            object = (Task)this.tasks.elementAt(n);
            if (tracing) {
                Connection connection = ((Task)object).connection;
                traceOut.println("CLOSING TASK " + (connection == null ? "[unknown]" : connection.getName()));
            }
            ((Task)object).close();
        }
        try {
            if (tracing) {
                traceOut.println("CLOSING CONNECTION FACTORY");
            }
            this.connectionFactory.close();
        }
        catch (ConnectionFactory.Fault fault) {
            // empty catch block
        }
        this.notifyAll();
        if (tracing) {
            traceOut.println("WAITING FOR TASKS TO EXIT");
        }
        while (this.tasks.size() > 0) {
            this.wait();
        }
        if (tracing) {
            traceOut.println("CLOSED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestsUntilClosed() throws InterruptedException {
        while (!this.closing) {
            try {
                Agent agent;
                Object var6_6;
                Task task;
                Connection connection = this.connectionFactory.nextConnection();
                Agent agent2 = this;
                synchronized (agent2) {
                    if (this.closing) {
                        Agent.closeIgnoreExceptions(connection);
                        return;
                    }
                    task = new Task(connection);
                    this.tasks.addElement(task);
                }
                try {
                    task.handleRequest();
                    var6_6 = null;
                    agent = this;
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    agent = this;
                    synchronized (agent) {
                        this.tasks.removeElement(task);
                    }
                    throw throwable;
                }
                synchronized (agent) {
                    this.tasks.removeElement(task);
                }
            }
            catch (ConnectionFactory.Fault fault) {
                this.notifier.errorOpeningConnection(fault.getException());
                if (tracing) {
                    traceOut.println("THREAD " + Thread.currentThread().getName() + " " + fault);
                }
                if (fault.isFatal()) {
                    this.close();
                    return;
                }
                int n = 1000 * Agent.min(5, this.getRetryDelay());
                Thread.currentThread();
                Thread.sleep(n);
            }
        }
    }

    private static void closeIgnoreExceptions(Connection connection) {
        try {
            connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private synchronized void setSystemStreams(Object object, PrintStream printStream, PrintStream printStream2) throws InterruptedException, SecurityException {
        if (object == null) {
            throw new NullPointerException();
        }
        while (this.currSystemStreamOwner != null) {
            this.wait();
        }
        this.currSystemStreamOwner = object;
        this.saveOut = System.out;
        this.saveErr = System.err;
        System.setOut(printStream);
        System.setErr(printStream2);
    }

    private synchronized void resetSystemStreams(Object object) throws SecurityException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object != this.currSystemStreamOwner) {
            throw new IllegalStateException("expected: " + object + " found: " + this.currSystemStreamOwner);
        }
        this.currSystemStreamOwner = null;
        System.setOut(this.saveOut);
        System.setErr(this.saveErr);
        this.notifyAll();
    }

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Task {
        private Connection connection;
        private DataInputStream in;
        private DataOutputStream out;
        private String tag;
        private String request;
        private ClassLoader agentClassLoader;

        Task(Connection connection) {
            if (connection == null) {
                throw new NullPointerException();
            }
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest() throws ConnectionFactory.Fault {
            try {
                Status status;
                Agent.this.notifier.openedConnection(this.connection);
                if (tracing) {
                    traceOut.println("REQUEST FROM " + this.connection.getName());
                }
                this.in = new DataInputStream(this.connection.getInputStream());
                short s = this.in.readShort();
                if (s != 103) {
                    throw new IOException("protocol mismatch; expected 103 received " + s);
                }
                this.tag = this.in.readUTF();
                if (tracing) {
                    traceOut.println("TAG IS `" + this.tag + "'");
                }
                this.request = this.in.readUTF();
                if (tracing) {
                    traceOut.println("REQUEST IS `" + this.request + "'");
                }
                this.out = new DataOutputStream(new BufferedOutputStream(this.connection.getOutputStream()));
                if (this.request.equals("executeTest") || this.request.equals("executeCommand") || this.request.equals("executeMain")) {
                    status = this.execute();
                } else {
                    if (tracing) {
                        traceOut.println("Unrecognized request for agent: `" + this.request + "'");
                    }
                    status = Status.error("Unrecognized request for agent: `" + this.request + "'");
                }
                if (tracing) {
                    traceOut.println("RETURN " + status);
                }
                Agent.this.notifier.result(this.connection, status);
                if (tracing) {
                    traceOut.println("SEND STATUS");
                }
                this.sendStatus(status);
                if (tracing) {
                    traceOut.println("FLUSH");
                }
                this.out.flush();
                if (tracing) {
                    traceOut.println("AWAIT CLOSE");
                }
                this.connection.waitUntilClosed(5000);
                if (this.connection.isClosed()) {
                    Agent.this.notifier.completed(this.connection);
                } else {
                    Agent.this.notifier.exception(this.connection, new IOException("timeout awaiting close from AgentManager"));
                }
            }
            catch (InterruptedException interruptedException) {
                if (tracing) {
                    traceOut.println("Interrupted");
                }
                Agent.this.notifier.exception(this.connection, interruptedException);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (tracing) {
                    traceOut.println("Interrupted (IO)");
                }
                Agent.this.notifier.exception(this.connection, interruptedIOException);
            }
            catch (IOException iOException) {
                if (tracing) {
                    traceOut.println("EXCEPTION IS `" + iOException + "'");
                    iOException.printStackTrace(traceOut);
                }
                Agent.this.notifier.exception(this.connection, iOException);
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Status execute() throws IOException {
            Status status;
            PrintWriter printWriter;
            PrintWriter printWriter2;
            block52: {
                Status status2;
                block51: {
                    Status status3;
                    block50: {
                        byte by;
                        int n;
                        String string = this.in.readUTF();
                        if (tracing) {
                            traceOut.println("CLASSNAME: " + string);
                        }
                        short s = this.in.readShort();
                        if (tracing) {
                            traceOut.println("nArgs: " + s);
                        }
                        String[] stringArray = new String[s];
                        for (n = 0; n < stringArray.length; ++n) {
                            stringArray[n] = this.in.readUTF();
                            if (!tracing) continue;
                            traceOut.println("arg[" + n + "]: " + stringArray[n]);
                        }
                        n = this.in.readBoolean() ? 1 : 0;
                        if (tracing) {
                            traceOut.println("mapArgs: " + (n != 0));
                        }
                        boolean bl = this.in.readBoolean();
                        if (tracing) {
                            traceOut.println("remoteClasses: " + bl);
                        }
                        if ((by = this.in.readByte()) != 0) {
                            throw new IOException("data format error");
                        }
                        if (Agent.this.map != null && n != 0) {
                            Agent.this.map.map(stringArray);
                        }
                        printWriter2 = new PrintWriter(new AgentWriter(76, this));
                        printWriter = new PrintWriter(new AgentWriter(82, this));
                        try {
                            Status status4;
                            block48: {
                                block49: {
                                    try {
                                        Class<?> clazz;
                                        ClassLoader classLoader = null;
                                        if (bl) {
                                            classLoader = this.getAgentClassLoader();
                                            clazz = classLoader.loadClass(string);
                                        } else {
                                            clazz = Class.forName(string);
                                        }
                                        if (this.request.equals("executeTest")) {
                                            status4 = this.executeTest(clazz, stringArray, printWriter2, printWriter);
                                            Object var13_30 = null;
                                            if (!tracing) break block48;
                                            break block49;
                                        }
                                        if (this.request.equals("executeCommand")) {
                                            status3 = this.executeCommand(clazz, stringArray, printWriter2, printWriter, classLoader);
                                            break block50;
                                        }
                                        if (this.request.equals("executeMain")) {
                                            status2 = this.executeMain(clazz, stringArray, printWriter2, printWriter);
                                            break block51;
                                        }
                                        status = Status.error("Unrecognized request for agent: `" + this.request + "'");
                                        break block52;
                                    }
                                    catch (ClassCastException classCastException) {
                                        if (tracing) {
                                            classCastException.printStackTrace(traceOut);
                                        }
                                        Status status5 = Status.error("Can't execute class `" + string + "': required interface not found");
                                        Object var13_34 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status5;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        Status status6 = Status.error("Can't find class `" + string + "'");
                                        Object var13_35 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status6;
                                    }
                                    catch (IllegalAccessException illegalAccessException) {
                                        Status status7 = Status.error("Illegal access to class `" + string + "'");
                                        Object var13_36 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status7;
                                    }
                                    catch (InstantiationException instantiationException) {
                                        Status status8 = Status.error("Can't instantiate class`" + string + "'");
                                        Object var13_37 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status8;
                                    }
                                    catch (ThreadDeath threadDeath) {
                                        throw threadDeath;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace(printWriter2);
                                        Status status9 = Status.error("Unexpected exception: " + exception);
                                        Object var13_38 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status9;
                                    }
                                    catch (Error error) {
                                        error.printStackTrace(printWriter2);
                                        Status status10 = Status.error("Unexpected error: " + error);
                                        Object var13_39 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status10;
                                    }
                                    catch (Throwable throwable) {
                                        throwable.printStackTrace(printWriter2);
                                        Status status11 = Status.error("Unexpected throwable: " + throwable);
                                        Object var13_40 = null;
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTREF");
                                        }
                                        printWriter.close();
                                        if (tracing) {
                                            traceOut.println("CLOSE TESTLOG");
                                        }
                                        printWriter2.close();
                                        return status11;
                                    }
                                }
                                traceOut.println("CLOSE TESTREF");
                            }
                            printWriter.close();
                            if (tracing) {
                                traceOut.println("CLOSE TESTLOG");
                            }
                            printWriter2.close();
                            return status4;
                        }
                        catch (Throwable throwable) {
                            Object var13_41 = null;
                            if (tracing) {
                                traceOut.println("CLOSE TESTREF");
                            }
                            printWriter.close();
                            if (tracing) {
                                traceOut.println("CLOSE TESTLOG");
                            }
                            printWriter2.close();
                            throw throwable;
                        }
                    }
                    Object var13_31 = null;
                    if (tracing) {
                        traceOut.println("CLOSE TESTREF");
                    }
                    printWriter.close();
                    if (tracing) {
                        traceOut.println("CLOSE TESTLOG");
                    }
                    printWriter2.close();
                    return status3;
                }
                Object var13_32 = null;
                if (tracing) {
                    traceOut.println("CLOSE TESTREF");
                }
                printWriter.close();
                if (tracing) {
                    traceOut.println("CLOSE TESTLOG");
                }
                printWriter2.close();
                return status2;
            }
            Object var13_33 = null;
            if (tracing) {
                traceOut.println("CLOSE TESTREF");
            }
            printWriter.close();
            if (tracing) {
                traceOut.println("CLOSE TESTLOG");
            }
            printWriter2.close();
            return status;
        }

        private Status executeTest(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execTest(this.connection, this.tag, clazz.getName(), stringArray);
            Test test = (Test)clazz.newInstance();
            return test.run(stringArray, printWriter, printWriter2);
        }

        private Status executeCommand(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2, ClassLoader classLoader) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
            Agent.this.notifier.execCommand(this.connection, this.tag, clazz.getName(), stringArray);
            Command command = (Command)clazz.newInstance();
            command.setClassLoader(classLoader);
            return command.run(stringArray, printWriter, printWriter2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Status executeMain(Class clazz, String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException, ClassNotFoundException, IllegalAccessException {
            Status status;
            Agent.this.notifier.execMain(this.connection, this.tag, clazz.getName(), stringArray);
            PrintStream printStream = Deprecated.createPrintStream(new WriterStream(printWriter2));
            PrintStream printStream2 = Deprecated.createPrintStream(new WriterStream(printWriter));
            try {
                try {
                    Agent.this.setSystemStreams(this, printStream, printStream2);
                    Method method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Agent.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    method.invoke(null, new Object[]{stringArray});
                    status = Status.passed("OK");
                    Object var11_15 = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Status status2 = Status.error("Can't find `public static void main(String[] args)' for `" + clazz.getName() + "'");
                    Object var11_16 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status2;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throwable.printStackTrace(printStream2);
                    Status status3 = Status.failed(throwable.toString());
                    Object var11_17 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status3;
                }
                catch (InterruptedException interruptedException) {
                    Status status4 = Status.failed("interrupted while waiting for access to system streams");
                    Object var11_18 = null;
                    Agent.this.resetSystemStreams(this);
                    printStream.flush();
                    printStream2.flush();
                    return status4;
                }
            }
            catch (Throwable throwable) {
                Object var11_19 = null;
                Agent.this.resetSystemStreams(this);
                printStream.flush();
                printStream2.flush();
                throw throwable;
            }
            Agent.this.resetSystemStreams(this);
            printStream.flush();
            printStream2.flush();
            return status;
        }

        synchronized void close() {
            if (!this.connection.isClosed()) {
                Agent.closeIgnoreExceptions(this.connection);
            }
            if (this.in != null) {
                try {
                    this.in.close();
                    this.in = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                    this.out = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        synchronized void sendChars(byte by, char[] cArray, int n, int n2) throws IOException {
            this.out.write(by);
            this.out.writeUTF(new String(cArray, n, n2));
            switch (by) {
                case 108: 
                case 114: {
                    this.out.flush();
                }
            }
        }

        private synchronized void sendStatus(Status status) throws IOException {
            this.out.write(83);
            this.out.write((byte)status.getType());
            this.out.writeUTF(status.getReason());
        }

        synchronized byte[] getClassData(String string) throws ClassNotFoundException {
            if (tracing) {
                traceOut.println("REMOTE LOAD " + string);
            }
            try {
                int n;
                this.out.write(67);
                this.out.writeUTF(string);
                this.out.flush();
                int n2 = this.in.readInt();
                if (n2 == 0) {
                    throw new ClassNotFoundException(string);
                }
                byte[] byArray = new byte[n2];
                for (int i = 0; i < byArray.length; i += n) {
                    n = this.in.read(byArray, i, byArray.length - i);
                    if (n != -1) continue;
                    throw new ClassNotFoundException(string + ": EOF while reading class data");
                }
                return byArray;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string + ": " + iOException);
            }
        }

        synchronized byte[] getResourceData(String string) throws MissingResourceException, IOException {
            int n;
            if (tracing) {
                traceOut.println("REMOTE LOAD " + string);
            }
            this.out.write(68);
            this.out.writeUTF(string);
            this.out.flush();
            int n2 = this.in.readInt();
            if (n2 == 0) {
                throw new MissingResourceException(string, null, string);
            }
            byte[] byArray = new byte[n2];
            for (int i = 0; i < byArray.length; i += n) {
                n = this.in.read(byArray, i, byArray.length - i);
                if (n != -1) continue;
                throw new IOException(string + ": EOF while reading resource data");
            }
            return byArray;
        }

        private ClassLoader getAgentClassLoader() throws InstantiationException, IllegalAccessException {
            if (this.agentClassLoader == null) {
                Object object;
                Class[] classArray;
                if (classLoaderConstructor == null) {
                    try {
                        classArray = this.getClass().getName();
                        String string = classArray.substring(0, classArray.lastIndexOf(46));
                        object = Class.forName(string + ".AgentClassLoader2");
                    }
                    catch (Throwable throwable) {
                        Object object2;
                        if (class$com$sun$javatest$agent$AgentClassLoader == null) {
                            class$com$sun$javatest$agent$AgentClassLoader = Agent.class$("com.sun.javatest.agent.AgentClassLoader");
                            object2 = class$com$sun$javatest$agent$AgentClassLoader;
                        } else {
                            object2 = class$com$sun$javatest$agent$AgentClassLoader;
                        }
                        object = object2;
                    }
                    try {
                        classArray = new Class[]{class$com$sun$javatest$agent$Agent$Task == null ? (class$com$sun$javatest$agent$Agent$Task = Agent.class$("com.sun.javatest.agent.Agent$Task")) : class$com$sun$javatest$agent$Agent$Task};
                        classLoaderConstructor = object.getDeclaredConstructor(classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                    }
                }
                try {
                    object = new Object[]{this};
                    return (ClassLoader)classLoaderConstructor.newInstance(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    classArray = invocationTargetException.getTargetException();
                    if (classArray instanceof RuntimeException) {
                        throw (RuntimeException)classArray;
                    }
                    if (classArray instanceof Error) {
                        throw (Error)classArray;
                    }
                    throw new Error(invocationTargetException.toString());
                }
            }
            return this.agentClassLoader;
        }
    }

    private class Notifier {
        private Observer[] observers = new Observer[0];

        private Notifier() {
        }

        public synchronized void addObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.append(this.observers, observer);
        }

        public synchronized void removeObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
        }

        public synchronized void started() {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].started(Agent.this);
            }
        }

        public synchronized void finished() {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].finished(Agent.this);
            }
        }

        public synchronized void openedConnection(Connection connection) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].openedConnection(Agent.this, connection);
            }
        }

        public synchronized void errorOpeningConnection(Exception exception) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].errorOpeningConnection(Agent.this, exception);
            }
        }

        public synchronized void execTest(Connection connection, String string, String string2, String[] stringArray) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execTest(Agent.this, connection, string, string2, stringArray);
            }
        }

        public synchronized void execCommand(Connection connection, String string, String string2, String[] stringArray) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execCommand(Agent.this, connection, string, string2, stringArray);
            }
        }

        public synchronized void execMain(Connection connection, String string, String string2, String[] stringArray) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].execMain(Agent.this, connection, string, string2, stringArray);
            }
        }

        public synchronized void result(Connection connection, Status status) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].result(Agent.this, connection, status);
            }
        }

        public synchronized void exception(Connection connection, Exception exception) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].exception(Agent.this, connection, exception);
            }
        }

        public synchronized void completed(Connection connection) {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].completed(Agent.this, connection);
            }
        }
    }

    public static interface Observer {
        public void started(Agent var1);

        public void errorOpeningConnection(Agent var1, Exception var2);

        public void finished(Agent var1);

        public void openedConnection(Agent var1, Connection var2);

        public void execTest(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execCommand(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void execMain(Agent var1, Connection var2, String var3, String var4, String[] var5);

        public void result(Agent var1, Connection var2, Status var3);

        public void exception(Agent var1, Connection var2, Throwable var3);

        public void completed(Agent var1, Connection var2);
    }
}

