/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.AgentMonitorToolManager;
import com.sun.javatest.agent.Connection;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.util.StringArray;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AgentMonitorTool
extends Tool {
    private AgentManager agentManager = AgentManager.access();
    private ActiveAgentPool activeAgentPool = this.agentManager.getActiveAgentPool();
    private JMenuBar menuBar;
    private AgentPoolSubpanel agentPoolSubpanel;
    private CurrentAgentsSubpanel currAgentsSubpanel;

    AgentMonitorTool(AgentMonitorToolManager agentMonitorToolManager) {
        super(agentMonitorToolManager, "agentMonitor", "agent.window.csh");
        this.setI18NTitle("tool.title");
        this.setShortTitle(this.uif.getI18NString("tool.shortTitle"));
        this.setLayout(new GridBagLayout());
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.uif.createHorizontalGlue("tool.glue"));
        JMenu jMenu = this.uif.createMenu("tool.help");
        jMenu.add(this.uif.createHelpMenuItem("tool.help.window", "agent.window.csh"));
        this.menuBar.add(jMenu);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.agentPoolSubpanel = new AgentPoolSubpanel();
        this.add((Component)this.agentPoolSubpanel, gridBagConstraints);
        this.currAgentsSubpanel = new CurrentAgentsSubpanel();
        this.add((Component)this.currAgentsSubpanel, gridBagConstraints);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void save(Map map) {
        int n;
        int n2 = this.agentPoolSubpanel.getPort();
        if (n2 != Integer.MIN_VALUE) {
            map.put("port", String.valueOf(n2));
        }
        if ((n = this.agentPoolSubpanel.getTimeout()) != Integer.MIN_VALUE) {
            map.put("timeout", String.valueOf(n));
        }
        map.put("listening", String.valueOf(this.agentPoolSubpanel.isListening()));
    }

    void restore(Map map) {
        String string = (String)map.get("listening");
        try {
            String string2;
            String string3 = (String)map.get("port");
            if (string3 != null && string3.length() != 0) {
                this.agentPoolSubpanel.setPort(Integer.parseInt(string3));
            }
            if ((string2 = (String)map.get("timeout")) != null && string2.length() != 0) {
                this.agentPoolSubpanel.setTimeout(Integer.parseInt(string2));
            }
            if (string != null && string.length() != 0) {
                this.agentPoolSubpanel.setListening(string.equals("true"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class CurrentAgentsSubpanel
    extends JPanel
    implements ListSelectionListener,
    AgentManager.Observer {
        private JList list;
        private DefaultListModel listData;
        private Entry selectedEntry;
        private JLabel addressLabel;
        private JTextField addressField;
        private JLabel tagLabel;
        private JTextField tagField;
        private JLabel requestLabel;
        private JTextField requestField;
        private JLabel execLabel;
        private JTextField execField;
        private JLabel argsLabel;
        private JTextField argsField;
        private JCheckBox localizeArgsCheck;

        CurrentAgentsSubpanel() {
            this.setName("tool.curr");
            this.setBorder(AgentMonitorTool.this.uif.createTitledBorder("tool.curr"));
            this.setLayout(new GridBagLayout());
            AgentMonitorTool.this.uif.setToolTip(this, "tool.curr");
            this.listData = new DefaultListModel();
            this.list = AgentMonitorTool.this.uif.createList("tool.list.curr", this.listData);
            this.list.setVisibleRowCount(5);
            this.list.setCellRenderer(new DefaultListCellRenderer(this){
                private final /* synthetic */ CurrentAgentsSubpanel this$1;
                {
                    this.this$1 = currentAgentsSubpanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = ((Entry)object).toString();
                    return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                }
            });
            this.list.addListSelectionListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)AgentMonitorTool.this.uif.createScrollPane(this.list), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets.right = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 2;
            this.addressLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.address", true);
            this.add((Component)this.addressLabel, gridBagConstraints2);
            this.addressField = AgentMonitorTool.this.uif.createOutputField("tool.curr.address", this.addressLabel);
            this.add((Component)this.addressField, gridBagConstraints3);
            this.tagLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.tag", true);
            this.add((Component)this.tagLabel, gridBagConstraints2);
            this.tagField = AgentMonitorTool.this.uif.createOutputField("tool.curr.tag", this.tagLabel);
            this.add((Component)this.tagField, gridBagConstraints3);
            this.requestLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.request", true);
            this.add((Component)this.requestLabel, gridBagConstraints2);
            this.requestField = AgentMonitorTool.this.uif.createOutputField("tool.curr.request", this.requestLabel);
            this.add((Component)this.requestField, gridBagConstraints3);
            this.execLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.execute", true);
            this.add((Component)this.execLabel, gridBagConstraints2);
            this.execField = AgentMonitorTool.this.uif.createOutputField("tool.curr.execute", this.execLabel);
            this.add((Component)this.execField, gridBagConstraints3);
            this.argsLabel = AgentMonitorTool.this.uif.createLabel("tool.curr.args", true);
            this.add((Component)this.argsLabel, gridBagConstraints2);
            this.argsField = AgentMonitorTool.this.uif.createOutputField("tool.curr.args", this.argsLabel);
            this.add((Component)this.argsField, gridBagConstraints3);
            this.add(AgentMonitorTool.this.uif.createGlue("tool.curr.pad"), gridBagConstraints2);
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.anchor = 17;
            this.localizeArgsCheck = AgentMonitorTool.this.uif.createCheckBox("tool.mapArgs", false);
            this.add((Component)this.localizeArgsCheck, gridBagConstraints3);
            AgentMonitorTool.this.agentManager.addObserver(this);
        }

        public synchronized void valueChanged(ListSelectionEvent listSelectionEvent) {
            Entry entry = (Entry)this.list.getSelectedValue();
            if (entry == null) {
                this.addressField.setText("");
                this.tagField.setText("");
                this.requestField.setText("");
                this.execField.setText("");
                this.argsField.setText("");
                this.localizeArgsCheck.setSelected(false);
                this.selectedEntry = null;
            } else {
                this.addressField.setText(entry.connection.getName());
                this.tagField.setText(entry.tag);
                this.requestField.setText(entry.request);
                this.execField.setText(entry.executable);
                this.argsField.setText(StringArray.join(entry.args));
                this.localizeArgsCheck.setSelected(entry.localizeArgs);
                this.selectedEntry = entry;
            }
        }

        public synchronized void started(Connection connection, String string, String string2, String string3, String[] stringArray, boolean bl) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, connection, string, string2, string3, stringArray, bl){
                    private final /* synthetic */ Connection val$c;
                    private final /* synthetic */ String val$tag;
                    private final /* synthetic */ String val$request;
                    private final /* synthetic */ String val$executable;
                    private final /* synthetic */ String[] val$args;
                    private final /* synthetic */ boolean val$localizeArgs;
                    private final /* synthetic */ CurrentAgentsSubpanel this$1;
                    {
                        this.this$1 = currentAgentsSubpanel;
                        this.val$c = connection;
                        this.val$tag = string;
                        this.val$request = string2;
                        this.val$executable = string3;
                        this.val$args = stringArray;
                        this.val$localizeArgs = bl;
                    }

                    public void run() {
                        this.this$1.started(this.val$c, this.val$tag, this.val$request, this.val$executable, this.val$args, this.val$localizeArgs);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                this.listData.addElement(new Entry(connection, string, string2, string3, stringArray, bl));
            }
        }

        public synchronized void finished(Connection connection, Status status) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, connection, status){
                    private final /* synthetic */ Connection val$c;
                    private final /* synthetic */ Status val$status;
                    private final /* synthetic */ CurrentAgentsSubpanel this$1;
                    {
                        this.this$1 = currentAgentsSubpanel;
                        this.val$c = connection;
                        this.val$status = status;
                    }

                    public void run() {
                        this.this$1.finished(this.val$c, this.val$status);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                for (int i = 0; i < this.listData.size(); ++i) {
                    Entry entry = (Entry)this.listData.elementAt(i);
                    if (entry.connection != connection) continue;
                    this.listData.removeElement(entry);
                    break;
                }
            }
        }

        private class Entry {
            Connection connection;
            String tag;
            String request;
            String executable;
            String[] args;
            boolean localizeArgs;

            Entry(Connection connection, String string, String string2, String string3, String[] stringArray, boolean bl) {
                this.connection = connection;
                this.tag = string;
                this.request = string2;
                this.executable = string3;
                this.args = stringArray;
                this.localizeArgs = bl;
            }

            public String toString() {
                return AgentMonitorTool.this.uif.getI18NString("tool.entry", new Object[]{this.connection.getName(), this.tag});
            }
        }
    }

    private class AgentPoolSubpanel
    extends JPanel
    implements ItemListener,
    ActiveAgentPool.Observer {
        private JCheckBox listeningCheck;
        private JLabel portLabel;
        private JTextField portField;
        private JLabel timeoutLabel;
        private JTextField timeoutField;
        private JList list;
        private DefaultListModel listData;

        AgentPoolSubpanel() {
            this.setName("tool.pool");
            this.setBorder(AgentMonitorTool.this.uif.createTitledBorder("tool.pool"));
            this.setLayout(new GridBagLayout());
            AgentMonitorTool.this.uif.setAccessibleDescription(this, "tool.pool");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets.right = 10;
            this.listeningCheck = AgentMonitorTool.this.uif.createCheckBox("tool.pool.listen", false);
            this.listeningCheck.setSelected(AgentMonitorTool.this.activeAgentPool.isListening());
            this.listeningCheck.addItemListener(this);
            this.add((Component)this.listeningCheck, gridBagConstraints2);
            this.portLabel = AgentMonitorTool.this.uif.createLabel("tool.pool.port", true);
            this.add((Component)this.portLabel, gridBagConstraints);
            this.portField = AgentMonitorTool.this.uif.createInputField("tool.pool.port", 6);
            this.portField.setText(String.valueOf(AgentMonitorTool.this.activeAgentPool.getPort()));
            this.add((Component)this.portField, gridBagConstraints2);
            this.portLabel.setLabelFor(this.portField);
            this.timeoutLabel = AgentMonitorTool.this.uif.createLabel("tool.pool.timeout", true);
            this.add((Component)this.timeoutLabel, gridBagConstraints);
            this.timeoutField = AgentMonitorTool.this.uif.createInputField("tool.pool.timeout", 6);
            int n = AgentMonitorTool.this.activeAgentPool.getTimeout();
            this.timeoutField.setText(String.valueOf((n + 500) / 1000));
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.weightx = 1.0;
            this.add((Component)this.timeoutField, gridBagConstraints2);
            this.timeoutLabel.setLabelFor(this.timeoutField);
            this.listData = new DefaultListModel();
            this.list = AgentMonitorTool.this.uif.createList("tool.pool", this.listData);
            this.list.setPrototypeCellValue("abcdefghiklmnopqrstuvwxyz");
            this.list.setVisibleRowCount(3);
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            this.add((Component)AgentMonitorTool.this.uif.createScrollPane(this.list), gridBagConstraints3);
            Enumeration enumeration = AgentMonitorTool.this.activeAgentPool.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                this.listData.addElement(connection.getName());
            }
            AgentMonitorTool.this.activeAgentPool.addObserver(this);
            this.enableFields();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable() == this.listeningCheck) {
                boolean bl;
                try {
                    if (itemEvent.getStateChange() == 1) {
                        int n;
                        try {
                            n = Integer.parseInt(this.timeoutField.getText());
                            AgentMonitorTool.this.activeAgentPool.setTimeout(n * 1000);
                        }
                        catch (NumberFormatException numberFormatException) {
                            AgentMonitorTool.this.uif.showError("tool.badTimeout");
                            Object var4_7 = null;
                            boolean bl2 = AgentMonitorTool.this.activeAgentPool.isListening();
                            if (bl2 != this.listeningCheck.isSelected()) {
                                this.listeningCheck.setSelected(bl2);
                            }
                            this.enableFields();
                            return;
                        }
                        try {
                            n = Integer.parseInt(this.portField.getText());
                            AgentMonitorTool.this.activeAgentPool.setPort(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            AgentMonitorTool.this.uif.showError("tool.badPort");
                            Object var4_8 = null;
                            boolean bl3 = AgentMonitorTool.this.activeAgentPool.isListening();
                            if (bl3 != this.listeningCheck.isSelected()) {
                                this.listeningCheck.setSelected(bl3);
                            }
                            this.enableFields();
                            return;
                        }
                        try {
                            AgentMonitorTool.this.activeAgentPool.setListening(true);
                        }
                        catch (IOException iOException) {
                            AgentMonitorTool.this.uif.showError("tool.listenOn", iOException);
                            Object var4_9 = null;
                            boolean bl4 = AgentMonitorTool.this.activeAgentPool.isListening();
                            if (bl4 != this.listeningCheck.isSelected()) {
                                this.listeningCheck.setSelected(bl4);
                            }
                            this.enableFields();
                            return;
                        }
                    }
                    try {
                        AgentMonitorTool.this.activeAgentPool.setListening(false);
                    }
                    catch (IOException iOException) {
                        AgentMonitorTool.this.uif.showError("tool.listenOff", iOException);
                        Object var4_10 = null;
                        boolean bl5 = AgentMonitorTool.this.activeAgentPool.isListening();
                        if (bl5 != this.listeningCheck.isSelected()) {
                            this.listeningCheck.setSelected(bl5);
                        }
                        this.enableFields();
                        return;
                    }
                    Object var4_11 = null;
                    bl = AgentMonitorTool.this.activeAgentPool.isListening();
                }
                catch (Throwable throwable) {
                    Object var4_12 = null;
                    boolean bl6 = AgentMonitorTool.this.activeAgentPool.isListening();
                    if (bl6 != this.listeningCheck.isSelected()) {
                        this.listeningCheck.setSelected(bl6);
                    }
                    this.enableFields();
                    throw throwable;
                }
                if (bl != this.listeningCheck.isSelected()) {
                    this.listeningCheck.setSelected(bl);
                }
                this.enableFields();
                {
                }
            }
        }

        public void addedToPool(Connection connection) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, connection){
                    private final /* synthetic */ Connection val$c;
                    private final /* synthetic */ AgentPoolSubpanel this$1;
                    {
                        this.this$1 = agentPoolSubpanel;
                        this.val$c = connection;
                    }

                    public void run() {
                        this.this$1.addedToPool(this.val$c);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                this.listData.addElement(connection.getName());
            }
        }

        public void removedFromPool(Connection connection) {
            if (!EventQueue.isDispatchThread()) {
                Runnable runnable = new Runnable(this, connection){
                    private final /* synthetic */ Connection val$c;
                    private final /* synthetic */ AgentPoolSubpanel this$1;
                    {
                        this.this$1 = agentPoolSubpanel;
                        this.val$c = connection;
                    }

                    public void run() {
                        this.this$1.removedFromPool(this.val$c);
                    }
                };
                EventQueue.invokeLater(runnable);
            } else {
                this.listData.removeElement(connection.getName());
            }
        }

        boolean isListening() {
            return this.listeningCheck.isSelected();
        }

        void setListening(boolean bl) {
            this.listeningCheck.setSelected(bl);
        }

        int getPort() {
            try {
                return Integer.parseInt(this.portField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }

        void setPort(int n) {
            this.portField.setText(String.valueOf(n));
        }

        int getTimeout() {
            try {
                return Integer.parseInt(this.timeoutField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }

        void setTimeout(int n) {
            this.timeoutField.setText(String.valueOf(n));
        }

        private void enableFields() {
            boolean bl = !this.listeningCheck.isSelected();
            this.portLabel.setEnabled(bl);
            this.portField.setEnabled(bl);
            this.timeoutLabel.setEnabled(bl);
            this.timeoutField.setEnabled(bl);
        }
    }
}

