/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;

abstract class ListPane
extends AuditPane {
    protected JList list;
    private ListModel model = new ListModel();

    ListPane(String string, UIFactory uIFactory) {
        super(string, uIFactory);
        this.list = uIFactory.createList(string + ".lst", this.model);
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.list.setCellRenderer(new Renderer());
        JScrollPane jScrollPane = uIFactory.createScrollPane(this.list, 20, 31);
        this.setBody(jScrollPane);
    }

    void setData(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.show(this.uif.getI18NString("list.noEntries"));
        } else {
            this.model.setData(objectArray);
            this.showBody();
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                string = testResult.getTestName();
            } else if (object instanceof TestDescription) {
                TestDescription testDescription = (TestDescription)object;
                string = testDescription.getRootRelativeURL();
            } else {
                string = String.valueOf(object);
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    private class ListModel
    extends AbstractListModel {
        private Object[] data;

        private ListModel() {
        }

        public Object getElementAt(int n) {
            return this.data[n];
        }

        public int getSize() {
            return this.data == null ? 0 : this.data.length;
        }

        void setData(Object[] objectArray) {
            this.data = objectArray;
            this.fireContentsChanged(this, 0, objectArray.length - 1);
        }
    }
}

