/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.batch;

import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.Status;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;

class RunTestsCommand
extends Command {
    private static final String DATE_OPTION = "date";
    private static final String NON_PASS_OPTION = "non-pass";
    private static final String START_OPTION = "start";
    private static final String FINISH_OPTION = "stop";
    private static final String PROGRESS_OPTION = "progress";
    private Harness harness;
    private CommandContext ctx;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$batch$RunTestsCommand == null ? (class$com$sun$javatest$batch$RunTestsCommand = RunTestsCommand.class$("com.sun.javatest.batch.RunTestsCommand")) : class$com$sun$javatest$batch$RunTestsCommand);
    static /* synthetic */ Class class$com$sun$javatest$batch$RunTestsCommand;

    static String getName() {
        return "runTests";
    }

    static void initVerboseOptions() {
        VerboseCommand.addOption(DATE_OPTION, new HelpTree.Node(i18n, "runTests.verbose.date"));
        VerboseCommand.addOption(NON_PASS_OPTION, new HelpTree.Node(i18n, "runTests.verbose.nonPass"));
        VerboseCommand.addOption(START_OPTION, new HelpTree.Node(i18n, "runTests.verbose.start"));
        VerboseCommand.addOption(FINISH_OPTION, new HelpTree.Node(i18n, "runTests.verbose.stop"));
        VerboseCommand.addOption(PROGRESS_OPTION, new HelpTree.Node(i18n, "runTests.verbose.progress"));
    }

    RunTestsCommand() {
        super(RunTestsCommand.getName());
    }

    RunTestsCommand(Iterator iterator) {
        super(RunTestsCommand.getName());
    }

    public boolean isActionCommand() {
        return true;
    }

    public void run(CommandContext commandContext) throws Command.Fault {
        this.ctx = commandContext;
        try {
            Harness harness;
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            this.harness = harness = new Harness();
            Harness.Observer[] observerArray = commandContext.getHarnessObservers();
            for (int i = 0; i < observerArray.length; ++i) {
                harness.addObserver(observerArray[i]);
            }
            VerboseObserver verboseObserver = new VerboseObserver(commandContext);
            harness.addObserver(verboseObserver);
            BatchObserver batchObserver = new BatchObserver();
            harness.addObserver(batchObserver);
            interviewParameters.getTestSuite().getTestFinder().setErrorHandler(batchObserver);
            boolean bl = harness.batch(interviewParameters);
            if (batchObserver.getFinderErrorCount() > 0) {
                commandContext.printErrorMessage(i18n, "runTests.warnError");
            }
            this.showResultStats(batchObserver.getStats());
            int n = harness.getTestsFoundCount();
            if (n > 0) {
                commandContext.printMessage(i18n, "runTests.resultsDone", interviewParameters.getWorkDirectory().getPath());
            }
            int[] nArray = batchObserver.getStats();
            if (!bl && n > 0 && n != nArray[0]) {
                commandContext.printErrorMessage(i18n, "runTests.testsFailed");
            }
            commandContext.addTestStats(nArray);
        }
        catch (Harness.Fault fault) {
            throw new Command.Fault((Command)this, i18n, "runTests.harnessError", fault.getMessage());
        }
        catch (InterruptedException interruptedException) {
            throw new Command.Fault(this, i18n, "runTests.interrupted");
        }
    }

    private void showResultStats(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        nArray[3] = this.harness.getTestsFoundCount() - n - n2 - n3;
        int n4 = nArray[3];
        if (n + n2 + n3 + n4 == 0) {
            this.ctx.printMessage(i18n, "runTests.noTests");
        } else {
            this.ctx.printMessage(i18n, "runTests.tests", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4)});
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VerboseObserver
    implements Harness.Observer {
        private boolean[] options;
        private boolean quiet_flag = false;
        private boolean max_flag = false;
        private DateFormat df;
        private CommandContext ctx;
        private PrintWriter out;
        private int[] stats;
        private boolean progressOnline = false;
        public static final int NO_DATE = 0;
        public static final int NON_PASS = 1;
        public static final int START = 2;
        public static final int FINISH = 3;
        public static final int PROGRESS = 4;
        public static final int DEFAULT = 4;
        private static final int OPTION_COUNT = 5;

        VerboseObserver(CommandContext commandContext) {
            this.ctx = commandContext;
            this.out = commandContext.getLogWriter();
            this.df = DateFormat.getDateTimeInstance(2, 2);
            commandContext.addHarnessObserver(this);
            boolean bl = commandContext.getVerboseOptionValue("default", false);
            this.options = new boolean[5];
            this.options[0] = !commandContext.isVerboseTimestampEnabled();
            this.options[1] = commandContext.getVerboseOptionValue(RunTestsCommand.NON_PASS_OPTION, false);
            this.options[2] = commandContext.getVerboseOptionValue(RunTestsCommand.START_OPTION, false);
            this.options[3] = commandContext.getVerboseOptionValue(RunTestsCommand.FINISH_OPTION, false);
            this.options[4] = commandContext.getVerboseOptionValue(RunTestsCommand.PROGRESS_OPTION, bl);
        }

        public boolean isVerbose(int n) {
            if (this.quiet_flag) {
                return false;
            }
            if (this.max_flag) {
                return true;
            }
            if (n < 5) {
                return this.options[n];
            }
            return false;
        }

        private void printTimestamp() {
            if (this.quiet_flag || this.options[0]) {
                return;
            }
            this.out.print(this.df.format(new Date()));
            this.out.print(" ");
        }

        public void startingTestRun(Parameters parameters) {
            this.stats = new int[4];
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.strt", parameters.getEnv().getName());
                this.out.flush();
                this.progressOnline = false;
            }
        }

        public void startingTest(TestResult testResult) {
            if (!this.isVerbose(2)) {
                return;
            }
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printMessage(i18n, "cmgr.verb.tsts", testResult.getTestName());
            this.out.flush();
            this.progressOnline = false;
        }

        public void finishedTest(TestResult testResult) {
            Status status = testResult.getStatus();
            int n = status.getType();
            this.stats[n] = this.stats[n] + 1;
            switch (status.getType()) {
                case 1: 
                case 2: {
                    if (!this.isVerbose(1) && !this.isVerbose(3)) break;
                    this.printFinish(status, testResult);
                    this.progressOnline = false;
                    break;
                }
                default: {
                    if (!this.isVerbose(3)) break;
                    this.printFinish(status, testResult);
                    this.progressOnline = false;
                }
            }
            this.printStats();
            this.out.flush();
        }

        public void stoppingTestRun() {
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printMessage(i18n, "cmgr.verb.stpng");
            this.out.flush();
            this.progressOnline = false;
        }

        public void finishedTesting() {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.donerun");
                this.out.flush();
                this.progressOnline = false;
            }
        }

        public void finishedTestRun(boolean bl) {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                this.ctx.printMessage(i18n, "cmgr.verb.finish");
                this.out.flush();
                this.progressOnline = false;
            }
        }

        public void error(String string) {
            if (this.progressOnline) {
                this.out.println();
            }
            this.printTimestamp();
            this.ctx.printErrorMessage(i18n, "cmgr.verb.err", string);
            this.out.flush();
            this.progressOnline = false;
        }

        private void printStats() {
            if (!this.isVerbose(4)) {
                return;
            }
            if (this.progressOnline) {
                this.out.print("\r");
            }
            int n = this.stats[0];
            int n2 = this.stats[1];
            int n3 = this.stats[2];
            int n4 = this.stats[3] = RunTestsCommand.this.harness.getTestsFoundCount() - n - n2 - n3;
            this.out.print(i18n.getString("cmgr.verb.prog", new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)}));
            this.out.print("    ");
            this.progressOnline = true;
        }

        private void printFinish(Status status, TestResult testResult) {
            if (!this.quiet_flag) {
                if (this.progressOnline) {
                    this.out.println();
                }
                this.printTimestamp();
                Object[] objectArray = new String[]{testResult.getTestName(), status.toString()};
                this.ctx.printMessage(i18n, "cmgr.verb.tstd", objectArray);
                this.out.flush();
                this.progressOnline = false;
            }
        }

        private boolean isScolling() {
            return this.isVerbose(2) || this.isVerbose(3);
        }
    }

    private class BatchObserver
    implements Harness.Observer,
    TestFinder.ErrorHandler {
        private int[] stats;
        private int finderErrors;

        private BatchObserver() {
        }

        int[] getStats() {
            return this.stats;
        }

        int getFinderErrorCount() {
            return this.finderErrors;
        }

        public void startingTestRun(Parameters parameters) {
            this.stats = new int[4];
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
            int n = testResult.getStatus().getType();
            this.stats[n] = this.stats[n] + 1;
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
            RunTestsCommand.this.ctx.printMessage(i18n, "runTests.error", string);
            ++this.finderErrors;
        }
    }
}

