/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.util.XMLWriter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

abstract class COFItem {
    BeanInfo bi = null;
    LinkedHashMap itemAttributes = this.getItemAttributes();
    LinkedHashMap itemElements = this.getItemElements();
    String itemTagName = this.getItemTagName();
    PropertyDescriptor[] pds = null;

    COFItem() {
    }

    private String[] getAttributeProperties() {
        return this.itemAttributes == null ? null : ((HashMap)this.itemAttributes).keySet().toArray(new String[this.itemAttributes.size()]);
    }

    LinkedHashMap getItemAttributes() {
        return null;
    }

    LinkedHashMap getItemElements() {
        return null;
    }

    String getItemTagName() {
        return null;
    }

    Object getProperty(String string) {
        if (this.bi == null) {
            try {
                this.bi = Introspector.getBeanInfo(this.getClass());
                this.pds = this.bi.getPropertyDescriptors();
                Arrays.sort(this.pds, new Comparator(){

                    public int compare(Object object, Object object2) {
                        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
                        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)object2;
                        return propertyDescriptor.getName().compareTo(propertyDescriptor2.getName());
                    }
                });
            }
            catch (IntrospectionException introspectionException) {
                introspectionException.printStackTrace();
            }
        }
        if (this.pds == null) {
            return null;
        }
        Object object = null;
        int n = Arrays.binarySearch(this.pds, string, new Comparator(){

            public int compare(Object object, Object object2) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
                String string = (String)object2;
                return propertyDescriptor.getName().compareTo(string);
            }
        });
        try {
            object = this.pds[n].getReadMethod().invoke((Object)this, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return object;
    }

    private String[] getPropOrder() {
        return this.itemElements == null ? null : ((HashMap)this.itemElements).keySet().toArray(new String[this.itemElements.size()]);
    }

    void write(XMLWriter xMLWriter) throws IOException {
        int n;
        String[] stringArray;
        if (this.itemTagName == null) {
            return;
        }
        xMLWriter.startTag(this.itemTagName);
        if (this.itemAttributes != null) {
            stringArray = this.getAttributeProperties();
            for (n = 0; n < stringArray.length; ++n) {
                xMLWriter.writeAttr(this.itemAttributes.get(stringArray[n]).toString(), (String)this.getProperty(stringArray[n]));
            }
        }
        if (this.itemElements != null) {
            stringArray = this.getPropOrder();
            for (n = 0; n < stringArray.length; ++n) {
                Object object = this.getProperty(stringArray[n]);
                if (object instanceof COFItem) {
                    COFItem cOFItem = (COFItem)object;
                    cOFItem.write(xMLWriter);
                    continue;
                }
                if (object instanceof Collection) {
                    this.writeCollection(xMLWriter, stringArray[n]);
                    continue;
                }
                if (object == null) continue;
                xMLWriter.startTag(this.itemElements.get(stringArray[n]).toString());
                this.write(xMLWriter, object);
                xMLWriter.endTag(this.itemElements.get(stringArray[n]).toString());
            }
        }
        xMLWriter.endTag(this.itemTagName);
    }

    protected void write(XMLWriter xMLWriter, Object object) throws IOException {
        if (object instanceof String) {
            xMLWriter.write((String)object);
        } else if (object instanceof Date) {
            xMLWriter.writeDate((Date)object);
        } else {
            xMLWriter.write(object.toString());
        }
    }

    void writeCollection(XMLWriter xMLWriter, String string) throws IOException {
        Collection collection = (Collection)this.getProperty(string);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof COFItem) {
                ((COFItem)e).write(xMLWriter);
                continue;
            }
            xMLWriter.startTag(this.itemElements.get(string).toString());
            this.write(xMLWriter, e);
            xMLWriter.endTag(this.itemElements.get(string).toString());
        }
    }
}

