/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class BP_FilteredOutSubpanel
extends BP_BranchSubpanel {
    private JTable table;
    private TestTableModel mod;
    private TT_NodeCache cache;
    private TestResultTable.TreeNode lastNode;
    private CacheObserver cacheWatcher;
    private volatile TableSynchronizer resyncThread;
    private TableCellRenderer renderer;
    private InputListener listener;
    private JTextArea infoTa;
    private boolean rowHeightSet;
    private static final int ROW_HEIGHT_PADDING = 3;
    private boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$BP_FilteredOutSubpanel == null ? (class$com$sun$javatest$exec$BP_FilteredOutSubpanel = BP_FilteredOutSubpanel.class$("com.sun.javatest.exec.BP_FilteredOutSubpanel")) : class$com$sun$javatest$exec$BP_FilteredOutSubpanel);
    static /* synthetic */ Class class$com$sun$javatest$exec$BP_FilteredOutSubpanel;

    BP_FilteredOutSubpanel(UIFactory uIFactory, BP_Model bP_Model, TestTreeModel testTreeModel) {
        super("fo", uIFactory, bP_Model, testTreeModel, "br.fo");
        this.init();
        CSH.setHelpIDString(this, "browse.filteredOutTab.csh");
        this.cacheWatcher = new CacheObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(TT_NodeCache tT_NodeCache) {
        BP_FilteredOutSubpanel bP_FilteredOutSubpanel = this;
        synchronized (bP_FilteredOutSubpanel) {
            if (this.cache != null) {
                this.cache.removeObserver(this.cacheWatcher);
            }
            this.cache = tT_NodeCache;
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            if (this.mod != null) {
                this.mod.reset();
            }
        }
        this.validateEnableState();
    }

    protected void invalidateFilters() {
        super.invalidateFilters();
        if (this.cache != null) {
            this.cache.removeObserver(this.cacheWatcher);
        }
        if (this.subpanelNode != null) {
            this.cache = this.ttm.getNodeInfo(this.subpanelNode, false);
            this.validateEnableState();
        }
        this.updateInfoText();
    }

    protected synchronized void updateSubpanel(TestResultTable.TreeNode treeNode) {
        super.updateSubpanel(treeNode);
        if (this.lastNode != treeNode || this.filtersInvalidated) {
            if (this.debug) {
                Debug.println("updating FO table");
            }
            if (this.resyncThread != null) {
                this.resyncThread.halt();
            }
            this.resyncThread = new TableSynchronizer();
            this.resyncThread.start();
            this.lastNode = treeNode;
            this.filtersInvalidated = false;
            this.validateEnableState();
        }
    }

    private void updateInfoText() {
        if (this.infoTa == null) {
            return;
        }
        TestFilter testFilter = this.model.getFilter();
        if (testFilter != null) {
            this.infoTa.setText(this.uif.getI18NString("br.fo.info.txt", testFilter.getName()));
        } else {
            this.infoTa.setText(this.uif.getI18NString("br.fo.noFn.txt"));
        }
    }

    private void validateEnableState() {
        if (this.cache.getRejectCount() > 0) {
            this.model.setEnabled(this, true);
        } else if (this.cache.getRejectCount() == 0) {
            this.model.setEnabled(this, false);
        }
    }

    private void init() {
        this.mod = new TestTableModel(this.uif);
        this.renderer = new TestCellRenderer(this.uif);
        this.listener = new InputListener();
        this.table = this.uif.createTable("br.fo.tbl", this.mod);
        this.table.setOpaque(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this.listener);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.renderer);
        tableColumn.setResizable(true);
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(this.renderer);
        tableColumn.setResizable(true);
        this.uif.setAccessibleInfo(this, "br.fo");
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.infoTa = this.uif.createMessageArea("br.fo.info");
        this.infoTa.setOpaque(false);
        this.add((Component)this.infoTa, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.uif.createScrollPane(this.table, 20, 30), gridBagConstraints);
        this.updateInfoText();
        InputListener inputListener = new InputListener();
        this.table.addMouseListener(inputListener);
        this.table.getSelectionModel().addListSelectionListener(inputListener);
        this.table.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "gotoTest");
        this.table.getActionMap().put("gotoTest", new KbTableAction(this.uif.getI18NResourceBundle(), "br.list.enter"));
        this.setMinimumSize(new Dimension(150, 100));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TestCellRenderer
    extends DefaultTableCellRenderer {
        private Border spacerBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);

        public TestCellRenderer(UIFactory uIFactory) {
            this.setOpaque(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            if (object instanceof TestResult) {
                TestResult testResult = (TestResult)object;
                this.setText(testResult.getTestName());
                this.setToolTipText(I18NUtils.getStatusMessage(testResult.getStatus()));
            } else if (object instanceof TestFilter) {
                TestFilter testFilter = (TestFilter)object;
                this.setText(testFilter.getReason());
                this.setToolTipText(testFilter.getDescription());
            } else {
                this.setText(object.toString());
            }
            this.setBorder(this.spacerBorder);
            this.setFont(this.getFont().deriveFont(0));
            if (bl) {
                this.setOpaque(true);
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
            if (!BP_FilteredOutSubpanel.this.rowHeightSet) {
                jTable.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 3);
                BP_FilteredOutSubpanel.this.rowHeightSet = true;
            }
            return this;
        }
    }

    private class KbTableAction
    extends AbstractAction {
        private String name;
        private String desc;

        KbTableAction(I18NResourceBundle i18NResourceBundle, String string) {
            this.desc = i18NResourceBundle.getString(string + ".desc");
            this.name = i18NResourceBundle.getString(string + ".act");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BP_FilteredOutSubpanel.this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            Object object = BP_FilteredOutSubpanel.this.table.getModel().getValueAt(n, 0);
            if (!(object instanceof TestResult)) {
                return;
            }
            TestResult testResult = (TestResult)object;
            TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
            if (treeNodeArray == null || treeNodeArray.length == 0) {
                return;
            }
            Object[] objectArray = new Object[treeNodeArray.length + 1];
            System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
            objectArray[objectArray.length - 1] = testResult;
            BP_FilteredOutSubpanel.this.model.showTest(testResult, objectArray);
        }

        public Object getValue(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.equals("Name")) {
                return this.name;
            }
            if (string.equals("ShortDescription")) {
                return this.desc;
            }
            return null;
        }
    }

    class InputListener
    extends MouseAdapter
    implements ListSelectionListener {
        private int lastIndex = -2;

        InputListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getComponent();
            int n = BP_FilteredOutSubpanel.this.table.columnAtPoint(mouseEvent.getPoint());
            int n2 = BP_FilteredOutSubpanel.this.table.rowAtPoint(mouseEvent.getPoint());
            TableModel tableModel = BP_FilteredOutSubpanel.this.table.getModel();
            if (tableModel.getRowCount() < 1) {
                BP_FilteredOutSubpanel.this.showMessage("");
                return;
            }
            TestResult testResult = (TestResult)tableModel.getValueAt(n2, 0);
            if (mouseEvent.getClickCount() == 1) {
                BP_FilteredOutSubpanel.this.showMessage(I18NUtils.getStatusMessage(testResult.getStatus()));
            } else if (mouseEvent.getClickCount() == 2) {
                TestResultTable.TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
                if (treeNodeArray == null || treeNodeArray.length == 0) {
                    return;
                }
                Object[] objectArray = new Object[treeNodeArray.length + 1];
                System.arraycopy(treeNodeArray, 0, objectArray, 0, treeNodeArray.length);
                objectArray[objectArray.length - 1] = testResult;
                BP_FilteredOutSubpanel.this.model.showTest(testResult, objectArray);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = listSelectionEvent.getLastIndex();
            if (BP_FilteredOutSubpanel.this.mod.getRowCount() == 0 || n >= BP_FilteredOutSubpanel.this.mod.getRowCount()) {
                return;
            }
            if (n != this.lastIndex) {
                TestResult testResult = (TestResult)BP_FilteredOutSubpanel.this.mod.getValueAt(n, 0);
                BP_FilteredOutSubpanel.this.showMessage(I18NUtils.getStatusMessage(testResult.getStatus()));
                this.lastIndex = n;
            }
        }
    }

    class TableNotifier
    implements Runnable {
        TestResultTable.TreeNode node;
        TestTableModel tm;
        private TableModelEvent tme;
        private boolean isValid = true;

        TableNotifier(TestResultTable.TreeNode treeNode, TestTableModel testTableModel) {
            this.node = treeNode;
            this.tm = testTableModel;
            this.tm.isUpdateScheduled = true;
        }

        TableNotifier(TableModelEvent tableModelEvent, TestTableModel testTableModel) {
            this.tm = testTableModel;
            this.tme = tableModelEvent;
        }

        public void run() {
            this.tm.pendingEvents.remove(this);
            if (!this.isValid) {
                return;
            }
            if (this.tme == null) {
                this.tm.isUpdateScheduled = false;
                this.tm.goLive();
            } else {
                this.tm.fireTableChanged(this.tme);
            }
        }

        public void cancel() {
            this.isValid = false;
        }
    }

    private class CacheObserver
    extends TT_NodeCache.TT_NodeCacheObserver {
        CacheObserver() {
            this.interestList[6] = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testAdded(int n, TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n2) {
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                BP_FilteredOutSubpanel.this.mod.addTest(testResult, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void testRemoved(int n, TestResultTable.TreeNode[] treeNodeArray, TestResult testResult, int n2) {
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                BP_FilteredOutSubpanel.this.mod.removeTest(testResult);
            }
        }

        public void statsUpdated(int[] nArray) {
        }
    }

    private class TestTableModel
    extends AbstractTableModel {
        private String[] colNames;
        private final Object vLock = new Object();
        private Vector inQueue;
        private Vector rmQueue;
        private LinkedList liveData;
        Vector pendingEvents = new Vector();
        volatile boolean isUpdateScheduled;
        private static final int BATCH_SIZE = 100;
        private static final int COLUMN_COUNT = 2;

        TestTableModel(UIFactory uIFactory) {
            this.colNames = new String[]{uIFactory.getI18NString("br.fo.col0.txt"), uIFactory.getI18NString("br.fo.col1.txt")};
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("TableModel constructed: ");
                Debug.println("   -> " + this);
            }
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            LinkedList linkedList = this.liveData;
            synchronized (linkedList) {
                return this.liveData.size();
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n >= this.colNames.length) {
                throw new IndexOutOfBoundsException();
            }
            return this.colNames[n];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    return this.liveData.get(n);
                }
            }
            if (n2 == 1) {
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    Object e = this.liveData.get(n);
                    Object object = null;
                    if (BP_FilteredOutSubpanel.this.cache != null && object == null) {
                        object = BP_FilteredOutSubpanel.this.cache.getRejectReason((TestResult)e);
                    }
                    if (object == null) {
                        object = BP_FilteredOutSubpanel.this.uif.getI18NString("br.fo.noFi.txt");
                    }
                    return object;
                }
            }
            throw new IndexOutOfBoundsException("Index into filtered out table is out of range: " + n + ", " + n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTest(Object object, boolean bl) {
            Object object2 = this.vLock;
            synchronized (object2) {
                if (!this.inQueue.contains(object)) {
                    this.inQueue.addElement(object);
                }
            }
            if (!bl && !this.isUpdateScheduled) {
                object2 = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                this.pendingEvents.addElement(object2);
                EventQueue.invokeLater((Runnable)object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeTest(Object object) {
            Object object2 = this.vLock;
            synchronized (object2) {
                this.rmQueue.addElement(object);
                if (!this.isUpdateScheduled) {
                    TableNotifier tableNotifier = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                    this.pendingEvents.addElement(tableNotifier);
                    EventQueue.invokeLater(tableNotifier);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = this.vLock;
            synchronized (object) {
                this.init();
            }
            this.notifyDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Vector vector = this.pendingEvents;
            synchronized (vector) {
                for (int i = 0; i < this.pendingEvents.size(); ++i) {
                    TableNotifier tableNotifier = (TableNotifier)this.pendingEvents.get(i);
                    tableNotifier.cancel();
                }
            }
            this.inQueue = new Vector();
            this.rmQueue = new Vector();
            this.liveData = new LinkedList();
            this.isUpdateScheduled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void goLive() {
            int n = 0;
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("BP_TL.TLM - goLive() starting.");
            }
            BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
            synchronized (bP_FilteredOutSubpanel) {
                Object object = this.vLock;
                synchronized (object) {
                    if (this.inQueue.size() == 0 && this.rmQueue.size() == 0) {
                        if (BP_FilteredOutSubpanel.this.debug) {
                            Debug.println("BP_TT.TTM - goLive() nothing to do, returning");
                        }
                        return;
                    }
                    this.processRemoveQueue();
                    if (this.inQueue.size() != 0) {
                        int n2;
                        Serializable serializable = this.liveData;
                        synchronized (serializable) {
                            n2 = this.liveData.size();
                            if (this.inQueue.size() < 100) {
                                this.liveData.addAll(this.inQueue);
                                n = this.liveData.size() - 1;
                                this.inQueue.setSize(0);
                            } else {
                                for (int i = 0; i < 100; ++i) {
                                    this.liveData.add(this.inQueue.remove(0));
                                }
                                if (!this.isUpdateScheduled) {
                                    TableNotifier tableNotifier = new TableNotifier(BP_FilteredOutSubpanel.this.subpanelNode, this);
                                    this.pendingEvents.addElement(tableNotifier);
                                    EventQueue.invokeLater(tableNotifier);
                                }
                                n = this.liveData.size() - 1;
                            }
                        }
                        if (this.listenerList.getListenerCount() > 0) {
                            serializable = new TableModelEvent(this, n2, n, -1, 1);
                            TableNotifier tableNotifier = new TableNotifier((TableModelEvent)serializable, BP_FilteredOutSubpanel.this.mod);
                            this.pendingEvents.addElement(tableNotifier);
                            EventQueue.invokeLater(tableNotifier);
                        }
                    }
                    if (BP_FilteredOutSubpanel.this.table.getSelectedRow() == -1 && this.inQueue.size() == 0) {
                        BP_FilteredOutSubpanel.this.showMessage("");
                    }
                }
            }
            if (BP_FilteredOutSubpanel.this.debug) {
                Debug.println("BP_TL.LT - goLive() finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processRemoveQueue() {
            if (this.rmQueue.size() == 0) {
                return;
            }
            while (this.rmQueue.size() > 0) {
                TestResult testResult = (TestResult)this.rmQueue.remove(0);
                int n = this.liveData.indexOf(testResult);
                if (n == -1) continue;
                LinkedList linkedList = this.liveData;
                synchronized (linkedList) {
                    n = this.liveData.indexOf(testResult);
                    if (n == -1) {
                        continue;
                    }
                    this.liveData.remove(n);
                    this.notifyRemoved(testResult, n);
                }
            }
        }

        private void preprocessAddQueue() {
            for (int i = 0; i < this.inQueue.size(); ++i) {
                if (!this.liveData.contains(this.inQueue.elementAt(i))) continue;
                this.inQueue.remove(i);
                --i;
            }
        }

        private void notifyAdded(TestResult testResult, int n) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 1);
                if (EventQueue.isDispatchThread()) {
                    BP_FilteredOutSubpanel.this.mod.fireTableChanged(tableModelEvent);
                } else {
                    TableNotifier tableNotifier = new TableNotifier(tableModelEvent, BP_FilteredOutSubpanel.this.mod);
                    this.pendingEvents.addElement(tableNotifier);
                    EventQueue.invokeLater(tableNotifier);
                }
            }
        }

        private void notifyRemoved(TestResult testResult, int n) {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
                if (EventQueue.isDispatchThread()) {
                    BP_FilteredOutSubpanel.this.mod.fireTableChanged(tableModelEvent);
                } else {
                    TableNotifier tableNotifier = new TableNotifier(tableModelEvent, BP_FilteredOutSubpanel.this.mod);
                    this.pendingEvents.addElement(tableNotifier);
                    EventQueue.invokeLater(tableNotifier);
                }
            }
        }

        private void notifyDone() {
            if (this.listenerList.getListenerCount() > 0) {
                TableModelEvent tableModelEvent = new TableModelEvent(this);
                TableNotifier tableNotifier = new TableNotifier(tableModelEvent, BP_FilteredOutSubpanel.this.mod);
                this.pendingEvents.addElement(tableNotifier);
                EventQueue.invokeLater(tableNotifier);
            }
        }
    }

    private class TableSynchronizer
    extends Thread {
        private volatile boolean stopping;

        TableSynchronizer() {
            super("filtered-out list synchronizer");
            this.setPriority(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TT_NodeCache tT_NodeCache = BP_FilteredOutSubpanel.this.cache;
            synchronized (tT_NodeCache) {
                BP_FilteredOutSubpanel bP_FilteredOutSubpanel = BP_FilteredOutSubpanel.this;
                synchronized (bP_FilteredOutSubpanel) {
                    Vector[] vectorArray = BP_FilteredOutSubpanel.this.cache.addObserver(BP_FilteredOutSubpanel.this.cacheWatcher, true);
                    for (int i = 0; i < vectorArray[vectorArray.length - 1].size() - 1 && !this.stopping; ++i) {
                        BP_FilteredOutSubpanel.this.mod.addTest(vectorArray[vectorArray.length - 1].elementAt(i), true);
                    }
                    if (vectorArray[vectorArray.length - 1].size() > 0 && !this.stopping) {
                        BP_FilteredOutSubpanel.this.mod.addTest(vectorArray[vectorArray.length - 1].lastElement(), false);
                    }
                    BP_FilteredOutSubpanel.this.resyncThread = null;
                }
            }
            BP_FilteredOutSubpanel.this.validateEnableState();
        }

        public void halt() {
            this.stopping = true;
        }
    }
}

