/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.EditableFileList;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_ExcludeListPane
extends CE_StdPane {
    Parameters.ExcludeListParameters excludeListParameters;
    Parameters.MutableExcludeListParameters mutableExcludeListParameters;
    private JToolBar toolBar;
    private ButtonGroup btnGrp;
    private JRadioButton customBtn;
    private JRadioButton initialBtn;
    private JRadioButton latestBtn;
    private JRadioButton noneBtn;
    private JPanel body;
    private JPanel blankPanel;
    private CustomPanel customPanel;
    private InitialPanel initialPanel;
    private LatestPanel latestPanel;
    private Listener listener = new Listener();

    CE_ExcludeListPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "excl");
        this.updateConfig();
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutableExcludeListParameters == null) {
            return true;
        }
        if (this.noneBtn.isSelected()) {
            return true;
        }
        if (this.initialBtn.isSelected()) {
            return this.initialPanel.isOKToClose();
        }
        if (this.latestBtn.isSelected()) {
            return this.latestPanel.isOKToClose();
        }
        if (this.customBtn.isSelected()) {
            return this.customPanel.isOKToClose();
        }
        throw new Error();
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        this.excludeListParameters = this.config.getExcludeListParameters();
        this.mutableExcludeListParameters = this.excludeListParameters instanceof Parameters.MutableExcludeListParameters ? (Parameters.MutableExcludeListParameters)this.excludeListParameters : null;
    }

    void load() {
        this.updateConfig();
        if (this.mutableExcludeListParameters != null) {
            int n = this.mutableExcludeListParameters.getExcludeMode();
            switch (n) {
                case 1: {
                    this.noneBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.initialBtn.setSelected(true);
                    break;
                }
                case 3: {
                    this.latestBtn.setSelected(true);
                    break;
                }
                case 4: {
                    this.customBtn.setSelected(true);
                }
            }
            TestSuite testSuite = this.config.getTestSuite();
            WorkDirectory workDirectory = this.config.getWorkDirectory();
            this.noneBtn.setEnabled(true);
            File file = testSuite.getInitialExcludeList();
            this.initialBtn.setEnabled(file != null);
            this.initialPanel.load(file);
            URL uRL = testSuite.getLatestExcludeList();
            File file2 = workDirectory.getSystemFile("latest.jtx");
            this.latestBtn.setEnabled(uRL != null);
            this.latestPanel.load(uRL, file2);
            this.customBtn.setEnabled(true);
            this.customPanel.load();
            this.customPanel.setEnabled(true);
        } else {
            this.noneBtn.setEnabled(false);
            this.initialBtn.setEnabled(false);
            this.latestBtn.setEnabled(false);
            this.customBtn.setSelected(true);
            this.customBtn.setEnabled(false);
            this.customPanel.clear();
            this.customPanel.setEnabled(false);
        }
    }

    void save() {
        if (this.mutableExcludeListParameters != null) {
            int n = this.customBtn.isSelected() ? 4 : (this.initialBtn.isSelected() ? 2 : (this.latestBtn.isSelected() ? 3 : 1));
            this.mutableExcludeListParameters.setExcludeMode(n);
            this.latestPanel.save();
            this.customPanel.save();
        }
    }

    void setCheckExcludeListListener(ActionListener actionListener) {
        this.latestPanel.setCheckExcludeListListener(actionListener);
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.excludeTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.excl", new BorderLayout(), false);
        this.initToolBar();
        jPanel.add((Component)this.toolBar, "West");
        this.body = this.uif.createPanel("ce.excl.body", new CardLayout(), false);
        this.body.setBorder(BorderFactory.createEtchedBorder());
        this.blankPanel = this.uif.createPanel("ce.excl.blank");
        this.blankPanel.setName("blank");
        this.body.add((Component)this.blankPanel, this.blankPanel.getName());
        this.customPanel = new CustomPanel();
        this.body.add((Component)this.customPanel, this.customPanel.getName());
        this.initialPanel = new InitialPanel();
        this.body.add((Component)this.initialPanel, this.initialPanel.getName());
        this.latestPanel = new LatestPanel();
        this.body.add((Component)this.latestPanel, this.latestPanel.getName());
        jPanel.add((Component)this.body, "Center");
        this.addBody(jPanel);
        if (this.mutableExcludeListParameters == null) {
            this.setEnabled(false);
        }
    }

    private void initToolBar() {
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.btnGrp = new ButtonGroup();
        this.noneBtn = this.uif.createRadioButton("ce.excl.none", this.btnGrp);
        this.noneBtn.addChangeListener(this.listener);
        this.toolBar.add(this.noneBtn);
        this.initialBtn = this.uif.createRadioButton("ce.excl.initial", this.btnGrp);
        this.initialBtn.addChangeListener(this.listener);
        this.toolBar.add(this.initialBtn);
        this.latestBtn = this.uif.createRadioButton("ce.excl.latest", this.btnGrp);
        this.latestBtn.addChangeListener(this.listener);
        this.toolBar.add(this.latestBtn);
        this.customBtn = this.uif.createRadioButton("ce.excl.custom", this.btnGrp);
        this.customBtn.addChangeListener(this.listener);
        this.toolBar.add(this.customBtn);
    }

    private class LatestPanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private JTextArea urlField;
        private JTextField dateField;
        private JCheckBox autoCheck;
        private ButtonGroup btnGrp;
        private JRadioButton daysButton;
        private JTextField daysField;
        private JTextField daysLabel;
        private JRadioButton runButton;
        private JButton nowButton;
        private File latestFile;
        private ActionListener checkExcludeListListener;

        LatestPanel() {
            super(new BorderLayout());
            this.setName("latest");
            JPanel jPanel = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.head", new GridBagLayout(), false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets.right = 5;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridwidth = 0;
            JLabel jLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.latest.url", true);
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.urlField = CE_ExcludeListPane.this.uif.createTextArea("ce.excl.latest.url");
            this.urlField.setEditable(false);
            this.urlField.setLineWrap(true);
            this.urlField.setOpaque(false);
            this.urlField.setBorder(null);
            this.urlField.setMinimumSize(new Dimension(100, 10));
            this.urlField.setSize(new Dimension(2 * CE_ExcludeListPane.this.uif.getDotsPerInch(), Integer.MAX_VALUE));
            jLabel.setLabelFor(this.urlField);
            jPanel.add((Component)this.urlField, gridBagConstraints2);
            JLabel jLabel2 = CE_ExcludeListPane.this.uif.createLabel("ce.excl.latest.date", true);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            this.dateField = CE_ExcludeListPane.this.uif.createOutputField("ce.excl.latest.date", jLabel2);
            this.dateField.setBorder(null);
            jLabel2.setLabelFor(this.dateField);
            jPanel.add((Component)this.dateField, gridBagConstraints2);
            this.add((Component)jPanel, "North");
            JPanel jPanel2 = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.body", new GridBagLayout(), false);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            this.autoCheck = CE_ExcludeListPane.this.uif.createCheckBox("ce.excl.latest.auto");
            this.autoCheck.addChangeListener(this);
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridwidth = 0;
            gridBagConstraints3.anchor = 17;
            jPanel2.add((Component)this.autoCheck, gridBagConstraints3);
            this.btnGrp = new ButtonGroup();
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets.left = 17;
            this.daysButton = CE_ExcludeListPane.this.uif.createRadioButton("ce.excl.latest.everyXDays", this.btnGrp);
            this.daysButton.addChangeListener(this);
            jPanel2.add((Component)this.daysButton, gridBagConstraints3);
            this.daysField = CE_ExcludeListPane.this.uif.createInputField("ce.excl.latest.days", 3);
            this.daysField.setText("7");
            gridBagConstraints3.insets.left = 0;
            gridBagConstraints3.insets.right = 5;
            jPanel2.add((Component)this.daysField, gridBagConstraints3);
            this.daysLabel = CE_ExcludeListPane.this.uif.createHeading("ce.excl.latest.days");
            this.daysLabel.setFont(this.daysButton.getFont());
            this.daysLabel.setForeground(this.daysButton.getForeground());
            jPanel2.add((Component)this.daysLabel, gridBagConstraints3);
            this.runButton = CE_ExcludeListPane.this.uif.createRadioButton("ce.excl.latest.everyRun", this.btnGrp);
            this.runButton.addChangeListener(this);
            gridBagConstraints3.insets.left = 20;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            jPanel2.add((Component)this.runButton, gridBagConstraints3);
            this.add((Component)jPanel2, "Center");
            JPanel jPanel3 = CE_ExcludeListPane.this.uif.createPanel("ce.excl.latest.foot", new GridBagLayout(), false);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.weightx = 1.0;
            this.nowButton = CE_ExcludeListPane.this.uif.createButton("ce.excl.latest.now", this);
            jPanel3.add((Component)this.nowButton, gridBagConstraints3);
            this.add((Component)jPanel3, "South");
        }

        boolean isOKToClose() {
            Object object;
            if (this.autoCheck.isSelected() && this.daysButton.isSelected()) {
                object = this.daysField.getText();
                if (object == null || ((String)object).length() == 0) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.latest.noDays");
                    return false;
                }
                try {
                    int n = Integer.parseInt((String)object);
                    if (n <= 0) {
                        CE_ExcludeListPane.this.uif.showError("ce.excl.latest.badDays");
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.latest.badDays");
                    return false;
                }
            }
            if (!((File)(object = CE_ExcludeListPane.this.config.getWorkDirectory().getSystemFile("latest.jtx"))).exists() && !this.autoCheck.isSelected()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.latest.noFile");
                return false;
            }
            return true;
        }

        void load(URL uRL, File file) {
            if (uRL == null) {
                this.urlField.setText("");
            } else {
                this.urlField.setText(uRL.toString());
            }
            this.latestFile = file;
            this.updateDateField();
            boolean bl = CE_ExcludeListPane.this.mutableExcludeListParameters.isLatestExcludeAutoCheckEnabled();
            this.autoCheck.setSelected(bl);
            int n = CE_ExcludeListPane.this.mutableExcludeListParameters.getLatestExcludeAutoCheckMode();
            if (n == 1) {
                this.daysButton.setSelected(true);
            } else {
                this.runButton.setSelected(true);
            }
            int n2 = CE_ExcludeListPane.this.mutableExcludeListParameters.getLatestExcludeAutoCheckInterval();
            if (n2 < 0) {
                this.daysField.setText("");
            } else {
                this.daysField.setText(String.valueOf(n2));
            }
        }

        void save() {
            boolean bl = this.autoCheck.isSelected();
            CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckEnabled(bl);
            int n = this.daysButton.isSelected() ? 1 : 2;
            CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckMode(n);
            try {
                String string = this.daysField.getText();
                if (string.length() > 0) {
                    int n2 = Integer.parseInt(string);
                    CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(n2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                CE_ExcludeListPane.this.mutableExcludeListParameters.setLatestExcludeAutoCheckInterval(Integer.MIN_VALUE);
            }
        }

        void setCheckExcludeListListener(ActionListener actionListener) {
            this.checkExcludeListListener = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.checkExcludeListListener != null) {
                this.checkExcludeListListener.actionPerformed(actionEvent);
                this.updateDateField();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = this.autoCheck.isSelected();
            this.daysButton.setEnabled(bl);
            this.daysField.setEnabled(bl && this.daysButton.isSelected());
            this.daysLabel.setEnabled(bl);
            this.runButton.setEnabled(bl);
        }

        private void updateDateField() {
            long l = this.latestFile.lastModified();
            if (l <= 0L) {
                this.dateField.setText(CE_ExcludeListPane.this.uif.getI18NString("ce.excl.latest.dateNotAvailable"));
            } else {
                DateFormat dateFormat = DateFormat.getDateTimeInstance();
                this.dateField.setText(dateFormat.format(new Date(l)));
            }
        }
    }

    private class InitialPanel
    extends JPanel {
        private JTextArea fileArea;
        private File initialFile;

        InitialPanel() {
            super(new GridBagLayout());
            this.setName("initial");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.initial.file", true);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets.top = 20;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            this.fileArea = CE_ExcludeListPane.this.uif.createTextArea("ce.excl.initial.file");
            this.fileArea.setMinimumSize(new Dimension(100, 10));
            this.fileArea.setEditable(false);
            this.fileArea.setOpaque(false);
            this.fileArea.setLineWrap(true);
            this.fileArea.setBorder(null);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            jLabel.setLabelFor(this.fileArea);
            this.add((Component)this.fileArea, gridBagConstraints);
        }

        boolean isOKToClose() {
            if (this.initialFile == null) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.noFile");
                return false;
            }
            if (!this.initialFile.exists()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.cantFindFile", this.initialFile);
                return false;
            }
            if (!this.initialFile.isFile() || !this.initialFile.canRead()) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.initial.cantReadFile", this.initialFile);
                return false;
            }
            return true;
        }

        void load(File file) {
            this.initialFile = file;
            if (file == null) {
                this.fileArea.setText("");
            } else {
                this.fileArea.setText(file.getPath());
            }
        }
    }

    private class CustomPanel
    extends JPanel {
        private EditableFileList filesField;

        CustomPanel() {
            super(new GridBagLayout());
            this.setName("custom");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = CE_ExcludeListPane.this.uif.createLabel("ce.excl.custom.files", true);
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.left = 5;
            this.add((Component)jLabel, gridBagConstraints);
            FileChooser fileChooser = new FileChooser(true);
            fileChooser.addChoosableExtension(".jtx", CE_ExcludeListPane.this.uif.getI18NString("ce.excl.jtxfiles"));
            this.filesField = new EditableFileList(fileChooser);
            this.filesField.setDuplicatesAllowed(false);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jLabel.setLabelFor(this.filesField);
            this.add((Component)this.filesField, gridBagConstraints);
        }

        public void setEnabled(boolean bl) {
            this.filesField.setEnabled(bl);
        }

        void clear() {
            this.filesField.clear();
        }

        boolean isOKToClose() {
            File file = CE_ExcludeListPane.this.config.getTestSuite().getRoot();
            File[] fileArray = this.filesField.getFiles();
            if (fileArray.length == 0) {
                CE_ExcludeListPane.this.uif.showError("ce.excl.custom.noFiles");
                return false;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2;
                File file3 = fileArray[i];
                File file4 = file2 = file3.isAbsolute() ? file3 : new File(file, file3.getPath());
                if (!file2.exists()) {
                    CE_ExcludeListPane.this.uif.showError("ce.excl.custom.cantFindFile", file3);
                    return false;
                }
                if (file2.isFile() && file2.canRead()) continue;
                CE_ExcludeListPane.this.uif.showError("ce.excl.custom.badFile", file3);
                return false;
            }
            return true;
        }

        void load() {
            File[] fileArray = CE_ExcludeListPane.this.mutableExcludeListParameters.getCustomExcludeFiles();
            this.filesField.setFiles(fileArray);
        }

        void save() {
            File[] fileArray = this.filesField.getFiles();
            CE_ExcludeListPane.this.mutableExcludeListParameters.setCustomExcludeFiles(fileArray);
        }
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JPanel jPanel = CE_ExcludeListPane.this.customBtn.isSelected() ? CE_ExcludeListPane.this.customPanel : (CE_ExcludeListPane.this.initialBtn.isSelected() ? CE_ExcludeListPane.this.initialPanel : (CE_ExcludeListPane.this.latestBtn.isSelected() ? CE_ExcludeListPane.this.latestPanel : CE_ExcludeListPane.this.blankPanel));
            ((CardLayout)CE_ExcludeListPane.this.body.getLayout()).show(CE_ExcludeListPane.this.body, jPanel.getName());
        }
    }
}

