/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CE_PriorStatusPane
extends CE_StdPane {
    private Parameters.PriorStatusParameters priorStatusParameters;
    private Parameters.MutablePriorStatusParameters mutablePriorStatusParameters;
    private JCheckBox selectCheck;
    private JCheckBox[] statusChecks = new JCheckBox[4];
    private static final String ANY_OF = "anyOf";
    private static final String ALL = "all";

    CE_PriorStatusPane(UIFactory uIFactory, InterviewParameters interviewParameters) {
        super(uIFactory, interviewParameters, "status");
        this.updateConfig();
        this.initGUI();
    }

    boolean isOKToClose() {
        if (this.mutablePriorStatusParameters == null) {
            return true;
        }
        if (this.selectCheck.isSelected() && !this.isAnyStatusCheckSelected()) {
            this.uif.showError("ce.status.noneSelected");
            return false;
        }
        return true;
    }

    void updateConfig() {
        if (this.config == null) {
            return;
        }
        this.priorStatusParameters = this.config.getPriorStatusParameters();
        this.mutablePriorStatusParameters = this.priorStatusParameters instanceof Parameters.MutablePriorStatusParameters ? (Parameters.MutablePriorStatusParameters)this.priorStatusParameters : null;
    }

    void load() {
        this.updateConfig();
        if (this.mutablePriorStatusParameters != null) {
            int n = this.mutablePriorStatusParameters.getPriorStatusMode();
            this.selectCheck.setSelected(n == 2);
            this.selectCheck.setEnabled(true);
            boolean[] blArray = this.mutablePriorStatusParameters.getMatchPriorStatusValues();
            for (int i = 0; i < this.statusChecks.length; ++i) {
                this.statusChecks[i].setSelected(blArray[i]);
            }
        } else {
            boolean[] blArray = this.priorStatusParameters.getPriorStatusValues();
            if (blArray == null) {
                this.selectCheck.setSelected(false);
                for (int i = 0; i < this.statusChecks.length; ++i) {
                    this.statusChecks[i].setSelected(false);
                }
            } else {
                this.selectCheck.setSelected(true);
                for (int i = 0; i < this.statusChecks.length; ++i) {
                    this.statusChecks[i].setSelected(blArray[i]);
                }
            }
            this.mutablePriorStatusParameters = null;
            this.selectCheck.setEnabled(false);
        }
        this.enableStatusFields();
    }

    void save() {
        if (this.mutablePriorStatusParameters != null) {
            int n = this.selectCheck.isSelected() ? 2 : 1;
            this.mutablePriorStatusParameters.setPriorStatusMode(n);
            boolean[] blArray = new boolean[4];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = this.statusChecks[i].isSelected();
            }
            this.mutablePriorStatusParameters.setMatchPriorStatusValues(blArray);
        }
    }

    private void initGUI() {
        CSH.setHelpIDString(this, "confEdit.statusTab.csh");
        JPanel jPanel = this.uif.createPanel("ce.status", new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.selectCheck = this.uif.createCheckBox("ce.status.select");
        this.selectCheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CE_PriorStatusPane.this.enableStatusFields();
            }
        });
        jPanel.add((Component)this.selectCheck, gridBagConstraints);
        JLabel jLabel = this.uif.createLabel("ce.status.anyOf", true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 17;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = this.uif.createPanel("ce.status.body", new GridBagLayout(), false);
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets.left = 10;
        this.statusChecks[0] = this.uif.createCheckBox("ce.status.prev.passed", false);
        jPanel2.add((Component)this.statusChecks[0], gridBagConstraints2);
        this.statusChecks[1] = this.uif.createCheckBox("ce.status.prev.failed", true);
        jPanel2.add((Component)this.statusChecks[1], gridBagConstraints2);
        this.statusChecks[2] = this.uif.createCheckBox("ce.status.prev.error", true);
        jPanel2.add((Component)this.statusChecks[2], gridBagConstraints2);
        gridBagConstraints2.insets.right = 10;
        this.statusChecks[3] = this.uif.createCheckBox("ce.status.prev.notRun", true);
        jPanel2.add((Component)this.statusChecks[3], gridBagConstraints2);
        this.uif.setToolTip(jPanel2, "ce.status.prev");
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 0;
        jLabel.setLabelFor(jPanel2);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addBody(jPanel);
    }

    private boolean isAnyStatusCheckSelected() {
        for (int i = 0; i < this.statusChecks.length; ++i) {
            if (!this.statusChecks[i].isSelected()) continue;
            return true;
        }
        return false;
    }

    private void enableStatusFields() {
        boolean bl = this.selectCheck.isEnabled() && this.selectCheck.isSelected();
        for (int i = 0; i < this.statusChecks.length; ++i) {
            this.statusChecks[i].setEnabled(bl);
        }
    }
}

