/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.CE_FullView;
import com.sun.javatest.exec.CE_StdView;
import com.sun.javatest.exec.CE_TemplateDialog;
import com.sun.javatest.exec.CE_View;
import com.sun.javatest.exec.DetailsBrowser;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.help.BadIDException;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class ConfigEditor
extends ToolDialog {
    public static final int DEFAULT_MODE = 0;
    public static final int FULL_MODE = 1;
    public static final int STD_MODE = 2;
    public static final int STD_TESTS_MODE = 3;
    public static final int STD_EXCLUDE_LIST_MODE = 4;
    public static final int STD_KEYWORDS_MODE = 5;
    public static final int STD_PRIOR_STATUS_MODE = 6;
    public static final int STD_ENVIRONMENT_MODE = 7;
    public static final int STD_CONCURRENCY_MODE = 8;
    public static final int STD_TIMEOUT_FACTOR_MODE = 9;
    private boolean runPending;
    private InterviewParameters mainConfig;
    private InterviewParameters viewConfig;
    private FileHistory history;
    private boolean saveRequired;
    private JMenu markerMenu;
    private JMenu searchMenu;
    private JMenu viewMenu;
    private JRadioButtonMenuItem viewFullBtn;
    private JRadioButtonMenuItem viewStdBtn;
    private JCheckBoxMenuItem viewInfoCheckBox;
    private JCheckBoxMenuItem viewTagCheckBox;
    private JMenuItem viewRefreshItem;
    private JComponent body;
    private JPanel views;
    private JHelpContentViewer infoPanel;
    private CE_FullView fullView;
    private CE_StdView stdView;
    private CE_View currView;
    private Listener listener;
    private CE_TemplateDialog templateDialog;
    private FileChooser fileChooser;
    private ActionListener closeListener;
    private DetailsBrowser detailsBrowser;
    private static final KeyStroke detailsKey = KeyStroke.getKeyStroke("shift alt D");
    private static final String NEW = "new";
    private static final String LOAD = "load";
    private static final String SAVE = "save";
    private static final String SAVE_AS = "saveAs";
    private static final String SAVE_AS_TEMPLATE = "saveAsTemplate";
    private static final String REVERT = "revert";
    private static final String DONE = "done";
    private static final String REFRESH = "refresh";
    private static final String DETAILS = "details";
    static final String CLOSE = "close";
    static final String MORE_INFO_PREF = "exec.config.moreInfo";
    static final String VIEW_PREF = "exec.config.view";

    ConfigEditor(JComponent jComponent, InterviewParameters interviewParameters, UIFactory uIFactory) {
        super(jComponent, uIFactory, "ce");
        this.history = FileHistory.getFileHistory(interviewParameters.getWorkDirectory(), "configHistory.jtl");
        this.mainConfig = interviewParameters;
        try {
            this.viewConfig = interviewParameters.getTestSuite().createInterview();
            this.viewConfig.setWorkDirectory(this.mainConfig.getWorkDirectory());
            this.copy(this.mainConfig, this.viewConfig);
        }
        catch (Interview.Fault fault) {
        }
        catch (TestSuite.Fault fault) {
            // empty catch block
        }
        this.fileChooser = new FileChooser(true);
        this.fileChooser.addChoosableExtension(".jti", uIFactory.getI18NString("ce.jtiFiles"));
    }

    public void clear() {
        if (this.stdView == null) {
            this.initGUI();
        }
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        if (this.viewConfig.isEdited()) {
            if (!ConfigEditor.equal(this.mainConfig, this.viewConfig)) {
                int n = this.uif.showYesNoCancelDialog("ce.clear.warn");
                switch (n) {
                    case 0: {
                        if (this.save0()) break;
                        return;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.viewConfig.clear();
            this.viewConfig.setEdited(false);
        }
        this.updateTitle();
        this.setView(this.fullView);
        this.setVisible(true);
    }

    public void load() {
        this.load0(null);
    }

    public void load(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.load0(file);
    }

    private void load0(File file) {
        if (this.isEdited()) {
            int n = this.uif.showYesNoCancelDialog("ce.load.warn");
            switch (n) {
                case 0: {
                    if (this.save0()) break;
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (file == null) {
            String string;
            File file2 = this.mainConfig.getFile();
            if (file2 != null) {
                this.fileChooser.setCurrentDirectory(file2.getParentFile());
            }
            this.fileChooser.setDialogTitle(this.uif.getI18NString("ce.load.title"));
            int n = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("ce.load.btn"));
            if (n != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile();
            if (file != null && !(string = file.getPath()).endsWith(".jti")) {
                file = new File(string + ".jti");
            }
        }
        try {
            this.mainConfig.load(file);
            this.copy(this.mainConfig, this.viewConfig);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.history.add(file);
            this.updateTitle();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.uif.showError("ce.load.cantFindFile", file);
        }
        catch (IOException iOException) {
            this.uif.showError("ce.load.error", new Object[]{file, iOException});
        }
        catch (Interview.Fault fault) {
            this.uif.showError("ce.load.error", new Object[]{file, fault.getMessage()});
        }
    }

    public void save() {
        this.save0();
    }

    private boolean save0() {
        return this.save0(this.viewConfig.getFile());
    }

    public void saveAs() {
        this.save0(null);
    }

    private boolean save0(File file) {
        File file2;
        File file3;
        if (file == null && (file = this.getSaveFile(file3 = (file2 = this.mainConfig.getFile()) == null ? null : file2.getParentFile())) == null) {
            return false;
        }
        try {
            if (this.currView != null) {
                this.currView.save();
                this.copy(this.viewConfig, this.mainConfig, false);
            }
            this.mainConfig.save(file);
            this.viewConfig.setFile(file);
            this.history.add(file);
            this.updateTitle();
            return true;
        }
        catch (IOException iOException) {
            if (!file.canWrite()) {
                this.uif.showError("ce.save.cantWriteFile", file);
            } else if (iOException instanceof FileNotFoundException) {
                this.uif.showError("ce.save.cantFindFile", file);
            } else {
                this.uif.showError("ce.save.error", new Object[]{file, iOException});
            }
        }
        catch (Interview.Fault fault) {
            this.uif.showError("ce.save.error", new Object[]{file, fault.getMessage()});
        }
        return false;
    }

    private File getSaveFile(File file) {
        this.fileChooser.setDialogTitle(this.uif.getI18NString("ce.save.title"));
        if (file != null) {
            this.fileChooser.setCurrentDirectory(file);
        }
        File file2 = null;
        while (file2 == null) {
            String string;
            int n = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("ce.save.btn"));
            if (n != 0) {
                return null;
            }
            file2 = this.fileChooser.getSelectedFile();
            if (file2 == null) continue;
            if (file2.isDirectory()) {
                this.uif.showError("ce.save.fileIsDir", file2);
                file2 = null;
                continue;
            }
            File file3 = file2.getParentFile();
            if (file3 != null) {
                if (file3.exists() && !file3.isDirectory()) {
                    this.uif.showError("ce.save.parentNotADir", file3);
                    file2 = null;
                    continue;
                }
                if (!file3.exists()) {
                    n = this.uif.showYesNoDialog("ce.save.createParentDir", file3);
                    if (n == 0) {
                        if (!file3.mkdirs()) {
                            this.uif.showError("ce.save.cantCreateParentDir", file3);
                            file2 = null;
                            continue;
                        }
                    } else {
                        file2 = null;
                        continue;
                    }
                }
            }
            if (!file2.exists() && !(string = file2.getPath()).endsWith(".jti")) {
                file2 = new File(string + ".jti");
            }
            if (!file2.exists()) continue;
            n = this.uif.showYesNoDialog("ce.save.warn");
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.fileChooser.setSelectedFile(null);
                    file2 = null;
                    break;
                }
            }
        }
        return file2;
    }

    public void saveAsTemplate() {
        if (this.templateDialog == null) {
            this.templateDialog = new CE_TemplateDialog(this.getTool(), this.viewConfig, this.uif);
        }
        if (this.currView != null) {
            this.currView.save();
        }
        this.templateDialog.setVisible(true);
    }

    public void revert() {
        if (!this.isEdited()) {
            return;
        }
        int n = this.uif.showOKCancelDialog("ce.revert.warn");
        if (n != 0) {
            return;
        }
        try {
            this.copy(this.mainConfig, this.viewConfig);
            if (this.currView != null && this.currView.isShowing()) {
                this.currView.load();
            }
            this.updateTitle();
        }
        catch (Interview.Fault fault) {
            this.uif.showError("ce.revert", fault.getMessage());
        }
    }

    public void setRunPending(boolean bl) {
        this.runPending = bl;
    }

    public boolean isRunPending() {
        return this.runPending;
    }

    public void show() {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.show(0);
    }

    public void show(int n) {
        if (this.stdView == null) {
            this.initGUI();
        }
        switch (n) {
            case 0: {
                this.show(this.currView == null ? this.getDefaultView() : this.currView);
                break;
            }
            case 1: {
                this.show(this.fullView);
                break;
            }
            case 2: {
                this.show(this.stdView);
                break;
            }
            case 3: {
                this.stdView.showTab(0);
                this.show(this.stdView);
                break;
            }
            case 4: {
                this.stdView.showTab(1);
                this.show(this.stdView);
                break;
            }
            case 5: {
                this.stdView.showTab(2);
                this.show(this.stdView);
                break;
            }
            case 6: {
                this.stdView.showTab(3);
                this.show(this.stdView);
                break;
            }
            case 7: {
                this.stdView.showTab(4);
                this.show(this.stdView);
                break;
            }
            case 8: {
                this.stdView.showTab(6);
                this.show(this.stdView);
                break;
            }
            case 9: {
                this.stdView.showTab(7);
                this.show(this.stdView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void show(ActionListener actionListener) {
        this.closeListener = actionListener;
        this.show();
    }

    public void show(int n, ActionListener actionListener) {
        this.closeListener = actionListener;
        this.show(n);
    }

    private void show(CE_View cE_View) {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        } else {
            try {
                this.copy(this.mainConfig, this.viewConfig);
            }
            catch (Interview.Fault fault) {
                this.uif.showError("ce.show.error", fault.getMessage());
            }
        }
        this.setView(cE_View);
        this.setVisible(true);
    }

    private void setView(CE_View cE_View) {
        if (cE_View == null) {
            throw new NullPointerException();
        }
        if (this.currView != cE_View) {
            Container container;
            FocusTraversalPolicy focusTraversalPolicy;
            Component component;
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component2 = keyboardFocusManager.getPermanentFocusOwner();
            boolean bl = component2 != null && this.currView != null && this.currView.isAncestorOf(component2);
            this.currView = cE_View;
            this.currView.load();
            ((CardLayout)this.views.getLayout()).show(this.views, this.currView.getName());
            if (bl && (component = (focusTraversalPolicy = (container = this.currView.isFocusCycleRoot() ? this.currView : this.currView.getFocusCycleRootAncestor()).getFocusTraversalPolicy()).getDefaultComponent(container)) != null) {
                component.requestFocusInWindow();
            }
            boolean bl2 = this.currView == this.fullView;
            this.markerMenu.setEnabled(bl2);
            this.searchMenu.setEnabled(bl2);
            (bl2 ? this.viewFullBtn : this.viewStdBtn).setSelected(true);
            this.viewTagCheckBox.setEnabled(bl2);
            if (this.detailsBrowser != null) {
                this.detailsBrowser.setQuestionInfoEnabled(bl2);
            }
            this.updateTitle();
        }
    }

    public void close() {
        if (this.currView != null && !this.currView.isOKToClose()) {
            return;
        }
        this.close(true);
    }

    private void close(boolean bl) {
        if (this.currView == null) {
            return;
        }
        if (!this.isShowing()) {
            return;
        }
        if (bl && this.isEdited()) {
            int n = this.uif.showYesNoCancelDialog("ce.close.warn");
            switch (n) {
                case 0: {
                    if (this.save0()) break;
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.setVisible(false);
        if (this.closeListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, CLOSE);
            this.closeListener.actionPerformed(actionEvent);
            this.closeListener = null;
        }
    }

    void setCheckExcludeListListener(ActionListener actionListener) {
        if (this.stdView == null) {
            this.initGUI();
        }
        this.stdView.setCheckExcludeListListener(actionListener);
    }

    boolean isCurrentQuestionChanged() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        Question question = this.mainConfig.getCurrentQuestion();
        Question question2 = this.viewConfig.getCurrentQuestion();
        return !ConfigEditor.equal(question.getTag(), question2.getTag());
    }

    boolean isEdited() {
        if (this.currView != null && this.currView.isShowing()) {
            this.currView.save();
        }
        return !ConfigEditor.equal(this.mainConfig, this.viewConfig);
    }

    private static boolean equal(InterviewParameters interviewParameters, InterviewParameters interviewParameters2) {
        if (interviewParameters.getMarkersEnabled() != interviewParameters2.getMarkersEnabled() || interviewParameters.getMarkersFilterEnabled() != interviewParameters2.getMarkersFilterEnabled()) {
            return false;
        }
        Map map = interviewParameters.getAllQuestions();
        Map map2 = interviewParameters2.getAllQuestions();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(map.keySet());
        treeSet.addAll(map2.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Question question = (Question)map.get(string);
            Question question2 = (Question)map2.get(string);
            if (question != null && question2 != null && question.equals(question2)) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(String string, String string2) {
        return string == null || string2 == null ? string == string2 : string.equals(string2);
    }

    protected void initGUI() {
        this.setHelp("confEdit.window.csh");
        this.listener = new Listener();
        this.updateTitle();
        if (this.viewConfig.getHelpSet() != null) {
            this.infoPanel = new JHelpContentViewer(this.viewConfig.getHelpSet());
            this.infoPanel.setName("info");
            int n = this.uif.getDotsPerInch();
            this.infoPanel.setPreferredSize(new Dimension(4 * n, 3 * n));
            this.infoPanel.putClientProperty("helpBrokerForHelpLink", this.uif.getHelpBroker());
        }
        this.fullView = new CE_FullView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        this.stdView = new CE_StdView(this.viewConfig, this.infoPanel, this.uif, this.listener);
        this.initMenuBar();
        this.views = this.uif.createPanel("ce.views", new CardLayout(), false);
        this.views.add((Component)this.fullView, this.fullView.getName());
        this.views.add((Component)this.stdView, this.stdView.getName());
        if (this.infoPanel == null) {
            this.viewInfoCheckBox.setEnabled(false);
            this.viewInfoCheckBox.setSelected(false);
        } else {
            Preferences preferences = Preferences.access();
            boolean bl = preferences.getPreference(MORE_INFO_PREF, "true").equals("true");
            this.viewInfoCheckBox.setEnabled(true);
            this.viewInfoCheckBox.setSelected(bl);
        }
        if (this.viewInfoCheckBox.isSelected()) {
            this.views.setBorder(null);
            JSplitPane jSplitPane = this.uif.createSplitPane(1, this.views, this.infoPanel);
            jSplitPane.setDividerLocation(this.views.getPreferredSize().width - 1);
            this.body = jSplitPane;
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.views.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        if (this.infoPanel != null) {
            this.infoPanel.registerKeyboardAction(this.listener, DETAILS, detailsKey, 1);
        }
        this.setBody(this.body);
        this.setComponentListener(this.listener);
    }

    private void initMenuBar() {
        JMenuBar jMenuBar = this.uif.createMenuBar("ce.menub");
        String[] stringArray = new String[]{NEW, LOAD, SAVE, SAVE_AS, SAVE_AS_TEMPLATE, REVERT, null, null, CLOSE};
        int n = stringArray.length - 2;
        JMenu jMenu = this.uif.createMenu("ce.file", stringArray, this.listener);
        FileHistory fileHistory = FileHistory.getFileHistory(this.viewConfig.getWorkDirectory(), "configHistory.jtl");
        FileHistory.Listener listener = new FileHistory.Listener(fileHistory, n, this.listener);
        jMenu.addMenuListener(listener);
        jMenuBar.add(jMenu);
        this.markerMenu = this.fullView.getMarkerMenu();
        jMenuBar.add(this.markerMenu);
        this.searchMenu = this.fullView.getSearchMenu();
        jMenuBar.add(this.searchMenu);
        this.viewMenu = this.uif.createMenu("ce.view");
        this.viewMenu.addMenuListener(this.listener);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.viewFullBtn = this.uif.createRadioButtonMenuItem("ce.view", "full");
        this.viewFullBtn.setSelected(true);
        this.viewFullBtn.setActionCommand("full");
        this.viewFullBtn.addActionListener(this.listener);
        buttonGroup.add(this.viewFullBtn);
        this.viewMenu.add(this.viewFullBtn);
        this.viewStdBtn = this.uif.createRadioButtonMenuItem("ce.view", "std");
        this.viewStdBtn.setActionCommand("std");
        this.viewStdBtn.addActionListener(this.listener);
        buttonGroup.add(this.viewStdBtn);
        this.viewMenu.add(this.viewStdBtn);
        this.viewMenu.addSeparator();
        this.viewInfoCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "info", false);
        this.viewInfoCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewInfoCheckBox);
        this.viewTagCheckBox = this.uif.createCheckBoxMenuItem("ce.view", "tag", false);
        this.viewTagCheckBox.setAccelerator(KeyStroke.getKeyStroke("alt T"));
        this.viewTagCheckBox.addChangeListener(this.listener);
        this.viewMenu.add(this.viewTagCheckBox);
        this.viewMenu.addSeparator();
        this.viewRefreshItem = this.uif.createMenuItem("ce.view", REFRESH, this.listener);
        this.viewRefreshItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.viewMenu.add(this.viewRefreshItem);
        jMenuBar.add(this.viewMenu);
        jMenuBar.add(this.uif.createHorizontalGlue("ce.pad"));
        JMenu jMenu2 = this.uif.createMenu("ce.help");
        JMenuItem jMenuItem = this.uif.createHelpMenuItem("ce.help.main", "confEdit.window.csh");
        jMenu2.add(jMenuItem);
        JMenuItem jMenuItem2 = this.uif.createHelpMenuItem("ce.help.full", "confEdit.fullView.csh");
        jMenu2.add(jMenuItem2);
        JMenuItem jMenuItem3 = this.uif.createHelpMenuItem("ce.help.std", "confEdit.stdView.csh");
        jMenu2.add(jMenuItem3);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
    }

    private void updateTitle() {
        File file = this.viewConfig.getFile();
        this.setI18NTitle("ce.title", new Object[]{new Integer(this.currView == this.fullView ? 0 : 1), new Integer(file == null ? 0 : 1), file});
    }

    private boolean isInfoVisible() {
        return this.body instanceof JSplitPane;
    }

    private void setInfoVisible(boolean bl) {
        Serializable serializable;
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (bl == this.isInfoVisible()) {
            return;
        }
        Dimension dimension = this.views.getSize();
        if (dimension.width == 0) {
            dimension = this.views.getPreferredSize();
        }
        Dimension dimension2 = this.infoPanel.getSize();
        if (dimension2.width == 0) {
            dimension2 = this.infoPanel.getPreferredSize();
        }
        if (bl) {
            this.views.setBorder(null);
            serializable = this.uif.createSplitPane(1, this.views, this.infoPanel);
            serializable.setDividerLocation(dimension.width - 1);
            this.body = serializable;
            this.showInfoForQuestion(this.viewConfig.getCurrentQuestion());
        } else {
            this.views.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.body = this.views;
        }
        this.setBody(this.body);
        if (this.isShowing()) {
            serializable = this.getSize();
            int n = new JSplitPane().getDividerSize();
            int n2 = ((Dimension)serializable).width;
            this.setSize(n2 += (bl ? 1 : -1) * (dimension2.width + n), ((Dimension)serializable).height);
        }
    }

    private void showInfoForQuestion(Question question) {
        try {
            Map.ID iD = question.getHelpID();
            if (iD == null) {
                System.err.println("WARNING: no help for " + question.getKey());
            } else {
                this.infoPanel.setCurrentID(iD);
            }
        }
        catch (BadIDException badIDException) {
            System.err.println("WARNING: no help for " + question.getKey());
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            JavaTestError.unexpectedException(invalidHelpSetContextException);
        }
    }

    private CE_View getDefaultView() {
        Preferences preferences = Preferences.access();
        String string = preferences.getPreference(VIEW_PREF, "full");
        if (string.equals("std")) {
            return this.stdView;
        }
        return this.fullView;
    }

    private void perform(String string) {
        if (string.equals(NEW)) {
            this.clear();
        } else if (string.equals(LOAD)) {
            this.load();
        } else if (string.equals(SAVE)) {
            this.save();
        } else if (string.equals(SAVE_AS)) {
            this.saveAs();
        } else if (string.equals(SAVE_AS_TEMPLATE)) {
            this.saveAsTemplate();
        } else if (string.equals(REVERT)) {
            this.revert();
        } else if (string.equals("full")) {
            this.show(this.fullView);
        } else if (string.equals("std")) {
            this.show(this.stdView);
        } else if (string.equals(CLOSE)) {
            this.close();
        } else if (string.equals(DONE)) {
            Integer n;
            int n2;
            if (this.currView != null && !this.currView.isOKToClose()) {
                return;
            }
            this.currView.save();
            if (!this.viewConfig.isFinishable() && (n2 = this.uif.showOKCancelDialog("ce.okToClose", n = new Integer(this.runPending ? 1 : 0))) != 0) {
                return;
            }
            if (this.isEdited() || this.isCurrentQuestionChanged()) {
                this.saveRequired = true;
            }
            if (this.saveRequired) {
                if (!this.save0()) {
                    return;
                }
                this.saveRequired = false;
            }
            this.close(false);
        } else if (string.equals(REFRESH)) {
            if (this.currView != null) {
                this.currView.refresh();
            }
        } else if (string.equals(DETAILS)) {
            if (this.detailsBrowser == null) {
                this.detailsBrowser = new DetailsBrowser(this.body, this.viewConfig, this.infoPanel);
                this.detailsBrowser.setQuestionInfoEnabled(this.currView == this.fullView);
            }
            this.detailsBrowser.setVisible(true);
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    private void copy(InterviewParameters interviewParameters, InterviewParameters interviewParameters2) throws Interview.Fault {
        this.copy(interviewParameters, interviewParameters2, true);
    }

    private void copy(InterviewParameters interviewParameters, InterviewParameters interviewParameters2, boolean bl) throws Interview.Fault {
        HashMap hashMap = new HashMap();
        interviewParameters.save(hashMap);
        interviewParameters2.load(hashMap, false);
        if (bl) {
            interviewParameters2.setFile(interviewParameters.getFile());
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    ChangeListener,
    MenuListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem;
            File file;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (file = (File)(jMenuItem = (JMenuItem)object).getClientProperty(FileHistory.FILE)) != null) {
                ConfigEditor.this.load(file);
                return;
            }
            ConfigEditor.this.perform(actionEvent.getActionCommand());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == ConfigEditor.this.viewInfoCheckBox && ConfigEditor.this.infoPanel != null) {
                ConfigEditor.this.setInfoVisible(ConfigEditor.this.viewInfoCheckBox.isSelected());
            } else if (object == ConfigEditor.this.viewTagCheckBox) {
                ConfigEditor.this.fullView.setTagVisible(ConfigEditor.this.viewTagCheckBox.isSelected());
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            Object object = menuEvent.getSource();
            if (object == ConfigEditor.this.viewMenu) {
                ConfigEditor.this.viewTagCheckBox.setSelected(ConfigEditor.this.fullView.isTagVisible());
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            ConfigEditor.this.close();
        }
    }
}

