/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.ExcludeListUpdateHandler;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ChecklistBrowser;
import com.sun.javatest.exec.ConfigEditor;
import com.sun.javatest.exec.EnvironmentBrowser;
import com.sun.javatest.exec.ExcludeListBrowser;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.QuestionLogBrowser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class ConfigHandler {
    private static KeyStroke configEditorAccelerator = KeyStroke.getKeyStroke(69, 2);
    private JComponent parent;
    private UIFactory uif;
    private ExecModel model;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters interviewParams;
    private Interview.Observer observer;
    private JMenu changeMenu;
    private Action loadConfigAction;
    private Action newConfigAction;
    private Action showConfigAction;
    private Action showFullConfigAction;
    private Action showStdConfigAction;
    private Action showEnvironmentAction;
    private Action showExcludeListAction;
    private Action showChecklistAction;
    private Action showQuestionLogAction;
    private ConfigEditor configEditor;
    private FileHistory.Listener configHistoryListener;
    private ChecklistBrowser checkListBrowser;
    private EnvironmentBrowser environmentBrowser;
    private ExcludeListBrowser excludeListBrowser;
    private QuestionLogBrowser questionLogBrowser;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutableTestsParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutableExcludeListParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutableKeywordsParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutablePriorStatusParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$LegacyEnvParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutableConcurrencyParameters;
    static /* synthetic */ Class class$com$sun$javatest$Parameters$MutableTimeoutFactorParameters;

    ConfigHandler(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        this.parent = jComponent;
        this.model = execModel;
        this.uif = uIFactory;
        this.initActions();
    }

    void addConfigEditorAccelerator(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(1);
        inputMap.put(configEditorAccelerator, "showFullConfigEditor");
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put("showFullConfigEditor", this.showFullConfigAction);
    }

    void dispose() {
        if (this.configEditor != null) {
            this.configEditor.dispose();
        }
        if (this.checkListBrowser != null) {
            this.checkListBrowser.dispose();
        }
        if (this.environmentBrowser != null) {
            this.environmentBrowser.dispose();
        }
        if (this.excludeListBrowser != null) {
            this.excludeListBrowser.dispose();
        }
        if (this.questionLogBrowser != null) {
            this.questionLogBrowser.dispose();
        }
    }

    JMenu getMenu() {
        this.changeMenu = new ChangeConfigMenu();
        JMenu jMenu = this.uif.createMenu("ch");
        jMenu.add(this.uif.createMenuItem(this.newConfigAction));
        jMenu.add(this.uif.createMenuItem(this.loadConfigAction));
        jMenu.add(this.changeMenu);
        jMenu.addSeparator();
        jMenu.add(this.uif.createMenuItem(this.showChecklistAction));
        jMenu.add(this.uif.createMenuItem(this.showExcludeListAction));
        jMenu.add(this.uif.createMenuItem(this.showEnvironmentAction));
        jMenu.add(this.uif.createMenuItem(this.showQuestionLogAction));
        jMenu.addSeparator();
        this.configHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                File file = (File)jMenuItem.getClientProperty(FileHistory.FILE);
                if (file != null) {
                    ConfigHandler.this.ensureConfigEditorInitialized();
                    ConfigHandler.this.configEditor.load(file);
                }
            }
        });
        jMenu.addMenuListener(this.configHistoryListener);
        return jMenu;
    }

    Action[] getToolBarActions() {
        return new Action[]{this.showFullConfigAction, this.showStdConfigAction};
    }

    boolean isConfigEdited() {
        return this.configEditor != null && this.configEditor.isEdited();
    }

    void checkExcludeListUpdate(JComponent jComponent, boolean bl) {
        try {
            Parameters.ExcludeListParameters excludeListParameters = this.interviewParams.getExcludeListParameters();
            if (!(excludeListParameters instanceof Parameters.MutableExcludeListParameters)) {
                return;
            }
            Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)excludeListParameters;
            URL uRL = this.testSuite.getLatestExcludeList();
            File file = this.workDir.getSystemFile("latest.jtx");
            ExcludeListUpdateHandler excludeListUpdateHandler = new ExcludeListUpdateHandler(uRL, file);
            if (bl && !excludeListUpdateHandler.isUpdateAvailable()) {
                return;
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridwidth = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            JLabel jLabel = this.uif.createLabel("ch.elu.remote");
            jPanel.add((Component)jLabel, gridBagConstraints);
            JTextField jTextField = this.uif.createOutputField("ch.elu.remote", jLabel);
            jTextField.setBorder(null);
            long l = excludeListUpdateHandler.getRemoteURLLastModified();
            String string = l <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(l).toString();
            jTextField.setText(string);
            jTextField.setColumns(string.length());
            jPanel.add((Component)jTextField, gridBagConstraints2);
            JLabel jLabel2 = this.uif.createLabel("ch.elu.local");
            jPanel.add((Component)jLabel2, gridBagConstraints);
            JTextField jTextField2 = this.uif.createOutputField("ch.elu.local", jLabel2);
            jTextField2.setBorder(null);
            long l2 = excludeListUpdateHandler.getLocalFileLastModified();
            String string2 = l2 <= 0L ? this.uif.getI18NString("ch.elu.notAvailable") : new Date(l2).toString();
            jTextField2.setText(string2);
            jTextField2.setColumns(string2.length());
            jPanel.add((Component)jTextField2, gridBagConstraints2);
            if (excludeListUpdateHandler.isUpdateAvailable()) {
                String string3;
                String string4 = this.uif.getI18NString("ch.elu.update.title");
                String string5 = this.uif.getI18NString("ch.elu.update.head");
                int n = JOptionPane.showConfirmDialog(jComponent, new Object[]{string5, jPanel, string3 = this.uif.getI18NString("ch.elu.update.foot")}, string4, 0);
                if (n == 0) {
                    excludeListUpdateHandler.update();
                }
            } else {
                String string6 = this.uif.getI18NString("ch.elu.noUpdate.title");
                String string7 = this.uif.getI18NString("ch.elu.noUpdate.head");
                JOptionPane.showMessageDialog(jComponent, new Object[]{string7, jPanel}, string6, 1);
            }
        }
        catch (IOException iOException) {
            I18NResourceBundle i18NResourceBundle = this.uif.getI18NResourceBundle();
            this.workDir.log(i18NResourceBundle, "ch.elu.logError", iOException);
            this.uif.showError("ch.elu.error", iOException);
        }
    }

    boolean ensureInterviewUpToDate() {
        try {
            if (this.interviewParams.isFileNewer()) {
                this.interviewParams.load();
            }
            return true;
        }
        catch (IOException iOException) {
            this.uif.showError("exec.loadInterview", iOException.toString());
            return false;
        }
        catch (Interview.Fault fault) {
            this.uif.showError("exec.loadInterview", fault.getMessage());
            return false;
        }
    }

    void ensureConfigEditorInitialized() {
        if (this.workDir == null) {
            throw new IllegalStateException();
        }
        if (this.configEditor == null) {
            this.configEditor = new ConfigEditor(this.parent, this.interviewParams, this.uif);
            this.configEditor.setCheckExcludeListListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    JComponent jComponent = object instanceof JComponent ? (JComponent)object : ConfigHandler.this.parent;
                    ConfigHandler.this.checkExcludeListUpdate(jComponent, false);
                }
            });
        }
    }

    void showConfigEditor() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1);
    }

    void showConfigEditor(ActionListener actionListener) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(1, actionListener);
    }

    void updateGUI() {
        this.testSuite = this.model.getTestSuite();
        this.workDir = this.model.getWorkDirectory();
        this.interviewParams = this.model.getInterviewParameters();
        if (this.interviewParams != null) {
            this.ensureInterviewUpToDate();
        }
        boolean bl = this.testSuite != null;
        this.newConfigAction.setEnabled(bl);
        this.loadConfigAction.setEnabled(bl);
        this.changeMenu.setEnabled(bl);
        this.showConfigAction.setEnabled(bl);
        this.showFullConfigAction.setEnabled(bl);
        this.showStdConfigAction.setEnabled(bl);
        this.showExcludeListAction.setEnabled(bl);
        this.showEnvironmentAction.setEnabled(bl);
        this.showQuestionLogAction.setEnabled(bl);
        this.showChecklistAction.setEnabled(bl && this.interviewParams != null && !this.interviewParams.isChecklistEmpty());
        if (this.workDir != null && this.configHistoryListener.getFileHistory() == null) {
            FileHistory fileHistory = FileHistory.getFileHistory(this.workDir, "configHistory.jtl");
            this.configHistoryListener.setFileHistory(fileHistory);
        }
        if (this.interviewParams != null && this.observer == null) {
            this.observer = new Interview.Observer(){

                public void currentQuestionChanged(Question question) {
                }

                public void pathUpdated() {
                    ConfigHandler.this.showChecklistAction.setEnabled(!ConfigHandler.this.interviewParams.isChecklistEmpty());
                }
            };
            this.interviewParams.addObserver(this.observer);
        }
    }

    void loadConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.load();
    }

    void newConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.clear();
    }

    void showConfig() {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show();
    }

    void showConfig(int n) {
        if (this.workDir == null) {
            this.model.showWorkDirDialog();
            if (this.workDir == null) {
                return;
            }
        }
        this.ensureConfigEditorInitialized();
        this.configEditor.show(n);
    }

    void showEnvironment() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.environmentBrowser == null) {
            this.environmentBrowser = new EnvironmentBrowser(this.parent, this.uif);
        }
        this.environmentBrowser.show(this.interviewParams);
    }

    void showExcludeList() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.excludeListBrowser == null) {
            this.excludeListBrowser = new ExcludeListBrowser(this.parent, this.uif);
        }
        this.excludeListBrowser.show(this.interviewParams);
    }

    void showChecklist() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.checkListBrowser == null) {
            this.checkListBrowser = new ChecklistBrowser(this.parent, this.model, this.uif);
        }
        this.checkListBrowser.setVisible(true);
    }

    void showQuestionLog() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.questionLogBrowser == null) {
            this.questionLogBrowser = new QuestionLogBrowser(this.parent, this.model, this.uif);
        }
        this.questionLogBrowser.setVisible(true);
    }

    private boolean isOKToContinue() {
        int n = this.uif.showOKCancelDialog("ch.edited.warn");
        return n == 0;
    }

    private void initActions() {
        this.loadConfigAction = new ToolAction(this.uif, "ch.load"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.loadConfig();
            }
        };
        this.newConfigAction = new ToolAction(this.uif, "ch.new"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.newConfig();
            }
        };
        this.showConfigAction = new ToolAction(this.uif, "ch.edit"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig();
            }
        };
        this.showFullConfigAction = new ToolAction(this.uif, "ch.full", true){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig(1);
            }
        };
        this.showStdConfigAction = new ToolAction(this.uif, "ch.std", true){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showConfig(2);
            }
        };
        this.showEnvironmentAction = new ToolAction(this.uif, "ch.env"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showEnvironment();
            }
        };
        this.showExcludeListAction = new ToolAction(this.uif, "ch.excl"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showExcludeList();
            }
        };
        this.showChecklistAction = new ToolAction(this.uif, "ch.checkList"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showChecklist();
            }
        };
        this.showQuestionLogAction = new ToolAction(this.uif, "ch.quLog"){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigHandler.this.showQuestionLog();
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ChangeConfigMenu
    extends JMenu
    implements ActionListener,
    MenuListener {
        private JMenuItem tests;
        private JMenuItem excludeList;
        private JMenuItem keywords;
        private JMenuItem priorStatus;
        private JMenuItem environment;
        private JMenuItem concurrency;
        private JMenuItem timeoutFactor;
        private static final String CHANGE_TESTS = "test";
        private static final String CHANGE_EXCLUDE_LIST = "excl";
        private static final String CHANGE_KEYWORDS = "keyw";
        private static final String CHANGE_PRIOR_STATUS = "stat";
        private static final String CHANGE_ENVIRONMENT = "envt";
        private static final String CHANGE_CONCURRENCY = "conc";
        private static final String CHANGE_TIMEOUT_FACTOR = "time";
        private static final String CHANGE_OTHER = "other";

        ChangeConfigMenu() {
            ConfigHandler.this.uif.initMenu(this, "ch.change");
            this.tests = this.addMenuItem(CHANGE_TESTS, 3);
            this.excludeList = this.addMenuItem(CHANGE_EXCLUDE_LIST, 4);
            this.keywords = this.addMenuItem(CHANGE_KEYWORDS, 5);
            this.priorStatus = this.addMenuItem(CHANGE_PRIOR_STATUS, 6);
            this.environment = this.addMenuItem(CHANGE_ENVIRONMENT, 7);
            this.concurrency = this.addMenuItem(CHANGE_CONCURRENCY, 8);
            this.timeoutFactor = this.addMenuItem(CHANGE_TIMEOUT_FACTOR, 9);
            this.addSeparator();
            JMenuItem jMenuItem = this.addMenuItem(CHANGE_OTHER, 1);
            jMenuItem.setAccelerator(configEditorAccelerator);
            this.addMenuListener(this);
        }

        private JMenuItem addMenuItem(String string, int n) {
            JMenuItem jMenuItem = ConfigHandler.this.uif.createMenuItem("ch.change", string, this);
            jMenuItem.putClientProperty(this, new Integer(n));
            this.add(jMenuItem);
            return jMenuItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Integer n = (Integer)jMenuItem.getClientProperty(this);
            if (n != null) {
                if (ConfigHandler.this.workDir == null) {
                    ConfigHandler.this.model.showWorkDirDialog();
                    if (ConfigHandler.this.workDir == null) {
                        return;
                    }
                }
                ConfigHandler.this.ensureConfigEditorInitialized();
                ConfigHandler.this.configEditor.show(n);
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            InterviewParameters interviewParameters = ConfigHandler.this.interviewParams;
            if (interviewParameters == null) {
                return;
            }
            this.update(this.tests, interviewParameters.getTestsParameters(), class$com$sun$javatest$Parameters$MutableTestsParameters == null ? (class$com$sun$javatest$Parameters$MutableTestsParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutableTestsParameters")) : class$com$sun$javatest$Parameters$MutableTestsParameters);
            this.update(this.excludeList, interviewParameters.getExcludeListParameters(), class$com$sun$javatest$Parameters$MutableExcludeListParameters == null ? (class$com$sun$javatest$Parameters$MutableExcludeListParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutableExcludeListParameters")) : class$com$sun$javatest$Parameters$MutableExcludeListParameters);
            this.update(this.keywords, interviewParameters.getKeywordsParameters(), class$com$sun$javatest$Parameters$MutableKeywordsParameters == null ? (class$com$sun$javatest$Parameters$MutableKeywordsParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutableKeywordsParameters")) : class$com$sun$javatest$Parameters$MutableKeywordsParameters);
            this.update(this.priorStatus, interviewParameters.getPriorStatusParameters(), class$com$sun$javatest$Parameters$MutablePriorStatusParameters == null ? (class$com$sun$javatest$Parameters$MutablePriorStatusParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutablePriorStatusParameters")) : class$com$sun$javatest$Parameters$MutablePriorStatusParameters);
            this.update(this.environment, interviewParameters.getEnvParameters(), class$com$sun$javatest$Parameters$LegacyEnvParameters == null ? (class$com$sun$javatest$Parameters$LegacyEnvParameters = ConfigHandler.class$("com.sun.javatest.Parameters$LegacyEnvParameters")) : class$com$sun$javatest$Parameters$LegacyEnvParameters);
            this.update(this.concurrency, interviewParameters.getConcurrencyParameters(), class$com$sun$javatest$Parameters$MutableConcurrencyParameters == null ? (class$com$sun$javatest$Parameters$MutableConcurrencyParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutableConcurrencyParameters")) : class$com$sun$javatest$Parameters$MutableConcurrencyParameters);
            this.update(this.timeoutFactor, interviewParameters.getTimeoutFactorParameters(), class$com$sun$javatest$Parameters$MutableTimeoutFactorParameters == null ? (class$com$sun$javatest$Parameters$MutableTimeoutFactorParameters = ConfigHandler.class$("com.sun.javatest.Parameters$MutableTimeoutFactorParameters")) : class$com$sun$javatest$Parameters$MutableTimeoutFactorParameters);
        }

        private void update(JMenuItem jMenuItem, Object object, Class clazz) {
            jMenuItem.setVisible(object != null && clazz.isAssignableFrom(object.getClass()));
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }
    }
}

