/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PropertiesBrowser
extends ToolDialog {
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private InterviewParameters config;
    private Pane[] panes;
    private String unset;
    private static final int TEST_SUITE_PANE = 0;
    private static final int WORK_DIRECTORY_PANE = 1;
    private static final int CONFIGURATION_PANE = 2;
    private static final int CLASSES_PANE = 3;
    private static final int NUM_PANES = 4;

    PropertiesBrowser(JComponent jComponent, UIFactory uIFactory) {
        super(jComponent, uIFactory, "props");
    }

    void showDialog(TestSuite testSuite, WorkDirectory workDirectory, InterviewParameters interviewParameters) {
        if (this.panes == null) {
            this.initGUI();
        }
        this.testSuite = testSuite;
        this.workDir = workDirectory;
        this.config = interviewParameters;
        for (int i = 0; i < this.panes.length; ++i) {
            this.panes[i].update();
        }
        this.setVisible(true);
    }

    protected void initGUI() {
        this.setHelp("execProps.dialog.csh");
        this.setI18NTitle("props.title");
        this.unset = this.uif.getI18NString("props.unset");
        this.panes = new Pane[4];
        this.panes[0] = new TestSuitePane();
        this.panes[1] = new WorkDirectoryPane();
        this.panes[2] = new ConfigurationPane();
        this.panes[3] = new PluginsPane();
        this.setBody(this.createVerticalBoxPane(this.panes));
        JButton jButton = this.uif.createHelpButton("props.help", "execProps.dialog.csh");
        JButton jButton2 = this.uif.createCloseButton("props.close");
        this.setButtons(new JButton[]{jButton, jButton2}, jButton2);
    }

    private JComponent createTabbedPane(Pane[] paneArray) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        for (int i = 0; i < paneArray.length; ++i) {
            Pane pane = paneArray[i];
            this.uif.addTab(jTabbedPane, pane.getKey(), pane);
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Component component = jTabbedPane.getSelectedComponent();
                CSH.setHelpIDString(jTabbedPane, CSH.getHelpIDString(component));
            }
        });
        Component component = jTabbedPane.getSelectedComponent();
        CSH.setHelpIDString(jTabbedPane, CSH.getHelpIDString(component));
        return jTabbedPane;
    }

    private JComponent createVerticalBoxPane(Pane[] paneArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        for (int i = 0; i < paneArray.length; ++i) {
            Pane pane = paneArray[i];
            String string = this.uif.getI18NString(pane.getKey() + ".tab");
            pane.setBorder(BorderFactory.createTitledBorder(string));
            jPanel.add((Component)pane, gridBagConstraints);
        }
        return jPanel;
    }

    private class PluginsPane
    extends Pane {
        private JTextField testSuiteClassName;
        private JTextField testFinderClassName;
        private JTextField testRunnerClassName;
        private JTextField configClassName;

        PluginsPane() {
            super("props.pi");
            CSH.setHelpIDString(this, "execProps.pluginsTab.csh");
            this.testSuiteClassName = this.addLabelledField("props.pi.testSuite");
            this.testFinderClassName = this.addLabelledField("props.pi.testFinder");
            this.testRunnerClassName = this.addLabelledField("props.pi.testRunner");
            this.configClassName = this.addLabelledField("props.pi.config");
        }

        void update() {
            if (PropertiesBrowser.this.testSuite == null) {
                this.setField(this.testSuiteClassName, null);
                this.setField(this.testFinderClassName, null);
                this.setField(this.configClassName, null);
            } else {
                this.setField(this.testSuiteClassName, PropertiesBrowser.this.testSuite.getClass().getName());
                this.setField(this.testFinderClassName, PropertiesBrowser.this.testSuite.getTestFinder().getClass().getName());
                this.setField(this.testRunnerClassName, PropertiesBrowser.this.testSuite.createTestRunner().getClass().getName());
                try {
                    InterviewParameters interviewParameters = PropertiesBrowser.this.config != null ? PropertiesBrowser.this.config : PropertiesBrowser.this.testSuite.createInterview();
                    this.setField(this.configClassName, interviewParameters.getClass().getName());
                }
                catch (TestSuite.Fault fault) {
                    this.setField(this.configClassName, null);
                }
            }
        }
    }

    private class ConfigurationPane
    extends Pane {
        private JTextField path;
        private JTextField configName;
        private JTextField configDesc;
        private JTextField state;
        private String completed;
        private String incomplete;

        ConfigurationPane() {
            super("props.cfg");
            CSH.setHelpIDString(this, "execProps.configTab.csh");
            this.path = this.addLabelledField("props.cfg.path");
            this.configName = this.addLabelledField("props.cfg.name");
            this.configDesc = this.addLabelledField("props.cfg.desc");
            this.state = this.addLabelledField("props.cfg.state");
            this.completed = PropertiesBrowser.this.uif.getI18NString("props.cfg.completed");
            this.incomplete = PropertiesBrowser.this.uif.getI18NString("props.cfg.incomplete");
        }

        void update() {
            if (PropertiesBrowser.this.config == null) {
                this.setField(this.path, null);
                this.setField(this.configName, null);
                this.setField(this.configDesc, null);
                this.setField(this.state, null);
            } else {
                File file = PropertiesBrowser.this.config.getFile();
                this.setField(this.path, file == null ? null : file.getPath());
                this.setField(this.configName, PropertiesBrowser.this.config.getName());
                this.setField(this.configDesc, PropertiesBrowser.this.config.getDescription());
                this.setField(this.state, PropertiesBrowser.this.config == null ? null : (PropertiesBrowser.this.config.isFinishable() ? this.completed : this.incomplete));
            }
        }
    }

    private class WorkDirectoryPane
    extends Pane {
        private JTextField path;

        WorkDirectoryPane() {
            super("props.wd");
            CSH.setHelpIDString(this, "execProps.workDirTab.csh");
            this.path = this.addLabelledField("props.wd.path");
        }

        void update() {
            this.setField(this.path, PropertiesBrowser.this.workDir == null ? null : PropertiesBrowser.this.workDir.getPath());
        }
    }

    private class TestSuitePane
    extends Pane {
        private JTextField path;
        private JTextField name;
        private JTextField id;

        TestSuitePane() {
            super("props.ts");
            CSH.setHelpIDString(this, "execProps.testSuiteTab.csh");
            this.path = this.addLabelledField("props.ts.path");
            this.name = this.addLabelledField("props.ts.name");
            this.id = this.addLabelledField("props.ts.id");
        }

        void update() {
            if (PropertiesBrowser.this.testSuite == null) {
                this.setField(this.path, null);
                this.setField(this.name, null);
                this.setField(this.id, null);
            } else {
                this.setField(this.path, PropertiesBrowser.this.testSuite.getPath());
                this.setField(this.name, PropertiesBrowser.this.testSuite.getName());
                this.setField(this.id, PropertiesBrowser.this.testSuite.getID());
            }
        }
    }

    private abstract class Pane
    extends JPanel {
        private String key;

        Pane(String string) {
            this.key = string;
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        String getKey() {
            return this.key;
        }

        JTextField addLabelledField(String string) {
            JLabel jLabel = this.addLabel(string);
            JTextField jTextField = PropertiesBrowser.this.uif.createOutputField(string, 30, jLabel);
            jTextField.setBorder(null);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.add((Component)jTextField, gridBagConstraints);
            return jTextField;
        }

        void setField(JTextField jTextField, String string) {
            if (string == null || string.length() == 0) {
                jTextField.setText(PropertiesBrowser.this.unset);
            } else {
                jTextField.setText(string);
            }
        }

        JLabel addLabel(String string) {
            JLabel jLabel = PropertiesBrowser.this.uif.createLabel(string, true);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets.right = 5;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jLabel, gridBagConstraints);
            return jLabel;
        }

        abstract void update();
    }
}

