/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.TestSuiteChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.WorkDirChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class QuickStartWizard
extends ToolDialog {
    private ExecTool tool;
    private Pane currPane;
    private Pane taskPane;
    private Pane configPane;
    private Pane testSuitePane;
    private Pane newWorkDirPane;
    private Pane openWorkDirPane;
    private Pane endPane;
    private int task;
    private static final int UNSET = 0;
    private static final int NEW = 1;
    private static final int RESUME = 2;
    private static final int BROWSE = 3;
    private Map configData;
    private File configFile;
    private InterviewParameters config;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private boolean showConfigEditorFlag;
    private boolean runTestsFlag;
    private File installDir;
    private File installParentDir;
    private boolean installDirIsTestSuite;
    private boolean installParentDirIsTestSuite;
    private File userDir;
    private boolean userDirIsTestSuite;
    private boolean userDirIsWorkDirectory;
    private JPanel body;
    private JPanel main;
    private JTextField head;
    private JTextField foot;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton doneBtn;
    private Listener listener = new Listener();
    private KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private Vector history = new Vector();

    QuickStartWizard(ExecTool execTool, UIFactory uIFactory) {
        super(execTool, uIFactory, "qsw");
        this.tool = execTool;
    }

    protected void initGUI() {
        JLabel jLabel;
        URL uRL;
        TestSuite testSuite;
        this.initDirs();
        this.initPanes();
        this.setHelp("qsw.window.csh");
        this.setI18NTitle("qsw.title");
        this.body = this.uif.createPanel("qsw.body", new BorderLayout(), false);
        this.body.setBorder(BorderFactory.createLoweredBevelBorder());
        try {
            testSuite = this.installDirIsTestSuite ? TestSuite.open(this.installDir) : (this.installParentDirIsTestSuite ? TestSuite.open(this.installParentDir) : (this.userDirIsTestSuite ? TestSuite.open(this.userDir) : null));
        }
        catch (Throwable throwable) {
            testSuite = null;
        }
        URL uRL2 = uRL = testSuite == null ? null : testSuite.getLogo();
        if (uRL == null) {
            jLabel = new JLabel(this.tool.getManager().getDesktop().getLogo());
            jLabel.setName("qsw.jtlogo");
            jLabel.setBackground(this.uif.getI18NColor("qsw.jtlogo.bg"));
            this.uif.setAccessibleInfo(jLabel, "qsw.jtlogo");
        } else {
            jLabel = new JLabel(new ImageIcon(uRL));
            jLabel.setName("qsw.tslogo");
            jLabel.setBackground(Color.white);
            this.uif.setAccessibleInfo(jLabel, "qsw.tslogo");
        }
        jLabel.setOpaque(true);
        jLabel.setFocusable(false);
        this.body.add((Component)jLabel, "West");
        this.main = this.uif.createPanel("qsw.main", new BorderLayout(), false);
        this.main.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 11));
        this.head = this.uif.createOutputField("qsw.head");
        this.head.setBorder(null);
        this.head.setFont(this.head.getFont().deriveFont(1));
        this.main.add((Component)this.head, "North");
        this.foot = this.uif.createOutputField("qsw.foot");
        this.foot.setBorder(null);
        this.foot.setFont(this.foot.getFont().deriveFont(1));
        this.foot.setForeground(this.uif.getI18NColor("qsw.foot"));
        this.main.add((Component)this.foot, "South");
        this.body.add((Component)this.main, "Center");
        this.setBody(this.body);
        this.backBtn = this.uif.createButton("qsw.back", this.listener);
        this.nextBtn = this.uif.createButton("qsw.next", this.listener);
        this.doneBtn = this.uif.createButton("qsw.done", this.listener);
        JButton jButton = this.uif.createCancelButton("qsw.cancel");
        this.setButtons(new JButton[]{this.backBtn, this.nextBtn, this.doneBtn, jButton}, null);
        this.setPane(this.taskPane);
    }

    private void initDirs() {
        File file = Harness.getClassDir();
        this.installDir = file == null ? null : file.getParentFile();
        this.installDirIsTestSuite = this.installDir == null ? false : TestSuite.isTestSuite(this.installDir);
        this.installParentDir = this.installDir == null ? null : this.installDir.getParentFile();
        this.installParentDirIsTestSuite = this.installParentDir == null ? false : TestSuite.isTestSuite(this.installParentDir);
        this.userDir = new File(System.getProperty("user.dir"));
        this.userDirIsTestSuite = this.userDir == null ? false : TestSuite.isTestSuite(this.userDir);
        this.userDirIsWorkDirectory = this.userDir == null ? false : WorkDirectory.isWorkDirectory(this.userDir);
    }

    private void initPanes() {
        this.taskPane = new TaskPane();
        this.configPane = new ConfigPane();
        this.testSuitePane = new TestSuitePane();
        this.newWorkDirPane = new CreateWorkDirPane();
        this.openWorkDirPane = new OpenWorkDirPane();
        this.endPane = new EndPane();
    }

    private void setPane(Pane pane) {
        if (this.currPane != null) {
            this.main.remove(this.currPane);
        }
        pane.update();
        this.head.setText(pane.getHead());
        this.main.add((Component)pane, "Center");
        this.showError(null);
        this.backBtn.setEnabled(this.history.size() > 0);
        pane.updateNextButton();
        this.doneBtn.setEnabled(pane == this.endPane);
        this.currPane = pane;
        this.main.validate();
        this.main.repaint();
    }

    private void showError(String string) {
        if (string == null) {
            this.foot.setText("");
            this.foot.setEnabled(false);
        } else {
            this.foot.setText(this.uif.getI18NString(string));
            this.foot.setEnabled(true);
            this.nextBtn.setEnabled(false);
        }
    }

    private void doBack() {
        int n = this.history.size();
        if (n > 0) {
            Pane pane = (Pane)this.history.remove(n - 1);
            this.setPane(pane);
        }
    }

    private void doNext() {
        Pane pane = this.currPane.getNext();
        if (pane != null) {
            this.history.add(this.currPane);
            this.setPane(pane);
        }
    }

    private void doDone() {
        if (this.config == null) {
            throw new IllegalStateException();
        }
        if (this.workDir != null) {
            this.config.setWorkDirectory(this.workDir);
        }
        this.tool.setInterviewParameters(this.config);
        if (this.showConfigEditorFlag) {
            this.tool.showConfigEditor(this.runTestsFlag);
        } else if (this.runTestsFlag) {
            this.tool.runTests();
        }
        this.setVisible(false);
    }

    private static boolean canonicalEquals(File file, File file2) {
        try {
            File file3 = file.getCanonicalFile();
            File file4 = file2.getCanonicalFile();
            return file3.equals(file4);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private class EndPane
    extends Pane {
        private JTextArea configTextArea = this.addText(false);
        private JCheckBox configCheck = this.addCheck("cfg");
        private JTextArea runTestsTextArea = this.addText(false);
        private JCheckBox runTestsCheck = this.addCheck("run");

        EndPane() {
            super("qsw.end");
        }

        void update() {
            super.update();
            Integer n = new Integer(QuickStartWizard.this.configData == null ? 0 : 1);
            StringBuffer stringBuffer = new StringBuffer();
            if (QuickStartWizard.this.config.isFinishable()) {
                stringBuffer.append(QuickStartWizard.this.uif.getI18NString("qsw.end.cfgComplete"));
                this.configCheck.setSelected(QuickStartWizard.this.task != 3);
            } else {
                if (QuickStartWizard.this.configData != null) {
                    stringBuffer.append(QuickStartWizard.this.uif.getI18NString("qsw.end.cfgIncomplete"));
                    stringBuffer.append(" ");
                }
                stringBuffer.append(QuickStartWizard.this.uif.getI18NString("qsw.end.needEditor", n));
                this.configCheck.setSelected(QuickStartWizard.this.task != 3);
            }
            stringBuffer.append(" ");
            stringBuffer.append(QuickStartWizard.this.uif.getI18NString("qsw.end.editor"));
            this.configTextArea.setText(stringBuffer.toString());
            if (QuickStartWizard.this.task == 3) {
                this.runTestsTextArea.setVisible(false);
                this.runTestsCheck.setVisible(false);
            } else {
                this.runTestsTextArea.setVisible(true);
                this.runTestsCheck.setVisible(true);
                this.runTestsTextArea.setText(QuickStartWizard.this.uif.getI18NString("qsw.end.runTests", n));
            }
            this.stateChanged();
        }

        void updateNextButton() {
            QuickStartWizard.this.nextBtn.setEnabled(false);
        }

        void stateChanged() {
            if (this.runTestsCheck.isSelected() && (QuickStartWizard.this.config == null || !QuickStartWizard.this.config.isFinishable())) {
                this.configCheck.setSelected(true);
            }
            QuickStartWizard.this.showConfigEditorFlag = this.configCheck.isSelected();
            QuickStartWizard.this.runTestsFlag = this.runTestsCheck.isSelected();
        }
    }

    private class OpenWorkDirPane
    extends WorkDirPane {
        OpenWorkDirPane() {
            super("qsw.owd");
            this.chooser.setMode(1);
            if (QuickStartWizard.this.userDirIsWorkDirectory) {
                this.workDirPanel.setSuggestions(new String[]{QuickStartWizard.this.userDir.getPath()});
            }
        }

        void stateChanged() {
            this.updateNextButton();
        }

        void updateNextButton() {
            File file = this.workDirPanel.getFile();
            WorkDirectory workDirectory = this.chooser.getSelectedWorkDirectory();
            if (file == null) {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            } else if (workDirectory != null && workDirectory.getRoot().equals(file)) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(WorkDirectory.isWorkDirectory(file));
            }
        }

        Pane getNext() {
            File file = this.workDirPanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.owd.noFile");
                return null;
            }
            if (QuickStartWizard.this.workDir == null || !QuickStartWizard.this.workDir.getRoot().equals(file)) {
                Object object;
                try {
                    object = this.chooser.getSelectedWorkDirectory();
                    if (object != null && ((WorkDirectory)object).getRoot().equals(file)) {
                        QuickStartWizard.this.workDir = (WorkDirectory)object;
                    } else {
                        QuickStartWizard.this.workDir = WorkDirectory.open(file);
                    }
                    QuickStartWizard.this.testSuite = QuickStartWizard.this.workDir.getTestSuite();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    QuickStartWizard.this.showError("qsw.owd.cantFindFile");
                    return null;
                }
                catch (WorkDirectory.Fault fault) {
                    QuickStartWizard.this.uif.showError("qsw.owd.cantOpen", new Object[]{file, fault.getMessage()});
                    return null;
                }
                try {
                    QuickStartWizard.this.config = QuickStartWizard.this.testSuite.createInterview();
                }
                catch (TestSuite.Fault fault) {
                    QuickStartWizard.this.uif.showError("qsw.owd.createCreateInterview", fault.getMessage());
                    return null;
                }
                object = FileHistory.getFileHistory(QuickStartWizard.this.workDir, "configHistory.jtl");
                File file2 = ((FileHistory)object).getLatestEntry();
                if (file2 != null) {
                    try {
                        QuickStartWizard.this.config.load(file2);
                    }
                    catch (IOException iOException) {
                        QuickStartWizard.this.uif.showError("qsw.owd.cantLoadDefaultConfig", new Object[]{file2, iOException});
                        return null;
                    }
                    catch (Interview.Fault fault) {
                        QuickStartWizard.this.uif.showError("qsw.owd.cantLoadDefaultConfig", new Object[]{file2, fault.getMessage()});
                        return null;
                    }
                }
            }
            return QuickStartWizard.this.endPane;
        }
    }

    private class CreateWorkDirPane
    extends WorkDirPane {
        CreateWorkDirPane() {
            super("qsw.nwd");
            this.chooser.setMode(0);
        }

        void stateChanged() {
            this.updateNextButton();
        }

        public void update() {
            this.chooser.setTestSuite(QuickStartWizard.this.testSuite);
        }

        void updateNextButton() {
            String string = this.workDirPanel.getPath();
            QuickStartWizard.this.nextBtn.setEnabled(string != null && string.length() > 0);
        }

        Pane getNext() {
            File file = this.workDirPanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.nwd.noFile");
                return null;
            }
            if (QuickStartWizard.this.workDir == null || !QuickStartWizard.this.workDir.getRoot().equals(file)) {
                try {
                    WorkDirectory workDirectory = this.chooser.getSelectedWorkDirectory();
                    if (workDirectory != null && QuickStartWizard.canonicalEquals(workDirectory.getRoot(), file)) {
                        QuickStartWizard.this.workDir = workDirectory;
                    } else {
                        QuickStartWizard.this.workDir = WorkDirectory.create(file, QuickStartWizard.this.testSuite);
                    }
                }
                catch (WorkDirectory.Fault fault) {
                    QuickStartWizard.this.uif.showError("qsw.nwd.cantCreate", new Object[]{file, fault.getMessage()});
                    return null;
                }
            }
            return QuickStartWizard.this.endPane;
        }
    }

    private abstract class WorkDirPane
    extends Pane {
        protected final JTextArea textArea = this.addText();
        protected final FilePanel workDirPanel;
        protected WorkDirChooser chooser = new WorkDirChooser();

        WorkDirPane(String string) {
            super(string);
            this.workDirPanel = this.addFile("file", this.chooser);
        }
    }

    private class TestSuitePane
    extends Pane {
        private FilePanel testSuitePanel;
        private TestSuiteChooser chooser;

        TestSuitePane() {
            super("qsw.ts");
            this.addText();
            this.chooser = new TestSuiteChooser();
            this.testSuitePanel = this.addFile("file", this.chooser);
        }

        void stateChanged() {
            QuickStartWizard.this.showError(null);
            this.updateNextButton();
        }

        void update() {
            String string;
            super.update();
            TreeSet<String> treeSet = new TreeSet<String>();
            if (QuickStartWizard.this.configData != null && (string = (String)QuickStartWizard.this.configData.get("TESTSUITE")) != null) {
                treeSet.add(string);
            }
            if (QuickStartWizard.this.userDirIsTestSuite) {
                treeSet.add(QuickStartWizard.this.userDir.getPath());
            }
            if (QuickStartWizard.this.installDirIsTestSuite) {
                treeSet.add(QuickStartWizard.this.installDir.getPath());
            }
            if (QuickStartWizard.this.installParentDirIsTestSuite) {
                treeSet.add(QuickStartWizard.this.installParentDir.getPath());
            }
            if (treeSet.size() > 0) {
                this.testSuitePanel.setSuggestions(treeSet.toArray(new String[treeSet.size()]));
            }
        }

        void updateNextButton() {
            File file = this.testSuitePanel.getFile();
            TestSuite testSuite = this.chooser.getSelectedTestSuite();
            if (file == null) {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            } else if (testSuite != null && testSuite.getRoot().equals(file)) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(TestSuite.isTestSuite(file));
            }
        }

        Pane getNext() {
            File file = this.testSuitePanel.getFile();
            if (file == null) {
                QuickStartWizard.this.showError("qsw.ts.noFile");
                return null;
            }
            if (QuickStartWizard.this.testSuite == null || !QuickStartWizard.this.testSuite.getRoot().equals(file) || QuickStartWizard.this.config == null) {
                Object object;
                try {
                    object = this.chooser.getSelectedTestSuite();
                    if (object != null && ((TestSuite)object).getRoot().equals(file)) {
                        QuickStartWizard.this.testSuite = (TestSuite)object;
                    } else {
                        QuickStartWizard.this.testSuite = TestSuite.open(file);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    QuickStartWizard.this.showError("qsw.ts.cantFindFile");
                    return null;
                }
                catch (TestSuite.Fault fault) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantOpen", new Object[]{file, fault.getMessage()});
                    return null;
                }
                try {
                    QuickStartWizard.this.config = QuickStartWizard.this.testSuite.createInterview();
                }
                catch (TestSuite.Fault fault) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantCreateInterview", fault.getMessage());
                    return null;
                }
                catch (Throwable throwable) {
                    QuickStartWizard.this.uif.showError("qsw.ts.cantCreateInterview", throwable.toString());
                    return null;
                }
                if (QuickStartWizard.this.configData != null) {
                    object = (String)QuickStartWizard.this.configData.get("INTERVIEW");
                    if (object != null && !QuickStartWizard.this.config.getClass().getName().equals(object)) {
                        QuickStartWizard.this.uif.showError("qsw.ts.configMismatch");
                        return null;
                    }
                    try {
                        QuickStartWizard.this.config.load(QuickStartWizard.this.configData, QuickStartWizard.this.configFile);
                    }
                    catch (Interview.Fault fault) {
                        QuickStartWizard.this.uif.showError("qsw.ts.cantLoadConfig", fault.getMessage());
                        return null;
                    }
                }
            }
            return QuickStartWizard.this.config == null ? null : (QuickStartWizard.this.task == 1 ? QuickStartWizard.this.newWorkDirPane : QuickStartWizard.this.endPane);
        }
    }

    private class ConfigPane
    extends Pane {
        private ButtonGroup bg = new ButtonGroup();
        private JRadioButton newConfig;
        private JRadioButton fileConfig;
        private FilePanel filePanel;
        private FileChooser chooser;
        private long configLastModified;

        ConfigPane() {
            super("qsw.cfg");
            this.addText();
            this.chooser = new FileChooser(true);
            this.chooser.addChoosableExtension(".jti", QuickStartWizard.this.uif.getI18NString("qsw.cfg.jtiFiles"));
            this.newConfig = this.addChoice("new", this.bg);
            this.fileConfig = this.addChoice("file", this.bg);
            this.filePanel = this.addFile("file.field", this.chooser, this.fileConfig);
        }

        void stateChanged() {
            QuickStartWizard.this.showError(null);
            this.updateNextButton();
        }

        void updateNextButton() {
            if (this.newConfig.isSelected()) {
                QuickStartWizard.this.nextBtn.setEnabled(true);
            } else if (this.fileConfig.isSelected()) {
                File file = this.filePanel.getFile();
                QuickStartWizard.this.nextBtn.setEnabled(file != null && file.exists() && file.isFile());
            } else {
                QuickStartWizard.this.nextBtn.setEnabled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Pane getNext() {
            if (this.bg.getSelection() == null) {
                return null;
            }
            if (this.newConfig.isSelected()) {
                QuickStartWizard.this.configData = null;
                QuickStartWizard.this.configFile = null;
            } else if (this.fileConfig.isSelected()) {
                String string = this.filePanel.getPath();
                if (string.length() == 0) {
                    QuickStartWizard.this.showError("qsw.cfg.noFile");
                    return null;
                }
                File file = new File(string);
                if (!file.exists()) {
                    QuickStartWizard.this.showError("qsw.cfg.cantFindFile");
                    return null;
                }
                if (!file.isFile()) {
                    QuickStartWizard.this.showError("qsw.cfg.badFile");
                    return null;
                }
                if (QuickStartWizard.this.configFile == null || !QuickStartWizard.this.configFile.equals(file) || this.configLastModified != file.lastModified()) {
                    Properties properties = new Properties();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    try {
                        properties.load(bufferedInputStream);
                        QuickStartWizard.this.configData = properties;
                        QuickStartWizard.this.configFile = file;
                    }
                    catch (RuntimeException runtimeException) {
                        Pane pane;
                        try {
                            QuickStartWizard.this.uif.showError("qsw.cfg.cantReadFile", runtimeException);
                            pane = null;
                        }
                        catch (Throwable throwable) {
                            try {
                                ((InputStream)bufferedInputStream).close();
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                QuickStartWizard.this.uif.showError("qsw.cfg.cantReadFile", iOException);
                                return null;
                            }
                        }
                        ((InputStream)bufferedInputStream).close();
                        return pane;
                    }
                    ((InputStream)bufferedInputStream).close();
                    if (!InterviewParameters.isChecksumValid(QuickStartWizard.this.configData, true)) {
                        QuickStartWizard.this.uif.showError("qsw.cfg.badChecksum");
                        return null;
                    }
                }
            }
            return QuickStartWizard.this.testSuitePane;
        }
    }

    private class TaskPane
    extends Pane {
        private ButtonGroup bg = new ButtonGroup();
        private JRadioButton newRun;
        private JRadioButton resumeRun;
        private JRadioButton browse;

        TaskPane() {
            super("qsw.tsk");
            this.addText();
            this.newRun = this.addChoice("new", this.bg);
            this.resumeRun = this.addChoice("resume", this.bg);
            this.browse = this.addChoice("browse", this.bg);
        }

        void stateChanged() {
            QuickStartWizard.this.task = this.newRun.isSelected() ? 1 : (this.resumeRun.isSelected() ? 2 : (this.browse.isSelected() ? 3 : 0));
            this.updateNextButton();
        }

        void updateNextButton() {
            QuickStartWizard.this.nextBtn.setEnabled(QuickStartWizard.this.task != 0);
        }

        Pane getNext() {
            return QuickStartWizard.this.task == 1 || QuickStartWizard.this.task == 3 ? QuickStartWizard.this.configPane : (QuickStartWizard.this.task == 2 ? QuickStartWizard.this.openWorkDirPane : null);
        }
    }

    private abstract class Pane
    extends JPanel {
        private ChangeListener changeListener = new ChangeListener(this){
            private final /* synthetic */ Pane this$1;
            {
                this.this$1 = pane;
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.this$1.stateChanged();
            }
        };
        private String paneKey;
        private String head;

        Pane(String string) {
            this.paneKey = string;
            this.setLayout(new GridBagLayout());
            int n = QuickStartWizard.this.uif.getDotsPerInch();
            this.setPreferredSize(new Dimension(5 * n, (int)(2.5 * (double)n)));
            this.head = QuickStartWizard.this.uif.getI18NString(this.paneKey + ".hd");
        }

        void stateChanged() {
        }

        String getHead() {
            return this.head;
        }

        void update() {
            this.updateNextButton();
        }

        abstract void updateNextButton();

        Pane getNext() {
            return null;
        }

        JCheckBox addCheck(String string) {
            JCheckBox jCheckBox = QuickStartWizard.this.uif.createCheckBox(this.paneKey + "." + string);
            jCheckBox.addChangeListener(this.changeListener);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jCheckBox, gridBagConstraints);
            return jCheckBox;
        }

        JRadioButton addChoice(String string, ButtonGroup buttonGroup) {
            JRadioButton jRadioButton = QuickStartWizard.this.uif.createRadioButton(this.paneKey + "." + string, buttonGroup);
            jRadioButton.addChangeListener(this.changeListener);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jRadioButton, gridBagConstraints);
            return jRadioButton;
        }

        FilePanel addFile(String string, JFileChooser jFileChooser) {
            return this.addFile(string, jFileChooser, null);
        }

        FilePanel addFile(String string, JFileChooser jFileChooser, JRadioButton jRadioButton) {
            FilePanel filePanel = new FilePanel(this.paneKey + "." + string, jFileChooser);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.insets.left = jRadioButton == null ? 0 : 30;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)filePanel, gridBagConstraints);
            if (jRadioButton != null) {
                filePanel.addAncestorListener(new AncestorListener(this, filePanel, jRadioButton){
                    private final /* synthetic */ FilePanel val$fp;
                    private final /* synthetic */ JRadioButton val$rb;
                    private final /* synthetic */ Pane this$1;
                    {
                        this.this$1 = pane;
                        this.val$fp = filePanel;
                        this.val$rb = jRadioButton;
                    }

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        this.val$fp.setEnabled(this.val$rb.isSelected());
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }
                });
                jRadioButton.addChangeListener(new ChangeListener(this, filePanel, jRadioButton){
                    private final /* synthetic */ FilePanel val$fp;
                    private final /* synthetic */ JRadioButton val$rb;
                    private final /* synthetic */ Pane this$1;
                    {
                        this.this$1 = pane;
                        this.val$fp = filePanel;
                        this.val$rb = jRadioButton;
                    }

                    public void stateChanged(ChangeEvent changeEvent) {
                        this.val$fp.setEnabled(this.val$rb.isSelected());
                    }
                });
            }
            filePanel.setDocumentListener(new DocumentListener(this, filePanel){
                private final /* synthetic */ FilePanel val$fp;
                private final /* synthetic */ Pane this$1;
                {
                    this.this$1 = pane;
                    this.val$fp = filePanel;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    Pane.access$2000(this.this$1).stateChanged(new ChangeEvent(this.val$fp));
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
            return filePanel;
        }

        JTextArea addText() {
            return this.addText(true);
        }

        JTextArea addText(boolean bl) {
            JTextArea jTextArea = QuickStartWizard.this.uif.createTextArea("qsw.text");
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setOpaque(false);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setFocusTraversalKeys(0, null);
            jTextArea.setFocusTraversalKeys(1, null);
            if (bl) {
                jTextArea.setText(QuickStartWizard.this.uif.getI18NString(this.paneKey + ".txt"));
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.top = 20;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.fill = 1;
            this.add((Component)jTextArea, gridBagConstraints);
            return jTextArea;
        }

        static /* synthetic */ ChangeListener access$2000(Pane pane) {
            return pane.changeListener;
        }
    }

    private class FilePanel
    extends JPanel {
        private JLabel label;
        private JTextField field;
        private JComboBox combo;
        private JComponent currPathComp;
        private JButton button;
        private DocumentListener listener;

        FilePanel(String string, final JFileChooser jFileChooser) {
            QuickStartWizard.this.uif.initPanel(this, string, new BorderLayout(), false);
            this.label = QuickStartWizard.this.uif.createLabel(string, true);
            this.field = QuickStartWizard.this.uif.createInputField(string, this.label);
            this.currPathComp = this.field;
            this.button = QuickStartWizard.this.uif.createButton(string + ".browse");
            this.button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    String string = this.getPath();
                    if (string != null && string.length() > 0) {
                        jFileChooser.setSelectedFile(new File(string));
                    }
                    if ((n = jFileChooser.showDialog(QuickStartWizard.this.body, jFileChooser.getApproveButtonText())) != 0) {
                        return;
                    }
                    string = jFileChooser.getSelectedFile().getPath();
                    field.setText(string);
                    if (combo != null) {
                        combo.setSelectedItem(string);
                    }
                }
            });
            this.add((Component)this.label, "West");
            this.add((Component)this.field, "Center");
            this.add((Component)this.button, "East");
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.label.setEnabled(bl);
            this.currPathComp.setEnabled(bl);
            this.button.setEnabled(bl);
        }

        void setSuggestions(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.setPathComponent(this.field);
            } else {
                if (this.combo == null) {
                    Component component;
                    this.combo = QuickStartWizard.this.uif.createChoice(this.getName(), true, this.label);
                    this.combo.setFont(this.combo.getFont().deriveFont(0));
                    if (this.listener != null && (component = this.combo.getEditor().getEditorComponent()) instanceof JTextField) {
                        ((JTextField)component).getDocument().addDocumentListener(this.listener);
                    }
                }
                this.setPathComponent(this.combo);
                this.combo.removeAllItems();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.combo.addItem(stringArray[i]);
                }
            }
        }

        File getFile() {
            String string = this.getPath();
            return string == null || string.length() == 0 ? null : new File(string);
        }

        String getPath() {
            if (this.currPathComp == this.field) {
                return this.field.getText();
            }
            if (this.currPathComp == this.combo) {
                Component component = this.combo.getEditor().getEditorComponent();
                if (component.isShowing() && component instanceof JTextField) {
                    return ((JTextField)component).getText();
                }
                return (String)this.combo.getSelectedItem();
            }
            throw new IllegalStateException();
        }

        void setDocumentListener(DocumentListener documentListener) {
            this.field.getDocument().addDocumentListener(documentListener);
            this.listener = documentListener;
        }

        private void setPathComponent(JComponent jComponent) {
            if (jComponent != this.currPathComp) {
                if (this.currPathComp != null) {
                    this.remove(this.currPathComp);
                }
                this.add((Component)jComponent, "Center");
                jComponent.setEnabled(this.isEnabled());
                this.label.setLabelFor(jComponent);
                this.currPathComp = jComponent;
            }
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == QuickStartWizard.this.nextBtn) {
                QuickStartWizard.this.doNext();
            } else if (object == QuickStartWizard.this.backBtn) {
                QuickStartWizard.this.doBack();
            } else if (object == QuickStartWizard.this.doneBtn) {
                QuickStartWizard.this.doDone();
            } else {
                System.err.println("QSG.Listener " + actionEvent);
            }
        }
    }
}

