/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.NewReportDialog;
import com.sun.javatest.exec.ReportBrowser;
import com.sun.javatest.report.Report;
import com.sun.javatest.report.ReportDirChooser;
import com.sun.javatest.tool.FileHistory;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.PrefixMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class ReportHandler {
    private Action newReportAction;
    private Action openReportAction;
    private static final String REPORT_PREFIX = "report";
    private JComponent parent;
    private UIFactory uif;
    private FileHistory.Listener reportHistoryListener;
    private FileHistory history;
    private Map lastState;
    private ExecModel model;
    private NewReportDialog newReportD;
    private ReportBrowser reportBrowser;
    private ReportDirChooser reportDirChooser;
    private WorkDirectory workDir;

    ReportHandler(JComponent jComponent, ExecModel execModel, UIFactory uIFactory) {
        this.parent = jComponent;
        this.model = execModel;
        this.uif = uIFactory;
        this.initActions();
    }

    JMenu getMenu() {
        Action[] actionArray = new Action[]{this.newReportAction, this.openReportAction, null};
        JMenu jMenu = this.uif.createMenu("rpth", actionArray);
        this.reportHistoryListener = new FileHistory.Listener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                File file = (File)jMenuItem.getClientProperty(FileHistory.FILE);
                if (file != null) {
                    ReportHandler.this.showReportBrowser(file);
                }
            }
        });
        jMenu.addMenuListener(this.reportHistoryListener);
        return jMenu;
    }

    void showReportDialog(int n) {
        ReportDirChooser reportDirChooser = this.getReportDirChooser();
        reportDirChooser.setMode(n);
        int n2 = reportDirChooser.showDialog(this.parent);
        if (n2 != 0) {
            return;
        }
        if (n != 0 && n == 1) {
            File file = reportDirChooser.getSelectedReportDirectory();
            this.showReportBrowser(file);
            this.history.add(file);
        }
    }

    void showNewReportDialog() {
        if (this.newReportD == null) {
            this.newReportD = new NewReportDialog(this.parent, this.uif, this.model.getFilterConfig(), this.getReportBrowser());
            this.newReportD.addObserver(new NewReportDialog.Observer(){

                public void update(Map map) {
                    ReportHandler.this.lastState = map;
                    String string = (String)ReportHandler.this.lastState.get("reportDir");
                    if (string != null) {
                        ReportHandler.this.history.add(new File(string));
                    }
                }
            });
        }
        this.newReportD.setInterviewParameters(this.model.getInterviewParameters());
        if (this.lastState != null) {
            this.newReportD.setLastState(this.lastState);
        }
        this.newReportD.setVisible(true);
    }

    void showReportBrowser(File file) {
        String[] stringArray = Report.getHtmlReportFilenames();
        File file2 = file;
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i]);
            if (!file3.exists() || file3.lastModified() <= l) continue;
            file2 = file3;
            l = file3.lastModified();
        }
        this.getReportBrowser().show(file2);
    }

    ReportBrowser getReportBrowser() {
        if (this.reportBrowser == null) {
            this.reportBrowser = new ReportBrowser(this.parent, this.model, this.uif, this);
        }
        return this.reportBrowser;
    }

    ReportDirChooser getReportDirChooser() {
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        return this.reportDirChooser;
    }

    Action getNewReportAction() {
        return this.newReportAction;
    }

    Action getOpenReportAction() {
        return this.openReportAction;
    }

    void updateGUI() {
        this.workDir = this.model.getWorkDirectory();
        boolean bl = this.workDir != null;
        this.newReportAction.setEnabled(bl);
        this.openReportAction.setEnabled(bl);
        if (!bl) {
            return;
        }
        if (this.history == null) {
            this.history = FileHistory.getFileHistory(this.workDir, "reportDirHistory.jtl");
            this.reportHistoryListener.setFileHistory(this.history);
        }
    }

    void save(Map map) {
        if (this.lastState != null && this.lastState.size() > 0) {
            PrefixMap prefixMap = new PrefixMap(map, REPORT_PREFIX);
            prefixMap.putAll(this.lastState);
        }
    }

    void restore(Map map) {
        PrefixMap prefixMap = new PrefixMap(map, REPORT_PREFIX);
        if (prefixMap == null) {
            return;
        }
        Object[] objectArray = prefixMap.keySet().toArray();
        if (this.lastState == null) {
            this.lastState = new HashMap();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((String)objectArray[i]).substring(REPORT_PREFIX.length() + 1);
            String string2 = (String)prefixMap.get(objectArray[i]);
            if (string2 == null) continue;
            this.lastState.put(string, string2);
        }
    }

    void dispose() {
        if (this.newReportD != null) {
            this.newReportD.dispose();
        }
        if (this.reportBrowser != null) {
            this.reportBrowser.dispose();
        }
        if (this.uif != null) {
            this.uif.dispose();
        }
        this.workDir = null;
        this.model = null;
        this.lastState = null;
    }

    private void initActions() {
        this.newReportAction = new ToolAction(this.uif, "rpth.new"){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportHandler.this.showNewReportDialog();
            }
        };
        this.openReportAction = new ToolAction(this.uif, "rpth.open"){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportHandler.this.showReportDialog(1);
            }
        };
    }
}

