/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.Monitor;
import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.tool.UIFactory;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.Timer;

class RunProgressMonitor
extends Monitor
implements MonitorState.Observer {
    private JProgressBar smMeter;
    private Timer pmTimer;
    private ActionListener pmUpdate;
    private static final int TIMER_FREQ = 3;
    private static final int TIMER_INITIAL = 1;

    RunProgressMonitor(MonitorState monitorState, UIFactory uIFactory) {
        super(monitorState, uIFactory);
        monitorState.addObserver(this);
    }

    public String getSmallMonitorName() {
        return this.uif.getI18NString("runprog.smName");
    }

    public Icon getSmallMonitorIcon() {
        return null;
    }

    public JComponent getSmallMonitor() {
        this.smMeter = this.uif.createProgressBar("runprog.sm", 0);
        this.smMeter.setMinimum(0);
        this.smMeter.setStringPainted(true);
        this.smMeter.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5), BorderFactory.createLineBorder(Color.black)));
        CSH.setHelpIDString(this.smMeter, "run.testProgress");
        return this.smMeter;
    }

    public String getLargeMonitorName() {
        return this.uif.getI18NString("runprog.lgName");
    }

    public Icon getLargeMonitorIcon() {
        return null;
    }

    public JComponent getLargeMonitor() {
        return null;
    }

    public void starting() {
        if (this.pmUpdate == null) {
            this.pmUpdate = new ActionListener(){
                private int lastDone = 0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.lastDone != RunProgressMonitor.this.state.getTestsDoneCount()) {
                        RunProgressMonitor.this.smMeter.setMaximum(RunProgressMonitor.this.state.getTestsFoundCount());
                        this.lastDone = RunProgressMonitor.this.state.getTestsDoneCount();
                        RunProgressMonitor.this.smMeter.setValue(this.lastDone);
                    }
                }
            };
        }
        if (this.pmTimer == null) {
            this.pmTimer = new Timer(3, this.pmUpdate);
            this.pmTimer.setInitialDelay(1);
            this.pmTimer.setCoalesce(false);
            this.pmTimer.setRepeats(true);
        }
        if (this.pmTimer.isRunning()) {
            this.pmTimer.restart();
        } else {
            this.pmTimer.start();
        }
    }

    public void postProcessing() {
        this.stopAll();
    }

    public void stopping() {
    }

    public void finished(boolean bl) {
    }

    private void stopAll() {
        if (this.pmTimer != null && this.pmTimer.isRunning()) {
            this.pmTimer.stop();
        }
        if (this.state.getTestsDoneCount() == this.state.getTestsFoundCount()) {
            this.smMeter.setValue(this.smMeter.getMaximum());
        }
    }
}

