/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BinaryTestFinder
extends TestFinder {
    private File jtdFile;
    private ZipFile zipFile;
    private ZipEntry stringsEntry;
    private ZipEntry testsEntry;
    private ZipEntry treeEntry;
    private StringTable stringTable;
    private TestTable testTable;
    private TestTree testTree;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$finder$BinaryTestFinder == null ? (class$com$sun$javatest$finder$BinaryTestFinder = BinaryTestFinder.class$("com.sun.javatest.finder.BinaryTestFinder")) : class$com$sun$javatest$finder$BinaryTestFinder);
    static /* synthetic */ Class class$com$sun$javatest$finder$BinaryTestFinder;

    public BinaryTestFinder() {
    }

    public BinaryTestFinder(File file) throws TestFinder.Fault {
        this.jtdFile = file;
        this.openBinaryFile();
    }

    public BinaryTestFinder(File file, File file2) throws TestFinder.Fault {
        this.init(file, file2);
    }

    public void init(String[] stringArray, File file, TestEnvironment testEnvironment) throws TestFinder.Fault {
        super.init(stringArray, file, testEnvironment);
        this.openBinaryFile();
    }

    public void init(File file, File file2) throws TestFinder.Fault {
        super.init(null, file, null);
        this.jtdFile = file2;
        this.openBinaryFile();
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if (stringArray[n].equalsIgnoreCase("-binary") || stringArray[n].equalsIgnoreCase("-jtd")) {
            String string = stringArray[n + 1];
            this.jtdFile = new File(string);
            return 2;
        }
        if (n == stringArray.length - 1 && !stringArray[n].startsWith("-")) {
            this.jtdFile = new File(stringArray[n]);
            return 1;
        }
        return super.decodeArg(stringArray, n);
    }

    protected void scan(File file) {
        if (this.zipFile != null) {
            this.readBinaryFile();
        }
        try {
            TestTree.Node node;
            File file2 = this.getRootDir();
            String string = this.getRelativePath(file2, file);
            TestTree.Node node2 = node = this.testTree == null ? null : this.testTree.getNode(string);
            if (node == null) {
                this.error(i18n, "bin.cantFindPath", file.getPath());
                return;
            }
            TestTree.Node[] nodeArray = node.children;
            if (nodeArray != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    File file3 = string.length() == 0 ? new File(nodeArray[i].name) : new File(string, nodeArray[i].name);
                    this.foundFile(file3);
                }
            }
            if (node.testIndexes != null) {
                File file4 = new File(string);
                for (int i = 0; i < node.testIndexes.length; ++i) {
                    TestDescription testDescription = node.getTest(i, file2, file4, this.testTable);
                    this.foundTestDescription(testDescription);
                }
            }
        }
        catch (IOException iOException) {
            this.error(i18n, "bin.internalIOError", new Object[]{file.getPath(), iOException});
        }
    }

    private String getRelativePath(File file, File file2) {
        if (file2.isAbsolute()) {
            String string = file.getPath();
            String string2 = file2.getPath();
            if (string2.startsWith(string)) {
                return string2.equals(string) ? "" : string2.substring(string.length() + 1);
            }
            throw new IllegalArgumentException();
        }
        return file2.getPath();
    }

    private void openBinaryFile() throws TestFinder.Fault {
        try {
            if (this.jtdFile == null) {
                throw new TestFinder.Fault(i18n, "bin.noFile");
            }
            File file = this.getRoot();
            File file2 = this.jtdFile.isAbsolute() || file == null ? this.jtdFile : new File(file, this.jtdFile.getPath());
            this.zipFile = new ZipFile(file2);
            this.stringsEntry = this.zipFile.getEntry("strings");
            this.testsEntry = this.zipFile.getEntry("tests");
            this.treeEntry = this.zipFile.getEntry("tree");
            if (this.stringsEntry == null || this.testsEntry == null || this.treeEntry == null) {
                throw new TestFinder.Fault(i18n, "bin.badBinFile", this.zipFile.getName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TestFinder.Fault(i18n, "bin.cantFindFile", this.jtdFile.getPath());
        }
        catch (IOException iOException) {
            throw new TestFinder.Fault(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readBinaryFile() {
        block12: {
            if (this.zipFile == null) {
                throw new IllegalStateException();
            }
            this.stringTable = StringTable.read(this.zipFile, this.stringsEntry);
            this.testTable = TestTable.read(this.zipFile, this.testsEntry, this.stringTable);
            this.testTree = TestTree.read(this.zipFile, this.treeEntry);
            Object var3_1 = null;
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException});
            }
            this.stringsEntry = null;
            this.testsEntry = null;
            this.treeEntry = null;
            this.zipFile = null;
            {
                break block12;
                catch (TestFinder.Fault fault) {
                    this.error(i18n, "bin.fault", new Object[]{this.jtdFile.getPath(), fault});
                    Object var3_2 = null;
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException iOException) {
                        this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException});
                    }
                    this.stringsEntry = null;
                    this.testsEntry = null;
                    this.treeEntry = null;
                    this.zipFile = null;
                    break block12;
                }
                catch (IOException iOException) {
                    this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException});
                    Object var3_3 = null;
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException iOException2) {
                        this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException2});
                    }
                    this.stringsEntry = null;
                    this.testsEntry = null;
                    this.treeEntry = null;
                    this.zipFile = null;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    this.zipFile.close();
                }
                catch (IOException iOException) {
                    this.error(i18n, "bin.ioError", new Object[]{this.jtdFile.getPath(), iOException});
                }
                this.stringsEntry = null;
                this.testsEntry = null;
                this.treeEntry = null;
                this.zipFile = null;
                throw throwable;
            }
        }
    }

    private static int readInt(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = 0;
        while ((n = dataInputStream.readUnsignedByte()) >= 128) {
            n2 = n2 << 7 | n & 0x7F;
        }
        n2 = n2 << 7 | n;
        return n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TestTree {
        private Node root;

        static TestTree read(ZipFile zipFile, ZipEntry zipEntry) throws IOException, TestFinder.Fault {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
            Node node = new Node(dataInputStream);
            return new TestTree(node);
        }

        TestTree(Node node) {
            this.root = node;
        }

        Node getNode(String string) {
            return string.length() == 0 ? this.root : this.root.getNode(string);
        }

        static class Node {
            private String name;
            private int[] testIndexes;
            private Node[] children;

            Node(DataInputStream dataInputStream) throws IOException {
                int n;
                this.name = dataInputStream.readUTF();
                int n2 = BinaryTestFinder.readInt(dataInputStream);
                if (n2 > 0) {
                    this.testIndexes = new int[n2];
                    for (n = 0; n < this.testIndexes.length; ++n) {
                        this.testIndexes[n] = BinaryTestFinder.readInt(dataInputStream);
                    }
                }
                if ((n = BinaryTestFinder.readInt(dataInputStream)) > 0) {
                    this.children = new Node[n];
                    for (int i = 0; i < this.children.length; ++i) {
                        this.children[i] = new Node(dataInputStream);
                    }
                }
            }

            Node getNode(String string) {
                int n = string.indexOf(File.separatorChar);
                String string2 = n == -1 ? string : string.substring(0, n);
                for (int i = 0; i < this.children.length; ++i) {
                    Node node = this.children[i];
                    if (!node.name.equals(string2)) continue;
                    return n == -1 ? node : node.getNode(string.substring(n + 1));
                }
                return null;
            }

            TestDescription getTest(int n, File file, File file2, TestTable testTable) throws IOException {
                if (this.testIndexes == null || n > this.testIndexes.length) {
                    throw new IllegalArgumentException();
                }
                return testTable.get(file, file2, this.testIndexes[n]);
            }
        }
    }

    static class TestTable {
        private ByteArrayInputStream bais;
        private StringTable stringTable;

        static TestTable read(ZipFile zipFile, ZipEntry zipEntry, StringTable stringTable) throws IOException, TestFinder.Fault {
            byte[] byArray = new byte[(int)zipEntry.getSize()];
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            for (int i = 0; i < byArray.length; i += inputStream.read(byArray, i, byArray.length - i)) {
            }
            return new TestTable(byArray, stringTable);
        }

        TestTable(byte[] byArray, StringTable stringTable) {
            this.bais = new ByteArrayInputStream(byArray);
            this.stringTable = stringTable;
        }

        TestDescription get(File file, File file2, int n) throws IOException {
            this.bais.reset();
            this.bais.skip(n);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DataInputStream dataInputStream = new DataInputStream(this.bais);
            int n2 = BinaryTestFinder.readInt(dataInputStream);
            for (int i = 0; i < n2; ++i) {
                String string = this.stringTable.readRef(dataInputStream);
                String string2 = this.stringTable.readRef(dataInputStream);
                hashMap.put(string, string2);
            }
            return new TestDescription(file, file2, hashMap);
        }
    }

    static class StringTable {
        private String[] strings;

        static StringTable read(ZipFile zipFile, ZipEntry zipEntry) throws IOException, TestFinder.Fault {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
            return new StringTable(dataInputStream);
        }

        StringTable(DataInputStream dataInputStream) throws IOException {
            int n = BinaryTestFinder.readInt(dataInputStream);
            this.strings = new String[n];
            for (int i = 0; i < n; ++i) {
                this.strings[i] = dataInputStream.readUTF();
            }
        }

        String readRef(DataInputStream dataInputStream) throws IOException {
            int n = BinaryTestFinder.readInt(dataInputStream);
            if (n == 0) {
                return dataInputStream.readUTF();
            }
            return this.strings[n];
        }

        String get(int n) {
            return this.strings[n];
        }
    }
}

