/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import java.io.PrintWriter;

public class MultiStatus {
    private int iTestCases = 0;
    private int iPassed = 0;
    private int iFail = 0;
    private int iError = 0;
    private int iBad = 0;
    private String firstTestCase = "";
    private PrintWriter out = null;

    public MultiStatus() {
    }

    public MultiStatus(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public int getTestCount() {
        return this.iTestCases;
    }

    public void add(String string, Status status) {
        if (this.out != null) {
            this.out.println(string + ": " + status);
        }
        ++this.iTestCases;
        if (status != null) {
            int n = status.getType();
            switch (n) {
                case 0: {
                    ++this.iPassed;
                    break;
                }
                case 1: {
                    ++this.iFail;
                    break;
                }
                case 2: {
                    ++this.iError;
                    break;
                }
                default: {
                    ++this.iBad;
                }
            }
            if (n != 0 && this.firstTestCase.length() == 0) {
                this.firstTestCase = string;
            }
        }
    }

    public Status getStatus() {
        String string;
        if (this.out != null) {
            this.out.flush();
        }
        if (this.iTestCases == 0) {
            string = "No tests cases found (or all test cases excluded.)";
        } else {
            string = "test cases: " + this.iTestCases;
            if (this.iPassed > 0) {
                string = this.iPassed == this.iTestCases ? string + "; all passed" : string + "; passed: " + this.iPassed;
            }
            if (this.iFail > 0) {
                string = this.iFail == this.iTestCases ? string + "; all failed" : string + "; failed: " + this.iFail;
            }
            if (this.iError > 0) {
                string = this.iError == this.iTestCases ? string + "; all had an error" : string + "; error: " + this.iError;
            }
            if (this.iBad > 0) {
                string = this.iBad == this.iTestCases ? string + "; all bad" : string + "; bad status: " + this.iBad;
            }
        }
        if (this.iBad > 0) {
            return Status.error(string + "; first bad test case result found: " + this.firstTestCase);
        }
        if (this.iError > 0) {
            return Status.error(string + "; first test case with error: " + this.firstTestCase);
        }
        if (this.iFail > 0) {
            return Status.failed(string + "; first test case failure: " + this.firstTestCase);
        }
        return Status.passed(string);
    }

    public static Status overallStatus(String[] stringArray, Status[] statusArray, PrintWriter printWriter) {
        if (stringArray.length != statusArray.length) {
            return Status.failed("mismatched array sizes; test cases: " + stringArray.length + " statuses: " + statusArray.length);
        }
        MultiStatus multiStatus = new MultiStatus(printWriter);
        for (int i = 0; i < statusArray.length; ++i) {
            multiStatus.add(stringArray[i], statusArray[i]);
        }
        return multiStatus.getStatus();
    }

    public static Status overallStatus(String[] stringArray, Status[] statusArray) {
        return MultiStatus.overallStatus(stringArray, statusArray, null);
    }
}

