/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.lib;

import com.sun.javatest.Status;
import com.sun.javatest.Test;
import com.sun.javatest.lib.MultiStatus;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TestCases {
    private Object test;
    private Class testClass;
    private Hashtable selectedCases = new Hashtable();
    private Hashtable excludedCases = new Hashtable();
    private PrintWriter log;
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    static /* synthetic */ Class class$com$sun$javatest$Status;
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public TestCases(Test test, PrintWriter printWriter) {
        this.test = test;
        this.log = printWriter;
        this.testClass = test.getClass();
    }

    public void select(String string) throws Fault {
        this.select(this.split(string));
    }

    public void select(String[] stringArray) throws Fault {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.selectedCases.put(string, this.getTestCase(string));
        }
    }

    public void exclude(String string) throws Fault {
        this.exclude(this.split(string));
    }

    public void exclude(String[] stringArray) throws Fault {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.excludedCases.put(string, this.getTestCase(string));
        }
    }

    public Enumeration enumerate() {
        Vector<Method> vector = new Vector<Method>();
        if (this.selectedCases.isEmpty()) {
            Method[] methodArray = this.testClass.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (this.excludedCases.get(method.getName()) != null) continue;
                Class<?>[] classArray = method.getParameterTypes();
                Class<?> clazz = method.getReturnType();
                if (classArray.length != 0 || !(class$com$sun$javatest$Status == null ? TestCases.class$("com.sun.javatest.Status") : class$com$sun$javatest$Status).isAssignableFrom(clazz)) continue;
                vector.addElement(method);
            }
        } else {
            Enumeration enumeration = this.selectedCases.elements();
            while (enumeration.hasMoreElements()) {
                Method method = (Method)enumeration.nextElement();
                if (this.excludedCases.get(method.getName()) != null) continue;
                vector.addElement(method);
            }
        }
        return vector.elements();
    }

    public Status invokeTestCases() {
        Method method;
        try {
            method = this.testClass.getMethod("invokeTestCase", class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = TestCases.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
            if (!(class$com$sun$javatest$Status == null ? (class$com$sun$javatest$Status = TestCases.class$("com.sun.javatest.Status")) : class$com$sun$javatest$Status).isAssignableFrom(method.getReturnType())) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        MultiStatus multiStatus = new MultiStatus(this.log);
        Enumeration enumeration = this.enumerate();
        while (enumeration.hasMoreElements()) {
            Status status;
            Method method2 = (Method)enumeration.nextElement();
            try {
                status = method != null ? (Status)method.invoke(this.test, method2) : (Status)method2.invoke(this.test, noArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
                status = Status.failed("Could not access test case: " + method2.getName());
            }
            catch (InvocationTargetException invocationTargetException) {
                this.printStackTrace(invocationTargetException.getTargetException());
                status = Status.failed("Exception from test case: " + invocationTargetException.getTargetException().toString());
            }
            catch (ThreadDeath threadDeath) {
                this.printStackTrace(threadDeath);
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.printStackTrace(throwable);
                status = Status.failed("Unexpected Throwable: " + throwable);
            }
            multiStatus.add(method2.getName(), status);
        }
        if (multiStatus.getTestCount() == 0) {
            return Status.passed("Test passed by default: no test cases executed.");
        }
        return multiStatus.getStatus();
    }

    protected void printStackTrace(Throwable throwable) {
        if (this.log != null) {
            throwable.printStackTrace(this.log);
        }
    }

    private Method getTestCase(String string) throws Fault {
        try {
            Method method = this.testClass.getMethod(string, noArgTypes);
            if (!(class$com$sun$javatest$Status == null ? (class$com$sun$javatest$Status = TestCases.class$("com.sun.javatest.Status")) : class$com$sun$javatest$Status).isAssignableFrom(method.getReturnType())) {
                throw new Fault("Method for test case '" + string + "' has wrong return type");
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Fault("Could not find test case: " + string);
        }
        catch (SecurityException securityException) {
            throw new Fault(securityException.toString());
        }
    }

    private String[] split(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(44);
        while (n2 != -1) {
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(44, n);
        }
        if (n != string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Fault
    extends Exception {
        public Fault(String string) {
            super(string);
        }
    }
}

