/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.Interview;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.VerboseCommand;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CommandContext {
    private Vector commands = new Vector();
    private File testSuitePath;
    private File workDirectoryPath;
    private boolean autoCreateWorkDirectory;
    private File configFilePath;
    private InterviewParameters config;
    private Command autoRunCommand;
    private File autoRunReportDir;
    private boolean closeDesktopWhenDoneEnabled;
    private Desktop desktop;
    private PrintWriter out;
    private int[] cumulativeTestStats = new int[4];
    private HashMap verboseOptionValues = new HashMap();
    private boolean verboseMax;
    private boolean verboseQuiet;
    private boolean verboseDate = true;
    private boolean errors;
    private Harness.Observer[] harnessObservers = new Harness.Observer[0];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$CommandContext == null ? (class$com$sun$javatest$tool$CommandContext = CommandContext.class$("com.sun.javatest.tool.CommandContext")) : class$com$sun$javatest$tool$CommandContext);
    static final String VERBOSE_COMMANDS = "commands";
    static final String TRACE_PREFIX = "+ ";
    static /* synthetic */ Class class$com$sun$javatest$tool$CommandContext;

    public CommandContext() {
        this(new PrintWriter(System.err));
    }

    public CommandContext(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public Command[] getCommands() {
        Object[] objectArray = new Command[this.commands.size()];
        this.commands.copyInto(objectArray);
        return objectArray;
    }

    public void runCommands() throws Fault {
        boolean bl = false;
        for (int i = 0; i < this.commands.size(); ++i) {
            Command command = (Command)this.commands.elementAt(i);
            bl |= command.isActionCommand();
            boolean bl2 = this.getVerboseOptionValue(VERBOSE_COMMANDS, false);
            if (bl2) {
                this.out.println(TRACE_PREFIX + command.toString());
            }
            try {
                command.run(this);
                continue;
            }
            catch (Command.Fault fault) {
                throw new Fault(fault);
            }
        }
        if (!bl && this.autoRunCommand != null) {
            try {
                this.autoRunCommand.run(this);
            }
            catch (Command.Fault fault) {
                throw new Fault(i18n, "cc.errorInDefault", fault.getMessage());
            }
        }
    }

    public void addHarnessObserver(Harness.Observer observer) {
        this.harnessObservers = (Harness.Observer[])DynamicArray.append(this.harnessObservers, observer);
    }

    public Harness.Observer[] getHarnessObservers() {
        return this.harnessObservers;
    }

    public Command getAutoRunCommand() {
        return this.autoRunCommand;
    }

    public void setAutoRunCommand(Command command) {
        this.autoRunCommand = command;
    }

    public File getAutoRunReportDir() {
        return this.autoRunReportDir;
    }

    public void setAutoRunReportDir(File file) {
        this.autoRunReportDir = file;
    }

    public void addTestStats(int[] nArray) {
        if (nArray.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            this.cumulativeTestStats[n] = this.cumulativeTestStats[n] + nArray[i];
        }
    }

    public int[] getTestStats() {
        int[] nArray = new int[4];
        System.arraycopy(this.cumulativeTestStats, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public boolean isCloseDesktopWhenDoneEnabled() {
        return this.closeDesktopWhenDoneEnabled;
    }

    public void setCloseDesktopWhenDoneEnabled(boolean bl) {
        this.closeDesktopWhenDoneEnabled = bl;
    }

    public boolean isTestSuiteSet() {
        return this.hasConfig();
    }

    public TestSuite getTestSuite() throws Fault {
        this.initConfig();
        return this.config.getTestSuite();
    }

    public void setTestSuite(File file) throws Fault {
        if (this.testSuitePath != null && !this.testSuitePath.equals(file)) {
            throw new Fault(i18n, "cc.tsAlreadySet", this.testSuitePath);
        }
        this.testSuitePath = file;
    }

    public void setTestSuite(TestSuite testSuite) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = testSuite.createInterview();
        } else if (this.config.getTestSuite() != testSuite) {
            throw new Fault(i18n, "cc.tsAlreadySet", this.testSuitePath);
        }
    }

    public boolean isWorkDirectorySet() {
        return this.hasConfig() && this.config.getWorkDirectory() != null;
    }

    public WorkDirectory getWorkDirectory() throws Fault {
        this.initConfig();
        return this.config.getWorkDirectory();
    }

    public void setWorkDirectory(File file) throws Fault {
        this.setWorkDirectory(file, false);
    }

    public void setWorkDirectory(File file, boolean bl) throws Fault {
        if (this.workDirectoryPath != null && !this.workDirectoryPath.equals(file)) {
            throw new Fault(i18n, "cc.wdAlreadySet", this.workDirectoryPath);
        }
        this.autoCreateWorkDirectory = bl;
        this.workDirectoryPath = file;
    }

    public void setWorkDirectory(WorkDirectory workDirectory) throws Fault, TestSuite.Fault {
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config == null) {
            this.config = workDirectory.getTestSuite().createInterview();
        } else {
            if (workDirectory.getTestSuite() != this.config.getTestSuite()) {
                throw new Fault(i18n, "cc.wdTestSuiteMismatch", new Object[]{workDirectory.getRoot(), this.config.getTestSuite().getRoot()});
            }
            WorkDirectory workDirectory2 = this.config.getWorkDirectory();
            if (workDirectory2 != null && workDirectory2 != workDirectory) {
                throw new Fault(i18n, "cc.wdAlreadySet", this.workDirectoryPath);
            }
        }
        this.config.setWorkDirectory(workDirectory);
    }

    public InterviewParameters getInterviewParameters() throws Fault {
        return this.getConfig();
    }

    public InterviewParameters getConfig() throws Fault {
        this.initConfig();
        return this.config;
    }

    public boolean hasConfig() {
        return this.config != null || this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null;
    }

    public void setConfig(File file) throws Fault {
        if (this.config != null) {
            if (this.configFilePath == null) {
                throw new Fault(i18n, "cc.confAlreadySetDefault", file);
            }
            throw new Fault(i18n, "cc.confAlreadySet", new Object[]{file, this.configFilePath});
        }
        this.configFilePath = file;
    }

    public void setInterviewParameters(InterviewParameters interviewParameters) throws Fault {
        WorkDirectory workDirectory;
        if (this.isInitConfigRequired()) {
            this.initConfig();
        }
        if (this.config != null) {
            if (this.config.getTestSuite() != interviewParameters.getTestSuite()) {
                throw new Fault(i18n, "cc.confTestSuiteMismatch", new Object[]{this.config.getTestSuite().getRoot()});
            }
            workDirectory = this.config.getWorkDirectory();
            WorkDirectory workDirectory2 = interviewParameters.getWorkDirectory();
            if (workDirectory != null && workDirectory2 != null && workDirectory2 != workDirectory) {
                throw new Fault(i18n, "cc.confWorkDirMismatch", new Object[]{workDirectory.getRoot()});
            }
        } else {
            workDirectory = null;
        }
        this.config = interviewParameters;
        if (this.config.getWorkDirectory() == null && workDirectory != null) {
            this.config.setWorkDirectory(workDirectory);
        }
    }

    private boolean isInitConfigRequired() {
        return this.config == null && (this.testSuitePath != null || this.workDirectoryPath != null || this.configFilePath != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initConfig() throws Fault {
        block35: {
            block34: {
                WorkDirectory workDirectory;
                File file;
                Object object;
                Properties properties;
                if (this.config != null) {
                    return;
                }
                if (this.workDirectoryPath == null || !this.autoCreateWorkDirectory && !WorkDirectory.isEmptyDirectory(this.workDirectoryPath)) break block34;
                if (this.testSuitePath == null) {
                    if (this.configFilePath == null) {
                        throw new Fault(i18n, "cc.noTestSuite");
                    }
                    properties = new Properties();
                    try {
                        object = new BufferedInputStream(new FileInputStream(this.configFilePath));
                        try {
                            properties.load((InputStream)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, runtimeException});
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new Fault(i18n, "cc.cantFindConfig", this.configFilePath);
                    }
                    catch (IOException iOException) {
                        throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, iOException});
                    }
                    object = (String)properties.get("TESTSUITE");
                    if (object == null) {
                        throw new Fault(i18n, "cc.noTestSuiteInConfigFile", this.configFilePath);
                    }
                    file = new File((String)object);
                } else {
                    properties = null;
                    file = this.testSuitePath;
                }
                try {
                    object = TestSuite.open(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new Fault(i18n, "cc.cantFindTS", new Object[]{file, new Integer(this.testSuitePath != null ? 0 : 1), this.configFilePath});
                }
                catch (TestSuite.Fault fault) {
                    throw new Fault(i18n, "cc.cantOpenTS", new Object[]{file, new Integer(this.testSuitePath != null ? 0 : 1), this.configFilePath, fault.getMessage()});
                }
                try {
                    workDirectory = WorkDirectory.create(this.workDirectoryPath, (TestSuite)object);
                }
                catch (WorkDirectory.Fault fault) {
                    throw new Fault(i18n, "cc.cantCreateWD", this.workDirectoryPath);
                }
                if (this.configFilePath == null || properties != null) {
                    try {
                        this.config = ((TestSuite)object).createInterview();
                    }
                    catch (TestSuite.Fault fault) {
                        throw new Fault(i18n, "cc.cantCreateConfig", new Object[]{this.testSuitePath, fault.getMessage()});
                    }
                    try {
                        if (properties != null) {
                            this.config.load((Map)properties, this.configFilePath);
                        }
                    }
                    catch (Interview.Fault fault) {
                        throw new Fault(i18n, "cc.cantOpenConfig", new Object[]{this.configFilePath, fault.getMessage()});
                    }
                    this.config.setWorkDirectory(workDirectory);
                    break block35;
                } else {
                    try {
                        this.config = InterviewParameters.open(this.configFilePath, workDirectory);
                    }
                    catch (IOException iOException) {
                        throw new Fault(i18n, "cc.cantReadConfig", new Object[]{this.configFilePath, iOException});
                    }
                    catch (Interview.Fault fault) {
                        throw new Fault(i18n, "cc.cantOpenConfig", new Object[]{this.configFilePath, fault.getMessage()});
                    }
                }
            }
            try {
                this.config = InterviewParameters.open(this.testSuitePath, this.workDirectoryPath, this.configFilePath);
            }
            catch (Interview.Fault fault) {
                throw new Fault(i18n, "cc.cantInitConfig", fault.getMessage());
            }
        }
        if (this.testSuitePath == null) {
            this.testSuitePath = this.config.getTestSuite().getRoot();
        }
        if (this.workDirectoryPath == null && this.config.getWorkDirectory() != null) {
            this.workDirectoryPath = this.config.getWorkDirectory().getRoot();
        }
        if (this.configFilePath == null) {
            this.configFilePath = this.config.getFile();
        }
    }

    public boolean isDesktopRequired() {
        int n = 0;
        for (int i = 0; i < this.commands.size(); ++i) {
            Command command = (Command)this.commands.elementAt(i);
            n = Math.max(n, command.getDesktopMode());
        }
        return n != 1;
    }

    public void setDesktop(Desktop desktop) {
        if (desktop == null) {
            throw new NullPointerException();
        }
        this.desktop = desktop;
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public void setVerboseMax(boolean bl) {
        this.verboseMax = bl;
    }

    public void setVerboseQuiet(boolean bl) {
        this.verboseQuiet = bl;
    }

    public void setVerboseTimestampEnabled(boolean bl) {
        this.verboseDate = bl;
    }

    public void setVerboseOptionValue(String string, boolean bl) {
        this.verboseOptionValues.put(string.toLowerCase(), new Boolean(bl));
    }

    public boolean getVerboseOptionValue(String string) {
        return this.getVerboseOptionValue(string, false);
    }

    public boolean getVerboseOptionValue(String string, boolean bl) {
        if (this.verboseMax) {
            return true;
        }
        if (this.verboseQuiet) {
            return false;
        }
        Boolean bl2 = (Boolean)this.verboseOptionValues.get(string.toLowerCase());
        return bl2 == null ? bl : bl2;
    }

    public boolean isVerboseOptionSet(String string) {
        return this.verboseOptionValues.get(string.toLowerCase()) != null;
    }

    public boolean isVerboseTimestampEnabled() {
        return this.verboseDate;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public void printMessage(I18NResourceBundle i18NResourceBundle, String string) {
        this.out.println(i18NResourceBundle.getString(string));
    }

    public void printMessage(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.out.println(i18NResourceBundle.getString(string, object));
    }

    public void printMessage(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.out.println(i18NResourceBundle.getString(string, objectArray));
    }

    public void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string) {
        this.out.println(i18NResourceBundle.getString(string));
        this.errors = true;
    }

    public void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.out.println(i18NResourceBundle.getString(string, object));
        this.errors = true;
    }

    public void printErrorMessage(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.out.println(i18NResourceBundle.getString(string, objectArray));
        this.errors = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        VerboseCommand.addOption(VERBOSE_COMMANDS, new HelpTree.Node(i18n, "cc.verbose"));
    }

    public class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }

        Fault(Command.Fault fault) {
            super(fault.getMessage(), fault);
        }

        public CommandContext getContext() {
            return CommandContext.this;
        }
    }
}

