/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.ConfigManager;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ListIterator;

public class CommandParser {
    private CommandManager[] mgrs;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$CommandParser == null ? (class$com$sun$javatest$tool$CommandParser = CommandParser.class$("com.sun.javatest.tool.CommandParser")) : class$com$sun$javatest$tool$CommandParser);
    static final String TRACE_PREFIX = "+ ";
    static /* synthetic */ Class class$com$sun$javatest$tool$CommandParser;

    public CommandParser(CommandManager[] commandManagerArray) {
        this.mgrs = commandManagerArray;
    }

    public void parse(String[] stringArray, CommandContext commandContext) throws Fault {
        this.parse(stringArray, false, commandContext);
    }

    public void parse(String[] stringArray, boolean bl, CommandContext commandContext) throws Fault {
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    stringArray[i] = URLDecoder.decode(stringArray[i], "UTF-8");
                    continue;
                }
                catch (Throwable throwable) {
                    throw new Fault(i18n, "cmdp.cantDecode", new Object[]{stringArray[i], throwable.toString()});
                }
            }
        }
        ListIterator listIterator = CommandParser.getIterator(CommandParser.trim(stringArray));
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            this.decodeArg(string, listIterator, commandContext);
        }
    }

    private void decodeArg(String string, ListIterator listIterator, CommandContext commandContext) throws Fault {
        if (string.equals("/?")) {
            string = "-?";
        }
        if (string.startsWith("@")) {
            File file = new File(string.substring(1));
            this.read(file, commandContext);
            return;
        }
        if (string.startsWith("-")) {
            String string2 = string.substring(1);
            if (string2.equals("read")) {
                if (listIterator.hasNext()) {
                    String string3 = (String)listIterator.next();
                    File file = new File(string3);
                    this.read(file, commandContext);
                    return;
                }
                throw new Fault(i18n, "cmdp.badReadOpt");
            }
            for (int i = 0; i < this.mgrs.length; ++i) {
                CommandManager commandManager = this.mgrs[i];
                try {
                    if (!commandManager.parseCommand(string2, listIterator, commandContext)) continue;
                    return;
                }
                catch (Command.Fault fault) {
                    throw new Fault(fault);
                }
            }
            throw new Fault(i18n, "cmdp.badOpt", string);
        }
        if (string.indexOf(" ") >= 0) {
            try {
                LineParser lineParser = new LineParser(new StringReader(string));
                this.read(lineParser, commandContext);
                return;
            }
            catch (LineParser.Fault fault) {
                throw new Fault(i18n, "cmdp.errorInString", fault.getMessage());
            }
        }
        if (!listIterator.hasNext()) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    commandContext.addCommand(ConfigManager.getOpenCommand(file));
                    return;
                }
            }
            catch (Command.Fault fault) {
                throw new Fault(i18n, "cmdp.badFileOpt", fault.getMessage());
            }
        }
        throw new Fault(i18n, "cmdp.badOpt", string);
    }

    private void read(File file, CommandContext commandContext) throws Fault {
        LineParser lineParser;
        try {
            lineParser = new LineParser(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "cmdp.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "cmdp.cantOpenFile", new Object[]{file, iOException});
        }
        try {
            this.read(lineParser, commandContext);
        }
        catch (Fault fault) {
            throw new Fault(i18n, "cmdp.errorInFile", new Object[]{file, new Integer(lineParser.getLineNumber()), fault.getMessage()});
        }
        catch (LineParser.Fault fault) {
            throw new Fault(i18n, "cmdp.errorInFile", new Object[]{file, new Integer(lineParser.getLineNumber()), fault.getMessage()});
        }
    }

    private void read(LineParser lineParser, CommandContext commandContext) throws Fault, LineParser.Fault {
        String[] stringArray;
        File file = lineParser.getFile();
        block2: while ((stringArray = lineParser.readLine()) != null) {
            Object object;
            ListIterator listIterator = CommandParser.getIterator(stringArray);
            String string = (String)listIterator.next();
            if (string.equals("read")) {
                if (listIterator.hasNext()) {
                    String string2 = (String)listIterator.next();
                    object = new File(string2);
                    if (!((File)object).isAbsolute()) {
                        object = new File(file.getParentFile(), ((File)object).getPath());
                    }
                    if (!listIterator.hasNext()) {
                        this.read((File)object, commandContext);
                        continue;
                    }
                }
                throw new Fault(i18n, "cmdp.badReadCmd");
            }
            for (int i = 0; i < this.mgrs.length; ++i) {
                object = this.mgrs[i];
                try {
                    if (!((CommandManager)object).parseCommand(string, listIterator, commandContext)) continue;
                    if (!listIterator.hasNext()) continue block2;
                    throw new Fault(i18n, "cmdp.excessArgs", string);
                }
                catch (Command.Fault fault) {
                    throw new Fault(fault);
                }
            }
            throw new Fault(i18n, "cmdp.badCmd", string);
        }
    }

    private static String[] trim(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i].trim();
        }
        return stringArray2;
    }

    private static ListIterator getIterator(final String[] stringArray) {
        return new ListIterator(){
            private int index;

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.index < stringArray.length;
            }

            public boolean hasPrevious() {
                return this.index > 0;
            }

            public Object next() {
                return this.index < stringArray.length ? stringArray[this.index++] : null;
            }

            public int nextIndex() {
                return this.index;
            }

            public Object previous() {
                return this.index > 0 ? stringArray[--this.index] : null;
            }

            public int previousIndex() {
                return this.index - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }

        Fault(Command.Fault fault) {
            super(fault.getMessage(), fault);
        }
    }
}

