/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.java.help.impl.JHelpPrintHandler;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.DesktopPrefsPane;
import com.sun.javatest.tool.FileOpener;
import com.sun.javatest.tool.MDIDeskView;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.SDIDeskView;
import com.sun.javatest.tool.TabDeskView;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.HTMLWriter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.LogFile;
import com.sun.javatest.util.SortedProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.WindowPresentation;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.text.JTextComponent;

public class Desktop {
    private static final int CLOSE = 0;
    private static final int EXIT = 1;
    private JDialog confirmDialog;
    public static final int TAB_STYLE = 0;
    public static final int MDI_STYLE = 1;
    public static final int SDI_STYLE = 2;
    static final int NUM_STYLES = 3;
    static final String[] styleNames = new String[]{"tab", "mdi", "sdi"};
    private static final String[] jt31StyleClassNames = new String[]{"com.sun.javatest.tool.TabDesktop", "com.sun.javatest.tool.MDIDesktop", "com.sun.javatest.tool.SDIDesktop"};
    private final UIFactory uif;
    private DeskView currView;
    private int style;
    private Dimension preferredSize;
    private Preferences.Pane prefsPane;
    private ToolManager[] toolManagers;
    private DefaultHelpBroker helpBroker;
    private LogFile logFile;
    private boolean firstTime;
    private boolean saveOnExit;
    private static int frameIndex;
    private LinkedList fileHistory = new LinkedList();
    private static final int FILE_HISTORY_MAX_SIZE = 10;
    private static Preferences preferences;
    static final String STYLE_PREF = "tool.appearance.style";
    static final String TTIP_PREF = "tool.appearance.ttipToggle";
    static final String TTIP_DELAY = "tool.appearance.ttipDelay";
    static final String TTIP_DURATION = "tool.appearance.ttipDuration";
    static final int TTIP_DURATION_FOREVER = -1;
    static final int TTIP_DELAY_NONE = 0;
    static final int TTIP_DELAY_DEFAULT = 0;
    static final int TTIP_DURATION_DEFAULT = 5000;
    static final String SAVE_ON_EXIT_PREF = "tool.appearance.saveOnExit";
    private static final String TOOLMGRLIST = "JavaTest.toolMgrs.lst";
    private static final String defaultToolManager;
    static /* synthetic */ Class class$com$sun$javatest$InterviewParameters;
    static /* synthetic */ Class class$com$sun$javatest$tool$ToolManager;
    static /* synthetic */ Class class$com$sun$javatest$tool$Desktop;

    public Desktop() {
        this(Desktop.getPreferredStyle());
    }

    public Desktop(int n) {
        String string = preferences.getPreference(TTIP_PREF);
        boolean bl = string == null || string.equalsIgnoreCase("true");
        this.setTooltipsEnabled(bl);
        int n2 = Desktop.getTooltipDelay(preferences);
        this.setTooltipDelay(n2);
        int n3 = Desktop.getTooltipDuration(preferences);
        this.setTooltipDuration(n3);
        String string2 = preferences.getPreference(SAVE_ON_EXIT_PREF);
        this.setSaveOnExit(string2 == null || string2.equalsIgnoreCase("true"));
        File file = Desktop.getDesktopFile();
        this.firstTime = file == null || !file.exists();
        this.initHelpBroker();
        this.uif = new UIFactory(this.getClass(), (HelpBroker)this.helpBroker);
        this.initToolManagers();
        this.style = n;
    }

    public int getStyle() {
        return this.currView == null ? this.style : this.currView.getStyle();
    }

    public static int getPreferredStyle() {
        String string = preferences.getPreference(STYLE_PREF);
        int n = Desktop.indexOf(string, styleNames);
        return n != -1 ? n : 0;
    }

    public void setStyle(int n) {
        if (n == this.getStyle()) {
            return;
        }
        if (this.currView == null) {
            this.style = n;
            return;
        }
        DeskView deskView = this.currView;
        switch (n) {
            case 1: {
                this.currView = new MDIDeskView(deskView);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(deskView);
                break;
            }
            case 0: {
                this.currView = new TabDeskView(deskView);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        deskView.dispose();
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public boolean isFirstTime() {
        return this.firstTime;
    }

    public void setFirstTime(boolean bl) {
        this.firstTime = bl;
    }

    public boolean isEmpty() {
        return this.currView == null ? true : this.currView.isEmpty();
    }

    public Tool[] getTools() {
        return this.currView == null ? new Tool[]{} : this.currView.getTools();
    }

    public void addTool(Tool tool) {
        this.ensureViewInitialized();
        this.currView.addTool(tool);
    }

    public void removeTool(Tool tool) {
        if (this.currView != null) {
            this.currView.removeTool(tool);
        }
    }

    public Tool getSelectedTool() {
        return this.currView == null ? null : this.currView.getSelectedTool();
    }

    public void setSelectedTool(Tool tool) {
        this.ensureViewInitialized();
        this.currView.setSelectedTool(tool);
    }

    public void addDefaultTool() {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.addDefaultTool();
                }
            });
            return;
        }
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            if (!toolManager.getClass().getName().equals(defaultToolManager)) continue;
            toolManager.startTool();
            return;
        }
    }

    public void addDefaultTool(InterviewParameters interviewParameters) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            if (!toolManager.getClass().getName().equals(defaultToolManager)) continue;
            try {
                Method method = toolManager.getClass().getMethod("startTool", class$com$sun$javatest$InterviewParameters == null ? (class$com$sun$javatest$InterviewParameters = Desktop.class$("com.sun.javatest.InterviewParameters")) : class$com$sun$javatest$InterviewParameters);
                method.invoke((Object)toolManager, interviewParameters);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public boolean containsTool(Tool tool) {
        Tool[] toolArray = this.getTools();
        for (int i = 0; i < toolArray.length; ++i) {
            if (tool != toolArray[i]) continue;
            return true;
        }
        return false;
    }

    public ToolManager[] getToolManagers() {
        return this.toolManagers;
    }

    public ToolManager getToolManager(Class clazz) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            if (!clazz.isInstance(toolManager)) continue;
            return toolManager;
        }
        return null;
    }

    public ToolManager getToolManager(String string) {
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            if (!toolManager.getClass().getName().equals(string)) continue;
            return toolManager;
        }
        return null;
    }

    public JFrame[] getFrames() {
        this.ensureViewInitialized();
        return this.currView.getFrames();
    }

    public Component getDialogParent() {
        this.ensureViewInitialized();
        return this.currView.getDialogParent();
    }

    public void addToFileHistory(File file, FileOpener fileOpener) {
        Iterator iterator = this.fileHistory.iterator();
        while (iterator.hasNext()) {
            FileHistoryEntry fileHistoryEntry = (FileHistoryEntry)iterator.next();
            if (fileHistoryEntry.fileOpener != fileOpener || !fileHistoryEntry.file.equals(file)) continue;
            iterator.remove();
            break;
        }
        this.fileHistory.addFirst(new FileHistoryEntry(fileOpener, file));
        while (this.fileHistory.size() > 10) {
            this.fileHistory.removeLast();
        }
    }

    List getFileHistory() {
        return this.fileHistory;
    }

    public boolean isVisible() {
        return this.currView == null ? false : this.currView.isVisible();
    }

    public void setVisible(final boolean bl) {
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.setVisible(bl);
                }
            });
            return;
        }
        this.ensureViewInitialized();
        this.currView.setVisible(bl);
    }

    public Container createDialog(Tool tool, String string, String string2, JMenuBar jMenuBar, Container container, Rectangle rectangle) {
        this.ensureViewInitialized();
        return this.currView.createDialog(tool, string, string2, jMenuBar, container, rectangle);
    }

    public boolean isToolOwnerForDialog(Tool tool, Container container) {
        this.ensureViewInitialized();
        return this.currView.isToolOwnerForDialog(tool, container);
    }

    public void checkToolsAndExitIfOK(JFrame jFrame) {
        if (this.isOKToExit(jFrame)) {
            boolean bl = this.getSaveOnExit();
            if (bl) {
                this.save();
            } else {
                File file = Desktop.getDesktopFile();
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            this.dispose();
        }
    }

    public boolean isOKToClose(Tool tool, JFrame jFrame) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        String[] stringArray = tool.getCloseAlerts();
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        return this.isOKToExitOrClose(jFrame, stringArray, 0);
    }

    public boolean isOKToExit(JFrame jFrame) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Vector<String> vector = new Vector<String>();
        Tool[] toolArray = this.getTools();
        for (int i = 0; i < toolArray.length; ++i) {
            String[] stringArray = toolArray[i].getCloseAlerts();
            if (stringArray == null) continue;
            vector.addAll(Arrays.asList(stringArray));
        }
        if (vector.size() == 0) {
            return true;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return this.isOKToExitOrClose(jFrame, (String[])objectArray, 1);
    }

    private boolean isOKToExitOrClose(JFrame jFrame, String[] stringArray, int n) {
        if (this.confirmDialog != null) {
            Toolkit.getDefaultToolkit().beep();
            this.confirmDialog.toFront();
            return false;
        }
        Integer n2 = new Integer(n);
        if (stringArray.length > 0) {
            Object object;
            StringWriter stringWriter = new StringWriter();
            try {
                object = new HTMLWriter((Writer)stringWriter, this.uif.getI18NResourceBundle());
                ((HTMLWriter)object).startTag("html");
                ((HTMLWriter)object).startTag("body");
                ((HTMLWriter)object).writeStyleAttr("font-family: SansSerif");
                ((HTMLWriter)object).startTag("p");
                ((HTMLWriter)object).writeStyleAttr("margin-top:0");
                ((HTMLWriter)object).startTag("b");
                ((HTMLWriter)object).writeI18N("dt.confirm.head", n2);
                ((HTMLWriter)object).endTag("b");
                ((HTMLWriter)object).endTag("p");
                ((HTMLWriter)object).startTag("p");
                ((HTMLWriter)object).startTag("i");
                ((HTMLWriter)object).writeI18N("dt.confirm.warn", n2);
                ((HTMLWriter)object).endTag("i");
                ((HTMLWriter)object).endTag("p");
                ((HTMLWriter)object).startTag("ul");
                ((HTMLWriter)object).writeStyleAttr("margin-top:0; margin-bottom:0; margin-left:30");
                for (int i = 0; i < stringArray.length; ++i) {
                    ((HTMLWriter)object).startTag("li");
                    ((HTMLWriter)object).write(stringArray[i]);
                }
                ((HTMLWriter)object).endTag("ul");
                ((HTMLWriter)object).startTag("p");
                ((HTMLWriter)object).writeStyleAttr("margin-top:5");
                ((HTMLWriter)object).writeI18N("dt.confirm.warn2", n2);
                ((HTMLWriter)object).endTag("p");
                ((HTMLWriter)object).startTag("p");
                ((HTMLWriter)object).writeStyleAttr("margin-bottom:0");
                ((HTMLWriter)object).writeI18N("dt.confirm.tail", n2);
                ((HTMLWriter)object).endTag("p");
                ((HTMLWriter)object).endTag("body");
                ((HTMLWriter)object).endTag("html");
                ((HTMLWriter)object).close();
            }
            catch (IOException iOException) {
                JavaTestError.unexpectedException(iOException);
            }
            object = new JEditorPane();
            ((JComponent)object).setOpaque(false);
            ((JEditorPane)object).setContentType("text/html");
            ((JEditorPane)object).setText(stringWriter.toString());
            ((JTextComponent)object).setEditable(false);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ((Component)object).setSize(new Dimension(5 * this.uif.getDotsPerInch(), Integer.MAX_VALUE));
            String string = this.uif.getI18NString("dt.confirm.title", n2);
            final JOptionPane jOptionPane = new JOptionPane(object, 2);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jOptionPane.setValue(actionEvent.getSource());
                    jOptionPane.setVisible(false);
                }
            };
            JButton jButton = this.uif.createButton("dt.confirm.yes", actionListener);
            JButton jButton2 = this.uif.createButton("dt.confirm.no", actionListener);
            jOptionPane.setOptions(new JComponent[]{jButton, jButton2});
            jOptionPane.setInitialValue(jButton2);
            this.confirmDialog = jOptionPane.createDialog(jFrame, string);
            this.confirmDialog.setVisible(true);
            this.confirmDialog.dispose();
            this.confirmDialog = null;
            if (jOptionPane.getValue() != jButton) {
                return false;
            }
        }
        return true;
    }

    public boolean isOKToAutoExit() {
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setOpaque(false);
        jTextArea.setText(this.uif.getI18NString("dt.autoExit.txt", new Integer(30)));
        jTextArea.setEditable(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTextArea.setSize(new Dimension(4 * this.uif.getDotsPerInch(), Integer.MAX_VALUE));
        final JOptionPane jOptionPane = new JOptionPane(jTextArea, 2, 2);
        String string = this.uif.getI18NString("dt.confirm.title", new Integer(1));
        final JDialog jDialog = jOptionPane.createDialog(null, string);
        Timer timer = new Timer(1000, new ActionListener(){
            private int timeRemaining = 30;

            public void actionPerformed(ActionEvent actionEvent) {
                if (--this.timeRemaining == 0) {
                    jOptionPane.setValue(new Integer(0));
                    jDialog.setVisible(false);
                } else {
                    jTextArea.setText(Desktop.this.uif.getI18NString("dt.autoExit.txt", new Integer(this.timeRemaining)));
                }
            }
        });
        timer.start();
        jDialog.setVisible(true);
        timer.stop();
        Object object = jOptionPane.getValue();
        return object != null && object.equals(new Integer(0));
    }

    public void save() {
        this.save(Desktop.getDesktopFile());
    }

    public void save(File file) {
        Object object;
        if (file == null) {
            return;
        }
        SortedProperties sortedProperties = new SortedProperties();
        int n = this.getStyle();
        if (n < 3) {
            sortedProperties.put("dt.style", styleNames[n]);
            sortedProperties.put("dt.class", jt31StyleClassNames[n]);
        }
        this.ensureViewInitialized();
        this.currView.saveDesktop(sortedProperties);
        sortedProperties.put("file.count", String.valueOf(this.fileHistory.size()));
        int n2 = 0;
        Object object2 = this.fileHistory.iterator();
        while (object2.hasNext()) {
            object = (FileHistoryEntry)object2.next();
            sortedProperties.put("fileHistory." + n2 + ".type", ((FileHistoryEntry)object).fileOpener.getFileType());
            sortedProperties.put("fileHistory." + n2 + ".path", ((FileHistoryEntry)object).file.getPath());
        }
        if (this.helpBroker != null) {
            sortedProperties.put("help.visible", String.valueOf(this.helpBroker.isDisplayed()));
            if (this.helpBroker.getCurrentView() != null) {
                sortedProperties.put("help.view", this.helpBroker.getCurrentView());
            }
            if (this.helpBroker.getCurrentID() != null) {
                sortedProperties.put("help.id", this.helpBroker.getCurrentID().id);
            }
        }
        try {
            object2 = file.getParentFile();
            if (object2 != null && !((File)object2).exists()) {
                ((File)object2).mkdirs();
            }
            object = new BufferedOutputStream(new FileOutputStream(file));
            sortedProperties.store((OutputStream)object, "JavaTest Desktop");
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            System.err.println("Error writing desktop file: " + iOException);
        }
    }

    public void restore() {
        this.restore(Desktop.getDesktopFile());
    }

    public void restore(final File file) {
        Tool[] toolArray;
        Tool tool;
        int n;
        String string;
        String string2;
        FileOpener fileOpener;
        Object object;
        if (!EventQueue.isDispatchThread()) {
            Desktop.invokeOnEventThread(new Runnable(){

                public void run() {
                    Desktop.this.restore(file);
                }
            });
            return;
        }
        Properties properties = new Properties();
        if (file != null && file.exists()) {
            try {
                object = new BufferedInputStream(new FileInputStream(file));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                System.err.println("Error reading desktop file: " + iOException);
            }
        }
        object = new HashMap();
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            FileOpener[] fileOpenerArray = toolManager.getFileOpeners();
            if (fileOpenerArray == null) continue;
            for (int j = 0; j < fileOpenerArray.length; ++j) {
                fileOpener = fileOpenerArray[j];
                ((HashMap)object).put(fileOpener.getFileType(), fileOpener);
            }
        }
        try {
            this.fileHistory.clear();
            string2 = (String)properties.get("file.count");
            if (string2 != null) {
                int n2 = Integer.parseInt(string2);
                for (int i = 0; i < n2; ++i) {
                    try {
                        String string3;
                        String string4 = (String)properties.get("fileHistory." + i + ".type");
                        fileOpener = (FileOpener)((HashMap)object).get(string4);
                        if (fileOpener == null || (string3 = (String)properties.get("fileHistory." + i + ".path")) == null || string3.length() <= 0) continue;
                        this.fileHistory.add(new FileHistoryEntry(fileOpener, new File(string3)));
                        continue;
                    }
                    catch (Throwable throwable) {
                        System.err.println("Error loading saved file: " + throwable);
                        throwable.printStackTrace();
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.helpBroker != null) {
            try {
                String string5;
                string2 = (String)properties.get("help.view");
                if (string2 != null) {
                    this.helpBroker.setCurrentView(string2);
                }
                if ((string5 = (String)properties.get("help.id")) != null) {
                    this.helpBroker.setCurrentID(string5);
                }
                this.helpBroker.setDisplayed("true".equals(properties.get("help.visible")));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.currView != null) {
            this.style = this.currView.getStyle();
            this.currView.dispose();
        }
        if ((string = (String)properties.get("dt.style")) != null) {
            n = Desktop.indexOf(string, styleNames);
        } else {
            String string6 = (String)properties.get("dt.class");
            int n3 = n = string6 == null ? -1 : Desktop.indexOf(string6, jt31StyleClassNames);
        }
        if (n != -1) {
            this.style = n;
        }
        this.ensureViewInitialized();
        this.currView.restoreDesktop(properties);
        if (this.getTools().length == 0) {
            this.addDefaultTool();
        }
        if ((tool = this.getSelectedTool()) == null && (toolArray = this.getTools()).length > 0) {
            tool = toolArray[0];
        }
        if (tool != null) {
            this.setSelectedTool(tool);
        }
        this.setVisible(true);
    }

    public void showPreferences(JFrame jFrame) {
        if (this.prefsPane == null) {
            this.prefsPane = new DesktopPrefsPane(this, this.uif);
        }
        Vector<Preferences.Pane> vector = new Vector<Preferences.Pane>();
        vector.addElement(this.prefsPane);
        for (int i = 0; i < this.toolManagers.length; ++i) {
            ToolManager toolManager = this.toolManagers[i];
            Preferences.Pane pane = toolManager.getPrefsPane();
            if (pane == null) continue;
            vector.addElement(pane);
        }
        Object[] objectArray = new Preferences.Pane[vector.size()];
        vector.copyInto(objectArray);
        preferences.showDialog(jFrame, (Preferences.Pane[])objectArray, this.helpBroker);
    }

    public Icon getLogo() {
        return this.uif.createIcon("dt.logo");
    }

    public void dispose() {
        if (this.currView != null) {
            this.currView.dispose();
        }
        if (this.helpBroker != null && this.helpBroker.isDisplayed()) {
            this.helpBroker.setDisplayed(false);
        }
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string);
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string, object);
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.ensureLogFileInitialized();
        this.logFile.log(i18NResourceBundle, string, objectArray);
    }

    private void ensureLogFileInitialized() {
        if (this.logFile == null) {
            File file;
            Object object;
            String string = System.getProperty("javatest.desktop.log");
            if (string == null) {
                object = new File(System.getProperty("user.home"));
                File file2 = new File((File)object, ".javatest");
                file = new File(file2, "log.txt");
            } else {
                file = string.equals("NONE") ? null : new File(string);
            }
            try {
                object = BackupPolicy.simpleBackups(5);
                ((BackupPolicy)object).backup(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.logFile = file == null ? new LogFile() : new LogFile(file);
        }
    }

    public boolean getSaveOnExit() {
        return this.saveOnExit;
    }

    public void setSaveOnExit(boolean bl) {
        this.saveOnExit = bl;
    }

    static int getTooltipDelay(Preferences preferences) {
        String string = preferences.getPreference(TTIP_DELAY);
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    static int getTooltipDuration(Preferences preferences) {
        String string = preferences.getPreference(TTIP_DURATION);
        int n = 5000;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 5000;
        }
        if (n < 0) {
            n = n == -1 ? Integer.MAX_VALUE : 5000;
        }
        return n;
    }

    void setTooltipsEnabled(boolean bl) {
        ToolTipManager.sharedInstance().setEnabled(bl);
    }

    void setTooltipDelay(int n) {
        ToolTipManager.sharedInstance().setInitialDelay(n);
    }

    void setTooltipDuration(int n) {
        if (n == -1) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        } else {
            ToolTipManager.sharedInstance().setDismissDelay(n);
        }
    }

    public void printSetup() {
        JHelp jHelp = this.getJHelp();
        JHelpPrintHandler jHelpPrintHandler = JHelpPrintHandler.getJHelpPrintHandler(jHelp);
        jHelpPrintHandler.printSetup();
    }

    public void print(URL uRL) {
        JHelp jHelp = this.getJHelp();
        JHelpPrintHandler jHelpPrintHandler = JHelpPrintHandler.getJHelpPrintHandler(jHelp);
        jHelpPrintHandler.print(uRL);
    }

    public void print(File file) {
        try {
            this.print(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            JavaTestError.unexpectedException(malformedURLException);
        }
    }

    private void initHelpBroker() {
        URL uRL = HelpSet.findHelpSet(null, "com/sun/javatest/help/jthelp.hs");
        if (uRL != null) {
            try {
                HelpSet helpSet = new HelpSet(null, uRL);
                this.helpBroker = new DefaultHelpBroker(helpSet);
            }
            catch (HelpSetException helpSetException) {
                // empty catch block
            }
        }
    }

    private JHelp getJHelp() {
        WindowPresentation windowPresentation = this.helpBroker.getWindowPresentation();
        windowPresentation.createHelpWindow();
        JFrame jFrame = (JFrame)windowPresentation.getHelpWindow();
        Container container = jFrame.getContentPane();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof JHelp)) continue;
            return (JHelp)component;
        }
        return null;
    }

    private void initToolManagers() {
        try {
            ManagerLoader managerLoader = new ManagerLoader(class$com$sun$javatest$tool$ToolManager == null ? (class$com$sun$javatest$tool$ToolManager = Desktop.class$("com.sun.javatest.tool.ToolManager")) : class$com$sun$javatest$tool$ToolManager, System.err);
            managerLoader.setManagerConstructorArgs(new Class[]{class$com$sun$javatest$tool$Desktop == null ? (class$com$sun$javatest$tool$Desktop = Desktop.class$("com.sun.javatest.tool.Desktop")) : class$com$sun$javatest$tool$Desktop}, new Object[]{this});
            Set set = managerLoader.loadManagers(TOOLMGRLIST);
            this.toolManagers = set.toArray(new ToolManager[set.size()]);
        }
        catch (IOException iOException) {
            throw new JavaTestError(this.uif.getI18NResourceBundle(), "dt.cantAccessResource", new Object[]{TOOLMGRLIST, iOException});
        }
    }

    private void ensureViewInitialized() {
        if (this.currView != null) {
            return;
        }
        switch (this.style) {
            case 1: {
                this.currView = new MDIDeskView(this);
                break;
            }
            case 2: {
                this.currView = new SDIDeskView(this);
                break;
            }
            default: {
                this.currView = new TabDeskView(this);
            }
        }
    }

    private static void appendStrings(StringBuffer stringBuffer, String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (stringArray[i].endsWith("\n")) continue;
                stringBuffer.append('\n');
            }
        }
    }

    private static File getDesktopFile() {
        String string = System.getProperty("javatest.desktop.file");
        if (string == null) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".javatest");
            return new File(file2, "desktop");
        }
        if (!string.equals("NONE")) {
            return new File(string);
        }
        return null;
    }

    static void addHelpDebugListener(Component component) {
        JRootPane jRootPane;
        if (component instanceof JFrame) {
            jRootPane = ((JFrame)component).getRootPane();
        } else if (component instanceof JDialog) {
            jRootPane = ((JDialog)component).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                Component component2 = SwingUtilities.findFocusOwner(component);
                System.err.println("ALT-F2: source=" + component);
                System.err.println("ALT-F2:  focus=" + component2);
                System.err.println("ALT-F2: helpId=" + (component2 == null ? "(none)" : CSH.getHelpIDString(component2)));
            }
        };
        jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("alt F2"), 2);
    }

    static void addPreferredSizeDebugListener(Component component) {
        JRootPane jRootPane;
        if (component instanceof JFrame) {
            jRootPane = ((JFrame)component).getRootPane();
        } else if (component instanceof JDialog) {
            jRootPane = ((JDialog)component).getRootPane();
        } else {
            throw new IllegalArgumentException();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Component component = (Component)actionEvent.getSource();
                for (Component component2 = SwingUtilities.findFocusOwner(component); component2 != null; component2 = component2.getParent()) {
                    Dimension dimension = component2.getPreferredSize();
                    System.err.println("ALT-1: comp=" + component2.getName() + "(" + component2.getClass().getName() + ") " + "[w:" + dimension.width + ",h:" + dimension.height + "]");
                }
            }
        };
        jRootPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke("alt 1"), 2);
    }

    private static void invokeOnEventThread(Runnable runnable) {
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
    }

    private static int indexOf(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(string == null ? stringArray[i] == null : string.equals(stringArray[i]))) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        preferences = Preferences.access();
        defaultToolManager = System.getProperty("javatest.desktop.defaultToolManager", "com.sun.javatest.exec.ExecToolManager");
    }

    static class FileHistoryEntry {
        FileOpener fileOpener;
        File file;

        FileHistoryEntry(FileOpener fileOpener, File file) {
            this.fileOpener = fileOpener;
            this.file = file;
        }
    }
}

