/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditableList
extends JComponent
implements Accessible {
    protected final UIFactory uif;
    private static UIFactory defaultUIF;
    protected DefaultListModel listModel;
    private JList list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private Listener listener = new Listener();
    private Renderer renderer = new Renderer();
    private boolean duplicatesAllowed;
    static /* synthetic */ Class class$com$sun$javatest$tool$EditableList;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public EditableList() {
        this(new UIFactory(class$com$sun$javatest$tool$EditableList == null ? (class$com$sun$javatest$tool$EditableList = EditableList.class$("com.sun.javatest.tool.EditableList")) : class$com$sun$javatest$tool$EditableList, null), "list");
    }

    private static UIFactory getDefaultUIF() {
        if (defaultUIF == null) {
            defaultUIF = new UIFactory(class$com$sun$javatest$tool$EditableList == null ? (class$com$sun$javatest$tool$EditableList = EditableList.class$("com.sun.javatest.tool.EditableList")) : class$com$sun$javatest$tool$EditableList, null);
        }
        return defaultUIF;
    }

    public EditableList(UIFactory uIFactory, String string) {
        this.uif = uIFactory;
        this.setLayout(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.listModel.addListDataListener(this.listener);
        this.list = uIFactory.createList(string, this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.renderer);
        this.list.addListSelectionListener(this.listener);
        this.add((Component)new JScrollPane(this.list), "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.addBtn = this.createButton(string + ".add");
        jToolBar.add(this.addBtn);
        this.removeBtn = this.createButton(string + ".remove");
        jToolBar.add(this.removeBtn);
        this.upBtn = this.createButton(string + ".up");
        jToolBar.add(this.upBtn);
        this.downBtn = this.createButton(string + ".down");
        jToolBar.add(this.downBtn);
        this.add((Component)jToolBar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
        this.updateButtons();
    }

    public void setItems(Object[] objectArray) {
        this.listModel.clear();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.listModel.addElement(objectArray[i]);
            }
        }
    }

    public void clear() {
        this.listModel.clear();
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.listModel.size());
        this.listModel.copyInto(objectArray);
        return objectArray;
    }

    public String getToolTipText() {
        return this.list.getToolTipText();
    }

    public void setToolTipText(String string) {
        this.list.setToolTipText(string);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EditableList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = EditableList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.duplicatesAllowed = bl;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    protected Object getDisplayValue(Object object) {
        return object;
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)this.uif.getI18NString("list.add.txt"));
    }

    protected Object getNewItem(Object object) {
        return JOptionPane.showInputDialog(this, this.uif.getI18NString("list.change.txt"), object);
    }

    private JButton createButton(String string) {
        JButton jButton = this.uif.createButton(string);
        jButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jButton.addActionListener(this.listener);
        jButton.setMnemonic(this.uif.getI18NString(string + ".mne").charAt(0));
        return jButton;
    }

    private void insertItem() {
        Object object = this.getNewItem();
        if (!this.duplicatesAllowed && this.listModel.contains(object)) {
            this.showDuplicateError(object);
            return;
        }
        if (object != null) {
            if (this.list.isSelectionEmpty()) {
                this.listModel.addElement(object);
            } else {
                this.listModel.add(1 + this.list.getSelectedIndex(), object);
            }
            this.list.setSelectedValue(object, true);
        }
    }

    private void removeSelectedItem() {
        if (!this.list.isSelectionEmpty()) {
            this.listModel.remove(this.list.getSelectedIndex());
        }
    }

    private void moveSelectedItemUp() {
        int n;
        if (!this.list.isSelectionEmpty() && (n = this.list.getSelectedIndex()) > 0) {
            this.swap(n, n - 1);
            this.list.setSelectedIndex(n - 1);
        }
    }

    private void moveSelectedItemDown() {
        int n;
        if (!this.list.isSelectionEmpty() && (n = this.list.getSelectedIndex()) + 1 < this.listModel.size()) {
            this.swap(n, n + 1);
            this.list.setSelectedIndex(n + 1);
        }
    }

    private void editItem(int n) {
        Object object = this.getNewItem(this.listModel.getElementAt(n));
        if (!this.duplicatesAllowed && this.listModel.contains(object)) {
            this.showDuplicateError(object);
            return;
        }
        if (object != null) {
            this.listModel.set(n, object);
        }
    }

    private void showDuplicateError(Object object) {
        String string = this.uif.getI18NString("list.duplicate.text", new Object[]{this.getDisplayValue(object)});
        String string2 = this.uif.getI18NString("list.duplicate.title");
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    private void updateButtons() {
        boolean bl = this.isEnabled();
        this.addBtn.setEnabled(bl);
        if (this.list.isSelectionEmpty() || !bl) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int n = this.list.getSelectedIndex();
            this.upBtn.setEnabled(n > 0);
            this.downBtn.setEnabled(n + 1 < this.listModel.size());
        }
    }

    private void swap(int n, int n2) {
        Object e = this.listModel.elementAt(n);
        Object e2 = this.listModel.elementAt(n2);
        this.listModel.set(n, e2);
        this.listModel.set(n2, e);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener,
    ListDataListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EditableList.this.addBtn) {
                EditableList.this.insertItem();
            } else if (object == EditableList.this.removeBtn) {
                EditableList.this.removeSelectedItem();
            } else if (object == EditableList.this.upBtn) {
                EditableList.this.moveSelectedItemUp();
            } else if (object == EditableList.this.downBtn) {
                EditableList.this.moveSelectedItemDown();
            }
            EditableList.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EditableList.this.updateButtons();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EditableList.this.list.locationToIndex(mouseEvent.getPoint());
                EditableList.this.editItem(n);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (listDataEvent2 == null) {
                    listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                }
                ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent2);
            }
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (listDataEvent2 == null) {
                    listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                }
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent2);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListDataEvent listDataEvent2 = null;
            Object[] objectArray = EditableList.this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? EditableList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (listDataEvent2 == null) {
                    listDataEvent2 = new ListDataEvent(EditableList.this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
                }
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent2);
            }
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, EditableList.this.getDisplayValue(object), n, bl, bl2);
        }
    }
}

