/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpSearchNavigator;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class HelpManager
extends CommandManager {
    private CommandManager[] commandManagers;
    private boolean commandLineHelpFlag;
    private String[] commandLineHelpQuery;
    private boolean onlineHelpFlag;
    private String onlineHelpQuery;
    private boolean versionFlag;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$HelpManager == null ? (class$com$sun$javatest$tool$HelpManager = HelpManager.class$("com.sun.javatest.tool.HelpManager")) : class$com$sun$javatest$tool$HelpManager);
    static /* synthetic */ Class class$com$sun$javatest$tool$Main;
    static /* synthetic */ Class class$com$sun$javatest$tool$HelpManager;
    static /* synthetic */ Class class$javax$help$JHelpSearchNavigator;
    static /* synthetic */ Class class$javax$swing$JTextField;

    public HelpManager() {
    }

    public HelpManager(CommandManager[] commandManagerArray) {
        this.setCommandManagers(commandManagerArray);
    }

    public HelpTree.Node getHelp() {
        String[] stringArray = new String[]{"help", "onlineHelp", "query1", "query2", "usage", "version"};
        return new HelpTree.Node(i18n, "help.cmd.opts", stringArray);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) {
        if (string.equalsIgnoreCase("help") || string.equalsIgnoreCase("usage") || string.equalsIgnoreCase("?")) {
            Vector<String> vector = new Vector<String>();
            while (listIterator.hasNext()) {
                vector.add(((String)listIterator.next()).toLowerCase());
            }
            this.commandLineHelpFlag = true;
            this.commandLineHelpQuery = vector.toArray(new String[vector.size()]);
            return true;
        }
        if (string.equalsIgnoreCase("onlineHelp")) {
            StringBuffer stringBuffer = new StringBuffer();
            while (listIterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(listIterator.next());
            }
            this.onlineHelpFlag = true;
            this.onlineHelpQuery = stringBuffer.toString();
            return true;
        }
        if (string.equalsIgnoreCase("version")) {
            this.versionFlag = true;
            return true;
        }
        return false;
    }

    public void setCommandManagers(CommandManager[] commandManagerArray) {
        this.commandManagers = commandManagerArray;
    }

    boolean isInfoRequired() {
        return this.versionFlag || this.commandLineHelpFlag || this.onlineHelpFlag;
    }

    void showRequiredInfo(PrintWriter printWriter) {
        if (this.versionFlag) {
            this.showVersion(printWriter);
        }
        if (this.commandLineHelpFlag) {
            this.showCommandLineHelp(printWriter);
        }
        if (this.onlineHelpFlag) {
            this.showOnlineHelp(printWriter);
        }
    }

    void showCommandLineHelp(PrintWriter printWriter) {
        HelpTree.Node node;
        Integer n;
        HelpTree helpTree = new HelpTree();
        Integer n2 = Integer.getInteger("javatest.help.nodeIndent");
        if (n2 != null) {
            helpTree.setNodeIndent(n2);
        }
        if ((n = Integer.getInteger("javatest.help.descIndent")) != null) {
            helpTree.setDescriptionIndent(n);
        }
        TreeMap<String, HelpTree.Node> treeMap = new TreeMap<String, HelpTree.Node>();
        for (int i = 0; i < this.commandManagers.length; ++i) {
            node = this.commandManagers[i].getHelp();
            treeMap.put(node.getName(), node);
        }
        String[] stringArray = treeMap.values().iterator();
        while (stringArray.hasNext()) {
            helpTree.addNode((HelpTree.Node)stringArray.next());
        }
        stringArray = new String[]{"ts", "wd", "jti"};
        node = new HelpTree.Node(i18n, "help.cmd.files", stringArray);
        helpTree.addNode(node);
        String[] stringArray2 = new String[]{"opts", "string", "atfile", "readfile", "encode"};
        HelpTree.Node node2 = new HelpTree.Node(i18n, "help.cmd.syntax", stringArray2);
        helpTree.addNode(node2);
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$tool$Main == null ? (class$com$sun$javatest$tool$Main = HelpManager.class$("com.sun.javatest.tool.Main")) : class$com$sun$javatest$tool$Main).getName());
        try {
            WrapWriter wrapWriter = new WrapWriter(printWriter);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.length == 0) {
                wrapWriter.write(i18n.getString("help.cmd.proto", string));
                wrapWriter.write("\n\n");
                wrapWriter.write(i18n.getString("help.cmd.introHead"));
                wrapWriter.write('\n');
                helpTree.writeSummary(wrapWriter);
            } else if (Arrays.asList(this.commandLineHelpQuery).contains("all")) {
                wrapWriter.write(i18n.getString("help.cmd.proto", string));
                wrapWriter.write("\n\n");
                wrapWriter.write(i18n.getString("help.cmd.fullHead"));
                wrapWriter.write('\n');
                helpTree.write(wrapWriter);
            } else {
                HelpTree.Selection selection = helpTree.find(this.commandLineHelpQuery);
                if (selection != null) {
                    helpTree.write((Writer)wrapWriter, selection);
                } else {
                    wrapWriter.write(i18n.getString("help.cmd.noEntriesFound"));
                    wrapWriter.write("\n\n");
                    wrapWriter.write(i18n.getString("help.cmd.summaryHead"));
                    wrapWriter.write('\n');
                    helpTree.writeSummary(wrapWriter);
                }
            }
            wrapWriter.write('\n');
            wrapWriter.write(i18n.getString("help.cmd.tail"));
            wrapWriter.write("\n\n");
            wrapWriter.write(i18n.getString("help.copyright.txt"));
            wrapWriter.write("\n\n");
            wrapWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void showOnlineHelp(PrintWriter printWriter) {
        printWriter.println(i18n.getString("help.onlineHelp.pleaseWait"));
        printWriter.flush();
        URL uRL = HelpSet.findHelpSet(null, "com/sun/javatest/help/jthelp.hs");
        if (uRL != null) {
            try {
                HelpSet helpSet = new HelpSet(null, uRL);
                CustomHelpBroker customHelpBroker = new CustomHelpBroker(helpSet);
                if (this.onlineHelpQuery != null && this.onlineHelpQuery.length() > 0) {
                    customHelpBroker.search(this.onlineHelpQuery);
                } else {
                    customHelpBroker.setCurrentID("command.intro.csh");
                }
                customHelpBroker.setDisplayed(true);
            }
            catch (HelpSetException helpSetException) {
                // empty catch block
            }
        }
    }

    void showVersion(PrintWriter printWriter) {
        File file = Harness.getClassDir();
        String string = file == null ? i18n.getString("help.version.unknown") : file.getPath();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Object[] objectArray = new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), string, System.getProperty("java.version"), System.getProperty("java.home"), ProductInfo.getBuildJavaVersion(), dateFormat.format(ProductInfo.getBuildDate())};
        printWriter.println(i18n.getString("help.version.txt", objectArray));
        printWriter.println(i18n.getString("help.copyright.txt"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CustomHelpBroker
    extends DefaultHelpBroker {
        CustomHelpBroker(HelpSet helpSet) {
            super(helpSet);
            ExitCount.inc();
        }

        void search(String string) {
            this.initPresentation();
            JFrame jFrame = (JFrame)this.getHelpWindow();
            Container container = jFrame.getContentPane();
            JHelpSearchNavigator jHelpSearchNavigator = (JHelpSearchNavigator)this.findComponent(container, class$javax$help$JHelpSearchNavigator == null ? (class$javax$help$JHelpSearchNavigator = HelpManager.class$("javax.help.JHelpSearchNavigator")) : class$javax$help$JHelpSearchNavigator);
            if (jHelpSearchNavigator == null) {
                return;
            }
            JTextField jTextField = (JTextField)this.findComponent(jHelpSearchNavigator, class$javax$swing$JTextField == null ? (class$javax$swing$JTextField = HelpManager.class$("javax.swing.JTextField")) : class$javax$swing$JTextField);
            if (jTextField == null) {
                return;
            }
            jTextField.setText(string);
            jTextField.postActionEvent();
            this.setCurrentView("Search");
        }

        public void setDisplayed(boolean bl) {
            super.setDisplayed(bl);
            JFrame jFrame = (JFrame)this.getHelpWindow();
            jFrame.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ CustomHelpBroker this$0;
                {
                    this.this$0 = customHelpBroker;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ExitCount.dec();
                }
            });
        }

        private Component findComponent(Container container, Class clazz) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component;
                Component component2 = container.getComponent(i);
                if (clazz.isInstance(component2)) {
                    return component2;
                }
                if (!(component2 instanceof Container) || (component = this.findComponent((Container)component2, clazz)) == null) continue;
                return component;
            }
            return null;
        }

        private Window getHelpWindow() {
            return this.getWindowPresentation().getHelpWindow();
        }
    }
}

