/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.WizPane;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.CommandParser;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.DesktopManager;
import com.sun.javatest.tool.HelpManager;
import com.sun.javatest.tool.Main;
import com.sun.javatest.tool.ManagerLoader;
import com.sun.javatest.tool.Startup;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.text.html.HTMLEditorKit;

public class Main {
    private CommandManager[] commandManagers;
    private HelpManager helpManager;
    private DesktopManager desktopManager;
    private static boolean tracing;
    private static long traceStartTime;
    private static PrintWriter traceOut;
    private static boolean initialized;
    private static final String CMDMGRLIST = "JavaTest.cmdMgrs.lst";
    private static I18NResourceBundle i18n;
    private static final int RC_GUI_ACTIVE = -1;
    private static final int RC_OK = 0;
    private static final int RC_BATCH_TESTS_FAILED = 1;
    private static final int RC_BATCH_TESTS_ERROR = 2;
    private static final int RC_USER_ERROR = 3;
    private static final int RC_INTERNAL_ERROR = 4;
    static /* synthetic */ Class class$com$sun$javatest$tool$CommandManager;
    static /* synthetic */ Class class$com$sun$javatest$tool$Main;

    public static void main(String[] stringArray) {
        String string;
        tracing = Boolean.getBoolean("javatest.trace.startup");
        if (tracing) {
            traceStartTime = System.currentTimeMillis();
        }
        if ((string = System.getProperty("java.version")) != null) {
            String[] stringArray2 = new String[]{"1.0", "1.1", "1.2", "1.3"};
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string.startsWith(stringArray2[i])) continue;
                System.err.println("Please use Java(TM) 2, Standard Edition, Version 1.4 or better to run the JavaTest(TM) harness.");
                System.exit(1);
            }
        }
        Main.main0(stringArray);
    }

    private static void main0(String[] stringArray) {
        Debug.setProperties(System.getProperties());
        PrintWriter printWriter = new PrintWriter(System.err){

            public void close() {
                this.flush();
            }
        };
        if (tracing) {
            traceOut = printWriter;
        }
        try {
            ExitCount.inc();
            Main main = new Main();
            CommandContext commandContext = new CommandContext(printWriter);
            main.run(stringArray, commandContext);
            if (tracing) {
                Main.trace("Main.run complete");
            }
            printWriter.flush();
            int[] nArray = commandContext.getTestStats();
            int n = nArray[2] > 0 ? 2 : (nArray[1] > 0 ? 1 : 0);
            ExitCount.dec(true, n);
            boolean bl = System.getProperty("javatest.preload.classes", "true").equals("true");
            if (bl) {
                if (tracing) {
                    Main.trace("preloading classes...");
                }
                Main.preloadUsefulClasses();
                if (tracing) {
                    Main.trace("preloaded classes");
                }
            }
            printWriter.flush();
        }
        catch (Command.Fault fault) {
            printWriter.println("+ " + fault.getCommand().toString());
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(3);
        }
        catch (CommandContext.Fault fault) {
            CommandContext commandContext;
            boolean bl;
            Throwable throwable = fault.getCause();
            if (throwable instanceof Command.Fault && !(bl = (commandContext = fault.getContext()).getVerboseOptionValue("commands"))) {
                Command.Fault fault2 = (Command.Fault)throwable;
                Command command = fault2.getCommand();
                printWriter.println("+ " + command.toString());
            }
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(3);
        }
        catch (CommandParser.Fault fault) {
            Throwable throwable = fault.getCause();
            if (throwable instanceof Command.Fault) {
                Command.Fault fault3 = (Command.Fault)throwable;
                Command command = fault3.getCommand();
                printWriter.println("+ " + command.toString());
            }
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(3);
        }
        catch (Fault fault) {
            printWriter.println(fault.getMessage());
            printWriter.flush();
            Main.exit(4);
        }
        catch (Error error) {
            error.printStackTrace(printWriter);
            printWriter.flush();
            Main.exit(4);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace(printWriter);
            printWriter.flush();
            Main.exit(4);
        }
    }

    public final void run(String[] stringArray, PrintWriter printWriter) throws Fault, Command.Fault, CommandContext.Fault, CommandParser.Fault {
        this.run(stringArray, new CommandContext(printWriter));
    }

    public final void run(String[] stringArray, final CommandContext commandContext) throws Fault, Command.Fault, CommandContext.Fault, CommandParser.Fault {
        block31: {
            Object object;
            Desktop desktop;
            boolean bl;
            Command[] commandArray;
            Object object2;
            if (this.commandManagers == null) {
                this.desktopManager = new DesktopManager();
                this.helpManager = new HelpManager();
                try {
                    object2 = new ManagerLoader(class$com$sun$javatest$tool$CommandManager == null ? (class$com$sun$javatest$tool$CommandManager = Main.class$("com.sun.javatest.tool.CommandManager")) : class$com$sun$javatest$tool$CommandManager, System.err);
                    Set set = ((ManagerLoader)object2).loadManagers(CMDMGRLIST);
                    set.add(this.desktopManager);
                    set.add(this.helpManager);
                    this.commandManagers = set.toArray(new CommandManager[set.size()]);
                    this.helpManager.setCommandManagers(this.commandManagers);
                }
                catch (IOException iOException) {
                    throw new Fault(i18n, "main.cantAccessResource", new Object[]{CMDMGRLIST, iOException});
                }
            }
            object2 = new CommandParser(this.commandManagers);
            boolean bl2 = Boolean.getBoolean("javatest.command.urlEncoded");
            ((CommandParser)object2).parse(stringArray, bl2, commandContext);
            if (!initialized) {
                commandArray = ProductInfo.getJavaTestClassDir();
                Harness.setClassDir((File)commandArray);
                JavaTestSecurityManager.install();
                initialized = true;
            }
            commandArray = commandContext.getCommands();
            boolean bl3 = this.helpManager.isInfoRequired();
            if (bl3) {
                this.helpManager.showRequiredInfo(commandContext.getLogWriter());
                if (commandArray.length == 0) {
                    return;
                }
            }
            if (bl = commandContext.isDesktopRequired()) {
                block30: {
                    if (tracing) {
                        Main.trace("creating desktop...");
                    }
                    desktop = this.desktopManager.createDesktop();
                    object = new Runnable(){

                        public void run() {
                            if (tracing) {
                                Main.trace("creating splash screen...");
                            }
                            Startup startup = new Startup();
                            Thread thread = new Thread(this, startup){
                                private final /* synthetic */ Startup val$splashScreen;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = var1_1;
                                    this.val$splashScreen = startup;
                                }

                                public void run() {
                                    block7: {
                                        int n = Integer.getInteger("javatest.splashScreen.time", 15);
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(n * 1000);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        if (Main.access$000()) {
                                            Main.access$100("splash timer done: showing desktop...");
                                        }
                                        Runnable runnable = new Runnable(this){
                                            private final /* synthetic */ 3 this$2;
                                            {
                                                this.this$2 = var1_1;
                                            }

                                            public void run() {
                                                2.access$300(3.access$200(this.this$2)).setVisible(true);
                                                3.access$400(this.this$2).disposeLater();
                                            }
                                        };
                                        try {
                                            EventQueue.invokeAndWait(runnable);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            if (Main.access$000()) {
                                                interruptedException.printStackTrace();
                                            }
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            if (!Main.access$000()) break block7;
                                            invocationTargetException.printStackTrace();
                                        }
                                    }
                                }

                                static /* synthetic */ 2 access$200(3 var0) {
                                    return var0.this$1;
                                }

                                static /* synthetic */ Startup access$400(3 var0) {
                                    return var0.val$splashScreen;
                                }
                            };
                            thread.setDaemon(true);
                            thread.start();
                        }

                        static /* synthetic */ Desktop access$300(2 var0) {
                            return var0.desktop;
                        }
                    };
                    try {
                        EventQueue.invokeAndWait((Runnable)object);
                    }
                    catch (InterruptedException interruptedException) {
                        if (tracing) {
                            interruptedException.printStackTrace();
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (!tracing) break block30;
                        invocationTargetException.printStackTrace();
                    }
                }
                commandContext.setDesktop(desktop);
            } else {
                desktop = null;
            }
            if (tracing) {
                Main.trace("executing command line...");
            }
            commandContext.runCommands();
            if (tracing) {
                Main.trace("command line done");
            }
            if (desktop != null) {
                if (commandContext.isCloseDesktopWhenDoneEnabled() && desktop.isOKToAutoExit()) {
                    object = new Runnable(){

                        public void run() {
                            desktop.setVisible(false);
                            desktop.dispose();
                        }
                    };
                    try {
                        EventQueue.invokeAndWait((Runnable)object);
                    }
                    catch (InterruptedException interruptedException) {
                        if (tracing) {
                            interruptedException.printStackTrace();
                        }
                        break block31;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (tracing) {
                            invocationTargetException.printStackTrace();
                        }
                        break block31;
                    }
                }
                if (desktop.isEmpty() && commandContext.hasConfig()) {
                    try {
                        object = commandContext.getConfig();
                    }
                    catch (CommandContext.Fault fault) {
                        throw new Fault(i18n, "main.cantGetConfig", fault.getMessage());
                    }
                } else {
                    object = null;
                }
                Runnable runnable = new Runnable((InterviewParameters)object){
                    private final /* synthetic */ InterviewParameters val$ip;
                    {
                        this.val$ip = interviewParameters;
                    }

                    public void run() {
                        if (desktop.isEmpty()) {
                            if (commandContext.hasConfig()) {
                                if (tracing) {
                                    Main.trace("show specified test suite");
                                }
                                desktop.addDefaultTool(this.val$ip);
                            } else if (desktop.isFirstTime()) {
                                if (tracing) {
                                    Main.trace("show default");
                                }
                                desktop.addDefaultTool();
                            } else {
                                if (tracing) {
                                    Main.trace("restore desktop");
                                }
                                desktop.restore();
                            }
                        }
                        if (tracing) {
                            Main.trace("set desktop visible");
                        }
                        desktop.setVisible(true);
                    }
                };
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    if (tracing) {
                        interruptedException.printStackTrace();
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!tracing) break block31;
                    invocationTargetException.printStackTrace();
                }
            }
        }
    }

    private static void preloadUsefulClasses() {
        new HTMLEditorKit().createDefaultDocument();
        Interview interview = new Interview("dummy"){
            Question qEnd = new FinalQuestion(this);
            {
                this.setFirstQuestion(this.qEnd);
            }
        };
        new WizPane(interview);
    }

    private static void trace(String string) {
        long l = System.currentTimeMillis();
        traceOut.println(MessageFormat.format("{0,number,[##0.0]} {1}", new Float((float)(l - traceStartTime) / 1000.0f), string));
        traceOut.flush();
    }

    private static final void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)securityManager).setAllowExit(true);
        }
        System.exit(n);
        throw new JavaTestError(i18n, "main.cannotExit.err");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        initialized = false;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$Main == null ? (class$com$sun$javatest$tool$Main = Main.class$("com.sun.javatest.tool.Main")) : class$com$sun$javatest$tool$Main);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

