/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

class ManagerLoader {
    private Class managerClass;
    private Constructor constr;
    private Class[] constrArgTypes;
    private Object[] constrArgs;
    private PrintStream log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$tool$ManagerLoader == null ? (class$com$sun$javatest$tool$ManagerLoader = ManagerLoader.class$("com.sun.javatest.tool.ManagerLoader")) : class$com$sun$javatest$tool$ManagerLoader);
    static /* synthetic */ Class class$com$sun$javatest$tool$ManagerLoader;

    ManagerLoader(Class clazz, PrintStream printStream) {
        this.setManagerClass(clazz);
        this.setLog(printStream);
    }

    void setManagerClass(Class clazz) {
        this.managerClass = clazz;
    }

    void setManagerConstructorArgs(Class[] classArray, Object[] objectArray) {
        this.constrArgTypes = classArray;
        this.constrArgs = objectArray;
    }

    void setLog(PrintStream printStream) {
        this.log = printStream;
    }

    Set loadManagers(String string) throws IOException {
        ClassLoader classLoader = (class$com$sun$javatest$tool$ManagerLoader == null ? (class$com$sun$javatest$tool$ManagerLoader = ManagerLoader.class$("com.sun.javatest.tool.ManagerLoader")) : class$com$sun$javatest$tool$ManagerLoader).getClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources(string);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#")) continue;
                    try {
                        Class<?> clazz = Class.forName(string2);
                        Object object = this.newInstance(clazz);
                        if (this.managerClass.isInstance(object)) {
                            hashSet.add(object);
                            continue;
                        }
                        if (this.log == null) continue;
                        this.writeI18N("ml.notSubtype", new Object[]{string2, this.managerClass.getName(), uRL});
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindClass", new Object[]{string2, uRL});
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantAccessClass", new Object[]{string2, uRL});
                    }
                    catch (InstantiationException instantiationException) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantCreateClass", new Object[]{string2, uRL});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (this.log == null) continue;
                        this.writeI18N("ml.cantFindConstr", new Object[]{string2, uRL});
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                if (this.log == null) continue;
                this.writeI18N("ml.cantRead", new Object[]{uRL, iOException});
            }
        }
        return hashSet;
    }

    private Object newInstance(Class clazz) throws IllegalAccessException, InstantiationException, NoSuchMethodException {
        if (this.constrArgTypes == null || this.constrArgTypes.length == 0) {
            return clazz.newInstance();
        }
        try {
            Constructor constructor = clazz.getConstructor(this.constrArgTypes);
            return constructor.newInstance(this.constrArgs);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(invocationTargetException);
        }
    }

    private void writeI18N(String string, Object[] objectArray) {
        this.log.println(i18n.getString(string, objectArray));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

