/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class ToolAction
implements Action {
    private String name;
    private String desc;
    private Integer mnemonic;
    private Icon icon;
    private Map misc;
    private boolean enabled = true;
    private WeakReference[] listeners = new WeakReference[0];

    public ToolAction(String string, String string2, int n) {
        this.name = string;
        this.desc = string2;
        this.mnemonic = new Integer(n);
        this.enabled = true;
    }

    public ToolAction(UIFactory uIFactory, String string) {
        this(uIFactory.getI18NResourceBundle(), string);
    }

    public ToolAction(UIFactory uIFactory, String string, boolean bl) {
        this(uIFactory, string);
        if (bl) {
            this.putValue("SmallIcon", uIFactory.createIcon(string));
        }
    }

    public ToolAction(I18NResourceBundle i18NResourceBundle, String string) {
        this(i18NResourceBundle.getString(string + ".act"), i18NResourceBundle.getString(string + ".tip"), ToolAction.getMnemonic(i18NResourceBundle, string + ".mne"));
    }

    public Object getValue(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("Name")) {
            return this.name;
        }
        if (string.equals("ShortDescription")) {
            return this.desc;
        }
        if (string.equals("MnemonicKey")) {
            return this.mnemonic;
        }
        if (string.equals("SmallIcon")) {
            return this.icon;
        }
        return this.misc == null ? null : this.misc.get(string);
    }

    public void putValue(String string, Object object) {
        Object object2;
        if (string.equals("Name")) {
            if (ToolAction.equal(object, this.name)) {
                return;
            }
            object2 = this.name;
            this.name = (String)object;
        } else if (string.equals("ShortDescription")) {
            if (ToolAction.equal(object, this.desc)) {
                return;
            }
            object2 = this.desc;
            this.desc = (String)object;
        } else if (string.equals("MnemonicKey")) {
            if (ToolAction.equal(object, this.mnemonic)) {
                return;
            }
            object2 = this.mnemonic;
            this.mnemonic = (Integer)object;
        } else if (string.equals("SmallIcon")) {
            if (ToolAction.equal(object, this.icon)) {
                return;
            }
            object2 = this.icon;
            this.icon = (Icon)object;
        } else {
            if (this.misc == null) {
                this.misc = new HashMap();
            }
            if (ToolAction.equal(object, object2 = this.misc.get(string))) {
                return;
            }
            this.misc.put(string, object);
        }
        this.firePropertyChangeEvent(string, object2, object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        boolean bl2 = this.enabled;
        this.enabled = bl;
        if (this.listeners.length > 0) {
            this.firePropertyChangeEvent("enabled", new Boolean(bl2), new Boolean(bl));
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners = (WeakReference[])DynamicArray.append(this.listeners, new WeakReference<PropertyChangeListener>(propertyChangeListener));
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        WeakReference[] weakReferenceArray = this.listeners;
        int n = weakReferenceArray.length;
        for (int i = n - 1; i >= 0; --i) {
            if (weakReferenceArray[i].get() != propertyChangeListener) continue;
            System.arraycopy(weakReferenceArray, i + 1, weakReferenceArray, i, --n - i);
        }
        if (n < weakReferenceArray.length) {
            this.listeners = new WeakReference[n];
            System.arraycopy(weakReferenceArray, 0, this.listeners, 0, n);
        }
    }

    private void firePropertyChangeEvent(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = null;
        WeakReference[] weakReferenceArray = this.listeners;
        if (weakReferenceArray.length > 0) {
            for (int i = weakReferenceArray.length - 1; i >= 0; --i) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)weakReferenceArray[i].get();
                if (propertyChangeListener == null) continue;
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    private static int getMnemonic(I18NResourceBundle i18NResourceBundle, String string) {
        String string2 = i18NResourceBundle.getString(string);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(string2);
        return keyStroke == null ? 0 : keyStroke.getKeyCode();
    }

    private static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }
}

