/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class ToolDialog {
    protected final Component parent;
    protected final UIFactory uif;
    protected final Tool tool;
    private String uiKey;
    private Container dialog;
    private String title;
    private JMenuBar menuBar;
    private Container main;
    private Container body;
    private JButton[] buttons;
    private JButton cancelButton;
    private JButton defaultButton;
    private String helpID;
    private ComponentListener componentListener;
    static /* synthetic */ Class class$com$sun$javatest$tool$Tool;

    protected ToolDialog(Component component, UIFactory uIFactory, String string) {
        if (component == null || uIFactory == null || string == null) {
            throw new NullPointerException();
        }
        this.parent = component;
        this.uif = uIFactory;
        this.uiKey = string;
        this.tool = (Tool)(component instanceof Tool ? component : SwingUtilities.getAncestorOfClass(class$com$sun$javatest$tool$Tool == null ? (class$com$sun$javatest$tool$Tool = ToolDialog.class$("com.sun.javatest.tool.Tool")) : class$com$sun$javatest$tool$Tool, component));
        if (this.tool == null) {
            throw new IllegalStateException();
        }
        this.tool.addToolDialog(this);
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.ensureDialogInitialized();
            this.dialog.setVisible(true);
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).toFront();
            } else {
                ((JInternalFrame)this.dialog).toFront();
            }
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).dispose();
            } else {
                ((JInternalFrame)this.dialog).dispose();
            }
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)this.dialog);
            rootPaneContainer.setContentPane(new Container());
            JMenuBar jMenuBar = rootPaneContainer.getRootPane().getJMenuBar();
            if (jMenuBar != null) {
                jMenuBar.removeAll();
            }
            if (this.componentListener != null && this.dialog != null) {
                this.dialog.removeComponentListener(this.componentListener);
            }
            this.dialog = null;
        }
    }

    protected abstract void initGUI();

    protected String getTitle() {
        return this.title;
    }

    protected void setI18NTitle(String string) {
        this.setLocalizedTitle(this.uif.getI18NString(string));
    }

    protected void setI18NTitle(String string, Object object) {
        this.setLocalizedTitle(this.uif.getI18NString(string, object));
    }

    protected void setI18NTitle(String string, Object[] objectArray) {
        this.setLocalizedTitle(this.uif.getI18NString(string, objectArray));
    }

    private void setLocalizedTitle(String string) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setTitle(string);
            } else {
                ((JInternalFrame)this.dialog).setTitle(string);
            }
        }
        this.title = string;
    }

    protected void setHelp(String string) {
        if (this.dialog != null) {
            this.uif.setHelp(this.dialog, string);
        }
        this.helpID = string;
    }

    protected JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    protected void setJMenuBar(JMenuBar jMenuBar) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setJMenuBar(jMenuBar);
            } else {
                ((JInternalFrame)this.dialog).setJMenuBar(jMenuBar);
            }
        }
        this.menuBar = jMenuBar;
    }

    protected Container getBody() {
        return this.body;
    }

    protected void setBody(Container container) {
        this.body = container;
        if (this.dialog != null) {
            this.initMain();
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setContentPane(this.main);
            } else {
                ((JInternalFrame)this.dialog).setContentPane(this.main);
            }
        }
    }

    protected JButton[] getButtons() {
        return this.buttons;
    }

    protected JButton getDefaultButton() {
        return this.defaultButton;
    }

    protected void setButtons(JButton[] jButtonArray, JButton jButton) {
        this.buttons = jButtonArray;
        this.defaultButton = jButton;
        this.cancelButton = null;
        if (jButtonArray != null) {
            for (int i = 0; i < jButtonArray.length && this.cancelButton == null; ++i) {
                if (!jButtonArray[i].getActionCommand().equals("cancel")) continue;
                this.cancelButton = jButtonArray[i];
            }
        }
        if (this.dialog != null) {
            this.initMain();
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setContentPane(this.main);
            } else {
                ((JInternalFrame)this.dialog).setContentPane(this.main);
            }
        }
    }

    protected void setComponentListener(ComponentListener componentListener) {
        this.componentListener = componentListener;
    }

    protected Dimension getSize() {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        return this.dialog.getSize();
    }

    protected void setSize(Dimension dimension) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setSize(dimension);
    }

    protected void setSize(int n, int n2) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setSize(n, n2);
    }

    private void ensureDialogInitialized() {
        Desktop desktop = this.tool.getDesktop();
        if (this.dialog == null || !desktop.isToolOwnerForDialog(this.tool, this.dialog)) {
            if (this.main == null) {
                this.initMain();
            }
            this.initDialog();
        }
    }

    void initDialog() {
        this.initDialog(null, this.isVisible());
    }

    void initDialog(DeskView deskView, boolean bl) {
        ActionMap actionMap;
        InputMap inputMap;
        Object object;
        if (deskView == null) {
            object = this.tool.getDesktop();
            this.dialog = ((Desktop)object).createDialog(this.tool, this.uiKey, this.title, this.menuBar, this.main, this.dialog == null ? null : this.dialog.getBounds());
        } else {
            this.dialog = deskView.createDialog(this.tool, this.uiKey, this.title, this.menuBar, this.main, this.dialog == null ? null : this.dialog.getBounds());
        }
        if (this.helpID != null) {
            this.uif.setHelp(this.dialog, this.helpID);
        }
        if (this.dialog instanceof JDialog) {
            object = (JDialog)this.dialog;
            if (this.defaultButton != null) {
                ((JDialog)object).getRootPane().setDefaultButton(this.defaultButton);
                ((Window)object).addWindowListener(new WindowAdapter((JDialog)object){
                    private final /* synthetic */ JDialog val$d;
                    {
                        this.val$d = jDialog;
                    }

                    public void windowActivated(WindowEvent windowEvent) {
                        ToolDialog.this.defaultButton.requestFocus();
                        this.val$d.removeWindowListener(this);
                    }
                });
            }
            ((JDialog)object).setDefaultCloseOperation(1);
            ((Window)object).pack();
        } else {
            object = (JInternalFrame)this.dialog;
            if (this.defaultButton != null) {
                ((JInternalFrame)object).getRootPane().setDefaultButton(this.defaultButton);
            }
            ((JInternalFrame)object).setDefaultCloseOperation(1);
            ((JInternalFrame)object).pack();
        }
        if (this.componentListener != null) {
            this.dialog.addComponentListener(this.componentListener);
        }
        if (this.cancelButton != null) {
            object = (JPanel)this.main;
            inputMap = ((JComponent)object).getInputMap(2);
            actionMap = ((JComponent)object).getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolDialog.this.cancelButton.doClick(250);
                }
            });
        }
        if (this.main instanceof JComponent) {
            object = (JComponent)this.main;
            inputMap = ((JComponent)object).getInputMap(2);
            actionMap = ((JComponent)object).getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("ctrl 0"), "showInfo");
            actionMap.put("showInfo", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolDialog.this.showInfo();
                }
            });
        }
        this.dialog.setVisible(bl);
    }

    private void initMain() {
        if (this.body == null) {
            this.initGUI();
        }
        if (this.body == null) {
            throw new IllegalStateException();
        }
        if (this.buttons == null || this.buttons.length == 0) {
            this.main = this.body;
        } else {
            Cloneable cloneable;
            int n;
            JPanel jPanel = this.uif.createPanel(this.uiKey + ".main", false);
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.body, "Center");
            Dimension dimension = new Dimension();
            for (n = 0; n < this.buttons.length; ++n) {
                cloneable = this.buttons[n].getPreferredSize();
                dimension.width = Math.max(dimension.width, cloneable.width);
                dimension.height = Math.max(dimension.height, cloneable.height);
            }
            for (n = 0; n < this.buttons.length; ++n) {
                this.buttons[n].setPreferredSize(dimension);
            }
            JPanel jPanel2 = this.uif.createPanel(this.uiKey + ".btns", false);
            jPanel2.setLayout(new GridBagLayout());
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).anchor = 13;
            ((GridBagConstraints)cloneable).insets.top = 5;
            ((GridBagConstraints)cloneable).insets.bottom = 11;
            ((GridBagConstraints)cloneable).insets.right = 11;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            for (int i = 0; i < this.buttons.length; ++i) {
                jPanel2.add((Component)this.buttons[i], cloneable);
                ((GridBagConstraints)cloneable).weightx = 0.0;
            }
            jPanel.add((Component)jPanel2, "South");
            this.main = jPanel;
        }
    }

    private void showInfo() {
        this.showComponent(this.main, 0);
    }

    private void showComponent(Component component, int n) {
        for (int i = 0; i < n; ++i) {
            System.err.print("  ");
        }
        System.err.print(component.getClass().getName() + " " + component.getName() + ":");
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getSize();
        Dimension dimension3 = new Dimension(dimension2.width - dimension.width, dimension2.height - dimension.height);
        System.err.print(" pref:[w=" + dimension.width + "," + dimension.height + "]");
        System.err.print(" size:[w=" + dimension2.width + "," + dimension2.height + "]");
        System.err.print(" diff:[w=" + dimension3.width + "," + dimension3.height + "]");
        if (component instanceof Container) {
            Container container = (Container)component;
            System.err.println(" " + container.getComponentCount() + " children");
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.showComponent(container.getComponent(i), n + 1);
            }
        } else {
            System.err.println();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

