/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogFile {
    private File file;
    private Writer out;
    private boolean logError;
    private static I18NResourceBundle local_i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$util$LogFile == null ? (class$com$sun$javatest$util$LogFile = LogFile.class$("com.sun.javatest.util.LogFile")) : class$com$sun$javatest$util$LogFile);
    static /* synthetic */ Class class$com$sun$javatest$util$LogFile;

    public LogFile() {
        this(new OutputStreamWriter(System.err));
    }

    public LogFile(Writer writer) {
        if (writer == null) {
            throw new NullPointerException();
        }
        this.out = writer;
    }

    public LogFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string) {
        this.log(i18NResourceBundle.getString(string), null);
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        if (object instanceof Throwable) {
            this.log(i18NResourceBundle.getString(string, object), (Throwable)object);
        } else {
            this.log(i18NResourceBundle.getString(string, object), null);
        }
    }

    public void log(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof Throwable) {
            this.log(i18NResourceBundle.getString(string, objectArray), (Throwable)objectArray[0]);
        } else {
            this.log(i18NResourceBundle.getString(string, objectArray), null);
        }
    }

    private synchronized void log(String string, Throwable throwable) {
        boolean bl;
        PrintWriter printWriter;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("[ddMMMyyyy kk:mmz]");
        if (this.out != null) {
            printWriter = new PrintWriter(this.out);
            bl = false;
        } else {
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.file, true);
            }
            catch (IOException iOException) {
                if (!this.logError) {
                    String string2 = local_i18n.getString("log.error", new Object[]{this.file, iOException.toString()});
                    System.err.println(string2);
                    this.logError = true;
                }
                return;
            }
            printWriter = new PrintWriter(fileWriter);
            bl = true;
        }
        printWriter.print(simpleDateFormat.format(new Date()));
        printWriter.print("  ");
        printWriter.println(string);
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
        }
        if (bl) {
            printWriter.close();
        } else {
            printWriter.flush();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

