/* 
 * Copyright 2002-2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug      4525039
 * @summary  Test to make sure that the serialVersionUID is properly
 * documented in the serialized form.
 * @author   jamieh
 * @library  ../lib/
 * @build    JavadocTester
 * @build    TestSerialVersionUID
 * @run main TestSerialVersionUID
 */

public class TestSerialVersionUID extends JavadocTester {
    
    //Test information.
    private static final String BUG_ID = "4525039";
    private static final String OUTPUT_DIR = "docs-" + BUG_ID;
    
    //Javadoc arguments.
    private static final String[] ARGS = new String[] {
        "-d", OUTPUT_DIR,
        SRC_DIR + FS + "C.java"
    };
    
    //Input for string search tests.
    private static final String[][] TEST = {
        {OUTPUT_DIR + FS + "serialized-form.html", "-111111111111111L"}
    };
    private static final String[][] NEGATED_TEST = NO_TEST;
    
    /**
     * The entry point of the test.
     * @param args the array of command line arguments.
     */
    public static void main(String[] args) {
        TestSerialVersionUID tester = new TestSerialVersionUID();
        run(tester, ARGS, TEST, NEGATED_TEST);
        tester.printSummary();
    }
    
    /**
     * {@inheritDoc}
     */
    public String getBugId() {
        return BUG_ID;
    }
    
    /**
     * {@inheritDoc}
     */
    public String getBugName() {
        return getClass().getName();
    }
}
