/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.lib.JavaCompileCommand;
import com.sun.javatest.lib.ProcessCommand;
import com.sun.javatest.regtest.Action;
import com.sun.javatest.regtest.ParseException;
import com.sun.javatest.regtest.RegressionScript;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.TestRunException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class CompileAction
extends Action {
    private String[] args;
    private File destDir;
    private boolean reverseStatus = false;
    private String ref = null;
    private int timeout = -1;
    private boolean classpathp = false;
    private boolean sourcepathp = false;
    private TestResult.Section section;

    public Status compile(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws TestRunException {
        this.init(stringArray, stringArray2, string, regressionScript);
        return this.run();
    }

    @Override
    public void init(String[][] stringArray, String[] stringArray2, String string, RegressionScript regressionScript) throws ParseException {
        Object object;
        String string2;
        int n;
        this.script = regressionScript;
        this.reason = string;
        if (stringArray2.length == 0) {
            throw new ParseException("No classname provided for `compile'");
        }
        for (n = 0; n < stringArray.length; ++n) {
            string2 = stringArray[n][0];
            object = stringArray[n][1];
            if (string2.equals("fail")) {
                this.reverseStatus = this.parseFail((String)object);
                continue;
            }
            if (string2.equals("timeout")) {
                this.timeout = this.parseTimeout((String)object);
                continue;
            }
            if (string2.equals("ref")) {
                this.ref = this.parseRef((String)object);
                continue;
            }
            throw new ParseException("Bad option for compile: " + string2);
        }
        if (this.timeout < 0) {
            this.timeout = regressionScript.getActionTimeout(0);
        }
        try {
            for (n = 0; n < stringArray2.length; ++n) {
                string2 = stringArray2[n];
                if (string2.endsWith(".java")) {
                    object = new File(string2 = string2.replace('/', File.separatorChar));
                    if (!((File)object).isAbsolute()) {
                        stringArray2[n] = regressionScript.absTestSrcDir() + FILESEP + string2;
                    }
                    if (regressionScript.hasEnv()) {
                        this.destDir = regressionScript.absTestClsDestDir(string2);
                        if (!this.destDir.exists()) {
                            this.destDir.mkdirs();
                        }
                    }
                }
                if (string2.equals("-classpath") || string2.equals("-cp")) {
                    this.classpathp = true;
                    if (regressionScript.hasEnv()) {
                        stringArray2[n + 1] = this.addPath(stringArray2[n + 1], regressionScript.absTestClsDir() + PATHSEP + regressionScript.absTestSrcDir() + PATHSEP + regressionScript.absClsLibListStr());
                    }
                    stringArray2[n + 1] = this.singleQuoteString(stringArray2[n + 1]);
                }
                if (string2.equals("-d")) {
                    throw new ParseException("Compile option not allowed: ");
                }
                if (!string2.equals("-sourcepath")) continue;
                this.sourcepathp = true;
                stringArray2[n + 1] = this.addPath(stringArray2[n + 1], regressionScript.absTestSrcDir() + PATHSEP + regressionScript.absSrcLibListStr());
                stringArray2[n + 1] = this.singleQuoteString(stringArray2[n + 1]);
            }
        }
        catch (RegressionScript.TestClassException testClassException) {
            throw new ParseException(testClassException.getMessage());
        }
        if (regressionScript.hasEnv() && this.destDir == null) {
            throw new ParseException("No classname ending with `.java' found");
        }
        this.args = stringArray2;
    }

    @Override
    public File[] getSourceFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < this.args.length; ++i) {
            String string = this.args[i];
            if (!string.endsWith(".java")) continue;
            arrayList.add(new File(string));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public Status run() throws TestRunException {
        this.section = this.startAction("compile", this.args, this.reason);
        for (int i = 0; i < this.args.length; ++i) {
            String string = this.args[i];
            if (!string.endsWith(".java") || new File(string).exists()) continue;
            throw new TestRunException("Can't file source file: " + string);
        }
        Status status = this.script.isCheck() ? Status.passed("Test description appears acceptable") : (this.script.isOtherJVM() ? this.runOtherJVM() : this.runSameJVM());
        this.endAction(status, this.section);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runOtherJVM() throws TestRunException {
        String string;
        Status status;
        boolean bl;
        boolean bl2 = bl = this.script.isJDK11();
        boolean bl3 = !bl;
        boolean bl4 = !bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            arrayList.add("CLASSPATH=" + this.script.getJavaTestClassPath() + PATHSEP + this.script.testClassPath());
        }
        arrayList.add(this.script.getJavacProg());
        arrayList.addAll(this.script.getTestToolVMOptions());
        arrayList.addAll(this.script.getTestCompilerOptions());
        arrayList.add("-d");
        arrayList.add(this.destDir.toString());
        if (!this.classpathp && bl3) {
            arrayList.add("-classpath");
            arrayList.add(this.script.getJavaTestClassPath() + PATHSEP + this.script.testClassPath());
        }
        if (!this.sourcepathp && bl4) {
            arrayList.add("-sourcepath");
            arrayList.add(this.script.testSourcePath());
        }
        String[] stringArray = this.script.getEnvVars();
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray3 = StringArray.append(stringArray, stringArray2);
        stringArray3 = StringArray.append(stringArray3, this.args);
        if (showCmd) {
            this.JTCmd("compile", stringArray3, this.section);
        }
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        try {
            ProcessCommand processCommand = new ProcessCommand();
            processCommand.setExecDir(this.script.absTestScratchDir());
            if (this.timeout > 0) {
                this.script.setAlarm(this.timeout * 1000);
            }
            status = processCommand.run(stringArray3, new PrintWriter(stringWriter2), new PrintWriter(stringWriter));
        }
        finally {
            this.script.setAlarm(0);
        }
        boolean bl5 = status.isPassed();
        int n = status.getType();
        if (bl5 && this.reverseStatus) {
            string = "Compilation passed unexpectedly";
            n = 1;
        } else if (bl5 && !this.reverseStatus) {
            string = "Compilation successful";
        } else if (!bl5 && this.reverseStatus) {
            string = "Compilation failed as expected";
            n = 0;
        } else {
            string = "Compilation failed";
        }
        status = new Status(n, string);
        String string2 = stringWriter.toString();
        String string3 = stringWriter2.toString();
        PrintWriter printWriter = this.section.createOutput("System.out");
        PrintWriter printWriter2 = this.section.createOutput("System.err");
        try {
            printWriter.write(string2);
            printWriter2.write(string3);
            try {
                if (this.ref != null && status.getType() == 0) {
                    BufferedReader bufferedReader;
                    File file = new File(this.script.absTestSrcDir(), this.ref);
                    BufferedReader bufferedReader2 = new BufferedReader(new StringReader(string2 + string3));
                    int n2 = this.compareGoldenFile(bufferedReader2, bufferedReader = new BufferedReader(new FileReader(file)));
                    if (n2 != 0) {
                        status = Status.failed("Output does not match reference file: " + this.ref + ", line " + n2);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                File file = new File(this.script.absTestSrcDir(), this.ref);
                throw new TestRunException("Can't find reference file: " + file);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (printWriter2 != null) {
                printWriter2.close();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runSameJVM() throws TestRunException {
        int n;
        String string;
        boolean bl;
        PrintWriter printWriter;
        Status status;
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.script.getTestCompilerOptions());
        arrayList.add("-d");
        arrayList.add(this.destDir.toString());
        if (!this.classpathp) {
            arrayList.add("-classpath");
            arrayList.add(this.script.testClassPath());
        }
        if (!this.sourcepathp) {
            arrayList.add("-sourcepath");
            arrayList.add(this.script.testSourcePath());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray2 = StringArray.append(stringArray, this.args);
        if (showCmd) {
            this.JTCmd("compile", stringArray2, this.section);
        }
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        PrintWriter printWriter2 = new PrintWriter(stringWriter);
        PrintWriter printWriter3 = new PrintWriter(stringWriter2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream2);
        PrintStream printStream3 = System.out;
        PrintStream printStream4 = System.err;
        try {
            object2 = this.redirectOutput(printStream, printStream2);
            if (!((Status)object2).isPassed()) {
                Status status2 = object2;
                return status2;
            }
            object = new JavaCompileCommand();
            if (this.timeout > 0) {
                this.script.setAlarm(this.timeout * 1000);
            }
            status = ((JavaCompileCommand)object).run(stringArray2, printWriter3, printWriter2);
        }
        finally {
            Status status3 = this.redirectOutput(printStream3, printStream4);
            if (!status3.isPassed()) {
                return status3;
            }
            this.script.setAlarm(0);
        }
        printWriter2.close();
        printWriter3.close();
        printStream.close();
        printStream2.close();
        object2 = stringWriter.toString();
        object = stringWriter2.toString();
        String string2 = byteArrayOutputStream.toString();
        String string3 = byteArrayOutputStream2.toString();
        if (((String)object2).length() > 0) {
            printWriter = this.section.createOutput("direct");
            printWriter.write((String)object2);
            printWriter.close();
        }
        if (((String)object).length() > 0) {
            printWriter = this.section.createOutput("direct.log");
            printWriter.write((String)object2);
            printWriter.close();
        }
        if (string2.length() > 0 || string3.length() > 0) {
            printWriter = this.section.createOutput("System.out");
            printWriter.write(string2);
            printWriter.close();
            PrintWriter printWriter4 = this.section.createOutput("System.err");
            printWriter4.write(string3);
            printWriter4.close();
        }
        if ((bl = status.isPassed()) && this.reverseStatus) {
            string = "Compilation passed unexpectedly";
            n = 1;
        } else if (bl && !this.reverseStatus) {
            string = "Compilation successful";
            n = 0;
        } else if (!bl && this.reverseStatus) {
            string = "Compilation failed as expected";
            n = 0;
        } else {
            string = "Compilation failed: " + status;
            n = 1;
        }
        status = new Status(n, string);
        try {
            if (this.ref != null && status.getType() == 0) {
                BufferedReader bufferedReader;
                File file = new File(this.script.absTestSrcDir(), this.ref);
                String string4 = file.getPath();
                BufferedReader bufferedReader2 = new BufferedReader(new StringReader((String)object2 + (String)object + string2 + string3));
                int n2 = this.compareGoldenFile(bufferedReader2, bufferedReader = new BufferedReader(new FileReader(string4)));
                if (n2 != 0) {
                    status = Status.failed("Output does not match reference file: " + this.ref + ", line " + n2);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = new File(this.script.absTestSrcDir(), this.ref);
            throw new TestRunException("Can't find reference file: " + file);
        }
        return status;
    }

    private String parseRef(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException("No reference file name");
        }
        File file = new File(this.script.absTestSrcDir(), string);
        if (!file.exists()) {
            throw new ParseException("Can't find reference file: " + file);
        }
        return string;
    }

    private String addPath(String string, String string2) {
        String string3 = string.endsWith(PATHSEP) ? (string2.endsWith(PATHSEP) ? string + string2 : string + string2 + PATHSEP) : (string2.endsWith(PATHSEP) ? string + PATHSEP + string2.substring(0, string2.length() - 1) : string + PATHSEP + string2);
        return string3;
    }

    private int compareGoldenFile(BufferedReader bufferedReader, BufferedReader bufferedReader2) throws TestRunException {
        try {
            String string;
            String string2;
            int n = 0;
            do {
                string2 = bufferedReader.readLine();
                string = bufferedReader2.readLine();
                ++n;
                if (string2 != null || string != null) continue;
                return 0;
            } while (string2 != null && string != null && string2.equals(string));
            return n;
        }
        catch (IOException iOException) {
            File file = new File(this.script.absTestSrcDir(), this.ref);
            throw new TestRunException("Problem reading reference file: " + file);
        }
    }
}

