/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.util.ExitCount;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelpSearchNavigator;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Help {
    private Option[] options;
    private boolean releaseNotesFlag;
    private boolean tagSpecFlag;
    private boolean versionFlag;
    private List<String> commandLineHelpQuery;
    private String onlineHelpQuery;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public Help(Option[] optionArray) {
        this.options = optionArray;
    }

    void setVersionFlag(boolean bl) {
        this.versionFlag = bl;
    }

    void setReleaseNotes(boolean bl) {
        this.releaseNotesFlag = bl;
    }

    void setTagSpec(boolean bl) {
        this.tagSpecFlag = bl;
    }

    void setCommandLineHelpQuery(String string) {
        if (this.commandLineHelpQuery == null) {
            this.commandLineHelpQuery = new ArrayList<String>();
        }
        if (string != null) {
            this.commandLineHelpQuery.addAll(Arrays.asList(string.trim().split("\\s+")));
        }
    }

    void setOnlineHelpQuery(String string) {
        if (string == null || string.length() == 0) {
            if (this.onlineHelpQuery == null) {
                this.onlineHelpQuery = "";
            }
        } else {
            this.onlineHelpQuery = this.onlineHelpQuery == null ? string : this.onlineHelpQuery + " " + string;
        }
    }

    void show(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.show(printWriter);
        printWriter.flush();
    }

    void show(PrintWriter printWriter) {
        if (this.releaseNotesFlag) {
            this.showReleaseNotes(printWriter);
        }
        if (this.tagSpecFlag) {
            this.showTagSpec(printWriter);
        }
        if (this.versionFlag) {
            this.showVersion(printWriter);
        }
        if (this.commandLineHelpQuery != null) {
            this.showCommandLineHelp(printWriter);
        }
        if (this.onlineHelpQuery != null) {
            this.showOnlineHelp(printWriter);
        }
    }

    void showReleaseNotes(PrintWriter printWriter) {
        File file = this.getDocDir();
        File file2 = new File(file, "ReleaseNotes-jtreg.html");
        if (file2.exists()) {
            printWriter.println(i18n.getString("help.releaseNotes", file2.getAbsolutePath()));
        } else {
            printWriter.println(i18n.getString("help.cantFindReleaseNotes"));
        }
    }

    void showTagSpec(PrintWriter printWriter) {
        File file = this.getDocDir();
        File file2 = new File(file, "tag-spec.txt");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            printWriter.println(i18n.getString("help.cantFindSpec"));
        }
        catch (IOException iOException) {
            printWriter.println(i18n.getString("help.cantReadSpec", iOException));
        }
    }

    void showVersion(PrintWriter printWriter) {
        Properties properties = this.getManifestForClass(this.getClass());
        if (properties == null) {
            properties = new Properties();
        }
        String string = i18n.getString("help.version.unknown");
        String string2 = properties.getProperty("jtreg-Name", string);
        String string3 = properties.getProperty("jtreg-Version", string);
        String string4 = properties.getProperty("jtreg-Milestone", string);
        String string5 = properties.getProperty("jtreg-Build", string);
        String string6 = properties.getProperty("jtreg-BuildJavaVersion", string);
        String string7 = properties.getProperty("jtreg-BuildDate", string);
        String string8 = System.getProperty("java.home");
        String string9 = System.getProperty("java.version");
        File file = this.getClassPathFileForClass(Main.class);
        String string10 = file == null ? string : file.getPath();
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Object[] objectArray = new Object[]{string2, string3, string4, string5, string10, string9, string8, string6, string7};
        printWriter.println(i18n.getString("help.version.txt", objectArray));
        printWriter.println(i18n.getString("help.copyright.txt"));
    }

    private File getDocDir() {
        File file = this.getClassPathFileForClass(Main.class);
        if (file == null) {
            return null;
        }
        File file2 = file.getParentFile();
        File file3 = file2.getParentFile();
        File file4 = new File(new File(file3, "doc"), "jtreg");
        if (file4.exists()) {
            return file4;
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> clazz) {
        try {
            URL uRL = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class");
            if (uRL.getProtocol().equals("jar")) {
                String string = uRL.getPath();
                int n = string.lastIndexOf("!");
                return new URL(string.substring(0, n));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private File getClassPathFileForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL.getProtocol().equals("file")) {
            return new File(uRL.getPath());
        }
        return null;
    }

    private Properties getManifestForClass(Class<?> clazz) {
        URL uRL = this.getClassPathEntryForClass(clazz);
        if (uRL == null) {
            return null;
        }
        try {
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                int n;
                String string;
                URL uRL2;
                URL uRL3 = enumeration.nextElement();
                if (!uRL3.getProtocol().equals("jar") || !(uRL2 = new URL((string = uRL3.getPath()).substring(0, n = string.lastIndexOf("!")))).equals(uRL)) continue;
                Properties properties = new Properties();
                InputStream inputStream = uRL3.openStream();
                properties.load(inputStream);
                inputStream.close();
                return properties;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    void showCommandLineHelp(PrintWriter printWriter) {
        Integer n;
        HelpTree helpTree = new HelpTree();
        Integer n2 = Integer.getInteger("javatest.help.nodeIndent");
        if (n2 != null) {
            helpTree.setNodeIndent(n2);
        }
        if ((n = Integer.getInteger("javatest.help.descIndent")) != null) {
            helpTree.setDescriptionIndent(n);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Option option : this.options) {
            linkedHashSet.add(option.group);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : linkedHashSet) {
            linkedHashMap.put(string, new TreeMap(new CaseInsensitiveStringComparator()));
        }
        for (Option object2 : this.options) {
            if (object2.names.length <= 0) continue;
            ((SortedMap)linkedHashMap.get(object2.group)).put(object2.names[0], object2);
        }
        for (String string : linkedHashSet) {
            SortedMap sortedMap = (SortedMap)linkedHashMap.get(string);
            if (sortedMap.isEmpty()) continue;
            ArrayList<HelpTree.Node> arrayList = new ArrayList<HelpTree.Node>();
            for (Option option : sortedMap.values()) {
                arrayList.add(this.createOptionHelpNode(option));
            }
            HelpTree.Node node = new HelpTree.Node(i18n, "help." + string.toString().toLowerCase(), arrayList.toArray(new HelpTree.Node[arrayList.size()]));
            helpTree.addNode(node);
        }
        String string = Help.getProgramName();
        try {
            WrapWriter wrapWriter = new WrapWriter(printWriter);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.size() == 0) {
                wrapWriter.write(i18n.getString("help.cmd.proto", string));
                wrapWriter.write("\n\n");
                wrapWriter.write(i18n.getString("help.cmd.introHead"));
                wrapWriter.write('\n');
                helpTree.writeSummary(wrapWriter);
            } else if (this.commandLineHelpQuery.contains("all")) {
                wrapWriter.write(i18n.getString("help.cmd.proto", string));
                wrapWriter.write("\n\n");
                wrapWriter.write(i18n.getString("help.cmd.fullHead"));
                wrapWriter.write('\n');
                helpTree.write(wrapWriter);
            } else {
                String[] stringArray = this.commandLineHelpQuery.toArray(new String[this.commandLineHelpQuery.size()]);
                HelpTree.Selection selection = helpTree.find(stringArray);
                if (selection != null) {
                    helpTree.write((Writer)wrapWriter, selection);
                } else {
                    wrapWriter.write(i18n.getString("help.cmd.noEntriesFound"));
                    wrapWriter.write("\n\n");
                    wrapWriter.write(i18n.getString("help.cmd.summaryHead"));
                    wrapWriter.write('\n');
                    helpTree.writeSummary(wrapWriter);
                }
            }
            wrapWriter.write('\n');
            wrapWriter.write(i18n.getString("help.cmd.tail"));
            wrapWriter.write("\n\n");
            wrapWriter.write(i18n.getString("help.cmd.ant"));
            wrapWriter.write("\n\n");
            wrapWriter.write(i18n.getString("help.copyright.txt"));
            wrapWriter.write("\n\n");
            wrapWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HelpTree.Node createOptionHelpNode(Option option) {
        String string = "help." + option.group.toString().toLowerCase() + "." + option.names[0];
        String string2 = option.argType == Option.ArgType.NONE ? null : i18n.getString(string + ".arg");
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (String string3 : option.names) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("  |  ");
            }
            stringBuilder.append("-");
            stringBuilder.append(string3);
            switch (option.argType) {
                case NONE: {
                    continue block7;
                }
                case OLD: 
                case STD: 
                case FILE: {
                    stringBuilder.append(":").append(string2);
                    continue block7;
                }
                case REST: {
                    stringBuilder.append(" ").append(string2);
                    continue block7;
                }
                case WILDCARD: {
                    stringBuilder.append(string2);
                    continue block7;
                }
                case OPT: {
                    stringBuilder.append("  |  -").append(string3).append(":").append(string2);
                    continue block7;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String string4 = stringBuilder.toString();
        String string5 = i18n.getString(string + ".desc");
        String[] stringArray = option.getChoices();
        if (stringArray == null || stringArray.length == 0) {
            return new HelpTree.Node(string4, string5);
        }
        HelpTree.Node[] nodeArray = new HelpTree.Node[stringArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = new HelpTree.Node(stringArray[i], i18n.getString(string + "." + stringArray[i] + ".desc"));
        }
        return new HelpTree.Node(string4, string5, nodeArray);
    }

    private static String getProgramName() {
        File file;
        String string = System.getProperty("program");
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty("java.class.path");
        if (string2.indexOf(File.pathSeparator) == -1 && (file = new File(string2)).getName().equals("jtreg.jar")) {
            return "java -jar jtreg.jar ";
        }
        return "java " + Main.class.getName();
    }

    void showOnlineHelp(PrintWriter printWriter) {
        printWriter.println(i18n.getString("help.onlineHelp.pleaseWait"));
        printWriter.flush();
        URL uRL = HelpSet.findHelpSet(null, "com/sun/javatest/regtest/help/jtreg.hs");
        if (uRL == null) {
            throw new AssertionError((Object)"cant find jtreg helpset");
        }
        try {
            HelpSet helpSet = new HelpSet(null, uRL);
            CustomHelpBroker customHelpBroker = new CustomHelpBroker(helpSet);
            if (this.onlineHelpQuery != null && this.onlineHelpQuery.length() > 0) {
                customHelpBroker.search(this.onlineHelpQuery);
            } else {
                customHelpBroker.setCurrentID("home");
            }
            customHelpBroker.setDisplayed(true);
        }
        catch (HelpSetException helpSetException) {
            // empty catch block
        }
    }

    private static class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null || string2 == null) {
                return string == null ? -1 : 1;
            }
            return string.compareToIgnoreCase(string2);
        }
    }

    private static class CustomHelpBroker
    extends DefaultHelpBroker {
        CustomHelpBroker(HelpSet helpSet) {
            super(helpSet);
            ExitCount.inc();
        }

        void search(String string) {
            this.initPresentation();
            JFrame jFrame = (JFrame)this.getHelpWindow();
            Container container = jFrame.getContentPane();
            JHelpSearchNavigator jHelpSearchNavigator = (JHelpSearchNavigator)this.findComponent(container, JHelpSearchNavigator.class);
            if (jHelpSearchNavigator == null) {
                return;
            }
            JTextField jTextField = (JTextField)this.findComponent(jHelpSearchNavigator, JTextField.class);
            if (jTextField == null) {
                return;
            }
            jTextField.setText(string);
            jTextField.postActionEvent();
            this.setCurrentView("Search");
        }

        @Override
        public void setDisplayed(boolean bl) {
            super.setDisplayed(bl);
            JFrame jFrame = (JFrame)this.getHelpWindow();
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ExitCount.dec();
                }
            });
        }

        private Component findComponent(Container container, Class clazz) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component;
                Component component2 = container.getComponent(i);
                if (clazz.isInstance(component2)) {
                    return component2;
                }
                if (!(component2 instanceof Container) || (component = this.findComponent((Container)component2, clazz)) == null) continue;
                return component;
            }
            return null;
        }

        private Window getHelpWindow() {
            return this.getWindowPresentation().getHelpWindow();
        }
    }
}

