/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.CompositeFilter;
import com.sun.javatest.Harness;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestSecurityManager;
import com.sun.javatest.Keywords;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.ExecToolManager;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.PageGenerator;
import com.sun.javatest.regtest.AntOptionDecoder;
import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.Help;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.regtest.OptionDecoder;
import com.sun.javatest.regtest.RegressionObserver;
import com.sun.javatest.regtest.RegressionParameters;
import com.sun.javatest.regtest.RegressionSecurityManager;
import com.sun.javatest.regtest.RegressionTestSuite;
import com.sun.javatest.regtest.StringArray;
import com.sun.javatest.regtest.Verbose;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Startup;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;

public class Main {
    public static final String MAIN = "main";
    public static final String SELECT = "select";
    public static final String JDK = "jdk";
    public static final String MODE = "mode";
    public static final String VERBOSE = "verbose";
    public static final String DOC = "doc";
    Option[] options = new Option[]{new Option(Option.ArgType.OPT, "verbose", "verbose", new String[]{"v", "verbose"}){

        @Override
        public String[] getChoices() {
            String[] stringArray = new String[Verbose.values().length];
            int n = 0;
            for (String string : Verbose.values()) {
                stringArray[n++] = string;
            }
            return stringArray;
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            if (string2 == null) {
                Main.verbose = Verbose.DEFAULT;
            } else {
                Main.verbose = Verbose.decode(string2);
                if (verbose == null) {
                    throw new BadArgs(i18n, "main.unknownVerbose", string2);
                }
            }
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"v1"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.SUMMARY;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"va"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.ALL;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vp"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.PASS;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vf"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.FAIL;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"ve"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.ERROR;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "verbose", "verbose", new String[]{"vt"}){

        @Override
        public void process(String string, String string2) {
            Main.verbose = Verbose.TIME;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"t", "tagspec"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setTagSpec(true);
        }
    }, new Option(Option.ArgType.NONE, "doc", "", new String[]{"n", "relnote"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setReleaseNotes(true);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"w", "workDir"}){

        @Override
        public void process(String string, String string2) {
            Main.this.workDirArg = new File(string2);
            Main.this.childArgs.add("-w:" + Main.this.workDirArg.getAbsolutePath());
        }
    }, new Option(Option.ArgType.OPT, "main", "", new String[]{"retain"}){

        @Override
        public String[] getChoices() {
            return new String[]{"pass", "fail", "error", "all", "file-pattern"};
        }

        @Override
        public void process(String string, String string2) {
            if (string2 != null) {
                string2 = string2.trim();
            }
            if (string2 == null || string2.length() == 0) {
                Main.this.retainArgs = Collections.singletonList("all");
            } else {
                Main.this.retainArgs = Arrays.asList(string2.split(","));
            }
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"r", "reportDir"}){

        @Override
        public void process(String string, String string2) {
            Main.this.reportDirArg = new File(string2);
            Main.this.childArgs.add("-r:" + Main.this.reportDirArg.getAbsolutePath());
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"ro", "reportOnly"}){

        @Override
        public void process(String string, String string2) {
            Main.this.reportOnlyFlag = true;
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"timeout", "timeoutFactor"}){

        @Override
        public void process(String string, String string2) {
            Main.this.timeoutFactorArg = string2;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "", new String[]{"dir"}){

        @Override
        public void process(String string, String string2) {
            Main.this.baseDirArg = new File(string2);
            Main.this.childArgs.add("-dir:" + Main.this.baseDirArg.getAbsolutePath());
        }
    }, new Option(Option.ArgType.STD, "select", "", new String[]{"status"}){

        @Override
        public String[] getChoices() {
            return new String[]{"pass", "fail", "notRun", "error"};
        }

        @Override
        public void process(String string, String string2) {
            Main.this.priorStatusValuesArg = string2.toLowerCase();
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", "", new String[]{"exclude", "Xexclude"}){

        @Override
        public void process(String string, String string2) {
            File file = new File(string2);
            Main.this.excludeListArgs.add(file);
            Main.this.childArgs.add(file.getAbsolutePath());
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"startHttpd"}){

        @Override
        public void process(String string, String string2) {
            Main.this.httpdFlag = true;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"o", "observer"}){

        @Override
        public void process(String string, String string2) {
            Main.this.observerClassName = string2;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "main", "", new String[]{"od", "observerDir", "op", "observerPath"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.observerPathArg = new ArrayList();
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Main.this.observerPathArg.add(new File(string3));
            }
            Main.this.childArgs.add("-op:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"g", "gui"}){

        @Override
        public void process(String string, String string2) {
            Main.this.guiFlag = true;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "main", null, new String[]{"c", "check"}){

        @Override
        public void process(String string, String string2) {
            Main.this.checkFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "main", "ignore", new String[]{"noignore"}){

        @Override
        public void process(String string, String string2) {
            Main.this.ignoreKind = IgnoreKind.RUN;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "main", "ignore", new String[]{"ignore"}){

        @Override
        public String[] getChoices() {
            String[] stringArray = new String[IgnoreKind.values().length];
            int n = 0;
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                stringArray[n++] = ignoreKind.toString().toLowerCase();
            }
            return stringArray;
        }

        @Override
        public void process(String string, String string2) throws BadArgs {
            for (IgnoreKind ignoreKind : IgnoreKind.values()) {
                if (!string2.equalsIgnoreCase(ignoreKind.toString())) continue;
                if (ignoreKind == IgnoreKind.QUIET) {
                    Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "!ignore");
                }
                Main.this.ignoreKind = ignoreKind;
                Main.this.childArgs.add(string);
                return;
            }
            throw new BadArgs(i18n, "main.unknownIgnore", string2);
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"a", "automatic", "automagic"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, Main.AUTOMATIC);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "a-m", new String[]{"m", "manual"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, Main.MANUAL);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"shell"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "shell");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "select", "shell-noshell", new String[]{"noshell"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "!shell");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"bug"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "bug" + string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "select", null, new String[]{"k", "keywords"}){

        @Override
        public void process(String string, String string2) {
            Main.this.keywordsExprArg = Main.combineKeywords(Main.this.keywordsExprArg, "(" + string2 + ")");
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "mode", "svm-ovm", new String[]{"ovm", "othervm"}){

        @Override
        public void process(String string, String string2) {
            Main.this.sameJVMFlag = false;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.NONE, "mode", "svm-ovm", new String[]{"s", "svm", "samevm"}){

        @Override
        public void process(String string, String string2) {
            Main.this.sameJVMFlag = true;
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.OLD, "jdk", "", new String[]{"jdk", "testjdk"}){

        @Override
        public void process(String string, String string2) {
            Main.this.jdk = new JDK(string2);
        }
    }, new Option(Option.ArgType.STD, "jdk", "", new String[]{"cpa", "classpathappend"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            for (String string3 : string2.split(File.pathSeparator)) {
                if (string3.length() == 0) continue;
                Main.this.classPathAppendArg.add(new File(string3));
            }
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"jit"}){

        @Override
        public void process(String string, String string2) {
            Main.this.jitFlag = true;
        }
    }, new Option(Option.ArgType.NONE, "jdk", "jit-nojit", new String[]{"nojit"}){

        @Override
        public void process(String string, String string2) {
            Main.this.jitFlag = false;
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"Xrunjcov"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"classic", "green", "native", "hotspot", "client", "server", "d32", "d64"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.OPT, "jdk", null, new String[]{"enableassertions", "ea", "disableassertions", "da"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.NONE, "jdk", null, new String[]{"enablesystemassertions", "esa", "disablesystemassertions", "dsa"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"XX", "Xms", "Xmx"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"Xint", "Xmixed", "Xcomp"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath/a"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath/a:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"Xbootclasspath/p"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add("-Xbootclasspath/p:" + Main.filesToAbsolutePath(Main.pathToFiles(string2)));
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"X"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.WILDCARD, "jdk", null, new String[]{"D"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"vmoption"}){

        @Override
        public void process(String string, String string2) {
            if (string2.length() > 0) {
                Main.this.testVMOpts.add(string2);
            }
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"vmoptions"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testVMOpts.addAll(Arrays.asList(string2.split("\\s+")));
        }
    }, new Option(Option.ArgType.OLD, "jdk", null, new String[]{"e"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.envVarArgs.addAll(Arrays.asList(string2.split(",")));
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"agentlib"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"agentpath"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javaagent"}){

        @Override
        public void process(String string, String string2) {
            Main.this.testVMOpts.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javacoption"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testCompilerOpts.add(string2);
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.STD, "jdk", null, new String[]{"javacoptions"}){

        @Override
        public void process(String string, String string2) {
            if ((string2 = string2.trim()).length() == 0) {
                return;
            }
            Main.this.testCompilerOpts.addAll(Arrays.asList(string2.split("\\s+")));
            Main.this.childArgs.add(string);
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"h", "help", "usage"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setCommandLineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.REST, "doc", "help", new String[]{"onlineHelp"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setOnlineHelpQuery(string2);
        }
    }, new Option(Option.ArgType.NONE, "doc", "help", new String[]{"version"}){

        @Override
        public void process(String string, String string2) {
            if (Main.this.help == null) {
                Main.this.help = new Help(Main.this.options);
            }
            Main.this.help.setVersionFlag(true);
        }
    }, new Option(Option.ArgType.FILE, "main", null, new String[0]){

        @Override
        public void process(String string, String string2) {
            File file = new File(string2);
            Main.this.testFileArgs.add(file);
            Main.this.childArgs.add(string2);
        }
    }};
    public static final int EXIT_OK = 0;
    public static final int EXIT_TEST_FAILED = 1;
    public static final int EXIT_TEST_ERROR = 2;
    public static final int EXIT_BAD_ARGS = 3;
    public static final int EXIT_FAULT = 4;
    public static final int EXIT_EXCEPTION = 5;
    private PrintWriter out;
    private PrintWriter err;
    private File testSuiteArg;
    private File workDirArg;
    private List<String> retainArgs;
    private List<File> excludeListArgs = new ArrayList<File>();
    private String keywordsExprArg;
    private String concurrencyArg;
    private String timeoutFactorArg;
    private String priorStatusValuesArg;
    private File reportDirArg;
    private List<File> testFileArgs = new ArrayList<File>();
    private List<File> antFileArgs = new ArrayList<File>();
    private File baseDirArg;
    private boolean sameJVMFlag;
    private JDK jdk;
    private boolean guiFlag;
    private boolean reportOnlyFlag;
    private static Verbose verbose;
    private boolean httpdFlag;
    private String observerClassName;
    private List<File> observerPathArg;
    private List<String> testCompilerOpts = new ArrayList<String>();
    private List<String> testVMOpts = new ArrayList<String>();
    private boolean checkFlag;
    private List<String> envVarArgs = new ArrayList<String>();
    private IgnoreKind ignoreKind;
    private List<File> classPathAppendArg = new ArrayList<File>();
    private boolean jitFlag = true;
    private Help help;
    private List<String> childArgs = new ArrayList<String>();
    private int[] testStats;
    private static final String AUTOMATIC = "!manual";
    private static final String MANUAL = "manual";
    private static final String[] DEFAULT_UNIX_ENV_VARS;
    private static final String[] DEFAULT_WINDOWS_ENV_VARS;
    private static final String JAVATEST_ANT_FILE_LIST = "javatest.ant.file.list";
    private static boolean debugChild;
    private static final String PATHSEP;
    private static I18NResourceBundle i18n;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        PrintWriter printWriter2 = new PrintWriter(System.err, true);
        Main main = new Main(printWriter, printWriter2);
        try {
            int n;
            try {
                n = main.run(stringArray);
            }
            finally {
                printWriter.flush();
                printWriter2.flush();
            }
            if (!main.guiFlag || n != 0) {
                Main.exit(n);
            }
        }
        catch (Harness.Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(4);
        }
        catch (Fault fault) {
            printWriter2.println(i18n.getString("main.error", fault.getMessage()));
            Main.exit(4);
        }
        catch (BadArgs badArgs) {
            printWriter2.println(i18n.getString("main.badArgs", badArgs.getMessage()));
            new Help(main.options).showCommandLineHelp(printWriter);
            Main.exit(3);
        }
        catch (InterruptedException interruptedException) {
            printWriter2.println(i18n.getString("main.interrupted"));
            Main.exit(5);
        }
        catch (Exception exception) {
            printWriter2.println(i18n.getString("main.unexpectedException"));
            exception.printStackTrace();
            Main.exit(5);
        }
    }

    public Main() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
        File file = this.findJar("javatest.jar", "lib/javatest.jar", Harness.class);
        if (file != null) {
            System.setProperty("javatestClassDir", file.getPath());
        }
    }

    public final int run(String[] stringArray) throws BadArgs, Fault, Harness.Fault, InterruptedException {
        new OptionDecoder(this.options).decodeArgs(Main.expandAtFiles(stringArray));
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int run() throws BadArgs, Fault, Harness.Fault, InterruptedException {
        Serializable serializable;
        Object object2;
        if (this.help != null) {
            this.help.show(this.out);
            return 0;
        }
        if (this.jdk == null) {
            object2 = null;
            if (!this.sameJVMFlag) {
                object2 = System.getenv("JAVA_HOME");
            }
            if (!(object2 != null && ((String)object2).length() != 0 || (object2 = System.getProperty("java.home")) != null && ((String)object2).length() != 0)) {
                throw new BadArgs(i18n, "main.jdk.not.set", new Object[0]);
            }
            serializable = new File((String)object2);
            if (((File)serializable).getName().toLowerCase().equals("jre") && ((File)serializable).getParentFile() != null) {
                serializable = ((File)serializable).getParentFile();
            }
            this.jdk = new JDK((File)serializable);
        }
        if (!this.jitFlag) {
            if (this.sameJVMFlag) {
                this.testVMOpts.add("-Djava.compiler=");
            } else {
                this.envVarArgs.add("JAVA_COMPILER=");
            }
        }
        if (this.classPathAppendArg.size() > 0 && !this.sameJVMFlag) {
            this.envVarArgs.add("CPAPPEND=" + Main.filesToAbsolutePath(this.classPathAppendArg));
        }
        if (!this.jdk.exists()) {
            throw new Fault(i18n, "main.jdk.not.found", this.jdk);
        }
        if (this.baseDirArg == null) {
            object2 = new File(System.getProperty("user.dir"));
        } else {
            if (!this.baseDirArg.exists()) {
                throw new Fault(i18n, "main.cantFindFile", this.baseDirArg);
            }
            object2 = this.baseDirArg.getAbsoluteFile();
        }
        serializable = new ArrayList();
        for (File file : this.testFileArgs) {
            void object3;
            if (!file.isAbsolute()) {
                File file2 = new File((File)object2, file.getPath());
            }
            if (!object3.exists()) {
                throw new Fault(i18n, "main.cantFindFile", object3);
            }
            serializable.add(object3);
        }
        this.testFileArgs = serializable;
        String string = System.getProperty(JAVATEST_ANT_FILE_LIST);
        if (string != null) {
            this.antFileArgs.addAll(Main.readFileList(new File(string)));
        }
        if (this.testSuiteArg == null) {
            void var4_9;
            if (this.testFileArgs.size() > 0) {
                File file = this.testFileArgs.iterator().next();
            } else if (this.antFileArgs.size() > 0) {
                File file = this.antFileArgs.iterator().next();
            } else {
                throw new BadArgs(i18n, "main.noTestSuiteOrTests", new Object[0]);
            }
            this.testSuiteArg = this.getTestSuite((File)var4_9);
            if (this.testSuiteArg == null) {
                throw new Fault(i18n, "main.cantDetermineTestSuite", var4_9);
            }
        }
        if (this.workDirArg == null) {
            this.workDirArg = new File("JTwork");
            this.childArgs.add(0, "-w:" + this.workDirArg.getAbsolutePath());
        }
        if (this.reportDirArg == null) {
            this.reportDirArg = new File("JTreport");
            this.childArgs.add(0, "-r:" + this.reportDirArg.getAbsolutePath());
        }
        this.makeDir(this.reportDirArg);
        this.makeDir(this.workDirArg);
        this.makeDir(new File(this.workDirArg, "scratch"));
        if (!this.isThisVMOK()) {
            return this.execChild();
        }
        RegressionParameters regressionParameters = this.createParameters();
        this.checkLockFiles(regressionParameters.getWorkDirectory().getRoot(), "start");
        Harness.setClassDir(ProductInfo.getJavaTestClassDir());
        Keywords.setAllowNumericKeywords(true);
        TestEnvironment.addDefaultPropTable("(system properties)", System.getProperties());
        if (this.sameJVMFlag) {
            RegressionSecurityManager.install();
        }
        if (this.httpdFlag) {
            this.startHttpServer();
        }
        if (this.guiFlag) {
            this.showTool(regressionParameters);
            return 0;
        }
        try {
            int n = this.batchHarness(regressionParameters);
            return n;
        }
        finally {
            this.checkLockFiles(regressionParameters.getWorkDirectory().getRoot(), "done");
        }
    }

    private static String[] expandAtFiles(String[] stringArray) throws Fault {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() > 1 && string.charAt(0) == '@') {
                if ((string = string.substring(1)).charAt(0) == '@') {
                    arrayList.add(string);
                    continue;
                }
                Main.loadCmdFile(string, arrayList);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void loadCmdFile(String string, List<String> list) throws Fault {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindFile", string);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenFile", string, iOException);
        }
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(32, 255);
            streamTokenizer.whitespaceChars(0, 32);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            while (true) {
                if (streamTokenizer.nextToken() != -1) {
                    list.add(streamTokenizer.sval);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantRead", string, iOException);
        }
        finally {
            try {
                ((Reader)bufferedReader).close();
            }
            catch (IOException iOException) {}
        }
    }

    private static List<File> readFileList(File file) throws Fault {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Fault(i18n, "main.cantFindFile", file);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantOpenFile", file, iOException);
        }
        try {
            String string;
            ArrayList<File> arrayList = new ArrayList<File>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(new File(string));
            }
            ArrayList<File> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantRead", file, iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void writeFileList(File file, List<File> list) throws Fault {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (File file2 : list) {
                String string = file2.getPath();
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantWrite", file, iOException);
        }
    }

    public int[] getTestStats() {
        return this.testStats;
    }

    private boolean isThisVMOK() {
        if (this.reportOnlyFlag || this.checkFlag || !this.sameJVMFlag) {
            return true;
        }
        File file = this.canon(new File(this.workDirArg, "scratch"));
        File file2 = this.canon(new File(""));
        if (!file2.equals(file)) {
            if (debugChild) {
                System.err.println("dir mismatch: " + file2 + " " + file);
            }
            return false;
        }
        File file3 = this.canon(new File(System.getProperty("java.home")));
        if (file3.getName().toLowerCase().equals("jre")) {
            file3 = file3.getParentFile();
        }
        if (!file3.equals(this.jdk.getCanonicalFile())) {
            if (debugChild) {
                System.err.println("jdk mismatch: " + file3 + " " + this.jdk + " (" + this.jdk.getCanonicalFile() + ")");
            }
            return false;
        }
        if (System.getProperty("javatest.child") == null && !this.testVMOpts.isEmpty()) {
            if (debugChild) {
                System.err.println("need VM opts: " + this.testVMOpts);
            }
            return false;
        }
        if (this.classPathAppendArg.size() > 0) {
            if (debugChild) {
                System.err.println("need classPathAppend: " + this.classPathAppendArg);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execChild() throws Fault {
        Object object;
        String[] stringArray;
        if (System.getProperty("javatest.child") != null) {
            throw new AssertionError();
        }
        File file = this.findJar("javatest.jar", "lib/javatest.jar", Harness.class);
        if (file == null) {
            throw new Fault(i18n, "main.cantFind.javatest.jar", new Object[0]);
        }
        File file2 = this.findJar("jtreg.jar", "lib/jtreg.jar", this.getClass());
        if (file2 == null) {
            throw new Fault(i18n, "main.cantFind.jtreg.jar", new Object[0]);
        }
        File file3 = this.jdk.getAbsoluteFile();
        File file4 = new File(new File(file3, "bin"), "java");
        File file5 = new File(new File(file3, "lib"), "tools.jar");
        File file6 = this.canon(new File(this.workDirArg, "scratch"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file4.getPath());
        arrayList.add("-classpath");
        ArrayList<File> arrayList2 = new ArrayList<File>();
        arrayList2.add(file2);
        arrayList2.add(file5);
        arrayList2.addAll(this.classPathAppendArg);
        arrayList.add(Main.filesToAbsolutePath(arrayList2));
        arrayList.addAll(this.testVMOpts);
        if (this.antFileArgs.size() > 0) {
            try {
                stringArray = File.createTempFile("jtreg.", ".tmp", file6);
                Main.writeFileList((File)stringArray, this.antFileArgs);
                arrayList.add("-Djavatest.ant.file.list=" + stringArray);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "main.cantWriteTempFile", iOException);
            }
        }
        for (Map.Entry object22 : System.getProperties().entrySet()) {
            object = (String)object22.getKey();
            if (!((String)object).startsWith("javatest.")) continue;
            arrayList.add("-D" + (String)object + "=" + object22.getValue());
        }
        arrayList.add("-Djavatest.child=true");
        arrayList.add(Main.class.getName());
        for (String string : this.testVMOpts) {
            arrayList.add("-vmoption:" + string);
        }
        if (this.baseDirArg == null) {
            arrayList.add("-dir:" + System.getProperty("user.dir"));
        }
        arrayList.addAll(this.childArgs);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        File file7 = file6;
        if (debugChild) {
            System.err.println("Starting JavaTest child");
            System.err.println("Dir " + file7 + "; Command " + arrayList);
        }
        object = Runtime.getRuntime();
        Process process = null;
        try {
            Object object2;
            Object n;
            Object interruptedException;
            try {
                interruptedException = "CLASSPATH=" + file + PATHSEP + file2 + PATHSEP + this.jdk.getToolsJar();
                n = this.getEnvVars();
                object2 = new String[((String[])n).length + 1];
                System.arraycopy(n, 0, object2, 0, ((String[])n).length);
                object2[((String[])object2).length - 1] = interruptedException;
                process = ((Runtime)object).exec(stringArray, (String[])object2, file7);
            }
            catch (IOException iOException) {
                this.err.println("cannot start child VM");
                int n2 = 4;
                if (process != null) {
                    process.destroy();
                }
                return n2;
            }
            interruptedException = process.getInputStream();
            n = new StreamCopier((InputStream)interruptedException, this.out);
            ((Thread)n).start();
            object2 = process.getErrorStream();
            StreamCopier streamCopier = new StreamCopier((InputStream)object2, this.err);
            streamCopier.start();
            OutputStream outputStream = process.getOutputStream();
            if (outputStream != null) {
                outputStream.close();
            }
            ((StreamCopier)n).waitUntilDone();
            streamCopier.waitUntilDone();
            int n3 = process.waitFor();
            process = null;
            if (debugChild) {
                System.err.println("JavaTest child process: rc=" + n3);
            }
            ((InputStream)interruptedException).close();
            ((InputStream)object2).close();
            int n4 = n3;
            return n4;
        }
        catch (IOException iOException) {
            int n = 5;
            return n;
        }
        catch (InterruptedException interruptedException) {
            int n = 5;
            return n;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    private File getTestSuite(File file) {
        File file2 = this.canon(file);
        if (file2.isFile()) {
            file2 = file2.getParentFile();
        }
        while (file2 != null) {
            if (new File(file2, "TEST.ROOT").exists()) {
                return file2;
            }
            file2 = file2.getParentFile();
        }
        return null;
    }

    private String getEnvVar(String string) {
        for (String string2 : this.envVarArgs) {
            if (!string2.startsWith(string + "=")) continue;
            return StringArray.splitEqual(string2)[1];
        }
        return null;
    }

    private void makeDir(File file) throws Fault {
        if (file.isDirectory()) {
            return;
        }
        this.out.println("Directory \"" + file + "\" not found: creating");
        file.mkdirs();
        if (!file.isDirectory()) {
            throw new Fault(i18n, "main.cantCreateDir", file);
        }
    }

    private static List<File> pathToFiles(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split(File.pathSeparator)) {
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2));
        }
        return arrayList;
    }

    private static String filesToAbsolutePath(List<File> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (File file : list) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(file.getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    private static String join(Iterator<?> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }

    private RegressionParameters createParameters() throws BadArgs, Fault {
        File file = this.testSuiteArg;
        File file2 = this.workDirArg;
        try {
            Iterator<String> iterator;
            Object object;
            RegressionTestSuite regressionTestSuite = new RegressionTestSuite(file);
            RegressionParameters regressionParameters = (RegressionParameters)regressionTestSuite.createInterview();
            WorkDirectory workDirectory = WorkDirectory.isWorkDirectory(file2) ? WorkDirectory.open(file2, regressionTestSuite) : WorkDirectory.convert(file2, regressionTestSuite);
            regressionParameters.setWorkDirectory(workDirectory);
            regressionParameters.setRetainArgs(this.retainArgs);
            File file3 = regressionTestSuite.getRoot();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.testFileArgs != null) {
                for (File object2 : this.testFileArgs) {
                    File file4 = this.canon(object2);
                    if (file4.equals(file3)) {
                        arrayList = null;
                        continue;
                    }
                    object = this.getRelativePath(file3, file4);
                    if (object == null) {
                        throw new Fault(i18n, "main.testNotInTestSuite", object2);
                    }
                    if (arrayList == null) continue;
                    arrayList.add((String)object);
                }
            }
            if (arrayList != null && this.antFileArgs != null && this.antFileArgs.size() > 0) {
                iterator = workDirectory.getTestResultTable();
                for (File file4 : this.antFileArgs) {
                    object = this.canon(file4);
                    if (((File)object).equals(file3)) {
                        arrayList = null;
                        continue;
                    }
                    String string = this.getRelativePath(file3, (File)object);
                    if (string == null) {
                        throw new Fault(i18n, "main.testNotInTestSuite", file4);
                    }
                    if (arrayList == null || !((TestResultTable)((Object)iterator)).validatePath(string)) continue;
                    arrayList.add(string);
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                regressionParameters.setTests(arrayList);
            }
            if (this.keywordsExprArg != null) {
                regressionParameters.setKeywordsExpr(this.keywordsExprArg);
            }
            regressionParameters.setExcludeLists(this.excludeListArgs.toArray(new File[this.excludeListArgs.size()]));
            if (this.priorStatusValuesArg == null || this.priorStatusValuesArg.length() == 0) {
                regressionParameters.setPriorStatusValues(null);
            } else {
                iterator = (Iterator<String>)new boolean[4];
                iterator[0] = this.priorStatusValuesArg.indexOf("pass") != -1;
                iterator[1] = (Iterator<String>)(this.priorStatusValuesArg.indexOf("fail") != -1 ? 1 : 0);
                iterator[2] = (Iterator<String>)(this.priorStatusValuesArg.indexOf("erro") != -1 ? 1 : 0);
                iterator[3] = (Iterator<String>)(this.priorStatusValuesArg.indexOf("notr") != -1 ? 1 : 0);
                regressionParameters.setPriorStatusValues((boolean[])iterator);
            }
            if (this.concurrencyArg != null) {
                try {
                    regressionParameters.setConcurrency(Integer.parseInt(this.concurrencyArg));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badConcurrency", new Object[0]);
                }
            }
            if (this.timeoutFactorArg != null) {
                try {
                    regressionParameters.setTimeoutFactor(Integer.parseInt(this.timeoutFactorArg));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new BadArgs(i18n, "main.badTimeoutFactor", new Object[0]);
                }
            }
            if (!regressionParameters.isValid()) {
                throw new Fault(i18n, "main.badParams", regressionParameters.getErrorMessage());
            }
            for (String string : this.testVMOpts) {
                if (!string.startsWith("-Xrunjcov")) continue;
                if (this.testVMOpts.contains("-XX:+EnableJVMPIInstructionStartEvent")) break;
                this.testVMOpts.add("-XX:+EnableJVMPIInstructionStartEvent");
                break;
            }
            if (this.testVMOpts.size() > 0) {
                regressionParameters.setTestVMOptions(this.testVMOpts);
            }
            if (this.testCompilerOpts.size() > 0) {
                regressionParameters.setTestCompilerOptions(this.testCompilerOpts);
            }
            regressionParameters.setCheck(this.checkFlag);
            regressionParameters.setSameJVM(this.sameJVMFlag);
            regressionParameters.setEnvVars(this.getEnvVars());
            regressionParameters.setJDK(this.jdk);
            if (this.ignoreKind != null) {
                regressionParameters.setIgnoreKind(this.ignoreKind);
            }
            return regressionParameters;
        }
        catch (TestSuite.Fault fault) {
            fault.printStackTrace();
            throw new Fault(i18n, "main.cantOpenTestSuite", file, fault);
        }
        catch (WorkDirectory.Fault fault) {
            throw new Fault(i18n, "main.cantRead", file2.getName(), fault);
        }
        catch (IOException iOException) {
            throw new Fault(i18n, "main.cantRead", file2.getName(), iOException);
        }
    }

    private File canon(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private String getRelativePath(File file, File file2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (file2 != null) {
            if (file2.equals(file)) {
                return stringBuilder.toString();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '/');
            }
            stringBuilder.insert(0, file2.getName());
            file2 = file2.getParentFile();
        }
        return null;
    }

    private Harness createHarness() throws Fault {
        Class<?> clazz;
        BackupPolicy backupPolicy = this.createBackupPolicy();
        Harness harness = new Harness();
        harness.setBackupPolicy(backupPolicy);
        if (this.observerClassName != null) {
            try {
                URL[] uRLArray;
                if (this.observerPathArg == null) {
                    clazz = Class.forName(this.observerClassName);
                } else {
                    uRLArray = new URL[this.observerPathArg.size()];
                    int n = 0;
                    for (File file : this.observerPathArg) {
                        try {
                            uRLArray[n++] = file.toURL();
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                    URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                    clazz = uRLClassLoader.loadClass(this.observerClassName);
                }
                uRLArray = (Harness.Observer)clazz.newInstance();
                harness.addObserver((Harness.Observer)uRLArray);
            }
            catch (ClassCastException classCastException) {
                throw new Fault(i18n, "main.obsvrType", Harness.Observer.class.getName(), this.observerClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Fault(i18n, "main.obsvrNotFound", this.observerClassName);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Fault(i18n, "main.obsvrFault", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new Fault(i18n, "main.obsvrFault", instantiationException);
            }
        }
        if (verbose != null) {
            clazz = new RegressionObserver(verbose, this.out, this.err);
            harness.addObserver((Harness.Observer)((Object)clazz));
        }
        return harness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int batchHarness(InterviewParameters interviewParameters) throws Fault, Harness.Fault, InterruptedException {
        try {
            boolean bl;
            boolean bl2;
            Object object;
            Object object2;
            if (this.reportOnlyFlag) {
                this.testStats = new int[4];
                object2 = this.getResultsIterator(interviewParameters);
                while (object2.hasNext()) {
                    object = (TestResult)object2.next();
                    int n = ((TestResult)object).getStatus().getType();
                    this.testStats[n] = this.testStats[n] + 1;
                }
                bl2 = this.testStats[1] == 0 && this.testStats[2] == 0;
            } else {
                object2 = this.createHarness();
                ((Harness)object2).addObserver(new BatchObserver());
                bl2 = ((Harness)object2).batch(interviewParameters);
            }
            this.showResultStats(this.testStats);
            boolean bl3 = bl = !Boolean.getBoolean("javatest.noReportRequired");
            if (bl) {
                try {
                    object = new Report();
                    Report.Settings settings = new Report.Settings(interviewParameters);
                    settings.setHtmlMainReport(true, true);
                    settings.setFilter(new CompositeFilter(interviewParameters.getFilters()));
                    ((Report)object).writeReport(settings, this.reportDirArg);
                    this.out.println("Report written to " + new File(this.reportDirArg, "report.html"));
                }
                catch (IOException iOException) {
                    this.out.println("Error while writing report: " + iOException);
                }
            }
            if (!this.reportOnlyFlag) {
                this.out.println("Results written to " + interviewParameters.getWorkDirectory().getPath());
            }
            if (!bl2) {
                this.err.println(i18n.getString("main.testsFailed"));
            }
            int n = this.testStats[2] > 0 ? 2 : (this.testStats[1] > 0 ? 1 : 0);
            return n;
        }
        finally {
            this.out.flush();
            this.err.flush();
        }
    }

    private Iterator getResultsIterator(InterviewParameters interviewParameters) {
        TestResultTable testResultTable = interviewParameters.getWorkDirectory().getTestResultTable();
        testResultTable.waitUntilReady();
        String[] stringArray = interviewParameters.getTests();
        TestFilter[] testFilterArray = interviewParameters.getFilters();
        if (stringArray == null) {
            return testResultTable.getIterator(testFilterArray);
        }
        return testResultTable.getIterator(stringArray, testFilterArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTool(final InterviewParameters interviewParameters) throws BadArgs {
        Startup startup = new Startup();
        try {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Desktop desktop = new Desktop();
                    ExecToolManager execToolManager = (ExecToolManager)desktop.getToolManager(ExecToolManager.class);
                    if (execToolManager == null) {
                        throw new AssertionError((Object)"Cannot find ExecToolManager");
                    }
                    execToolManager.startTool(interviewParameters);
                    desktop.setVisible(true);
                }
            });
        }
        finally {
            startup.disposeLater();
        }
    }

    private void showResultStats(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        String string = n + n2 + n3 + n4 == 0 ? i18n.getString("main.noTests") : i18n.getString("main.tests", new Object[]{new Integer(n), new Integer(n > 0 && n2 + n3 + n4 > 0 ? 1 : 0), new Integer(n2), new Integer(n2 > 0 && n3 + n4 > 0 ? 1 : 0), new Integer(n3), new Integer(n3 > 0 && n4 > 0 ? 1 : 0), new Integer(n4)});
        this.out.println(string);
    }

    private BackupPolicy createBackupPolicy() {
        return new BackupPolicy(){
            private int numBackupsToKeep = Integer.getInteger("javatest.backup.count", 5);
            private String[] ignoreExtns = StringArray.split(System.getProperty("javatest.backup.ignore", ".jtr"));

            @Override
            public int getNumBackupsToKeep(File file) {
                return this.numBackupsToKeep;
            }

            @Override
            public boolean isBackupRequired(File file) {
                if (this.ignoreExtns != null) {
                    for (int i = 0; i < this.ignoreExtns.length; ++i) {
                        if (!file.getPath().endsWith(this.ignoreExtns[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    private void startHttpServer() {
        HttpdServer httpdServer = new HttpdServer();
        Thread thread = new Thread(httpdServer);
        PageGenerator.setSWName(ProductInfo.getName());
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        Date date = ProductInfo.getBuildDate();
        String string = date != null ? dateFormat.format(date) : i18n.getString("main.nobDate");
        PageGenerator.setSWBuildDate(string);
        PageGenerator.setSWVersion(ProductInfo.getVersion());
        thread.start();
    }

    private String[] getEnvVars() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("windows")) {
            this.addEnvVars(treeMap, DEFAULT_WINDOWS_ENV_VARS);
            this.addEnvVars(treeMap, "PATH");
        } else {
            this.addEnvVars(treeMap, DEFAULT_UNIX_ENV_VARS);
            this.addEnvVars(treeMap, "PATH=/bin:/usr/bin");
        }
        this.addEnvVars(treeMap, this.envVarArgs);
        return treeMap.values().toArray(new String[treeMap.size()]);
    }

    private void addEnvVars(Map<String, String> map, String string) {
        this.addEnvVars(map, string.split(","));
    }

    private void addEnvVars(Map<String, String> map, String[] stringArray) {
        this.addEnvVars(map, Arrays.asList(stringArray));
    }

    private void addEnvVars(Map<String, String> map, List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            String string2;
            if ((string = string.trim()).length() == 0) continue;
            int n = string.indexOf("=");
            if (n == -1) {
                string2 = System.getenv(string);
                if (string2 == null) continue;
                map.put(string, string + "=" + string2);
                continue;
            }
            if (n <= 0) continue;
            string2 = string.substring(0, n);
            map.put(string2, string);
        }
    }

    private static String combineKeywords(String string, String string2) {
        return string == null ? string2 : string + " & " + string2;
    }

    private File findJar(String string, String string2, Class<?> clazz) {
        String string3;
        if (string != null && (string3 = System.getProperty(string)) != null) {
            return new File(string3);
        }
        if (string2 != null && (string3 = System.getProperty("jtreg.home")) != null) {
            return new File(string3, string2);
        }
        if (clazz != null) {
            try {
                int n;
                String string4;
                string3 = clazz.getName().replace(".", "/") + ".class";
                URI uRI = this.getClass().getClassLoader().getResource(string3).toURI();
                if (uRI.getScheme().equals("jar") && (uRI = new URI((string4 = uRI.getRawSchemeSpecificPart()).substring(0, n = string4.lastIndexOf("!")))).getScheme().equals("file")) {
                    return new File(uRI.getPath());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return null;
    }

    private static final void exit(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof JavaTestSecurityManager) {
            ((JavaTestSecurityManager)securityManager).setAllowExit(true);
        }
        System.exit(n);
    }

    private void checkLockFiles(File file, String string) {
    }

    static /* synthetic */ int[] access$3302(Main main, int[] nArray) {
        main.testStats = nArray;
        return nArray;
    }

    static {
        DEFAULT_UNIX_ENV_VARS = new String[]{"DISPLAY", "HOME", "LANG", "LC_ALL", "LC_TYPE", "LPDEST", "PRINTER", "TZ", "XMODIFIERS"};
        DEFAULT_WINDOWS_ENV_VARS = new String[]{"SystemDrive", "SystemRoot", "windir", "TMP", "TEMP"};
        debugChild = Boolean.getBoolean("javatest.regtest.debugChild");
        PATHSEP = System.getProperty("path.separator");
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
    }

    private class BatchObserver
    implements Harness.Observer {
        private BatchObserver() {
        }

        @Override
        public void startingTestRun(Parameters parameters) {
            Main.access$3302(Main.this, new int[4]);
        }

        @Override
        public void startingTest(TestResult testResult) {
        }

        @Override
        public void finishedTest(TestResult testResult) {
            int[] nArray = Main.this.testStats;
            int n = testResult.getStatus().getType();
            nArray[n] = nArray[n] + 1;
        }

        @Override
        public void stoppingTestRun() {
        }

        @Override
        public void finishedTesting() {
        }

        @Override
        public void finishedTestRun(boolean bl) {
        }

        @Override
        public void error(String string) {
            Main.this.err.println(i18n.getString("main.error", string));
        }
    }

    static class StreamCopier
    extends Thread {
        private DataInputStream in;
        private PrintWriter out;
        private boolean done;
        private static int serial;

        StreamCopier(InputStream inputStream, PrintWriter printWriter) {
            super(Thread.currentThread().getName() + "_StreamCopier_" + serial++);
            this.in = new DataInputStream(inputStream);
            this.out = printWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                while ((object = this.in.readLine()) != null) {
                    this.out.println((String)object);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = this;
            synchronized (object) {
                this.done = true;
                this.notifyAll();
            }
        }

        public synchronized boolean isDone() {
            return this.done;
        }

        public synchronized void waitUntilDone() throws InterruptedException {
            boolean bl = false;
            while (!(bl = Thread.interrupted()) && !this.done) {
                this.wait(1000L);
            }
            if (bl) {
                throw new InterruptedException();
            }
        }
    }

    public static class Ant
    extends MatchingTask {
        private Main m = new Main();
        private File jdk;
        private File dir;
        private File reportDir;
        private File workDir;
        private String status;
        private String vmOption;
        private String vmOptions;
        private String javacOption;
        private String javacOptions;
        private String verbose;
        private boolean sameVM;
        private boolean otherVM;
        private Boolean failOnError;
        private String resultProperty;
        private String failureProperty;
        private String errorProperty;
        private List<Commandline.Argument> args = new ArrayList<Commandline.Argument>();

        public void setDir(File file) {
            this.dir = file;
        }

        public void setReportDir(File file) {
            this.reportDir = file;
        }

        public void setWorkDir(File file) {
            this.workDir = file;
        }

        public void setJDK(File file) {
            this.jdk = file;
        }

        public void setVMOption(String string) {
            this.vmOption = string;
        }

        public void setVMOptions(String string) {
            this.vmOptions = string;
        }

        public void setJavacOption(String string) {
            this.javacOption = string;
        }

        public void setJavacOptions(String string) {
            this.javacOptions = string;
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public void setVerbose(String string) {
            this.verbose = string;
        }

        public void setSameVM(boolean bl) {
            this.sameVM = bl;
        }

        public void setOtherVM(boolean bl) {
            this.otherVM = bl;
        }

        public void setResultProperty(String string) {
            this.resultProperty = string;
        }

        public void setFailureProperty(String string) {
            this.failureProperty = string;
        }

        public void setErrorProperty(String string) {
            this.errorProperty = string;
        }

        public void setFailOnError(boolean bl) {
            this.failOnError = bl;
        }

        public void addArg(Commandline.Argument argument) {
            this.args.add(argument);
        }

        public void execute() {
            Project project = this.getProject();
            Hashtable hashtable = project.getProperties();
            for (Map.Entry entry : hashtable.entrySet()) {
                String string = (String)entry.getKey();
                if (!string.startsWith("javatest.")) continue;
                System.setProperty(string, (String)entry.getValue());
            }
            try {
                Map.Entry entry;
                AntOptionDecoder antOptionDecoder = new AntOptionDecoder(this.m.options);
                antOptionDecoder.process("dir", this.dir);
                antOptionDecoder.process("reportDir", this.reportDir);
                antOptionDecoder.process("workDir", this.workDir);
                antOptionDecoder.process(Main.JDK, this.jdk);
                antOptionDecoder.process(Main.VERBOSE, this.verbose);
                antOptionDecoder.process("sameVM", this.sameVM);
                antOptionDecoder.process("otherVM", this.otherVM);
                antOptionDecoder.process("vmoption", this.vmOption);
                antOptionDecoder.process("vmoptions", this.vmOptions);
                antOptionDecoder.process("javacoption", this.javacOption);
                antOptionDecoder.process("javacoptions", this.javacOptions);
                antOptionDecoder.process("status", this.status);
                if (this.args.size() > 0) {
                    entry = new ArrayList();
                    for (Commandline.Argument argument : this.args) {
                        entry.addAll(Arrays.asList(argument.getParts()));
                    }
                    antOptionDecoder.decodeArgs((List<String>)((Object)entry));
                }
                if (this.m.testFileArgs.size() == 0 && this.dir != null) {
                    entry = this.getDirectoryScanner(this.dir);
                    this.addPaths(this.dir, entry.getIncludedFiles());
                }
                int n = this.m.run();
                if (this.resultProperty != null) {
                    project.setProperty(this.resultProperty, String.valueOf(n));
                }
                if (this.failureProperty != null && n >= 1) {
                    project.setProperty(this.failureProperty, i18n.getString("main.testsFailed"));
                }
                if (this.errorProperty != null && n >= 2) {
                    project.setProperty(this.errorProperty, i18n.getString("main.testsError"));
                }
                if (this.failOnError == null) {
                    this.failOnError = this.resultProperty == null && this.failureProperty == null && this.errorProperty == null;
                }
                if (this.failOnError.booleanValue() && n != 0) {
                    throw new BuildException(i18n.getString("main.testsFailed"));
                }
            }
            catch (BadArgs badArgs) {
                throw new BuildException(badArgs.getMessage(), (Throwable)badArgs);
            }
            catch (Fault fault) {
                throw new BuildException(fault.getMessage(), (Throwable)fault);
            }
            catch (Harness.Fault fault) {
                throw new BuildException(fault.getMessage(), (Throwable)fault);
            }
            catch (InterruptedException interruptedException) {
                throw new BuildException(i18n.getString("main.interrupted"), (Throwable)interruptedException);
            }
        }

        private void addPaths(File file, String[] stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.m.antFileArgs.add(new File(file, string));
                }
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string, Object ... objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

