/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.Main;
import com.sun.javatest.regtest.Option;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OptionDecoder {
    private Map<String, Option> simpleOptions = new HashMap<String, Option>();
    private List<Option> matchOptions = new ArrayList<Option>();
    private Option fileOption;
    private Map<String, String> locks = new HashMap<String, String>();
    private boolean inFiles;
    protected static boolean debugOptions = Boolean.getBoolean("javatest.regtest.debugOptions");
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Main.class);

    public OptionDecoder(Option[] optionArray) {
        block4: for (Option option : optionArray) {
            switch (option.argType) {
                case WILDCARD: {
                    this.matchOptions.add(option);
                    continue block4;
                }
                case FILE: {
                    this.fileOption = option;
                    continue block4;
                }
                default: {
                    for (String string : option.names) {
                        this.simpleOptions.put(string.toLowerCase(), option);
                    }
                }
            }
        }
    }

    public void decodeArgs(String[] stringArray) throws BadArgs {
        this.decodeArgs(Arrays.asList(stringArray));
    }

    public void decodeArgs(List<String> list) throws BadArgs {
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.length() == 0) {
                throw new BadArgs(i18n, "opt.empty", new Object[0]);
            }
            if (!string.startsWith("-")) {
                this.inFiles = true;
            }
            if (this.inFiles) {
                this.fileOption.process(null, string);
                continue;
            }
            this.decodeArg(string, iterator);
        }
    }

    private void decodeArg(String string, Iterator<String> iterator) throws BadArgs {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n == -1) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        Option option = this.getOption(string3);
        if (option == null) {
            throw new BadArgs(i18n, "opt.unknown", string3);
        }
        switch (option.argType) {
            case NONE: {
                if (string2 == null) break;
                throw new BadArgs(i18n, "opt.unexpected.value", string);
            }
            case STD: {
                if (string2 != null) break;
                throw new BadArgs(i18n, "opt.missing.value", string);
            }
            case OLD: {
                if (string2 == null && iterator.hasNext()) {
                    string2 = iterator.next();
                }
                if (string2 != null) break;
                throw new BadArgs(i18n, "opt.missing.value", string);
            }
            case OPT: {
                break;
            }
            case WILDCARD: {
                string2 = option.getValue(string);
                break;
            }
            case REST: {
                string2 = OptionDecoder.join(iterator, " ");
            }
        }
        this.checkConflicts(option, string3);
        if (debugOptions) {
            System.err.println("OptionDecoder.decodeArg: " + string3 + " " + string2);
        }
        option.process(string, string2);
    }

    public void addFile(File file) throws BadArgs {
        this.fileOption.process(null, file.getPath());
    }

    public void addFile(String string) throws BadArgs {
        this.fileOption.process(null, string);
    }

    protected Option getOption(String string) {
        Option option;
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        if ((option = this.simpleOptions.get(string.toLowerCase())) != null) {
            return option;
        }
        for (Option option2 : this.matchOptions) {
            if (!option2.matches(string)) continue;
            return option2;
        }
        return null;
    }

    protected void checkConflicts(Option option, String string) throws BadArgs {
        if (option.lockName != null) {
            String string2 = this.locks.get(option.lockName);
            if (string2 != null) {
                if (string2.equals(string)) {
                    throw new BadArgs(i18n, "opt.duplicate", string);
                }
                throw new BadArgs(i18n, "opt.conflict", string2, string);
            }
            this.locks.put(option.lockName, string);
        }
    }

    private static String join(Iterator<?> iterator, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString();
    }
}

