/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.Status;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.lib.ProcessCommand;
import com.sun.javatest.regtest.IgnoreKind;
import com.sun.javatest.regtest.JDK;
import com.sun.javatest.regtest.RegressionEnvironment;
import com.sun.javatest.regtest.StringArray;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RegressionParameters
extends BasicInterviewParameters
implements Parameters.EnvParameters {
    private static final String ENVVARS = ".envVars";
    private static final String CHECK = ".check";
    private static final String JCOV_OPTION = ".jcovOption";
    private static final String JCOV_OPTION_INITED = ".jcovOption.inited";
    private static final String JDK = ".jdk";
    private static final String SAME_JVM = ".sameJVM";
    private static final String TEST_VM_OPTIONS = ".testVMOpts";
    private static final String IGNORE = ".ignore";
    private static final String RETAIN_ARGS = ".retain";
    private String[] envVars;
    private boolean check;
    boolean sameJVM;
    IgnoreKind ignoreKind = IgnoreKind.ERROR;
    JDK jdk;
    private File javaHome;
    private String javaVersion;
    private String javaFullVersion;
    private String stdJavaClassPath;
    private String stdJDKClassPath;
    private String javaTestClassPath;
    private List<String> testVMOpts;
    private List<String> testCompilerOpts;
    private List<String> retainArgs;
    private Set<Integer> retainStatusSet = new HashSet<Integer>(4);
    private Pattern retainFilesPattern;
    private static final String FILESEP = System.getProperty("file.separator");
    private static final String PATHSEP = System.getProperty("path.separator");
    private static final String LINESEP = System.getProperty("line.separator");

    public RegressionParameters(String string, TestSuite testSuite) throws Interview.Fault {
        super(string, testSuite);
        this.setTitle("RegTest Configuration Editor");
        this.setEdited(false);
    }

    public void setTests(List<String> list) {
        this.setTests(list == null ? null : list.toArray(new String[list.size()]));
    }

    public void setTests(String[] stringArray) {
        Parameters.MutableTestsParameters mutableTestsParameters = (Parameters.MutableTestsParameters)this.getTestsParameters();
        mutableTestsParameters.setTests(stringArray);
    }

    public void setKeywordsExpr(String string) {
        Parameters.MutableKeywordsParameters mutableKeywordsParameters = (Parameters.MutableKeywordsParameters)this.getKeywordsParameters();
        mutableKeywordsParameters.setKeywords(3, string);
    }

    public void setConcurrency(int n) {
        Parameters.MutableConcurrencyParameters mutableConcurrencyParameters = (Parameters.MutableConcurrencyParameters)this.getConcurrencyParameters();
        mutableConcurrencyParameters.setConcurrency(n);
    }

    public void setTimeoutFactor(int n) {
        Parameters.MutableTimeoutFactorParameters mutableTimeoutFactorParameters = (Parameters.MutableTimeoutFactorParameters)this.getTimeoutFactorParameters();
        mutableTimeoutFactorParameters.setTimeoutFactor(n);
    }

    public void setExcludeLists(File[] fileArray) {
        Parameters.MutableExcludeListParameters mutableExcludeListParameters = (Parameters.MutableExcludeListParameters)this.getExcludeListParameters();
        mutableExcludeListParameters.setExcludeFiles(fileArray);
    }

    public void setPriorStatusValues(boolean[] blArray) {
        Parameters.MutablePriorStatusParameters mutablePriorStatusParameters = (Parameters.MutablePriorStatusParameters)this.getPriorStatusParameters();
        mutablePriorStatusParameters.setPriorStatusValues(blArray);
    }

    @Override
    public TestEnvironment getEnv() {
        try {
            return new RegressionEnvironment(this);
        }
        catch (TestEnvironment.Fault fault) {
            return null;
        }
    }

    @Override
    public Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    @Override
    protected Question getEnvFirstQuestion() {
        return this.getEnvSuccessorQuestion();
    }

    @Override
    public void load(Map map, boolean bl) throws Interview.Fault {
        super.load(map, bl);
        String string = this.getTag();
        String string2 = (String)map.get(string + ENVVARS);
        if (string2 != null) {
            this.setEnvVars(StringArray.splitSeparator("\n", string2));
        }
        if ((string2 = (String)map.get(string + CHECK)) != null) {
            this.setCheck(string2.equals("true"));
        }
        if ((string2 = (String)map.get(string + SAME_JVM)) != null) {
            this.setSameJVM(string2.equals("true"));
        }
        if ((string2 = (String)map.get(string + IGNORE)) != null) {
            this.setIgnoreKind(IgnoreKind.valueOf(string2));
        }
        if ((string2 = (String)map.get(string + JDK)) != null) {
            this.setJDK(new JDK(string2));
        }
        if ((string2 = (String)map.get(string + TEST_VM_OPTIONS)) != null) {
            this.setTestVMOptions(Arrays.asList(StringArray.splitSeparator("\n", string2)));
        }
        if ((string2 = (String)map.get(string + RETAIN_ARGS)) != null) {
            this.setRetainArgs(Arrays.asList(StringArray.splitSeparator("\n", string2)));
        }
    }

    @Override
    public void save(Map map) {
        this.save0(map);
        super.save(map);
    }

    private void save0(Map<String, String> map) {
        String string = this.getTag();
        if (this.envVars != null) {
            map.put(string + ENVVARS, StringArray.join(this.envVars, "\n"));
        }
        map.put(string + CHECK, String.valueOf(this.check));
        map.put(string + SAME_JVM, String.valueOf(this.sameJVM));
        map.put(string + IGNORE, String.valueOf((Object)this.ignoreKind));
        if (this.jdk != null) {
            map.put(string + JDK, this.jdk.getPath());
        }
        if (this.retainArgs != null) {
            map.put(string + RETAIN_ARGS, StringArray.join(this.retainArgs.toArray(new String[this.retainArgs.size()]), "\n"));
        }
        if (this.testVMOpts != null) {
            map.put(string + TEST_VM_OPTIONS, StringArray.join(this.testVMOpts.toArray(new String[this.testVMOpts.size()]), "\n"));
        }
    }

    String[] getEnvVars() {
        if (this.envVars == null) {
            String string = System.getProperty("envVars");
            this.envVars = string != null && string.length() != 0 ? StringArray.splitSeparator(",", string) : new String[0];
        }
        return this.envVars;
    }

    void setEnvVars(String[] stringArray) {
        this.envVars = stringArray == null ? new String[]{} : stringArray;
    }

    boolean isCheck() {
        return this.check;
    }

    void setCheck(boolean bl) {
        this.check = bl;
    }

    void setSameJVM(boolean bl) {
        this.sameJVM = bl;
    }

    boolean isSameJVM() {
        return this.sameJVM;
    }

    boolean isOtherJVM() {
        return !this.sameJVM;
    }

    void setIgnoreKind(IgnoreKind ignoreKind) {
        ((Object)((Object)ignoreKind)).getClass();
        this.ignoreKind = ignoreKind;
    }

    IgnoreKind getIgnoreKind() {
        return this.ignoreKind;
    }

    void setJDK(JDK jDK) {
        jDK.getClass();
        this.jdk = jDK;
    }

    JDK getJDK() {
        return this.jdk;
    }

    private File getJavaHome() {
        if (this.javaHome == null) {
            this.initJavaHome();
        }
        return this.javaHome;
    }

    private void initJavaHome() {
        String[] stringArray = this.getEnvVars();
        String string = System.getProperty("java.home");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("TESTJAVAHOME")) continue;
            String string2 = StringArray.splitEqual(stringArray[i])[1];
            if (string2.equals("samevm")) break;
            string = string2;
            break;
        }
        this.javaHome = new File(string);
    }

    String getJavaVersion() {
        if (this.javaVersion == null) {
            String string = "unknown";
            if (this.isOtherJVM()) {
                String[] stringArray;
                StringWriter stringWriter;
                StringWriter stringWriter2;
                Status status = null;
                ProcessCommand processCommand = new ProcessCommand();
                String[] stringArray2 = new String[]{"CLASSPATH=" + this.getJavaTestClassPath(), this.jdk.getJavaProg().getPath(), "com.sun.javatest.regtest.GetSystemProperty", "java.specification.version"};
                status = processCommand.run(stringArray2, new PrintWriter(stringWriter2 = new StringWriter()), new PrintWriter(stringWriter = new StringWriter()));
                if (status.isPassed() && (stringArray = StringArray.splitEqual(stringWriter.toString().trim())).length == 2 && stringArray[0].equals("java.specification.version")) {
                    string = stringArray[1];
                }
            } else {
                string = System.getProperty("java.specification.version");
            }
            this.javaVersion = string == null || string.length() == 0 ? "1.1" : string;
        }
        return this.javaVersion;
    }

    String getJavaFullVersion() {
        if (this.javaFullVersion == null) {
            Status status = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.jdk.getJavaProg().getPath());
            arrayList.addAll(this.getTestVMOptions());
            arrayList.add("-version");
            StringWriter stringWriter = new StringWriter();
            StringWriter stringWriter2 = new StringWriter();
            ProcessCommand processCommand = new ProcessCommand();
            status = processCommand.run(arrayList.toArray(new String[arrayList.size()]), new PrintWriter(stringWriter2), new PrintWriter(stringWriter));
            if (status.isPassed()) {
                String string = stringWriter2.toString().trim();
                this.javaFullVersion = "(" + this.getJDK() + ")" + LINESEP;
                this.javaFullVersion = string.length() == 0 ? this.javaFullVersion + stringWriter.toString().trim() : this.javaFullVersion + string;
            } else {
                this.javaFullVersion = this.getJDK().getPath();
            }
        }
        return this.javaFullVersion;
    }

    String getStdJavaClassPath() {
        if (this.stdJavaClassPath == null) {
            File file = this.getJavaHome();
            File file2 = new File(file, "lib");
            this.stdJavaClassPath = new File(file, "classes") + PATHSEP + new File(file2, "classes") + PATHSEP + new File(file2, "classes.zip");
        }
        return this.stdJavaClassPath;
    }

    String getStdJDKClassPath() {
        if (this.stdJDKClassPath == null) {
            this.stdJDKClassPath = this.getJDK().getToolsJar().getPath();
        }
        return this.stdJDKClassPath;
    }

    String getJavaTestClassPath() {
        if (this.javaTestClassPath == null) {
            File file = ProductInfo.getJavaTestClassDir();
            this.javaTestClassPath = file.getPath();
            int n = this.javaTestClassPath.indexOf("javatest.jar");
            if (n > 0) {
                String string = this.javaTestClassPath.substring(0, n) + "jtreg.jar";
                this.javaTestClassPath = this.javaTestClassPath + PATHSEP + string;
            }
        }
        return this.javaTestClassPath;
    }

    List<String> getTestVMOptions() {
        if (this.testVMOpts == null) {
            this.testVMOpts = new ArrayList<String>();
        }
        return this.testVMOpts;
    }

    List<String> getTestToolVMOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.getTestVMOptions()) {
            arrayList.add("-J" + string);
        }
        return arrayList;
    }

    void setTestVMOptions(List<String> list) {
        this.testVMOpts = list;
    }

    List<String> getTestCompilerOptions() {
        if (this.testCompilerOpts == null) {
            this.testCompilerOpts = new ArrayList<String>();
        }
        return this.testCompilerOpts;
    }

    void setTestCompilerOptions(List<String> list) {
        this.testCompilerOpts = list;
    }

    List<String> getRetainArgs() {
        return this.retainArgs;
    }

    void setRetainArgs(List<String> list) {
        this.retainArgs = list;
        this.retainStatusSet.clear();
        if (list == null) {
            this.retainFilesPattern = null;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            if (string.equals("all")) {
                this.retainStatusSet.add(0);
                this.retainStatusSet.add(1);
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.equals("pass")) {
                this.retainStatusSet.add(0);
                continue;
            }
            if (string.equals("fail")) {
                this.retainStatusSet.add(1);
                continue;
            }
            if (string.equals("error")) {
                this.retainStatusSet.add(2);
                continue;
            }
            if (string.length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            boolean bl = false;
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '*': {
                        if (bl) {
                            stringBuilder.append("\\E");
                            bl = false;
                        }
                        stringBuilder.append(".*");
                        continue block4;
                    }
                    default: {
                        if (!bl) {
                            stringBuilder.append("\\Q");
                            bl = true;
                        }
                        stringBuilder.append(c);
                    }
                }
            }
            if (!bl) continue;
            stringBuilder.append("\\E");
        }
        this.retainFilesPattern = stringBuilder.length() == 0 ? null : Pattern.compile(stringBuilder.toString());
    }

    boolean isRetainEnabled() {
        return this.retainArgs != null;
    }

    Set<Integer> getRetainStatus() {
        return this.retainStatusSet;
    }

    Pattern getRetainFilesPattern() {
        return this.retainFilesPattern;
    }
}

