/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.FileFilter;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.io.File;
import java.util.Map;
import java.util.Vector;

public abstract class FileListQuestion
extends Question {
    private static final File[] empty = new File[0];
    protected File[] value;
    private File[] defaultValue;
    private File baseDir;
    private boolean baseRelativeOnly;
    private FileFilter[] filters;
    private boolean duplicatesAllowed = true;

    protected FileListQuestion(Interview interview, String string) {
        super(interview, string);
        if (interview.getInterviewSemantics() > 0) {
            this.clear();
        }
        this.setDefaultValue(this.value);
    }

    public File[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(File[] fileArray) {
        this.defaultValue = fileArray;
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.duplicatesAllowed = bl;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public File[] getValue() {
        return this.value;
    }

    public File[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        return FileListQuestion.join(this.value);
    }

    public void setValue(String string) {
        this.setValue(string == null ? (File[])null : FileListQuestion.split(string));
    }

    public void setValue(File[] fileArray) {
        File[] fileArray2 = this.value;
        this.value = fileArray;
        if (!FileListQuestion.equal(this.value, fileArray2)) {
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public FileFilter[] getFilters() {
        return this.filters;
    }

    public void setFilter(FileFilter fileFilter) {
        this.filters = new FileFilter[]{fileFilter};
    }

    public void setFilters(FileFilter[] fileFilterArray) {
        this.filters = fileFilterArray;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public void setBaseDirectory(File file) {
        this.baseDir = file;
    }

    public boolean isBaseRelativeOnly() {
        return this.baseRelativeOnly;
    }

    public void setBaseRelativeOnly(boolean bl) {
        this.baseRelativeOnly = bl;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof File[]) {
            this.setValue((File[])v);
        } else if (v instanceof String) {
            this.setValue(FileListQuestion.split((String)v));
        }
    }

    public static File[] split(String string) {
        if (string == null) {
            return empty;
        }
        char c = string.indexOf(10) == -1 ? (char)' ' : '\n';
        Vector<File> vector = new Vector<File>();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) {
                if (n != -1) {
                    vector.addElement(new File(string.substring(n, i)));
                }
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            vector.addElement(new File(string.substring(n)));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, FileListQuestion.join(this.value));
        }
    }

    public static String join(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return "";
        }
        int n = fileArray.length - 1;
        for (int i = 0; i < fileArray.length; ++i) {
            n += fileArray[i].getPath().length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        String string = fileArray[0].getPath();
        stringBuffer.append(string);
        if (fileArray.length == 1 && string.indexOf(32) != -1) {
            stringBuffer.append('\n');
        } else {
            for (int i = 1; i < fileArray.length; ++i) {
                stringBuffer.append('\n');
                stringBuffer.append(fileArray[i].getPath());
            }
        }
        return stringBuffer.toString();
    }

    protected static boolean equal(File[] fileArray, File[] fileArray2) {
        if (fileArray == null || fileArray2 == null) {
            return fileArray == fileArray2;
        }
        if (fileArray.length != fileArray2.length) {
            return false;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == fileArray2[i]) continue;
            return false;
        }
        return true;
    }
}

