/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.ChoiceArrayQuestion;
import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.FloatQuestion;
import com.sun.interview.InetAddressQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringListQuestion;
import com.sun.interview.StringQuestion;
import com.sun.interview.TreeQuestion;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class WizPrint {
    private Interview interview;
    private Question[] questions;
    private BufferedWriter out;
    private boolean showResponses;
    private boolean showResponseTypes;
    private boolean showTags;
    private int state;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;
    private static final ResourceBundle i18n = ResourceBundle.getBundle("com.sun.interview.i18n");
    private static final String DOCTYPE = "!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\"";
    private static final String A = "a";
    private static final String ALIGN = "align";
    private static final String B = "b";
    private static final String BODY = "body";
    private static final String BR = "br";
    private static final String FONT = "font";
    private static final String H1 = "h1";
    private static final String H3 = "h3";
    private static final String HEAD = "head";
    private static final String HR = "hr";
    private static final String HREF = "href";
    private static final String HTML = "html";
    private static final String I = "i";
    private static final String LEFT = "left";
    private static final String LI = "li";
    private static final String NAME = "name";
    private static final String P = "p";
    private static final String SIZE = "size";
    private static final String STRIKE = "strike";
    private static final String TITLE = "title";
    private static final String UL = "ul";
    private static final String WIDTH = "width";
    static /* synthetic */ Class class$com$sun$interview$WizPrint;

    public static void usage() {
        String string = System.getProperty("program");
        if (string == null) {
            string = WizPrint.formatI18N("wp.prog", (class$com$sun$interview$WizPrint == null ? (class$com$sun$interview$WizPrint = WizPrint.class$("com.sun.interview.WizPrint")) : class$com$sun$interview$WizPrint).getName());
        }
        String string2 = WizPrint.formatI18N("wp.usage", string);
        boolean bl = true;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '\n') {
                System.err.println();
                bl = true;
                continue;
            }
            System.err.print(c);
            bl = false;
        }
        if (!bl) {
            System.err.println();
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            Object[] objectArray;
            Object object3;
            Object object4;
            boolean bl = false;
            String string = null;
            File file = null;
            File file2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-o") && i + 1 < stringArray.length) {
                    file2 = new File(stringArray[++i]);
                    continue;
                }
                if (stringArray[i].equals("-path")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-all")) {
                    bl = false;
                    continue;
                }
                if (stringArray[i].startsWith("-")) {
                    throw new BadArgs(i18n, "wp.badArg", stringArray[i]);
                }
                if (i == stringArray.length - 1) {
                    if (stringArray[i].endsWith(".jti")) {
                        file = new File(stringArray[i]);
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                throw new BadArgs(i18n, "wp.badArg", stringArray[i]);
            }
            Object object5 = null;
            if (file != null) {
                try {
                    object4 = new BufferedInputStream(new FileInputStream(file));
                    object3 = new Properties();
                    ((Properties)object3).load((InputStream)object4);
                    string = (String)((Properties)object3).get("INTERVIEW");
                    object5 = object3;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new Fault(i18n, "wp.cantFindFile", file);
                }
                catch (IOException iOException) {
                    throw new Fault(i18n, "wp.cantReadFile", new Object[]{file, iOException});
                }
            }
            if (string == null) {
                throw new BadArgs(i18n, "wp.noInterview");
            }
            if (file2 == null) {
                int n;
                if (file != null && (n = ((String)(object4 = file.getPath())).lastIndexOf(".")) != -1) {
                    file2 = new File(((String)object4).substring(0, n) + ".html");
                }
                if (file2 == null) {
                    throw new BadArgs(i18n, "wp.noOutput");
                }
            }
            object4 = Class.forName(string);
            object3 = (Interview)((Class)object4).newInstance();
            if (object5 != null) {
                ((Interview)object3).load((Map)object5);
            }
            if (bl) {
                objectArray = ((Interview)object3).getPath();
            } else {
                object2 = new SortedVector();
                object = ((Interview)object3).getQuestions().iterator();
                while (object.hasNext()) {
                    Question question = (Question)object.next();
                    ((SortedVector)object2).insert(question);
                }
                objectArray = new Question[((SortedVector)object2).size()];
                ((SortedVector)object2).copyInto(objectArray);
            }
            try {
                object2 = new FileWriter(file2);
                object = new WizPrint((Interview)object3, (Question[])objectArray);
                ((WizPrint)object).setShowTags(!bl);
                ((WizPrint)object).setShowResponses(bl);
                ((WizPrint)object).setShowResponseTypes(!bl);
                ((WizPrint)object).write((Writer)object2);
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "wp.cantWriteFile", new Object[]{file2, iOException});
            }
        }
        catch (BadArgs badArgs) {
            System.err.println(WizPrint.formatI18N("wp.error", badArgs.getMessage()));
            WizPrint.usage();
            System.exit(1);
        }
        catch (Fault fault) {
            System.err.println(fault.getMessage());
            System.exit(2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(3);
        }
    }

    public WizPrint(Interview interview) {
        this(interview, interview.getPath());
    }

    public WizPrint(Interview interview, Question[] questionArray) {
        this.interview = interview;
        this.questions = questionArray;
    }

    public boolean getShowResponses() {
        return this.showResponses;
    }

    public void setShowResponses(boolean bl) {
        this.showResponses = bl;
    }

    public boolean getShowResponseTypes() {
        return this.showResponseTypes;
    }

    public void setShowResponseTypes(boolean bl) {
        this.showResponseTypes = bl;
    }

    public boolean getShowTags() {
        return this.showTags;
    }

    public void setShowTags(boolean bl) {
        this.showTags = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        try {
            this.setWriter(writer);
            this.startTag(DOCTYPE);
            this.newLine();
            this.startTag(HTML);
            this.newLine();
            this.startTag(HEAD);
            this.writeTag(TITLE, this.interview.getTitle());
            this.endTag(HEAD);
            this.newLine();
            this.startTag(BODY);
            this.writeTag(H1, this.interview.getTitle());
            this.newLine();
            this.writeIndex();
            this.writeQuestions();
            this.endTag(BODY);
            this.endTag(HTML);
            this.newLine();
        }
        finally {
            this.out.flush();
            this.out.close();
        }
    }

    private void writeIndex() throws IOException {
        this.startTag(UL);
        this.newLine();
        for (int i = 0; i < this.questions.length; ++i) {
            Question question = this.questions[i];
            this.startTag(LI);
            this.startTag(A);
            this.writeAttr(HREF, "#" + question.getTag());
            this.writeText(question.getSummary());
            this.endTag(A);
            this.newLine();
        }
        this.endTag(UL);
        this.newLine();
        this.newLine();
    }

    private void writeQuestions() throws IOException {
        this.startTag(HR);
        for (int i = 0; i < this.questions.length; ++i) {
            Question question;
            String string;
            if (i > 0) {
                this.startTag(P);
                this.startTag(HR);
                this.writeAttr(ALIGN, LEFT);
                this.writeAttr(WIDTH, "25%");
            }
            if ((string = (question = this.questions[i]).getTag()) != null) {
                this.startTag(A);
                this.writeAttr(NAME, question.getTag());
                this.endTag(A);
                this.newLine();
            }
            this.writeTag(H3, question.getSummary());
            this.newLine();
            if (this.showTags) {
                this.startTag(P);
                this.startTag(I);
                this.writeI18N("wp.tag");
                if (string == null) {
                    this.writeTag(I, "null");
                } else {
                    this.writeTag(B, string);
                }
                this.endTag(I);
                this.endTag(P);
                this.newLine();
            }
            if (question instanceof ErrorQuestion) {
                this.startTag(P);
                this.startTag(FONT);
                this.writeAttr(SIZE, "+1");
                this.writeText(question.getText());
                this.endTag(FONT);
                this.endTag(P);
                continue;
            }
            this.startTag(P);
            this.writeText(question.getText());
            this.endTag(P);
            this.newLine();
            if (this.showResponseTypes) {
                this.writeResponseType(question);
            }
            if (!this.showResponses) continue;
            this.writeResponse(question);
        }
    }

    private void writeResponse(Question question) throws IOException {
        if (question instanceof ChoiceArrayQuestion) {
            ChoiceArrayQuestion choiceArrayQuestion = (ChoiceArrayQuestion)question;
            this.writeResponse(choiceArrayQuestion.getValue(), choiceArrayQuestion.getChoices(), choiceArrayQuestion.getDisplayChoices());
        } else if (question instanceof ChoiceQuestion) {
            ChoiceQuestion choiceQuestion = (ChoiceQuestion)question;
            if (choiceQuestion.getChoices() == choiceQuestion.getDisplayChoices()) {
                this.writeResponse(choiceQuestion.getValue());
            } else {
                this.writeResponse(choiceQuestion.getValue(), choiceQuestion.getDisplayValue());
            }
        } else if (!(question instanceof ErrorQuestion)) {
            if (question instanceof FileListQuestion) {
                FileListQuestion fileListQuestion = (FileListQuestion)question;
                File[] fileArray = fileListQuestion.getValue();
                this.writeResponse(this.filesToStrings(fileArray));
            } else if (question instanceof FileQuestion) {
                FileQuestion fileQuestion = (FileQuestion)question;
                File file = fileQuestion.getValue();
                this.writeResponse(file == null ? null : file.getPath());
            } else if (!(question instanceof FinalQuestion)) {
                if (question instanceof FloatQuestion) {
                    FloatQuestion floatQuestion = (FloatQuestion)question;
                    this.writeResponse(floatQuestion.getStringValue());
                } else if (question instanceof InetAddressQuestion) {
                    InetAddressQuestion inetAddressQuestion = (InetAddressQuestion)question;
                    this.writeResponse(inetAddressQuestion.getStringValue());
                } else if (question instanceof IntQuestion) {
                    IntQuestion intQuestion = (IntQuestion)question;
                    this.writeResponse(intQuestion.getStringValue());
                } else if (!(question instanceof NullQuestion)) {
                    if (question instanceof StringQuestion) {
                        StringQuestion stringQuestion = (StringQuestion)question;
                        this.writeResponse(stringQuestion.getValue());
                    } else if (question instanceof StringListQuestion) {
                        StringListQuestion stringListQuestion = (StringListQuestion)question;
                        this.writeResponse(stringListQuestion.getValue());
                    } else if (question instanceof TreeQuestion) {
                        TreeQuestion treeQuestion = (TreeQuestion)question;
                        String[] stringArray = treeQuestion.getValue();
                        if (stringArray == null || stringArray.length == 0) {
                            this.writeResponse(i18n.getString("wp.all"));
                        } else {
                            this.writeResponse(stringArray);
                        }
                    } else {
                        this.writeResponse(question.getStringValue());
                    }
                }
            }
        }
    }

    private void writeResponse(String string) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (string == null) {
            this.writeI18N("wp.noResponse");
        } else {
            this.writeTag(B, string);
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(String string, String string2) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (string == null) {
            this.writeI18N("wp.noResponse");
        } else {
            this.writeTag(B, string);
            if (string2 != null) {
                this.writeText(" ");
                this.writeI18N("wp.display", string2);
            }
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(boolean[] blArray, String[] stringArray, String[] stringArray2) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (blArray == null) {
            this.writeI18N("wp.noResponse");
        } else {
            for (int i = 0; i < blArray.length; ++i) {
                if (i > 0) {
                    this.writeI18N("wp.listSep");
                }
                this.startTag(B);
                if (!blArray[i]) {
                    this.startTag(STRIKE);
                }
                this.writeText(stringArray[i]);
                if (stringArray2 != null && !WizPrint.equal(stringArray[i], stringArray2[i])) {
                    this.writeText(" ");
                    this.writeI18N("wp.display", stringArray2[i]);
                }
                if (!blArray[i]) {
                    this.endTag(STRIKE);
                }
                this.endTag(B);
            }
        }
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeResponse(String[] stringArray) throws IOException {
        this.startTag(P);
        this.startTag(I);
        this.writeI18N("wp.response");
        if (stringArray == null || stringArray.length == 0) {
            this.writeI18N("wp.noResponse");
            this.endTag(I);
            this.endTag(P);
        } else {
            this.endTag(I);
            this.endTag(P);
            this.startTag(UL);
            for (int i = 0; i < stringArray.length; ++i) {
                this.startTag(LI);
                this.startTag(B);
                this.startTag(I);
                this.writeText(stringArray[i]);
                this.endTag(I);
                this.endTag(B);
            }
            this.endTag(UL);
        }
        this.newLine();
        this.newLine();
    }

    private void writeResponseType(Question question) throws IOException {
        if (question instanceof ChoiceArrayQuestion) {
            ChoiceArrayQuestion choiceArrayQuestion = (ChoiceArrayQuestion)question;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(i18n.getString("wp.type.chooseAny"));
            String[] stringArray = choiceArrayQuestion.getChoices();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(i18n.getString("wp.listSep"));
                }
                stringBuffer.append(stringArray[i] == null ? i18n.getString("wp.unset") : stringArray[i]);
            }
            this.writeResponseType(stringBuffer.toString());
        } else if (question instanceof ChoiceQuestion) {
            ChoiceQuestion choiceQuestion = (ChoiceQuestion)question;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(i18n.getString("wp.type.chooseOne"));
            String[] stringArray = choiceQuestion.getChoices();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(i18n.getString("wp.listSep"));
                }
                stringBuffer.append(stringArray[i] == null ? i18n.getString("wp.unset") : stringArray[i]);
            }
            this.writeResponseType(stringBuffer.toString());
        } else if (!(question instanceof ErrorQuestion)) {
            if (question instanceof FileQuestion) {
                this.writeResponseType(i18n.getString("wp.type.file"));
            } else if (question instanceof FileListQuestion) {
                this.writeResponseType(i18n.getString("wp.type.fileList"));
            } else if (!(question instanceof FinalQuestion)) {
                if (question instanceof FloatQuestion) {
                    FloatQuestion floatQuestion = (FloatQuestion)question;
                    float f = floatQuestion.getLowerBound();
                    float f2 = floatQuestion.getUpperBound();
                    this.writeResponseType(WizPrint.formatI18N("wp.type.float", new Object[]{new Integer(f == Float.MIN_VALUE ? 0 : 1), new Float(f), new Integer(f2 == Float.MAX_VALUE ? 0 : 1), new Float(f2)}));
                } else if (question instanceof InetAddressQuestion) {
                    this.writeResponseType(i18n.getString("wp.type.inetAddress"));
                } else if (question instanceof IntQuestion) {
                    IntQuestion intQuestion = (IntQuestion)question;
                    int n = intQuestion.getLowerBound();
                    int n2 = intQuestion.getUpperBound();
                    this.writeResponseType(WizPrint.formatI18N("wp.type.int", new Object[]{new Integer(n == Integer.MIN_VALUE ? 0 : 1), new Integer(n), new Integer(n2 == Integer.MAX_VALUE ? 0 : 1), new Integer(n2)}));
                } else if (!(question instanceof NullQuestion)) {
                    if (question instanceof StringQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.string"));
                    } else if (question instanceof StringListQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.stringList"));
                    } else if (question instanceof TreeQuestion) {
                        this.writeResponseType(i18n.getString("wp.type.tree"));
                    } else {
                        this.startTag(P);
                        this.writeTag(I, "unknown type of question; cannot determine response type");
                        this.endTag(P);
                    }
                }
            }
        }
    }

    private void writeResponseType(String string) throws IOException {
        this.startTag(P);
        this.startTag(I);
        if (this.showResponseTypes && this.showResponses) {
            this.writeI18N("wp.responseType");
        } else {
            this.writeI18N("wp.response");
        }
        this.startTag(B);
        this.writeText(string);
        this.endTag(B);
        this.endTag(I);
        this.endTag(P);
        this.newLine();
        this.newLine();
    }

    private void writeI18N(String string) throws IOException {
        this.writeText(i18n.getString(string));
    }

    private void writeI18N(String string, Object object) throws IOException {
        String string2 = WizPrint.formatI18N(string, object);
        this.writeText(string2);
    }

    private String[] filesToStrings(File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = fileArray[i].getPath();
        }
        return stringArray;
    }

    private void newLine() throws IOException {
        if (this.state == 1) {
            this.out.write(62);
            this.state = 2;
        }
        this.out.newLine();
    }

    private void startTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(62);
        }
        this.out.write(60);
        this.out.write(string);
        this.state = 1;
    }

    private void endTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(62);
        }
        this.out.write("</");
        this.out.write(string);
        this.out.write(62);
        this.state = 2;
    }

    private void writeAttr(String string, String string2) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(string);
        this.out.write("=");
        boolean bl = true;
        for (int i = 0; i < string2.length() && bl; ++i) {
            bl = Character.isLetter(string2.charAt(i));
        }
        if (!bl) {
            this.out.write("\"");
        }
        this.out.write(string2);
        if (!bl) {
            this.out.write("\"");
        }
    }

    private void writeTag(String string, String string2) throws IOException {
        this.startTag(string);
        this.writeText(string2);
        this.endTag(string);
    }

    private void writeText(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        if (string == null) {
            this.out.write("<i>");
            this.out.write(i18n.getString("wp.null"));
            this.out.write("</i>");
        } else {
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': {
                        this.out.write("<br>");
                        continue block6;
                    }
                    case '<': {
                        this.out.write("&lt;");
                        continue block6;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block6;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block6;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        }
    }

    private static String formatI18N(String string, Object object) {
        return MessageFormat.format(i18n.getString(string), object);
    }

    private static String formatI18N(String string, Object[] objectArray) {
        return MessageFormat.format(i18n.getString(string), objectArray);
    }

    private void setWriter(Writer writer) {
        this.out = this.out instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    private static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SortedVector {
        private Vector v;

        public SortedVector() {
            this.v = new Vector();
        }

        public SortedVector(int n) {
            this.v = new Vector(n);
        }

        public int size() {
            return this.v.size();
        }

        public Object elementAt(int n) {
            return this.v.elementAt(n);
        }

        public void insert(Object object) {
            this.v.insertElementAt(object, this.findSortIndex(object));
        }

        public void insert(Object object, boolean bl) {
            int n = this.findSortIndex(object);
            if (bl && n < this.v.size() && this.compare(object, this.v.elementAt(n)) == 0) {
                return;
            }
            this.v.insertElementAt(object, n);
        }

        public void copyInto(Object[] objectArray) {
            this.v.copyInto(objectArray);
        }

        protected int compare(Object object, Object object2) {
            String string = ((Question)object).getTag();
            String string2 = ((Question)object2).getTag();
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }

        private int findSortIndex(Object object) {
            int n = 0;
            int n2 = this.v.size() - 1;
            int n3 = 0;
            if (n2 == -1) {
                return 0;
            }
            int n4 = 0;
            Object e = this.v.elementAt(n2);
            n4 = this.compare(object, e);
            if (n4 > 0) {
                return n2 + 1;
            }
            while (n <= n2) {
                n3 = n + (n2 - n) / 2;
                Object e2 = this.v.elementAt(n3);
                n4 = this.compare(object, e2);
                if (n4 == 0) {
                    return n3;
                }
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                n = n3 + 1;
            }
            return n4 < 0 ? n3 : n3 + 1;
        }
    }

    public static class Fault
    extends Exception {
        public Fault(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        public Fault(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }

    public static class BadArgs
    extends Exception {
        public BadArgs(ResourceBundle resourceBundle, String string) {
            super(resourceBundle.getString(string));
        }

        public BadArgs(ResourceBundle resourceBundle, String string, Object object) {
            super(MessageFormat.format(resourceBundle.getString(string), object));
        }

        public BadArgs(ResourceBundle resourceBundle, String string, Object[] objectArray) {
            super(MessageFormat.format(resourceBundle.getString(string), objectArray));
        }
    }
}

