/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.IntQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;

class IntQuestionRenderer
implements QuestionRenderer {
    private int lwb;
    private int upb;
    private long range;
    private int[] suggs;
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    IntQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        IntQuestion intQuestion = (IntQuestion)question;
        this.lwb = intQuestion.getLowerBound();
        this.upb = intQuestion.getUpperBound();
        this.range = (long)this.upb - (long)this.lwb;
        this.suggs = intQuestion.getSuggestions();
        if (this.range > 10L || this.suggs != null) {
            return this.createTextField(intQuestion, actionListener);
        }
        return this.createSlider(intQuestion, actionListener);
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private JPanel createTextField(IntQuestion intQuestion, ActionListener actionListener) {
        JButton jButton;
        String[] stringArray;
        int n = 1;
        while (this.range >= 10L) {
            this.range /= 10L;
            ++n;
        }
        if (this.lwb < 0) {
            ++n;
        }
        if (this.suggs == null) {
            stringArray = null;
        } else {
            stringArray = new String[this.suggs.length];
            for (int i = 0; i < this.suggs.length; ++i) {
                stringArray[i] = String.valueOf(this.suggs[i]);
            }
        }
        final int n2 = intQuestion.getDefaultValue();
        if (n2 == Integer.MIN_VALUE) {
            jButton = null;
        } else {
            jButton = new JButton(i18n.getString("int.reset.btn"));
            jButton.setName("int.reset.btn");
            jButton.setMnemonic(i18n.getString("int.reset.mne").charAt(0));
            jButton.setToolTipText(i18n.getString("int.reset.tip"));
        }
        final TypeInPanel typeInPanel = new TypeInPanel("int.field", intQuestion, n, stringArray, jButton, actionListener);
        if (jButton != null) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    typeInPanel.setValue(numberFormat.format(new Integer(n2)));
                }
            });
        }
        return typeInPanel;
    }

    private JPanel createSlider(final IntQuestion intQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("int");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(i18n.getString("int.sldr.lbl"));
        jLabel.setName("int.sldr.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("int.sldr.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("int.sldr.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        int n = intQuestion.isValid() ? intQuestion.getValue() : this.lwb;
        final JSlider jSlider = new JSlider(this.lwb, this.upb, n);
        jSlider.setName("int.sldr");
        jSlider.setMajorTickSpacing((this.upb - this.lwb) / 2);
        jSlider.setMinorTickSpacing(1);
        jSlider.setSnapToTicks(true);
        jSlider.setPaintTicks(true);
        int n2 = intQuestion.getLabelStartHint();
        int n3 = intQuestion.getLabelIncrementHint();
        if (n3 != 0) {
            jSlider.setLabelTable(jSlider.createStandardLabels(n3, n2));
        }
        jSlider.setPaintLabels(true);
        jLabel.setLabelFor(jSlider);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jSlider, gridBagConstraints);
        Runnable runnable = new Runnable(){

            public void run() {
                intQuestion.setValue(jSlider.getValue());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }
}

