/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class SearchDialog
extends JDialog {
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(SearchDialog.FIND)) {
                SearchDialog.this.find();
            } else if (string.equals(SearchDialog.CLOSE)) {
                SearchDialog.this.setVisible(false);
            } else if (string.equals(SearchDialog.HELP)) {
                SearchDialog.this.helpBroker.setCurrentID(SearchDialog.this.helpPrefix + "search.csh");
                SearchDialog.this.helpBroker.setDisplayed(true);
            }
        }
    };
    private Interview interview;
    private Question currentQuestion;
    private HelpBroker helpBroker;
    private String helpPrefix;
    private JTextField textField;
    private JComboBox whereChoice;
    private JCheckBox caseChk;
    private JCheckBox wordChk;
    private static final String ANSWER = "answer";
    private static final String ANYWHERE = "anywhere";
    private static final String CLOSE = "close";
    private static final String FIND = "find";
    private static final String HELP = "help";
    private static final String QUESTION = "question";
    private static final String TITLE = "title";
    private static final KeyStroke escapeKey = KeyStroke.getKeyStroke("ESCAPE");
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    static /* synthetic */ Class class$java$awt$Dialog;
    static /* synthetic */ Class class$java$awt$Frame;

    static SearchDialog create(Component component, Interview interview, HelpBroker helpBroker, String string) {
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = SearchDialog.class$("java.awt.Dialog")) : class$java$awt$Dialog, component);
        if (dialog != null) {
            return new SearchDialog(dialog, interview, helpBroker, string);
        }
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = SearchDialog.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        return new SearchDialog(frame, interview, helpBroker, string);
    }

    SearchDialog(Frame frame, Interview interview, HelpBroker helpBroker, String string) {
        super(frame);
        this.init(frame, interview, helpBroker, string);
    }

    SearchDialog(Dialog dialog, Interview interview, HelpBroker helpBroker, String string) {
        super(dialog);
        this.init(dialog, interview, helpBroker, string);
    }

    private void init(Component component, Interview interview, HelpBroker helpBroker, String string) {
        this.interview = interview;
        this.helpBroker = helpBroker;
        this.helpPrefix = string;
        this.setName(FIND);
        this.setTitle(i18n.getString("find.title"));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString("find.name"));
        accessibleContext.setAccessibleDescription(i18n.getString("find.desc"));
        Container container = this.getContentPane();
        container.setName("content");
        container.setFocusable(false);
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("main");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.right = 10;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = this.createLabel("find.field", true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.textField = new JTextField("", 32);
        this.textField.setName("find.text");
        this.textField.addActionListener(this.listener);
        this.textField.setActionCommand(FIND);
        this.textField.setToolTipText(jLabel.getAccessibleContext().getAccessibleDescription());
        jLabel.setLabelFor(this.textField);
        gridBagConstraints2.insets.bottom = 10;
        jPanel.add((Component)this.textField, gridBagConstraints2);
        JLabel jLabel2 = this.createLabel("find.where", true);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        String[] stringArray = new String[]{TITLE, QUESTION, ANSWER, ANYWHERE};
        this.whereChoice = this.createChoice("find.where", stringArray);
        jLabel2.setLabelFor(this.whereChoice);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.bottom = 0;
        jPanel.add((Component)this.whereChoice, gridBagConstraints2);
        JLabel jLabel3 = this.createLabel("find.options", false);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("options");
        jPanel2.setFocusable(false);
        this.caseChk = this.createCheckBox("find.case");
        jPanel2.add(this.caseChk);
        this.wordChk = this.createCheckBox("find.word");
        jPanel2.add(this.wordChk);
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        jPanel.registerKeyboardAction(this.listener, CLOSE, escapeKey, 1);
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        container.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("btns");
        jPanel3.setFocusable(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 13;
        jPanel3.add((Component)this.createButton("find.find", FIND, this.listener), gridBagConstraints2);
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.weightx = 0.0;
        jPanel3.add((Component)this.createButton("find.close", CLOSE, this.listener), gridBagConstraints2);
        if (helpBroker != null) {
            jPanel3.add((Component)this.createButton("find.help", HELP, this.listener), gridBagConstraints2);
        }
        jPanel3.setBorder(BorderFactory.createEmptyBorder(11, 12, 11, 11));
        container.add((Component)jPanel3, "South");
        if (helpBroker != null) {
            helpBroker.enableHelpKey(this.getRootPane(), string + "search.csh", null);
        }
        this.pack();
        this.setLocationRelativeTo(component);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.textField.requestFocus();
        }
    }

    public void find() {
        if (this.textField.getText().length() == 0) {
            this.setVisible(true);
        } else {
            Hashtable hashtable = new Hashtable();
            this.interview.save(hashtable);
            Question[] questionArray = this.interview.getPath();
            Question question = this.interview.getCurrentQuestion();
            for (int i = 0; i < questionArray.length; ++i) {
                if (questionArray[i] != question) continue;
                for (int j = 0; j < questionArray.length; ++j) {
                    Question question2 = questionArray[(i + 1 + j) % questionArray.length];
                    String string = (String)hashtable.get(question2.getTag());
                    if (!this.matches(question2, string, this.caseChk.isSelected(), this.wordChk.isSelected())) continue;
                    try {
                        this.interview.setCurrentQuestion(question2);
                    }
                    catch (Interview.Fault fault) {
                        // empty catch block
                    }
                    return;
                }
                this.getToolkit().beep();
                return;
            }
        }
    }

    private boolean matches(Question question, String string, boolean bl, boolean bl2) {
        String string2 = this.textField.getText();
        String string3 = (String)this.whereChoice.getSelectedItem();
        if (string3.equals(TITLE)) {
            return SearchDialog.match(string2, question.getSummary(), bl, bl2);
        }
        if (string3.equals(QUESTION)) {
            return SearchDialog.match(string2, question.getText(), bl, bl2);
        }
        if (string3.equals(ANSWER)) {
            return string != null && SearchDialog.match(string2, string, bl, bl2);
        }
        return SearchDialog.match(string2, question.getSummary(), bl, bl2) || SearchDialog.match(string2, question.getText(), bl, bl2) || string != null && SearchDialog.match(string2, string, bl, bl2);
    }

    private static boolean match(String string, String string2, boolean bl, boolean bl2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i <= n2 - n; ++i) {
            if (!string.regionMatches(!bl, 0, string2, i, n)) continue;
            if (bl2) {
                return !(i != 0 && !SearchDialog.isBoundaryCh(string2.charAt(i - 1)) || i + n != string2.length() && !SearchDialog.isBoundaryCh(string2.charAt(i + n)));
            }
            return true;
        }
        return false;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(i18n.getString(string + ".btn"));
        jButton.setName(string);
        jButton.setMnemonic(this.getMnemonic(string));
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        this.setToolTipText(jButton, string);
        return jButton;
    }

    private JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(i18n.getString(string + ".ckb"));
        jCheckBox.setName(string);
        jCheckBox.setMnemonic(this.getMnemonic(string));
        this.setToolTipText(jCheckBox, string);
        return jCheckBox;
    }

    private JComboBox createChoice(String string, final String[] stringArray) {
        final String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i18n.getString(string + "." + stringArray[i] + ".chc");
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName(string);
        AccessibleContext accessibleContext = jComboBox.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".tip"));
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Object object2 = object;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != object) continue;
                    object2 = stringArray2[i];
                    break;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
            }
        });
        this.setToolTipText(jComboBox, string);
        accessibleContext.setAccessibleDescription(jComboBox.getToolTipText());
        return jComboBox;
    }

    private JLabel createLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(i18n.getString(string + ".lbl"));
        jLabel.setName(string);
        if (bl) {
            jLabel.setDisplayedMnemonic(this.getMnemonic(string));
        }
        this.setToolTipText(jLabel, string);
        return jLabel;
    }

    private char getMnemonic(String string) {
        return i18n.getString(string + ".mne").charAt(0);
    }

    private void setToolTipText(JComponent jComponent, String string) {
        jComponent.setToolTipText(i18n.getString(string + ".tip"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

