/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Question;
import com.sun.interview.TreeQuestion;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class TreeQuestionRenderer
implements QuestionRenderer {
    private static final int NONE_SELECTED = 0;
    private static final int SOME_SELECTED = 1;
    private static final int ALL_SELECTED = 2;
    private static Icon[] folderIcons;
    private static Icon[] leafIcons;
    private static final I18NResourceBundle i18n;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;

    TreeQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        final TreeQuestion treeQuestion = (TreeQuestion)question;
        final TQTree tQTree = new TQTree(treeQuestion.getModel(), actionListener);
        tQTree.setName("tree");
        tQTree.setToolTipText(i18n.getString("tree.tip"));
        tQTree.getAccessibleContext().setAccessibleName(tQTree.getName());
        tQTree.getAccessibleContext().setAccessibleDescription(tQTree.getToolTipText());
        JScrollPane jScrollPane = new JScrollPane(tQTree);
        tQTree.setSelection(treeQuestion.getValue());
        Runnable runnable = new Runnable(){

            public void run() {
                treeQuestion.setValue(tQTree.getSelection());
            }
        };
        jScrollPane.putClientProperty("valueSaver", runnable);
        return jScrollPane;
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private static String stringOf(TreePath treePath) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = treePath.getPath();
        for (int i = 0; i < objectArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(((TQNode)objectArray[i]).getName());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Icon[] access$002(Icon[] iconArray) {
        folderIcons = iconArray;
        return iconArray;
    }

    static /* synthetic */ Icon[] access$102(Icon[] iconArray) {
        leafIcons = iconArray;
        return iconArray;
    }

    static {
        i18n = I18NResourceBundle.getDefaultBundle();
    }

    private static class LeafIcon
    implements Icon {
        private int style;
        private Image image;
        private static final int width = 16;
        private static final int height = 16;

        LeafIcon(int n) {
            this.style = n;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = this.image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = 15;
            int n2 = 15;
            graphics.setColor(MetalLookAndFeel.getWindowBackground());
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 0, 2, n2);
            graphics.drawLine(2, 0, n - 4, 0);
            graphics.drawLine(2, n2, n - 1, n2);
            graphics.drawLine(n - 1, 6, n - 1, n2);
            graphics.drawLine(n - 6, 2, n - 2, 6);
            graphics.drawLine(n - 5, 1, n - 4, 1);
            graphics.drawLine(n - 3, 2, n - 3, 3);
            graphics.drawLine(n - 2, 4, n - 2, 5);
            switch (this.style) {
                case 0: {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(3, 1, 3, n2 - 1);
                    graphics.drawLine(3, 1, n - 6, 1);
                    graphics.drawLine(n - 2, 7, n - 2, n2 - 1);
                    graphics.drawLine(n - 5, 2, n - 3, 4);
                    graphics.drawLine(3, n2 - 1, n - 2, n2 - 1);
                    break;
                }
                case 2: {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(4, 2, 9, 2);
                    graphics.drawLine(4, 3, 9, 3);
                    graphics.drawLine(4, 4, 10, 4);
                    graphics.drawLine(4, 5, 10, 5);
                    graphics.drawLine(4, 6, 11, 6);
                    graphics.fillRect(4, 6, 10, 9);
                }
            }
        }
    }

    static class FolderIcon
    implements Icon {
        private int style;
        private Image image;
        private static final int width = 16;
        private static final int height = 16;

        FolderIcon(int n) {
            this.style = n;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = this.image.getGraphics();
                this.paintMe(component, graphics2);
                graphics2.dispose();
            }
            graphics.drawImage(this.image, n, n2 - 1, null);
        }

        private void paintMe(Component component, Graphics graphics) {
            int n = 15;
            int n2 = 15;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n - 5, 3, n, 3);
            graphics.drawLine(n - 6, 4, n, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 7, 13, 8);
            switch (this.style) {
                case 0: {
                    graphics.setColor(Color.white);
                    graphics.fillRect(2, 7, 13, 8);
                    break;
                }
                case 1: {
                    graphics.setColor(Color.white);
                    for (int i = 0; i < 8; ++i) {
                        graphics.drawLine(4 + i, 7 + i, 18, 7 + i);
                    }
                    break;
                }
            }
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n - 6, 5, n - 1, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 6, 0, n2);
            graphics.drawLine(1, 5, n - 7, 5);
            graphics.drawLine(n - 6, 6, n - 1, 6);
            graphics.drawLine(n, 5, n, n2);
            graphics.drawLine(0, n2, n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 6, 1, n2 - 1);
            graphics.drawLine(1, 6, n - 7, 6);
            graphics.drawLine(n - 6, 7, n - 1, 7);
        }
    }

    private class TQListener
    implements TreeExpansionListener,
    TreeSelectionListener {
        private boolean ignoreEvents;
        private ActionListener editedListener;

        TQListener(ActionListener actionListener) {
            this.editedListener = actionListener;
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TQNode tQNode = (TQNode)treePath.getLastPathComponent();
            if (tQNode.selectState == 0 || tQNode.selectState == 2) {
                tQNode.children = null;
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TQNode tQNode;
            TreePath treePath;
            int n;
            if (this.ignoreEvents) {
                return;
            }
            JTree jTree = (JTree)treeSelectionEvent.getSource();
            TreePath[] treePathArray = treeSelectionEvent.getPaths();
            for (n = 0; n < treePathArray.length; ++n) {
                treePath = treePathArray[n];
                if (treeSelectionEvent.isAddedPath(treePath)) continue;
                tQNode = (TQNode)treePath.getLastPathComponent();
                tQNode.setSelected(false);
            }
            for (n = 0; n < treePathArray.length; ++n) {
                treePath = treePathArray[n];
                if (!treeSelectionEvent.isAddedPath(treePath)) continue;
                tQNode = (TQNode)treePath.getLastPathComponent();
                tQNode.setSelected(true);
            }
            ActionEvent actionEvent = new ActionEvent(treeSelectionEvent.getSource(), 1001, "edited");
            this.editedListener.actionPerformed(actionEvent);
        }

        void setIgnoreEvents(boolean bl) {
            this.ignoreEvents = bl;
        }
    }

    private class TQRenderer
    extends DefaultTreeCellRenderer {
        private int style;

        TQRenderer() {
            if (folderIcons == null) {
                TreeQuestionRenderer.access$002(new FolderIcon[3]);
                folderIcons[0] = new FolderIcon(0);
                folderIcons[1] = new FolderIcon(1);
                folderIcons[2] = new FolderIcon(2);
            }
            if (leafIcons == null) {
                TreeQuestionRenderer.access$102(new LeafIcon[3]);
                leafIcons[0] = new LeafIcon(0);
                leafIcons[2] = new LeafIcon(2);
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TQModel tQModel = (TQModel)jTree.getModel();
            TQNode tQNode = (TQNode)object;
            object = tQModel.getName(tQNode);
            this.style = tQNode.selectState;
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        public Icon getOpenIcon() {
            return folderIcons[this.style];
        }

        public Icon getClosedIcon() {
            return folderIcons[this.style];
        }

        public Icon getLeafIcon() {
            return leafIcons[this.style];
        }
    }

    private class TQModel
    implements TreeModel {
        private TQNode root;
        private EventListenerList listenerList = new EventListenerList();

        TQModel(TQNode tQNode) {
            this.root = tQNode;
        }

        public String getName(Object object) {
            return ((TQNode)object).getName();
        }

        public Object getChild(Object object, int n) {
            return ((TQNode)object).getChild(n);
        }

        public int getChildCount(Object object) {
            return ((TQNode)object).getChildCount();
        }

        public int getIndexOfChild(Object object, Object object2) {
            return ((TQNode)object).getIndexOfChild((TQNode)object2);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            return ((TQNode)object).isLeaf();
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeQuestionRenderer.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = TreeQuestionRenderer.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, treeModelListener);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            throw new UnsupportedOperationException();
        }

        void fireTreeNodesChanged(TQTree tQTree, TQNode tQNode) {
            TreeModelEvent treeModelEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$TreeModelListener == null ? TreeQuestionRenderer.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) continue;
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)tQTree, tQTree.getTreePath(tQNode));
                }
                ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
            }
        }
    }

    private class TQNode {
        TQTree tree;
        TQNode parent;
        TQNode[] children;
        int selectState;
        Object clientNode;

        TQNode(TQTree tQTree, TQNode tQNode, Object object) {
            if (tQTree == null || object == null) {
                throw new NullPointerException();
            }
            this.tree = tQTree;
            this.parent = tQNode;
            this.clientNode = object;
        }

        String getName() {
            return this.tree.clientModel.getName(this.clientNode);
        }

        int getChildCount() {
            return this.children == null ? this.tree.clientModel.getChildCount(this.clientNode) : this.children.length;
        }

        TQNode getChild(int n) {
            if (this.children == null) {
                this.initChildren();
            }
            return this.children[n];
        }

        boolean isLeaf() {
            return this.tree.clientModel.isLeaf(this.clientNode);
        }

        int getIndexOfChild(TQNode tQNode) {
            if (this.children == null) {
                this.initChildren();
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (tQNode != this.children[i]) continue;
                return i;
            }
            return -1;
        }

        void setSelected(boolean bl) {
            if (bl && this.selectState == 2 || !bl && this.selectState == 0) {
                return;
            }
            this.setSelectState(bl ? 2 : 0);
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].setSelected(bl);
                }
            }
            TQNode tQNode = this;
            TQNode tQNode2 = this.parent;
            while (tQNode2 != null) {
                int n = tQNode2.children[0].selectState;
                for (int i = 1; i < tQNode2.children.length && n != 1; ++i) {
                    TQNode tQNode3 = tQNode2.children[i];
                    if ((n != 2 || tQNode3.selectState == 2) && (n != 0 || tQNode3.selectState == 0)) continue;
                    n = 1;
                }
                if (tQNode2.selectState == n) break;
                tQNode2.setSelectState(n);
                tQNode = tQNode2;
                tQNode2 = tQNode.parent;
            }
        }

        private void setSelectState(int n) {
            if (this.selectState == n) {
                return;
            }
            if (this.selectState == 2) {
                this.tree.removeFromSelection(this);
            }
            this.selectState = n;
            ((TQModel)this.tree.getModel()).fireTreeNodesChanged(this.tree, this);
            if (this.selectState == 2) {
                this.tree.addToSelection(this);
            }
        }

        private void initChildren() {
            int n;
            this.children = new TQNode[this.getChildCount()];
            for (n = 0; n < this.children.length; ++n) {
                this.children[n] = new TQNode(this.tree, this, this.tree.clientModel.getChild(this.clientNode, n));
            }
            if (this.selectState == 2) {
                for (n = 0; n < this.children.length; ++n) {
                    this.children[n].setSelectState(2);
                }
            }
        }
    }

    private class TQTree
    extends JTree {
        TreeQuestion.Model clientModel;
        TQListener listener;
        TQNode root;

        TQTree(TreeQuestion.Model model, ActionListener actionListener) {
            this.clientModel = model;
            this.listener = new TQListener(actionListener);
            this.addTreeSelectionListener(this.listener);
            this.root = new TQNode(this, null, this.clientModel.getRoot());
            this.setModel(new TQModel(this.root));
            this.setCellRenderer(new TQRenderer());
            this.setExpandsSelectedPaths(false);
        }

        String[] getSelection() {
            Vector vector = new Vector();
            this.getSelection(this.root, vector);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        private void getSelection(TQNode tQNode, Vector vector) {
            switch (tQNode.selectState) {
                case 0: {
                    break;
                }
                case 1: {
                    for (int i = 0; i < tQNode.getChildCount(); ++i) {
                        this.getSelection(tQNode.getChild(i), vector);
                    }
                    break;
                }
                case 2: {
                    vector.add(this.getPath(tQNode));
                }
            }
        }

        void setSelection(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.root.setSelected(true);
            } else {
                this.root.setSelected(false);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        TQNode tQNode = this.getNode(this.root, stringArray[i]);
                        if (tQNode == null) continue;
                        tQNode.setSelected(true);
                    }
                }
            }
        }

        void addToSelection(TQNode tQNode) {
            this.listener.setIgnoreEvents(true);
            TreePath treePath = this.getTreePath(tQNode);
            this.getSelectionModel().addSelectionPath(treePath);
            this.listener.setIgnoreEvents(false);
        }

        void removeFromSelection(TQNode tQNode) {
            this.listener.setIgnoreEvents(true);
            TreePath treePath = this.getTreePath(tQNode);
            this.getSelectionModel().removeSelectionPath(treePath);
            this.listener.setIgnoreEvents(false);
        }

        private TQNode getNode(TQNode tQNode, String string) {
            String string2;
            String string3;
            if (tQNode == null) {
                throw new NullPointerException();
            }
            if (string.length() == 0) {
                return tQNode;
            }
            int n = string.indexOf("/");
            if (n == -1) {
                string3 = string;
                string2 = null;
            } else {
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            for (int i = 0; i < tQNode.getChildCount(); ++i) {
                TQNode tQNode2 = tQNode.getChild(i);
                if (!tQNode2.getName().equals(string3)) continue;
                return string2 == null ? tQNode2 : this.getNode(tQNode2, string2);
            }
            return null;
        }

        String getPath(TQNode tQNode) {
            return this.getPath(tQNode, 0).toString();
        }

        private StringBuffer getPath(TQNode tQNode, int n) {
            if (tQNode.parent == null) {
                return new StringBuffer(n);
            }
            String string = tQNode.getName();
            StringBuffer stringBuffer = this.getPath(tQNode.parent, 1 + string.length() + n);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("/");
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        TreePath getTreePath(TQNode tQNode) {
            if (tQNode.parent == null) {
                return new TreePath(tQNode);
            }
            return this.getTreePath(tQNode.parent).pathByAddingChild(tQNode);
        }
    }
}

