/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InfoPanel;
import com.sun.interview.wizard.PathPanel;
import com.sun.interview.wizard.QuestionPanel;
import com.sun.interview.wizard.SearchDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.help.HelpBroker;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WizPane
extends JPanel {
    private Listener listener = new Listener();
    private Interview interview;
    private boolean infoEnabled;
    private HelpBroker helpHelpBroker;
    private String helpHelpPrefix = "wizard.";
    private JComponent main;
    private JPanel body;
    private PathPanel pathPanel;
    private QuestionPanel questionPanel;
    private JPanel buttonPanel;
    private InfoPanel infoPanel;
    private SearchDialog searchDialog;
    private static String DETAILS = "details";
    private static String FIND_NEXT = "findNext";
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    static /* synthetic */ Class class$java$awt$Window;

    public WizPane(Interview interview) {
        this(interview, true);
    }

    public WizPane(Interview interview, boolean bl) {
        this.interview = interview;
        this.infoEnabled = bl;
        this.initGUI();
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpHelpBroker = helpBroker;
    }

    public void setHelpPrefix(String string) {
        this.helpHelpPrefix = string;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setButtonPanel(JPanel jPanel) {
        this.buttonPanel = jPanel;
        this.body.add((Component)jPanel, "South");
    }

    public boolean isEdited() {
        this.questionPanel.saveCurrentResponse();
        return this.interview.isEdited();
    }

    public boolean hasInfo() {
        return this.infoPanel != null;
    }

    public boolean isInfoVisible() {
        return this.main instanceof JSplitPane;
    }

    public void setInfoVisible(boolean bl) {
        Container container;
        if (this.infoPanel == null) {
            throw new IllegalStateException();
        }
        if (bl == this.isInfoVisible()) {
            return;
        }
        Dimension dimension = this.body.getSize();
        if (dimension.width == 0) {
            dimension = this.body.getPreferredSize();
        }
        Dimension dimension2 = this.infoPanel.getSize();
        if (dimension2.width == 0) {
            dimension2 = this.infoPanel.getPreferredSize();
        }
        this.remove(this.main);
        if (bl) {
            this.body.setBorder(null);
            container = new JSplitPane(1, this.body, this.infoPanel);
            ((JSplitPane)container).setDividerLocation(dimension.width - 1);
            this.main = container;
            this.infoPanel.setCurrentID(this.interview.getCurrentQuestion());
        } else {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        }
        this.add(this.main);
        container = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = WizPane.class$("java.awt.Window")) : class$java$awt$Window, this);
        if (container != null) {
            Dimension dimension3 = container.getSize();
            int n = new JSplitPane().getDividerSize();
            int n2 = dimension3.width;
            ((Window)container).setSize(n2 += (bl ? 1 : -1) * (dimension2.width + n), dimension3.height);
        }
    }

    public boolean isTagVisible() {
        return this.questionPanel.isTagVisible();
    }

    public void setTagVisible(boolean bl) {
        this.questionPanel.setTagVisible(bl);
    }

    public boolean getMarkersEnabled() {
        return this.pathPanel.getMarkersEnabled();
    }

    public void setMarkersEnabled(boolean bl) {
        this.pathPanel.setMarkersEnabled(bl);
    }

    public boolean getMarkersFilterEnabled() {
        return this.pathPanel.getMarkersFilterEnabled();
    }

    public void setMarkersFilterEnabled(boolean bl) {
        this.pathPanel.setMarkersFilterEnabled(bl);
    }

    public JMenu getMarkerMenu() {
        return this.pathPanel.getMarkerMenu();
    }

    public void save() {
        this.questionPanel.saveCurrentResponse();
    }

    public void prev() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.prev();
        }
        catch (Interview.Fault fault) {
            // empty catch block
        }
    }

    public void prevVisible() {
        this.questionPanel.saveCurrentResponse();
        this.setCurrentQuestion(this.pathPanel.getPrevVisible());
    }

    public void next() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.next();
        }
        catch (Interview.Fault fault) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void nextVisible() {
        this.questionPanel.saveCurrentResponse();
        this.setCurrentQuestion(this.pathPanel.getNextVisible());
    }

    public void last() {
        this.questionPanel.saveCurrentResponse();
        try {
            this.interview.last();
        }
        catch (Interview.Fault fault) {
            this.questionPanel.showValueInvalidMessage();
        }
    }

    public void lastVisible() {
        this.questionPanel.saveCurrentResponse();
        Question question = this.interview.getCurrentQuestion();
        Question question2 = this.pathPanel.getLastVisible();
        if (question2 == question) {
            if (!(question2 instanceof FinalQuestion)) {
                this.questionPanel.showValueInvalidMessage();
            }
        } else {
            this.setCurrentQuestion(question2);
        }
    }

    private void setCurrentQuestion(Question question) {
        if (question == null) {
            this.questionPanel.showValueInvalidMessage();
        } else {
            try {
                this.interview.setCurrentQuestion(question);
            }
            catch (Interview.Fault fault) {
                throw new IllegalStateException();
            }
        }
    }

    public void find() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.setVisible(true);
    }

    public void findNext() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.find();
    }

    private void initGUI() {
        this.setInfo(this, "wizPane");
        this.setLayout(new BorderLayout());
        this.questionPanel = new QuestionPanel(this.interview);
        this.questionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.questionPanel.setNextAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WizPane.this.getMarkersFilterEnabled()) {
                    WizPane.this.nextVisible();
                } else {
                    WizPane.this.next();
                }
            }
        });
        this.pathPanel = new PathPanel(this.questionPanel, this.interview);
        JScrollPane jScrollPane = new JScrollPane(this.pathPanel, 20, 31);
        jScrollPane.setName(this.pathPanel.getName() + ".sp");
        jScrollPane.setFocusable(false);
        this.body = new JPanel(new BorderLayout());
        this.body.setName("wizPane.body");
        this.body.setFocusable(false);
        this.body.add((Component)jScrollPane, "West");
        JScrollPane jScrollPane2 = new JScrollPane(this.questionPanel, 20, 31);
        jScrollPane2.setName(this.questionPanel.getName() + ".sp");
        jScrollPane2.setFocusable(false);
        this.body.add((Component)jScrollPane2, "Center");
        this.body.registerKeyboardAction(this.listener, FIND_NEXT, KeyStroke.getKeyStroke("F3"), 1);
        if (this.infoEnabled && this.interview.getHelpSet() != null) {
            this.infoPanel = new InfoPanel(this.interview);
        }
        if (this.infoPanel == null) {
            this.body.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.main = this.body;
        } else {
            this.body.setBorder(null);
            this.main = new JSplitPane(1, this.body, this.infoPanel);
            this.setInfo(this.main, "wizPane.split");
        }
        this.add(this.main);
    }

    private void setInfo(JComponent jComponent, String string) {
        jComponent.setName(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".name"));
        accessibleContext.setAccessibleDescription(i18n.getString(string + ".desc"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(FIND_NEXT)) {
                WizPane.this.findNext();
            }
        }
    }
}

