/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters;
import com.sun.javatest.StatusFilter;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public abstract class BasicParameters
implements Parameters,
Parameters.MutableTestsParameters,
Parameters.MutableExcludeListParameters,
Parameters.MutableKeywordsParameters,
Parameters.MutablePriorStatusParameters,
Parameters.MutableConcurrencyParameters,
Parameters.MutableTimeoutFactorParameters {
    private TestSuite testSuite;
    protected String testSuiteError;
    private WorkDirectory workDir;
    protected String workDirError;
    private int testsMode = 1;
    private String[] tests;
    private int excludeMode = 1;
    private boolean latestExcludeAutoCheck;
    private int latestExcludeAutoCheckMode;
    private int latestExcludeAutoCheckInterval;
    private File[] customExcludeFiles = new File[0];
    private File[] cachedAbsExcludeFiles;
    private File cachedAbsExcludeFiles_base;
    private File[] cachedAbsExcludeFiles_excludeFiles;
    private ExcludeList cachedExcludeList;
    private File[] cachedExcludeList_absExclFiles;
    private ExcludeListFilter cachedExcludeListFilter;
    protected String excludeListError;
    private int keywordsMode = 1;
    private int keywordsMatchMode = 3;
    private String keywordsMatchValue;
    private int cachedKeywordsMatchMode;
    private String cachedKeywordsMatchValue;
    private Keywords cachedKeywords;
    private TestFilter cachedKeywordsFilter;
    protected String keywordsError;
    private int priorStatusMode = 1;
    private boolean[] priorStatusValues = new boolean[4];
    private StatusFilter cachedPriorStatusFilter;
    private int concurrency = 1;
    protected String concurrencyError;
    private float timeoutFactor = 1.0f;
    protected String timeoutFactorError;
    private TestFilter cachedRelevantTestFilter;
    private TestSuite cachedRelevantTestFilterTestSuite;
    private TestEnvironment cachedRelevantTestFilterEnv;
    private TestFilter[] cachedTestFilters;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$BasicParameters == null ? (class$com$sun$javatest$BasicParameters = BasicParameters.class$("com.sun.javatest.BasicParameters")) : class$com$sun$javatest$BasicParameters);
    static /* synthetic */ Class class$com$sun$javatest$BasicParameters;

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public void setTestSuite(File file) {
        if (file == null) {
            this.testSuiteError = i18n.getString("bp.noTestSuite");
        } else {
            try {
                this.setTestSuite(TestSuite.open(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.testSuiteError = i18n.getString("bp.cantFindTestSuite", file);
            }
            catch (TestSuite.Fault fault) {
                this.testSuiteError = i18n.getString("bp.badTestSuite", fault.getMessage());
            }
        }
    }

    public void setTestSuite(TestSuite testSuite) {
        if (testSuite == null) {
            throw new NullPointerException();
        }
        if (this.testSuite != null && this.testSuite != testSuite) {
            throw new IllegalStateException();
        }
        this.testSuite = testSuite;
        this.testSuiteError = null;
    }

    private boolean isTestSuiteOK() {
        return this.testSuiteError == null;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(File file) {
        block12: {
            if (file == null) {
                this.workDirError = i18n.getString("bp.workDirMissing");
            } else if (this.isTestSuiteOK()) {
                try {
                    TestSuite testSuite = this.getTestSuite();
                    if (file.exists()) {
                        if (WorkDirectory.isWorkDirectory(file)) {
                            this.setWorkDirectory(WorkDirectory.open(file, testSuite));
                            this.workDirError = null;
                        } else if (WorkDirectory.isEmptyDirectory(file)) {
                            this.workDir = WorkDirectory.create(file, testSuite);
                            this.workDirError = null;
                        } else {
                            this.workDirError = i18n.getString("bp.badWorkDir", file.getPath());
                        }
                        break block12;
                    }
                    this.workDirError = i18n.getString("bp.cantFindWorkDir", file.getPath());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.workDirError = i18n.getString("bp.cantFindWorkDir", file.getPath());
                }
                catch (WorkDirectory.Fault fault) {
                    this.workDirError = i18n.getString("bp.workDirError", fault.getMessage());
                }
            } else {
                this.workDirError = i18n.getString("bp.noTestSuite");
            }
        }
    }

    public void setWorkDirectory(WorkDirectory workDirectory) {
        if (workDirectory == null) {
            throw new NullPointerException();
        }
        if (this.workDir != null && this.workDir != workDirectory) {
            throw new IllegalStateException();
        }
        if (this.testSuite != null && workDirectory.getTestSuite() != this.testSuite) {
            throw new IllegalArgumentException();
        }
        if (this.testSuite == null) {
            this.setTestSuite(workDirectory.getTestSuite());
        }
        this.workDir = workDirectory;
    }

    private boolean isWorkDirectoryOK() {
        return this.workDirError == null;
    }

    public Parameters.TestsParameters getTestsParameters() {
        return this;
    }

    public String[] getTests() {
        return this.tests;
    }

    public void setTests(String[] stringArray) {
        if (stringArray == null) {
            this.testsMode = 1;
        } else {
            this.testsMode = 2;
            this.tests = stringArray;
        }
    }

    public int getTestsMode() {
        return this.testsMode;
    }

    public void setTestsMode(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.testsMode = n;
    }

    public String[] getSpecifiedTests() {
        return this.tests;
    }

    public void setSpecifiedTests(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.tests = stringArray;
    }

    private boolean isTestsOK() {
        return true;
    }

    public Parameters.ExcludeListParameters getExcludeListParameters() {
        return this;
    }

    public File[] getExcludeFiles() {
        TestSuite testSuite = this.getTestSuite();
        switch (this.excludeMode) {
            case 2: {
                if (testSuite == null) {
                    return null;
                }
                File file = testSuite.getInitialExcludeList();
                if (file == null) {
                    return null;
                }
                return new File[]{file};
            }
            case 3: {
                if (testSuite == null) {
                    return null;
                }
                URL uRL = testSuite.getLatestExcludeList();
                if (uRL == null) {
                    return null;
                }
                WorkDirectory workDirectory = this.getWorkDirectory();
                if (workDirectory == null) {
                    return null;
                }
                return new File[]{workDirectory.getSystemFile("latest.jtx")};
            }
            case 4: {
                return this.customExcludeFiles;
            }
        }
        return null;
    }

    public void setExcludeFiles(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            this.setExcludeMode(1);
        } else {
            this.setExcludeMode(4);
            this.setCustomExcludeFiles(fileArray);
        }
    }

    public ExcludeList getExcludeList() {
        this.updateExcludeList();
        return this.cachedExcludeList;
    }

    public TestFilter getExcludeListFilter() {
        this.updateExcludeList();
        return this.cachedExcludeListFilter;
    }

    public int getExcludeMode() {
        return this.excludeMode;
    }

    public void setExcludeMode(int n) {
        this.excludeMode = n;
    }

    public File[] getCustomExcludeFiles() {
        return this.customExcludeFiles;
    }

    public void setCustomExcludeFiles(File[] fileArray) {
        this.customExcludeFiles = fileArray;
    }

    public boolean isLatestExcludeAutoCheckEnabled() {
        return false;
    }

    public void setLatestExcludeAutoCheckEnabled(boolean bl) {
        this.latestExcludeAutoCheck = bl;
    }

    public int getLatestExcludeAutoCheckMode() {
        return this.latestExcludeAutoCheckMode;
    }

    public void setLatestExcludeAutoCheckMode(int n) {
        this.latestExcludeAutoCheckMode = n;
    }

    public int getLatestExcludeAutoCheckInterval() {
        return this.latestExcludeAutoCheckInterval;
    }

    public void setLatestExcludeAutoCheckInterval(int n) {
        this.latestExcludeAutoCheckInterval = n;
    }

    private boolean isExcludeListOK() {
        return this.excludeListError == null;
    }

    private File[] getAbsoluteExcludeFiles() {
        this.updateAbsoluteExcludeFiles();
        return this.cachedAbsExcludeFiles;
    }

    private void updateAbsoluteExcludeFiles() {
        TestSuite testSuite = this.getTestSuite();
        File file = testSuite == null ? null : testSuite.getRootDir();
        File[] fileArray = this.getExcludeFiles();
        if (this.cachedAbsExcludeFiles == null || this.cachedAbsExcludeFiles_base != file || this.cachedAbsExcludeFiles_excludeFiles != fileArray) {
            this.cachedAbsExcludeFiles = BasicParameters.getAbsoluteFiles(file, fileArray);
        }
    }

    private void updateExcludeList() {
        File[] fileArray = this.getAbsoluteExcludeFiles();
        if (this.cachedExcludeList == null || !BasicParameters.equal(this.cachedExcludeList_absExclFiles, fileArray)) {
            try {
                this.cachedExcludeList = fileArray == null ? new ExcludeList() : new ExcludeList(this.cachedAbsExcludeFiles);
                this.cachedExcludeList_absExclFiles = this.cachedAbsExcludeFiles;
                this.cachedExcludeListFilter = new ExcludeListFilter(this.cachedExcludeList);
                this.excludeListError = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListNotFound", fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListFault", iOException);
            }
            catch (ExcludeList.Fault fault) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.excludeListError = i18n.getString("bp.exclListFault", fault.getMessage());
            }
        }
    }

    public Parameters.KeywordsParameters getKeywordsParameters() {
        return this;
    }

    public Keywords getKeywords() {
        this.updateCachedKeywords();
        return this.cachedKeywords;
    }

    public void setKeywords(int n, String string) {
        if (string == null) {
            this.keywordsMode = 1;
        } else {
            this.keywordsMode = 2;
            this.keywordsMatchMode = n;
            this.keywordsMatchValue = string;
        }
    }

    public TestFilter getKeywordsFilter() {
        this.updateCachedKeywords();
        if (this.keywordsMode == 1) {
            return null;
        }
        return this.cachedKeywordsFilter;
    }

    public int getKeywordsMode() {
        return this.keywordsMode;
    }

    public void setKeywordsMode(int n) {
        this.keywordsMode = n;
    }

    public int getMatchKeywordsMode() {
        return this.keywordsMatchMode;
    }

    public String getMatchKeywordsValue() {
        return this.keywordsMatchValue;
    }

    public void setMatchKeywords(int n, String string) {
        this.keywordsMatchMode = n;
        this.keywordsMatchValue = string;
    }

    private void updateCachedKeywords() {
        if (this.keywordsMode == 1) {
            this.cachedKeywordsMatchMode = -1;
            this.cachedKeywordsMatchValue = null;
            this.cachedKeywords = null;
            this.cachedKeywordsFilter = null;
            this.keywordsError = null;
        } else if (this.cachedKeywordsMatchMode != this.keywordsMatchMode || this.cachedKeywordsMatchValue == null || !this.cachedKeywordsMatchValue.equals(this.keywordsMatchValue)) {
            try {
                this.cachedKeywordsMatchMode = this.keywordsMatchMode;
                this.cachedKeywordsMatchValue = this.keywordsMatchValue;
                String string = this.keywordsMatchMode == 3 ? "expr" : (this.keywordsMatchMode == 2 ? "all of" : "any of");
                this.cachedKeywords = Keywords.create(string, this.keywordsMatchValue);
                this.cachedKeywordsFilter = new KeywordsFilter(this.cachedKeywords);
            }
            catch (Keywords.Fault fault) {
                this.cachedKeywords = null;
                this.cachedKeywordsFilter = null;
                this.keywordsError = i18n.getString("bp.badKeywords", fault.getMessage());
            }
        }
    }

    private boolean isKeywordsOK() {
        this.updateCachedKeywords();
        return this.keywordsError == null;
    }

    public Parameters.PriorStatusParameters getPriorStatusParameters() {
        return this;
    }

    public boolean[] getPriorStatusValues() {
        if (this.priorStatusMode == 1) {
            return null;
        }
        return this.priorStatusValues;
    }

    public void setPriorStatusValues(boolean[] blArray) {
        if (blArray == null) {
            this.priorStatusMode = 1;
        } else {
            this.priorStatusMode = 2;
            this.priorStatusValues = blArray;
        }
    }

    public TestFilter getPriorStatusFilter() {
        WorkDirectory workDirectory = this.getWorkDirectory();
        TestResultTable testResultTable = workDirectory == null ? null : workDirectory.getTestResultTable();
        boolean[] blArray = this.getPriorStatusValues();
        if (testResultTable == null || blArray == null) {
            this.cachedPriorStatusFilter = null;
        } else if (this.cachedPriorStatusFilter == null || this.cachedPriorStatusFilter.getTestResultTable() != testResultTable || !BasicParameters.equal(this.cachedPriorStatusFilter.getStatusValues(), blArray)) {
            this.cachedPriorStatusFilter = new StatusFilter(blArray, testResultTable);
        }
        return this.cachedPriorStatusFilter;
    }

    public int getPriorStatusMode() {
        return this.priorStatusMode;
    }

    public void setPriorStatusMode(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        this.priorStatusMode = n;
    }

    public boolean[] getMatchPriorStatusValues() {
        return this.priorStatusValues;
    }

    public void setMatchPriorStatusValues(boolean[] blArray) {
        if (blArray == null) {
            throw new NullPointerException();
        }
        if (blArray.length != 4) {
            throw new IllegalArgumentException();
        }
        this.priorStatusValues = blArray;
    }

    private boolean isPriorStatusOK() {
        return true;
    }

    public Parameters.ConcurrencyParameters getConcurrencyParameters() {
        return this;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int n) {
        if (n <= 0) {
            this.concurrencyError = i18n.getString("bp.badConcurrency", new Integer(n));
            this.concurrency = 1;
        } else {
            this.concurrencyError = null;
            this.concurrency = n;
        }
    }

    private boolean isConcurrencyOK() {
        return this.concurrencyError == null;
    }

    public Parameters.TimeoutFactorParameters getTimeoutFactorParameters() {
        return this;
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public void setTimeoutFactor(float f) {
        if (f <= 0.0f) {
            this.timeoutFactorError = i18n.getString("bp.badTimeout", new Float(f));
            this.timeoutFactor = 1.0f;
        } else {
            this.timeoutFactorError = null;
            this.timeoutFactor = f;
        }
    }

    private boolean isTimeoutFactorOK() {
        return this.timeoutFactorError == null;
    }

    public TestFilter getRelevantTestFilter() {
        TestSuite testSuite = this.getTestSuite();
        TestEnvironment testEnvironment = this.getEnv();
        if (testSuite == null || testEnvironment == null) {
            this.cachedRelevantTestFilter = null;
        } else if (this.cachedRelevantTestFilter == null || testSuite != this.cachedRelevantTestFilterTestSuite || testEnvironment != this.cachedRelevantTestFilterEnv) {
            this.cachedRelevantTestFilter = testSuite.createTestFilter(testEnvironment);
        }
        return this.cachedRelevantTestFilter;
    }

    public synchronized TestFilter[] getFilters() {
        TestFilter testFilter;
        TestFilter testFilter2;
        TestFilter testFilter3;
        Vector<TestFilter> vector = new Vector<TestFilter>();
        TestFilter testFilter4 = this.getExcludeListFilter();
        if (testFilter4 != null) {
            vector.addElement(testFilter4);
        }
        if ((testFilter3 = this.getKeywordsFilter()) != null) {
            vector.addElement(testFilter3);
        }
        if ((testFilter2 = this.getPriorStatusFilter()) != null) {
            vector.addElement(testFilter2);
        }
        if ((testFilter = this.getRelevantTestFilter()) != null) {
            vector.addElement(testFilter);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (BasicParameters.equal(vector, this.cachedTestFilters)) {
            return this.cachedTestFilters;
        }
        Object[] objectArray = new TestFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isValid() {
        return this.isTestSuiteOK() && this.isWorkDirectoryOK() && this.isTestsOK() && this.isExcludeListOK() && this.isKeywordsOK() && this.isPriorStatusOK() && this.isConcurrencyOK() && this.isTimeoutFactorOK();
    }

    public String getErrorMessage() {
        return this.testSuiteError != null ? this.testSuiteError : (this.workDirError != null ? this.workDirError : (this.excludeListError != null ? this.excludeListError : (this.keywordsError != null ? this.keywordsError : (this.concurrencyError != null ? this.concurrencyError : (this.timeoutFactorError != null ? this.timeoutFactorError : null)))));
    }

    protected static File[] getAbsoluteFiles(File file, File[] fileArray) {
        if (fileArray == null) {
            return null;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length && bl; ++i) {
            bl = fileArray[i].isAbsolute();
        }
        if (bl) {
            return fileArray;
        }
        File[] fileArray2 = new File[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            fileArray2[i] = file2.isAbsolute() ? file2 : new File(file, file2.getPath());
        }
        return fileArray2;
    }

    protected static boolean equal(boolean[] blArray, boolean[] blArray2) {
        if (blArray == null || blArray2 == null) {
            return blArray == blArray2;
        }
        if (blArray.length != blArray2.length) {
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(File[] fileArray, File[] fileArray2) {
        if (fileArray == null || fileArray2 == null) {
            return fileArray == fileArray2;
        }
        if (fileArray.length != fileArray2.length) {
            return false;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i] == fileArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(Vector vector, TestFilter[] testFilterArray) {
        if (testFilterArray == null || vector.size() != testFilterArray.length) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(testFilterArray[i])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

