/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CompositeFilter
extends TestFilter {
    private TestFilter[] filters;
    private String description;
    private String name;
    private String reason;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$CompositeFilter == null ? (class$com$sun$javatest$CompositeFilter = CompositeFilter.class$("com.sun.javatest.CompositeFilter")) : class$com$sun$javatest$CompositeFilter);
    static /* synthetic */ Class class$com$sun$javatest$CompositeFilter;

    public CompositeFilter(TestFilter[] testFilterArray, I18NResourceBundle i18NResourceBundle, String string) {
        this.filters = testFilterArray;
        this.description = i18NResourceBundle.getString(string + ".description");
        this.name = i18NResourceBundle.getString(string + ".name");
        this.reason = i18NResourceBundle.getString(string + ".reason");
        if (this.description == null) {
            this.description = i18n.getString("compFilter.unset.description");
        }
        if (this.name == null) {
            this.name = i18n.getString("compFilter.unset.name");
        }
        if (this.reason == null) {
            this.reason = i18n.getString("compFilter.unset.reason");
        }
    }

    public CompositeFilter(TestFilter[] testFilterArray) {
        if (testFilterArray == null) {
            throw new NullPointerException();
        }
        this.filters = testFilterArray;
    }

    public String getName() {
        if (this.name == null) {
            return i18n.getString("compFilter.name");
        }
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            return i18n.getString("compFilter.description");
        }
        return this.description;
    }

    public String getReason() {
        if (this.reason == null) {
            return i18n.getString("compFilter.reason");
        }
        return this.reason;
    }

    public boolean accepts(TestDescription testDescription) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return true;
        }
        try {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i].accepts(testDescription)) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw new TestFilter.Fault(i18n, "compFilter.exception", runtimeException);
        }
    }

    public boolean accepts(TestDescription testDescription, TestFilter.Observer observer) throws TestFilter.Fault {
        if (this.filters == null || this.filters.length == 0) {
            return true;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i].accepts(testDescription, observer)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CompositeFilter)) {
            return false;
        }
        TestFilter[] testFilterArray = ((CompositeFilter)object).getFilters();
        if ((this.filters == null || this.filters.length == 0) && testFilterArray.length == 0) {
            return true;
        }
        if (this.filters.length != testFilterArray.length) {
            return false;
        }
        return CompositeFilter.equals(this.filters, testFilterArray);
    }

    public TestFilter[] getFilters() {
        if (this.filters == null) {
            return new TestFilter[0];
        }
        TestFilter[] testFilterArray = new TestFilter[this.filters.length];
        System.arraycopy(this.filters, 0, testFilterArray, 0, this.filters.length);
        return testFilterArray;
    }

    public static boolean equals(TestFilter[] testFilterArray, TestFilter[] testFilterArray2) {
        List<TestFilter> list = Arrays.asList(testFilterArray);
        List<TestFilter> list2 = Arrays.asList(testFilterArray2);
        HashSet<TestFilter> hashSet = new HashSet<TestFilter>(list);
        HashSet<TestFilter> hashSet2 = new HashSet<TestFilter>(list2);
        return hashSet.equals(hashSet2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

