/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.ExcludeList;
import com.sun.javatest.HarnessHttpHandler;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.LastRunInfo;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.Trace;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.ReadAheadIterator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class Harness {
    private BackupPolicy backupPolicy;
    private int autostopThreshold;
    private HarnessHttpHandler httpHandler;
    private Trace trace;
    private Thread worker;
    private Parameters params;
    private TestSuite testSuite;
    private WorkDirectory workDir;
    private ExcludeList excludeList;
    private TestResultTable.TreeIterator testIter;
    private int readAheadMode;
    private ReadAheadIterator raTestIter;
    private int numTestsDone;
    private TestEnvironment env;
    private TestResultTable resultTable;
    private Notifier notifier;
    private long startTime;
    private long finishTime;
    private boolean stopping;
    private static File classDir;
    private static final boolean ZERO_TESTS_OK = true;
    private static final boolean ZERO_TESTS_ERROR = false;
    private static final int DEFAULT_READ_AHEAD = 100;
    private static I18NResourceBundle i18n;
    static /* synthetic */ Class class$com$sun$javatest$Harness;

    public Harness(File file) {
        this();
        Harness.setClassDir(file);
    }

    public Harness() {
        Integer n = Integer.getInteger("javatest.autostop.threshold");
        this.autostopThreshold = n == null ? 0 : n;
        this.readAheadMode = 2;
        this.notifier = new Notifier();
        this.startTime = -1L;
        this.finishTime = -1L;
        this.backupPolicy = BackupPolicy.noBackups();
        this.params = null;
        if (!Boolean.getBoolean("javatest.noTraceRequired")) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        }
        if (HttpdServer.isActive()) {
            this.httpHandler = new HarnessHttpHandler(this);
            RootRegistry.getInstance().addHandler("/harness", "JavaTest Harness", this.httpHandler);
        }
    }

    public BackupPolicy getBackupPolicy() {
        return this.backupPolicy;
    }

    public void setBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public boolean isTracingRequired() {
        return this.trace != null;
    }

    public void setTracingRequired(boolean bl) {
        if (bl && this.trace == null) {
            this.trace = new Trace(this.backupPolicy);
            this.addObserver(this.trace);
        } else if (!bl && this.trace != null) {
            this.removeObserver(this.trace);
            this.trace = null;
        }
    }

    public static File getClassDir() {
        return classDir;
    }

    public static void setClassDir(File file) {
        if (classDir != null && classDir != file) {
            throw new IllegalStateException(i18n.getString("harness.classDirAlreadySet"));
        }
        classDir = file;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public TestEnvironment getEnv() {
        return this.env;
    }

    public TestResultTable getResultTable() {
        WorkDirectory workDirectory = this.params == null ? null : this.params.getWorkDirectory();
        return workDirectory == null ? null : workDirectory.getTestResultTable();
    }

    public void addObserver(Observer observer) {
        this.notifier.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.notifier.removeObserver(observer);
    }

    public void start(Parameters parameters) throws Fault {
        this.startWorker(parameters);
    }

    public synchronized void waitUntilDone() throws InterruptedException {
        while (this.worker != null) {
            this.wait();
        }
    }

    public synchronized void stop() {
        if (this.worker != null) {
            if (!this.stopping) {
                this.notifier.stoppingTestRun();
                this.stopping = true;
            }
            this.worker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean batch(Parameters parameters) throws Fault, InterruptedException {
        if (Boolean.getBoolean("javatest.noReadAhead")) {
            this.readAheadMode = 0;
        }
        Harness harness2 = this;
        // MONITORENTER : harness2
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = Thread.currentThread();
        // MONITOREXIT : harness2
        if (!parameters.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", parameters.getErrorMessage());
        }
        boolean bl = false;
        try {
            try {
                this.workDir = parameters.getWorkDirectory();
                this.resultTable = this.workDir.getTestResultTable();
                this.resultTable.suppressFinderScan(true);
                bl = this.runTests(parameters, true);
            }
            catch (TestSuite.Fault fault) {
                throw new Fault(i18n, "harness.testsuiteError", fault.getMessage());
            }
            Object var5_4 = null;
            Harness harness = this;
            // MONITORENTER : harness
            this.worker = null;
            this.notifyAll();
            // MONITOREXIT : harness
            this.notifier.finishedTestRun(bl);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Harness harness = this;
            // MONITORENTER : harness
            this.worker = null;
            this.notifyAll();
            // MONITOREXIT : harness
            this.notifier.finishedTestRun(bl);
            throw throwable;
        }
    }

    public boolean isRunning() {
        return this.worker != null;
    }

    public boolean isAllTestsFound() {
        if (this.isRunning() && this.raTestIter != null) {
            return this.raTestIter.isSourceExhausted();
        }
        return false;
    }

    public long getElapsedTime() {
        long l = 0L;
        if (this.startTime == -1L) {
            l = 0L;
        } else if (this.finishTime == -1L) {
            long l2 = System.currentTimeMillis();
            l = l2 - this.startTime;
        } else {
            l = this.finishTime - this.startTime;
        }
        return l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getEstimatedTime() {
        if (!this.isRunning() || this.numTestsDone == 0) {
            return 0L;
        }
        long l = this.getElapsedTime() * (long)(this.getTestsFoundCount() - this.numTestsDone) / (long)this.numTestsDone;
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTestsFoundCount() {
        if (this.raTestIter == null) {
            return 0;
        }
        ReadAheadIterator readAheadIterator = this.raTestIter;
        synchronized (readAheadIterator) {
            return this.raTestIter.getUsedElementCount() + this.raTestIter.getOutputQueueSize();
        }
    }

    private synchronized void startWorker(final Parameters parameters) throws Fault {
        if (this.worker != null) {
            throw new Fault(i18n, "harness.alreadyRunning");
        }
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Harness harness;
                boolean bl = false;
                try {
                    try {
                        bl = Harness.this.runTests(parameters, false);
                    }
                    catch (Fault fault) {
                        Harness.this.notifyLocalizedError(fault.getMessage());
                        Object var4_3 = null;
                        Harness harness3 = Harness.this;
                        synchronized (harness3) {
                            Harness.this.worker = null;
                            Harness.this.notifyAll();
                        }
                        Harness.this.notifier.finishedTestRun(bl);
                        return;
                    }
                    catch (TestSuite.Fault fault) {
                        Harness.this.notifyLocalizedError(fault.getMessage());
                        Object var4_4 = null;
                        Harness harness4 = Harness.this;
                        synchronized (harness4) {
                            Harness.this.worker = null;
                            Harness.this.notifyAll();
                        }
                        Harness.this.notifier.finishedTestRun(bl);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        Harness.this.notifyError(i18n, "harness.interrupted");
                        Object var4_5 = null;
                        Harness harness5 = Harness.this;
                        synchronized (harness5) {
                            Harness.this.worker = null;
                            Harness.this.notifyAll();
                        }
                        Harness.this.notifier.finishedTestRun(bl);
                        return;
                    }
                    Object var4_2 = null;
                    harness = Harness.this;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    Harness harness2 = Harness.this;
                    synchronized (harness2) {
                        Harness.this.worker = null;
                        Harness.this.notifyAll();
                    }
                    Harness.this.notifier.finishedTestRun(bl);
                    throw throwable;
                }
                synchronized (harness) {
                    Harness.this.worker = null;
                    Harness.this.notifyAll();
                }
                Harness.this.notifier.finishedTestRun(bl);
            }
        };
        this.worker.setName("Harness:Worker");
        this.worker.setPriority(3);
        this.worker.start();
    }

    private boolean runTests(Parameters parameters, boolean bl) throws Fault, TestSuite.Fault, InterruptedException {
        int n;
        Object object;
        File file;
        boolean bl2 = true;
        this.stopping = false;
        this.startTime = System.currentTimeMillis();
        this.finishTime = -1L;
        this.numTestsDone = 0;
        if (!parameters.isValid()) {
            throw new Fault(i18n, "harness.incompleteParameters", parameters.getErrorMessage());
        }
        this.params = parameters;
        this.testSuite = this.params.getTestSuite();
        this.workDir = this.params.getWorkDirectory();
        this.resultTable = this.workDir.getTestResultTable();
        this.excludeList = this.params.getExcludeList();
        this.workDir.log(i18n, "harness.starting");
        float f = this.params.getTimeoutFactor();
        if (f == Float.NaN) {
            f = 1.0f;
        }
        String[] stringArray = new String[]{String.valueOf((int)Math.ceil(f)), String.valueOf(f)};
        this.env = this.params.getEnv();
        this.env.put("javatestTimeoutFactor", stringArray);
        this.env.putUrlAndFile("javatestClassDir", classDir, true);
        this.env.putUrlAndFile("harnessClassDir", classDir, true);
        this.env.putUrlAndFile("javatestWorkDir", this.workDir.getRoot(), true);
        String string = this.testSuite.getTestSuiteInfo("env.tsRoot");
        File file2 = file = string == null ? null : new File(string);
        if (file != null && file.exists()) {
            this.env.putUrlAndFile("testSuiteRoot", file, file.isDirectory());
            this.env.putUrlAndFile("testSuiteRootDir", file.isDirectory() ? file : file.getParentFile(), true);
        } else {
            this.env.putUrlAndFile("testSuiteRoot", this.testSuite.getRoot(), this.testSuite.getRoot().isDirectory());
            this.env.putUrlAndFile("testSuiteRootDir", this.testSuite.getRootDir(), true);
        }
        String[] stringArray2 = this.params.getTests();
        TestFilter[] testFilterArray = this.params.getFilters();
        this.resultTable.waitUntilReady();
        if (stringArray2 == null || stringArray2.length == 0) {
            this.testIter = this.resultTable.getIterator(testFilterArray);
        } else {
            try {
                object = new File[stringArray2.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    object[n] = new File(stringArray2[n]);
                }
                this.testIter = this.resultTable.getIterator((File[])object, testFilterArray);
            }
            catch (TestResultTable.Fault fault) {
                throw new Fault(i18n, "harness.badInitFiles", fault.getMessage());
            }
        }
        this.raTestIter = new ReadAheadIterator(this.testIter, this.readAheadMode, 100);
        if (this.autostopThreshold > 0) {
            this.addObserver(new Autostop(this.autostopThreshold));
        }
        this.testSuite.starting(this);
        this.notifier.startingTestRun(this.params);
        object = this.testSuite.createTestRunner();
        ((TestRunner)object).setWorkDirectory(this.workDir);
        ((TestRunner)object).setBackupPolicy(this.backupPolicy);
        ((TestRunner)object).setEnvironment(this.env);
        ((TestRunner)object).setExcludeList(this.excludeList);
        n = this.params.getConcurrency();
        n = Math.max(1, Math.min(n, 50));
        ((TestRunner)object).setConcurrency(n);
        ((TestRunner)object).setNotifier(this.notifier);
        try {
            ((TestRunner)object).runTests(new Iterator(){

                public boolean hasNext() {
                    return Harness.this.stopping ? false : Harness.this.raTestIter.hasNext();
                }

                public Object next() {
                    TestResult testResult = (TestResult)Harness.this.raTestIter.next();
                    try {
                        return testResult.getDescription();
                    }
                    catch (TestResult.Fault fault) {
                        Harness.this.stopping = true;
                        throw new JavaTestError(i18n, "harness.trProb", testResult.getWorkRelativePath(), (Throwable)fault);
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finishTime = System.currentTimeMillis();
        this.notifier.finishedTesting();
        int[] nArray = this.testIter.getResultStats();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        if (n2 == 0 && !bl) {
            this.notifyError(i18n, "harness.noTests");
            bl2 = false;
        } else if (this.resultTable.getTestFinder().getErrorCount() > 0) {
            this.notifyError(i18n, "harness.finderError");
            bl2 = false;
        }
        if (bl2 && (this.notifier.getErrorCount() > 0 || this.notifier.getFailedCount() > 0)) {
            bl2 = false;
        }
        try {
            LastRunInfo.writeInfo(this.workDir, this.startTime, this.finishTime, this.env.getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resultTable.waitUntilReady();
        this.workDir.log(i18n, "harness.done", new Integer(bl2 ? 0 : 1));
        return bl2;
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string));
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string, object));
    }

    private void notifyError(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.notifyLocalizedError(i18NResourceBundle.getString(string, objectArray));
    }

    private void notifyLocalizedError(String string) {
        this.notifier.error(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$Harness == null ? (class$com$sun$javatest$Harness = Harness.class$("com.sun.javatest.Harness")) : class$com$sun$javatest$Harness);
    }

    class Autostop
    implements Observer {
        private int level;
        private int threshold;

        Autostop(int n) {
            this.threshold = n;
        }

        public void startingTestRun(Parameters parameters) {
        }

        public void startingTest(TestResult testResult) {
        }

        public void finishedTest(TestResult testResult) {
            switch (testResult.getStatus().getType()) {
                case 1: {
                    ++this.level;
                    break;
                }
                case 2: {
                    this.level += 5;
                    break;
                }
                default: {
                    this.level = Math.max(this.level - 2, 0);
                }
            }
            if (this.level >= this.threshold) {
                Harness.this.notifyError(i18n, "harness.tooManyErrors");
                Harness.this.stop();
            }
        }

        public void stoppingTestRun() {
        }

        public void finishedTesting() {
        }

        public void finishedTestRun(boolean bl) {
        }

        public void error(String string) {
        }
    }

    private class Notifier
    implements Observer {
        private Observer[] observers = new Observer[0];
        private volatile int errCount;
        private volatile int failCount;

        private Notifier() {
        }

        void addObserver(Observer observer) {
            if (observer == null) {
                throw new NullPointerException();
            }
            this.observers = (Observer[])DynamicArray.append(this.observers, observer);
        }

        void removeObserver(Observer observer) {
            this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
        }

        public void startingTestRun(Parameters parameters) {
            Harness.this.resultTable.starting();
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].startingTestRun(parameters);
            }
        }

        public void startingTest(TestResult testResult) {
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].startingTest(testResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishedTest(TestResult testResult) {
            Harness.this.numTestsDone++;
            Harness.this.resultTable.update(testResult);
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].finishedTest(testResult);
            }
            switch (testResult.getStatus().getType()) {
                case 1: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.failCount;
                        break;
                    }
                }
                case 2: {
                    Notifier notifier = this;
                    synchronized (notifier) {
                        ++this.errCount;
                        break;
                    }
                }
            }
        }

        public void stoppingTestRun() {
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].stoppingTestRun();
            }
        }

        public void finishedTesting() {
            Harness.this.resultTable.finished();
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].finishedTesting();
            }
        }

        public void finishedTestRun(boolean bl) {
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].finishedTestRun(bl);
            }
        }

        public void error(String string) {
            Observer[] observerArray = this.observers;
            for (int i = observerArray.length - 1; i >= 0; --i) {
                observerArray[i].error(string);
            }
        }

        synchronized int getErrorCount() {
            return this.errCount;
        }

        synchronized int getFailedCount() {
            return this.failCount;
        }
    }

    public static interface Observer {
        public void startingTestRun(Parameters var1);

        public void startingTest(TestResult var1);

        public void finishedTest(TestResult var1);

        public void stoppingTestRun();

        public void finishedTesting();

        public void finishedTestRun(boolean var1);

        public void error(String var1);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

