/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.NewJavaTestSecurityManager;
import java.io.FileDescriptor;
import java.net.InetAddress;

public class JavaTestSecurityManager
extends SecurityManager {
    private static boolean allowExit = false;
    private static boolean allowPropertiesAccess = Boolean.getBoolean("javatest.security.allowPropertiesAccess");
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public static void install() {
        block6: {
            try {
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JavaTest did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    try {
                        Class.forName("java.security.Permission");
                        System.setSecurityManager(new NewJavaTestSecurityManager());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.setSecurityManager(new JavaTestSecurityManager());
                    }
                }
            }
            catch (SecurityException securityException) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager instanceof JavaTestSecurityManager) break block6;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JavaTest could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + securityException);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    public void checkAccept(String string, int n) {
    }

    public void checkAccess(Thread thread) {
    }

    public void checkAccess(ThreadGroup threadGroup) {
    }

    public void checkConnect(String string, int n) {
    }

    public void checkConnect(String string, int n, Object object) {
    }

    public void checkCreateClassLoader() {
    }

    public void checkDelete(String string) {
    }

    public void checkExec(String string) {
    }

    public void checkExit(int n) {
        if (!allowExit) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": System.exit() forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("System.exit() forbidden by JavaTest");
        }
    }

    public void checkLink(String string) {
    }

    public void checkListen(int n) {
    }

    public void checkPackageAccess(String string) {
    }

    public void checkPackageDefinition(String string) {
    }

    public synchronized void checkPropertiesAccess() {
        if (!allowPropertiesAccess) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": properties access forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Action forbidden by JavaTest: checkPropertiesAccess");
        }
    }

    public void checkPropertyAccess(String string) {
    }

    public void checkRead(FileDescriptor fileDescriptor) {
    }

    public void checkRead(String string) {
    }

    public void checkRead(String string, Object object) {
    }

    public void checkSetFactory() {
    }

    public boolean checkTopLevelWindow(Object object) {
        return true;
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
    }

    public void checkWrite(String string) {
    }

    public void checkAwtEventQueueAccess() {
    }

    public void checkMemberAccess(Class clazz, int n) {
    }

    public void checkMulticast(InetAddress inetAddress) {
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
    }

    public void checkPrintJobAccess() {
    }

    public void checkSecurityAccess(String string) {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean setAllowExit(boolean bl) {
        boolean bl2 = allowExit;
        allowExit = bl;
        return bl2;
    }

    public boolean setAllowPropertiesAccess(boolean bl) {
        boolean bl2 = allowPropertiesAccess;
        allowPropertiesAccess = bl;
        return bl2;
    }
}

